// Copyright (c) 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Generated from template:
//   templates/feature_policy_features.cc.tmpl
// and input files:
//   ../../../../kde-qtwebengine/src/3rdparty/chromium/third_party/blink/renderer/core/feature_policy/feature_policy_features.json5


#include "third_party/blink/public/common/feature_policy/feature_policy_features.h"

#include "base/no_destructor.h"
#include "third_party/blink/public/mojom/feature_policy/feature_policy_feature.mojom.h"

namespace blink {

const FeaturePolicyFeatureList& GetFeaturePolicyFeatureList() {
  static const base::NoDestructor<FeaturePolicyFeatureList> feature_list({      {
        mojom::FeaturePolicyFeature::kAccelerometer,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kAmbientLightSensor,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kAutoplay,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kCamera,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kClientHintDPR,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kClientHintDeviceMemory,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kClientHintDownlink,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kClientHintECT,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kClientHintLang,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kClientHintRTT,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kClientHintUA,
        FeaturePolicyFeatureDefault::EnableForAll
      },      {
        mojom::FeaturePolicyFeature::kClientHintUAArch,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kClientHintUAPlatform,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kClientHintUAModel,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kClientHintUAMobile,
        FeaturePolicyFeatureDefault::EnableForAll
      },      {
        mojom::FeaturePolicyFeature::kClientHintUAFullVersion,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kClientHintUAPlatformVersion,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kClientHintViewportWidth,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kClientHintWidth,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kClipboardRead,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kClipboardWrite,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kConversionMeasurement,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kCrossOriginIsolated,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kDocumentDomain,
        FeaturePolicyFeatureDefault::EnableForAll
      },      {
        mojom::FeaturePolicyFeature::kDownloads,
        FeaturePolicyFeatureDefault::EnableForAll
      },      {
        mojom::FeaturePolicyFeature::kEncryptedMedia,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kExecutionWhileOutOfViewport,
        FeaturePolicyFeatureDefault::EnableForAll
      },      {
        mojom::FeaturePolicyFeature::kExecutionWhileNotRendered,
        FeaturePolicyFeatureDefault::EnableForAll
      },      {
        mojom::FeaturePolicyFeature::kFocusWithoutUserActivation,
        FeaturePolicyFeatureDefault::EnableForAll
      },      {
        mojom::FeaturePolicyFeature::kFormSubmission,
        FeaturePolicyFeatureDefault::EnableForAll
      },      {
        mojom::FeaturePolicyFeature::kFullscreen,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kFrobulate,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kGamepad,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kGeolocation,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kGyroscope,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kHid,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kIdleDetection,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kMagnetometer,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kMicrophone,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kMidiFeature,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kModals,
        FeaturePolicyFeatureDefault::EnableForAll
      },      {
        mojom::FeaturePolicyFeature::kOrientationLock,
        FeaturePolicyFeatureDefault::EnableForAll
      },      {
        mojom::FeaturePolicyFeature::kPayment,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kPictureInPicture,
        FeaturePolicyFeatureDefault::EnableForAll
      },      {
        mojom::FeaturePolicyFeature::kPointerLock,
        FeaturePolicyFeatureDefault::EnableForAll
      },      {
        mojom::FeaturePolicyFeature::kPopups,
        FeaturePolicyFeatureDefault::EnableForAll
      },      {
        mojom::FeaturePolicyFeature::kPresentation,
        FeaturePolicyFeatureDefault::EnableForAll
      },      {
        mojom::FeaturePolicyFeature::kPublicKeyCredentialsGet,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kScreenWakeLock,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kScript,
        FeaturePolicyFeatureDefault::EnableForAll
      },      {
        mojom::FeaturePolicyFeature::kSerial,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kStorageAccessAPI,
        FeaturePolicyFeatureDefault::EnableForAll
      },      {
        mojom::FeaturePolicyFeature::kSyncXHR,
        FeaturePolicyFeatureDefault::EnableForAll
      },      {
        mojom::FeaturePolicyFeature::kTopNavigation,
        FeaturePolicyFeatureDefault::EnableForAll
      },      {
        mojom::FeaturePolicyFeature::kTrustTokenRedemption,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kUsb,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kVerticalScroll,
        FeaturePolicyFeatureDefault::EnableForAll
      },      {
        mojom::FeaturePolicyFeature::kWebShare,
        FeaturePolicyFeatureDefault::EnableForSelf
      },      {
        mojom::FeaturePolicyFeature::kWebXr,
        FeaturePolicyFeatureDefault::EnableForSelf
      },  });
  return *feature_list;
}

} // namespace blink
