// services/video_capture/public/mojom/virtual_device.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIRTUAL_DEVICE_MOJOM_PARAMS_DATA_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIRTUAL_DEVICE_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace video_capture {
namespace mojom {
namespace internal {
class  SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data));
      new (data()) SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data>(index_);
    }
    SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> dimension;
  int32_t pixel_format;
  uint8_t pad1_[4];
  mojo::internal::Pointer<::media::mojom::internal::PlaneStrides_Data> strides;

 private:
  SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data();
  ~SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data() = delete;
};
static_assert(sizeof(SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data) == 32,
              "Bad sizeof(SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data)");
class  SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data));
      new (data()) SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data>(index_);
    }
    SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t buffer_id;
  uint8_t padfinal_[4];

 private:
  SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data();
  ~SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data() = delete;
};
static_assert(sizeof(SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data) == 16,
              "Bad sizeof(SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data)");
class  SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data));
      new (data()) SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data>(index_);
    }
    SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t buffer_id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::media::mojom::internal::VideoFrameInfo_Data> frame_info;

 private:
  SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data();
  ~SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data() = delete;
};
static_assert(sizeof(SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data) == 24,
              "Bad sizeof(SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data)");
class  TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data));
      new (data()) TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data>(index_);
    }
    TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t buffer_id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::media::mojom::internal::MailboxBufferHandleSet_Data> mailbox_handles;

 private:
  TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data();
  ~TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data() = delete;
};
static_assert(sizeof(TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data) == 24,
              "Bad sizeof(TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data)");
class  TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data));
      new (data()) TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data>(index_);
    }
    TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t buffer_id;
  mojo::internal::Interface_Data access_permission;
  uint8_t pad1_[4];
  mojo::internal::Pointer<::media::mojom::internal::VideoFrameInfo_Data> frame_info;

 private:
  TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data();
  ~TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data() = delete;
};
static_assert(sizeof(TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data) == 32,
              "Bad sizeof(TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data)");
class  TextureVirtualDevice_OnBufferRetired_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(TextureVirtualDevice_OnBufferRetired_Params_Data));
      new (data()) TextureVirtualDevice_OnBufferRetired_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    TextureVirtualDevice_OnBufferRetired_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<TextureVirtualDevice_OnBufferRetired_Params_Data>(index_);
    }
    TextureVirtualDevice_OnBufferRetired_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t buffer_id;
  uint8_t padfinal_[4];

 private:
  TextureVirtualDevice_OnBufferRetired_Params_Data();
  ~TextureVirtualDevice_OnBufferRetired_Params_Data() = delete;
};
static_assert(sizeof(TextureVirtualDevice_OnBufferRetired_Params_Data) == 16,
              "Bad sizeof(TextureVirtualDevice_OnBufferRetired_Params_Data)");
class  GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data));
      new (data()) GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data>(index_);
    }
    GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t buffer_id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::gfx::mojom::internal::GpuMemoryBufferHandle_Data> gmb_handle;

 private:
  GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data();
  ~GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data() = delete;
};
static_assert(sizeof(GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data) == 24,
              "Bad sizeof(GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data)");
class  GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data));
      new (data()) GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data>(index_);
    }
    GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t buffer_id;
  mojo::internal::Interface_Data access_permission;
  uint8_t pad1_[4];
  mojo::internal::Pointer<::media::mojom::internal::VideoFrameInfo_Data> frame_info;

 private:
  GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data();
  ~GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data() = delete;
};
static_assert(sizeof(GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data) == 32,
              "Bad sizeof(GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data)");
class  GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data));
      new (data()) GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data>(index_);
    }
    GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t buffer_id;
  uint8_t padfinal_[4];

 private:
  GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data();
  ~GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data() = delete;
};
static_assert(sizeof(GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data) == 16,
              "Bad sizeof(GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data)");

}  // namespace internal


class SharedMemoryVirtualDevice_RequestFrameBuffer_ParamsDataView {
 public:
  SharedMemoryVirtualDevice_RequestFrameBuffer_ParamsDataView() {}

  SharedMemoryVirtualDevice_RequestFrameBuffer_ParamsDataView(
      internal::SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetDimensionDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDimension(UserType* output) {
    
    auto* pointer = data_->dimension.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPixelFormat(UserType* output) const {
    auto data_value = data_->pixel_format;
    return mojo::internal::Deserialize<::media::mojom::VideoCapturePixelFormat>(
        data_value, output);
  }

  ::media::mojom::VideoCapturePixelFormat pixel_format() const {
    return static_cast<::media::mojom::VideoCapturePixelFormat>(data_->pixel_format);
  }
  inline void GetStridesDataView(
      ::media::mojom::PlaneStridesDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStrides(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::PlaneStridesDataView, UserType>(),
    "Attempting to read the optional `strides` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStrides` instead "
    "of `ReadStrides if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->strides.Get();
    return mojo::internal::Deserialize<::media::mojom::PlaneStridesDataView>(
        pointer, output, context_);
  }
 private:
  internal::SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParamsDataView {
 public:
  SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParamsDataView() {}

  SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParamsDataView(
      internal::SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t buffer_id() const {
    return data_->buffer_id;
  }
 private:
  internal::SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data* data_ = nullptr;
};



class SharedMemoryVirtualDevice_OnFrameReadyInBuffer_ParamsDataView {
 public:
  SharedMemoryVirtualDevice_OnFrameReadyInBuffer_ParamsDataView() {}

  SharedMemoryVirtualDevice_OnFrameReadyInBuffer_ParamsDataView(
      internal::SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t buffer_id() const {
    return data_->buffer_id;
  }
  inline void GetFrameInfoDataView(
      ::media::mojom::VideoFrameInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFrameInfo(UserType* output) {
    
    auto* pointer = data_->frame_info.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoFrameInfoDataView>(
        pointer, output, context_);
  }
 private:
  internal::SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class TextureVirtualDevice_OnNewMailboxHolderBufferHandle_ParamsDataView {
 public:
  TextureVirtualDevice_OnNewMailboxHolderBufferHandle_ParamsDataView() {}

  TextureVirtualDevice_OnNewMailboxHolderBufferHandle_ParamsDataView(
      internal::TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t buffer_id() const {
    return data_->buffer_id;
  }
  inline void GetMailboxHandlesDataView(
      ::media::mojom::MailboxBufferHandleSetDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMailboxHandles(UserType* output) {
    
    auto* pointer = data_->mailbox_handles.Get();
    return mojo::internal::Deserialize<::media::mojom::MailboxBufferHandleSetDataView>(
        pointer, output, context_);
  }
 private:
  internal::TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class TextureVirtualDevice_OnFrameReadyInBuffer_ParamsDataView {
 public:
  TextureVirtualDevice_OnFrameReadyInBuffer_ParamsDataView() {}

  TextureVirtualDevice_OnFrameReadyInBuffer_ParamsDataView(
      internal::TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t buffer_id() const {
    return data_->buffer_id;
  }
  template <typename UserType>
  UserType TakeAccessPermission() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::video_capture::mojom::ScopedAccessPermissionInterfaceBase>>(
            &data_->access_permission, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetFrameInfoDataView(
      ::media::mojom::VideoFrameInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFrameInfo(UserType* output) {
    
    auto* pointer = data_->frame_info.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoFrameInfoDataView>(
        pointer, output, context_);
  }
 private:
  internal::TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class TextureVirtualDevice_OnBufferRetired_ParamsDataView {
 public:
  TextureVirtualDevice_OnBufferRetired_ParamsDataView() {}

  TextureVirtualDevice_OnBufferRetired_ParamsDataView(
      internal::TextureVirtualDevice_OnBufferRetired_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t buffer_id() const {
    return data_->buffer_id;
  }
 private:
  internal::TextureVirtualDevice_OnBufferRetired_Params_Data* data_ = nullptr;
};



class GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_ParamsDataView {
 public:
  GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_ParamsDataView() {}

  GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_ParamsDataView(
      internal::GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t buffer_id() const {
    return data_->buffer_id;
  }
  inline void GetGmbHandleDataView(
      ::gfx::mojom::GpuMemoryBufferHandleDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadGmbHandle(UserType* output) {
    
    auto* pointer = data_->gmb_handle.Get();
    return mojo::internal::Deserialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
        pointer, output, context_);
  }
 private:
  internal::GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_ParamsDataView {
 public:
  GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_ParamsDataView() {}

  GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_ParamsDataView(
      internal::GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t buffer_id() const {
    return data_->buffer_id;
  }
  template <typename UserType>
  UserType TakeAccessPermission() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::video_capture::mojom::ScopedAccessPermissionInterfaceBase>>(
            &data_->access_permission, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetFrameInfoDataView(
      ::media::mojom::VideoFrameInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFrameInfo(UserType* output) {
    
    auto* pointer = data_->frame_info.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoFrameInfoDataView>(
        pointer, output, context_);
  }
 private:
  internal::GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class GpuMemoryBufferVirtualDevice_OnBufferRetired_ParamsDataView {
 public:
  GpuMemoryBufferVirtualDevice_OnBufferRetired_ParamsDataView() {}

  GpuMemoryBufferVirtualDevice_OnBufferRetired_ParamsDataView(
      internal::GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t buffer_id() const {
    return data_->buffer_id;
  }
 private:
  internal::GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data* data_ = nullptr;
};


inline void SharedMemoryVirtualDevice_RequestFrameBuffer_ParamsDataView::GetDimensionDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->dimension.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}
inline void SharedMemoryVirtualDevice_RequestFrameBuffer_ParamsDataView::GetStridesDataView(
    ::media::mojom::PlaneStridesDataView* output) {
  auto pointer = data_->strides.Get();
  *output = ::media::mojom::PlaneStridesDataView(pointer, context_);
}




inline void SharedMemoryVirtualDevice_OnFrameReadyInBuffer_ParamsDataView::GetFrameInfoDataView(
    ::media::mojom::VideoFrameInfoDataView* output) {
  auto pointer = data_->frame_info.Get();
  *output = ::media::mojom::VideoFrameInfoDataView(pointer, context_);
}


inline void TextureVirtualDevice_OnNewMailboxHolderBufferHandle_ParamsDataView::GetMailboxHandlesDataView(
    ::media::mojom::MailboxBufferHandleSetDataView* output) {
  auto pointer = data_->mailbox_handles.Get();
  *output = ::media::mojom::MailboxBufferHandleSetDataView(pointer, context_);
}


inline void TextureVirtualDevice_OnFrameReadyInBuffer_ParamsDataView::GetFrameInfoDataView(
    ::media::mojom::VideoFrameInfoDataView* output) {
  auto pointer = data_->frame_info.Get();
  *output = ::media::mojom::VideoFrameInfoDataView(pointer, context_);
}




inline void GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_ParamsDataView::GetGmbHandleDataView(
    ::gfx::mojom::GpuMemoryBufferHandleDataView* output) {
  auto pointer = data_->gmb_handle.Get();
  *output = ::gfx::mojom::GpuMemoryBufferHandleDataView(pointer, context_);
}


inline void GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_ParamsDataView::GetFrameInfoDataView(
    ::media::mojom::VideoFrameInfoDataView* output) {
  auto pointer = data_->frame_info.Get();
  *output = ::media::mojom::VideoFrameInfoDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace video_capture

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIRTUAL_DEVICE_MOJOM_PARAMS_DATA_H_