// media/mojo/mojom/interface_factory.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/interface_factory.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "media/mojo/mojom/interface_factory.mojom-params-data.h"
#include "media/mojo/mojom/interface_factory.mojom-shared-message-ids.h"

#include "media/mojo/mojom/interface_factory.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_INTERFACE_FACTORY_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_INTERFACE_FACTORY_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
const char InterfaceFactory::Name_[] = "media.mojom.InterfaceFactory";

class InterfaceFactory_CreateCdm_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  InterfaceFactory_CreateCdm_ForwardToCallback(
      InterfaceFactory::CreateCdmCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  InterfaceFactory::CreateCdmCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(InterfaceFactory_CreateCdm_ForwardToCallback);
};

InterfaceFactoryProxy::InterfaceFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void InterfaceFactoryProxy::CreateAudioDecoder(
    ::mojo::PendingReceiver<::media::mojom::AudioDecoder> in_audio_decoder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::InterfaceFactory::CreateAudioDecoder", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("audio_decoder", in_audio_decoder.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kInterfaceFactory_CreateAudioDecoder_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::InterfaceFactory_CreateAudioDecoder_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioDecoderInterfaceBase>>(
      in_audio_decoder, &params->audio_decoder, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->audio_decoder),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid audio_decoder in InterfaceFactory.CreateAudioDecoder request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InterfaceFactory::Name_);
  message.set_method_name("CreateAudioDecoder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void InterfaceFactoryProxy::CreateVideoDecoder(
    ::mojo::PendingReceiver<::media::mojom::VideoDecoder> in_video_decoder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::InterfaceFactory::CreateVideoDecoder", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("video_decoder", in_video_decoder.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kInterfaceFactory_CreateVideoDecoder_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::InterfaceFactory_CreateVideoDecoder_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::VideoDecoderInterfaceBase>>(
      in_video_decoder, &params->video_decoder, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->video_decoder),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid video_decoder in InterfaceFactory.CreateVideoDecoder request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InterfaceFactory::Name_);
  message.set_method_name("CreateVideoDecoder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void InterfaceFactoryProxy::CreateDefaultRenderer(
    const std::string& in_audio_device_id, ::mojo::PendingReceiver<::media::mojom::Renderer> in_renderer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::InterfaceFactory::CreateDefaultRenderer", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("audio_device_id", in_audio_device_id);
      raw_value->SetBoolean("renderer", in_renderer.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kInterfaceFactory_CreateDefaultRenderer_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::InterfaceFactory_CreateDefaultRenderer_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->audio_device_id)::BaseType::BufferWriter
      audio_device_id_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_audio_device_id, buffer, &audio_device_id_writer, &serialization_context);
  params->audio_device_id.Set(
      audio_device_id_writer.is_null() ? nullptr : audio_device_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->audio_device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null audio_device_id in InterfaceFactory.CreateDefaultRenderer request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::RendererInterfaceBase>>(
      in_renderer, &params->renderer, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->renderer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid renderer in InterfaceFactory.CreateDefaultRenderer request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InterfaceFactory::Name_);
  message.set_method_name("CreateDefaultRenderer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void InterfaceFactoryProxy::CreateCdm(
    const std::string& in_key_system, const ::media::CdmConfig& in_cdm_config, CreateCdmCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::InterfaceFactory::CreateCdm", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("key_system", in_key_system);
      raw_value->SetString("cdm_config", base::trace_event::ValueToString(in_cdm_config, "<value of type const ::media::CdmConfig&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kInterfaceFactory_CreateCdm_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::InterfaceFactory_CreateCdm_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->key_system)::BaseType::BufferWriter
      key_system_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_key_system, buffer, &key_system_writer, &serialization_context);
  params->key_system.Set(
      key_system_writer.is_null() ? nullptr : key_system_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_system.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_system in InterfaceFactory.CreateCdm request");
  typename decltype(params->cdm_config)::BaseType::BufferWriter
      cdm_config_writer;
  mojo::internal::Serialize<::media::mojom::CdmConfigDataView>(
      in_cdm_config, buffer, &cdm_config_writer, &serialization_context);
  params->cdm_config.Set(
      cdm_config_writer.is_null() ? nullptr : cdm_config_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cdm_config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cdm_config in InterfaceFactory.CreateCdm request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InterfaceFactory::Name_);
  message.set_method_name("CreateCdm");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new InterfaceFactory_CreateCdm_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class InterfaceFactory_CreateCdm_ProxyToResponder {
 public:
  static InterfaceFactory::CreateCdmCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<InterfaceFactory_CreateCdm_ProxyToResponder> proxy(
        new InterfaceFactory_CreateCdm_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&InterfaceFactory_CreateCdm_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~InterfaceFactory_CreateCdm_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  InterfaceFactory_CreateCdm_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "InterfaceFactory::CreateCdmCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<::media::mojom::ContentDecryptionModule> in_cdm, const base::Optional<::base::UnguessableToken>& in_cdm_id, ::mojo::PendingRemote<::media::mojom::Decryptor> in_decryptor, const std::string& in_error_message);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(InterfaceFactory_CreateCdm_ProxyToResponder);
};

bool InterfaceFactory_CreateCdm_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::InterfaceFactory::CreateCdmCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::InterfaceFactory_CreateCdm_ResponseParams_Data* params =
      reinterpret_cast<
          internal::InterfaceFactory_CreateCdm_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::mojo::PendingRemote<::media::mojom::ContentDecryptionModule> p_cdm{};
  base::Optional<::base::UnguessableToken> p_cdm_id{};
  ::mojo::PendingRemote<::media::mojom::Decryptor> p_decryptor{};
  std::string p_error_message{};
  InterfaceFactory_CreateCdm_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success) {
    p_cdm =
        input_data_view.TakeCdm<decltype(p_cdm)>();
  }
  if (success && !input_data_view.ReadCdmId(&p_cdm_id))
    success = false;
  if (success) {
    p_decryptor =
        input_data_view.TakeDecryptor<decltype(p_decryptor)>();
  }
  if (success && !input_data_view.ReadErrorMessage(&p_error_message))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        InterfaceFactory::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_cdm), 
std::move(p_cdm_id), 
std::move(p_decryptor), 
std::move(p_error_message));
  return true;
}

void InterfaceFactory_CreateCdm_ProxyToResponder::Run(
    ::mojo::PendingRemote<::media::mojom::ContentDecryptionModule> in_cdm, const base::Optional<::base::UnguessableToken>& in_cdm_id, ::mojo::PendingRemote<::media::mojom::Decryptor> in_decryptor, const std::string& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::InterfaceFactory::CreateCdmCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("cdm", in_cdm.is_valid());
      raw_value->SetString("cdm_id", base::trace_event::ValueToString(in_cdm_id, "<value of type const base::Optional<::base::UnguessableToken>&>"));
      raw_value->SetBoolean("decryptor", in_decryptor.is_valid());
      raw_value->SetString("error_message", in_error_message);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kInterfaceFactory_CreateCdm_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::InterfaceFactory_CreateCdm_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::ContentDecryptionModuleInterfaceBase>>(
      in_cdm, &params->cdm, &serialization_context);
  typename decltype(params->cdm_id)::BaseType::BufferWriter
      cdm_id_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_cdm_id, buffer, &cdm_id_writer, &serialization_context);
  params->cdm_id.Set(
      cdm_id_writer.is_null() ? nullptr : cdm_id_writer.data());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::DecryptorInterfaceBase>>(
      in_decryptor, &params->decryptor, &serialization_context);
  typename decltype(params->error_message)::BaseType::BufferWriter
      error_message_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_message, buffer, &error_message_writer, &serialization_context);
  params->error_message.Set(
      error_message_writer.is_null() ? nullptr : error_message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::InterfaceFactory::CreateCdmCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InterfaceFactory::Name_);
  message.set_method_name("CreateCdm");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool InterfaceFactoryStubDispatch::Accept(
    InterfaceFactory* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kInterfaceFactory_CreateAudioDecoder_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::InterfaceFactory::CreateAudioDecoder",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::InterfaceFactory::CreateAudioDecoder");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::InterfaceFactory_CreateAudioDecoder_Params_Data* params =
          reinterpret_cast<internal::InterfaceFactory_CreateAudioDecoder_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::AudioDecoder> p_audio_decoder{};
      InterfaceFactory_CreateAudioDecoder_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_audio_decoder =
            input_data_view.TakeAudioDecoder<decltype(p_audio_decoder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InterfaceFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAudioDecoder(
std::move(p_audio_decoder));
      return true;
    }
    case internal::kInterfaceFactory_CreateVideoDecoder_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::InterfaceFactory::CreateVideoDecoder",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::InterfaceFactory::CreateVideoDecoder");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::InterfaceFactory_CreateVideoDecoder_Params_Data* params =
          reinterpret_cast<internal::InterfaceFactory_CreateVideoDecoder_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::VideoDecoder> p_video_decoder{};
      InterfaceFactory_CreateVideoDecoder_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_video_decoder =
            input_data_view.TakeVideoDecoder<decltype(p_video_decoder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InterfaceFactory::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateVideoDecoder(
std::move(p_video_decoder));
      return true;
    }
    case internal::kInterfaceFactory_CreateDefaultRenderer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::InterfaceFactory::CreateDefaultRenderer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::InterfaceFactory::CreateDefaultRenderer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::InterfaceFactory_CreateDefaultRenderer_Params_Data* params =
          reinterpret_cast<internal::InterfaceFactory_CreateDefaultRenderer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_audio_device_id{};
      ::mojo::PendingReceiver<::media::mojom::Renderer> p_renderer{};
      InterfaceFactory_CreateDefaultRenderer_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadAudioDeviceId(&p_audio_device_id))
        success = false;
      if (success) {
        p_renderer =
            input_data_view.TakeRenderer<decltype(p_renderer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InterfaceFactory::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateDefaultRenderer(
std::move(p_audio_device_id), 
std::move(p_renderer));
      return true;
    }
    case internal::kInterfaceFactory_CreateCdm_Name: {
      break;
    }
  }
  return false;
}

// static
bool InterfaceFactoryStubDispatch::AcceptWithResponder(
    InterfaceFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kInterfaceFactory_CreateAudioDecoder_Name: {
      break;
    }
    case internal::kInterfaceFactory_CreateVideoDecoder_Name: {
      break;
    }
    case internal::kInterfaceFactory_CreateDefaultRenderer_Name: {
      break;
    }
    case internal::kInterfaceFactory_CreateCdm_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::InterfaceFactory::CreateCdm",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::InterfaceFactory::CreateCdm");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::InterfaceFactory_CreateCdm_Params_Data* params =
          reinterpret_cast<
              internal::InterfaceFactory_CreateCdm_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_key_system{};
      ::media::CdmConfig p_cdm_config{};
      InterfaceFactory_CreateCdm_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadKeySystem(&p_key_system))
        success = false;
      if (success && !input_data_view.ReadCdmConfig(&p_cdm_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InterfaceFactory::Name_, 3, false);
        return false;
      }
      InterfaceFactory::CreateCdmCallback callback =
          InterfaceFactory_CreateCdm_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCdm(
std::move(p_key_system), 
std::move(p_cdm_config), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kInterfaceFactoryValidationInfo[] = {
    {internal::kInterfaceFactory_CreateAudioDecoder_Name,
     {&internal::InterfaceFactory_CreateAudioDecoder_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kInterfaceFactory_CreateVideoDecoder_Name,
     {&internal::InterfaceFactory_CreateVideoDecoder_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kInterfaceFactory_CreateDefaultRenderer_Name,
     {&internal::InterfaceFactory_CreateDefaultRenderer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kInterfaceFactory_CreateCdm_Name,
     {&internal::InterfaceFactory_CreateCdm_Params_Data::Validate,
      &internal::InterfaceFactory_CreateCdm_ResponseParams_Data::Validate}},
};

bool InterfaceFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::InterfaceFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kInterfaceFactoryValidationInfo);
}

bool InterfaceFactoryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::InterfaceFactory::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kInterfaceFactoryValidationInfo);

}
}  // namespace mojom
}  // namespace media

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif