// content/common/frame.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_FRAME_MOJOM_SHARED_INTERNAL_H_
#define CONTENT_COMMON_FRAME_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "content/common/document_scoped_interface_bundle.mojom-shared-internal.h"
#include "content/common/frame_messages.mojom-shared-internal.h"
#include "content/common/native_types.mojom-shared-internal.h"
#include "content/common/navigation_client.mojom-shared-internal.h"
#include "content/common/navigation_params.mojom-shared-internal.h"
#include "content/common/web_ui.mojom-shared-internal.h"
#include "content/public/common/browser_controls_state.mojom-shared-internal.h"
#include "content/public/common/window_container_type.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared-internal.h"
#include "mojo/public/mojom/base/values.mojom-shared-internal.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared-internal.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-shared-internal.h"
#include "services/network/public/mojom/url_loader.mojom-shared-internal.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared-internal.h"
#include "services/network/public/mojom/url_response_head.mojom-shared-internal.h"
#include "services/service_manager/public/mojom/interface_provider.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/commit_result/commit_result.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/feature_policy/document_policy_feature.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/feature_policy/feature_policy.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/feature_policy/feature_policy_feature.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/feature_policy/policy_value.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/frame/lifecycle.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/frame/navigation_initiator.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/page/page.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/page/widget.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/portal/portal.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/widget/visual_properties.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/window_features/window_features.mojom-shared-internal.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared-internal.h"
#include "ui/base/mojom/window_open_disposition.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"
#include "base/component_export.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace content {
namespace mojom {
namespace internal {
class CreateNewWindowParams_Data;
class CreateNewWindowReply_Data;
class OpenURLParams_Data;

struct CreateNewWindowStatus_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};
using TriggeringEventInfo_Data =
    mojo::internal::NativeEnum_Data;

#pragma pack(push, 1)
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) CreateNewWindowParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CreateNewWindowParams_Data));
      new (data()) CreateNewWindowParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CreateNewWindowParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CreateNewWindowParams_Data>(index_);
    }
    CreateNewWindowParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t allow_popup : 1;
  uint8_t opener_suppressed : 1;
  uint8_t pad1_[3];
  int32_t window_container_type;
  mojo::internal::Pointer<mojo::internal::String_Data> session_storage_namespace_id;
  mojo::internal::Pointer<mojo::internal::String_Data> clone_from_session_storage_namespace_id;
  mojo::internal::Pointer<mojo::internal::String_Data> frame_name;
  int32_t disposition;
  uint8_t pad6_[4];
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> target_url;
  mojo::internal::Pointer<::blink::mojom::internal::Referrer_Data> referrer;
  mojo::internal::Pointer<::blink::mojom::internal::WindowFeatures_Data> features;

 private:
  CreateNewWindowParams_Data();
  ~CreateNewWindowParams_Data() = delete;
};
static_assert(sizeof(CreateNewWindowParams_Data) == 72,
              "Bad sizeof(CreateNewWindowParams_Data)");
// Used by CreateNewWindowParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CreateNewWindowParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CreateNewWindowParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CreateNewWindowParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    CreateNewWindowParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CreateNewWindowParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) CreateNewWindowReply_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CreateNewWindowReply_Data));
      new (data()) CreateNewWindowReply_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CreateNewWindowReply_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CreateNewWindowReply_Data>(index_);
    }
    CreateNewWindowReply_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t route_id;
  int32_t main_frame_route_id;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> main_frame_frame_token;
  int32_t main_frame_widget_route_id;
  mojo::internal::AssociatedEndpointHandle_Data frame_widget;
  mojo::internal::Pointer<::blink::mojom::internal::VisualProperties_Data> visual_properties;
  mojo::internal::AssociatedInterface_Data frame_widget_host;
  mojo::internal::AssociatedInterface_Data widget_host;
  mojo::internal::AssociatedEndpointHandle_Data widget;
  mojo::internal::AssociatedEndpointHandle_Data page_broadcast;
  mojo::internal::Pointer<::content::mojom::internal::DocumentScopedInterfaceBundle_Data> main_frame_interface_bundle;
  mojo::internal::Pointer<mojo::internal::String_Data> cloned_session_storage_namespace_id;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> devtools_main_frame_token;
  uint8_t wait_for_debugger : 1;
  uint8_t padfinal_[7];

 private:
  CreateNewWindowReply_Data();
  ~CreateNewWindowReply_Data() = delete;
};
static_assert(sizeof(CreateNewWindowReply_Data) == 96,
              "Bad sizeof(CreateNewWindowReply_Data)");
// Used by CreateNewWindowReply::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CreateNewWindowReply_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CreateNewWindowReply_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CreateNewWindowReply_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    CreateNewWindowReply_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CreateNewWindowReply_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) OpenURLParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(OpenURLParams_Data));
      new (data()) OpenURLParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    OpenURLParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<OpenURLParams_Data>(index_);
    }
    OpenURLParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> initiator_origin;
  int32_t initiator_routing_id;
  int32_t disposition;
  mojo::internal::Pointer<::network::mojom::internal::URLRequestBody_Data> post_body;
  mojo::internal::Pointer<mojo::internal::String_Data> extra_headers;
  mojo::internal::Pointer<::blink::mojom::internal::Referrer_Data> referrer;
  uint8_t should_replace_current_entry : 1;
  uint8_t user_gesture : 1;
  uint8_t pad8_[3];
  int32_t triggering_event_info;
  mojo::internal::Handle_Data blob_url_token;
  uint8_t pad10_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> href_translate;
  mojo::internal::Pointer<::content::mojom::internal::Impression_Data> impression;
  mojo::internal::Pointer<::content::mojom::internal::NavigationDownloadPolicy_Data> download_policy;

 private:
  OpenURLParams_Data();
  ~OpenURLParams_Data() = delete;
};
static_assert(sizeof(OpenURLParams_Data) == 96,
              "Bad sizeof(OpenURLParams_Data)");
// Used by OpenURLParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct OpenURLParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  OpenURLParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~OpenURLParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    OpenURLParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    OpenURLParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace content

#endif  // CONTENT_COMMON_FRAME_MOJOM_SHARED_INTERNAL_H_