// content/browser/conversions/conversion_internals.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_CONVERSIONS_CONVERSION_INTERNALS_MOJOM_SHARED_H_
#define CONTENT_BROWSER_CONVERSIONS_CONVERSION_INTERNALS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "content/browser/conversions/conversion_internals.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace mojom {
class WebUIConversionReportDataView;

class WebUIImpressionDataView;



}  // namespace mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mojom::WebUIConversionReportDataView> {
  using Data = ::mojom::internal::WebUIConversionReport_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::WebUIImpressionDataView> {
  using Data = ::mojom::internal::WebUIImpression_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace mojom {
// Interface base classes. They are used for type safety check.
class ConversionInternalsHandlerInterfaceBase {};

using ConversionInternalsHandlerPtrDataView =
    mojo::InterfacePtrDataView<ConversionInternalsHandlerInterfaceBase>;
using ConversionInternalsHandlerRequestDataView =
    mojo::InterfaceRequestDataView<ConversionInternalsHandlerInterfaceBase>;
using ConversionInternalsHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ConversionInternalsHandlerInterfaceBase>;
using ConversionInternalsHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ConversionInternalsHandlerInterfaceBase>;


class WebUIConversionReportDataView {
 public:
  WebUIConversionReportDataView() {}

  WebUIConversionReportDataView(
      internal::WebUIConversionReport_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetImpressionDataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadImpressionData(UserType* output) {
    
    auto* pointer = data_->impression_data.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetConversionDataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadConversionData(UserType* output) {
    
    auto* pointer = data_->conversion_data.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetConversionOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadConversionOrigin(UserType* output) {
    
    auto* pointer = data_->conversion_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, context_);
  }
  inline void GetReportingOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReportingOrigin(UserType* output) {
    
    auto* pointer = data_->reporting_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, context_);
  }
  double report_time() const {
    return data_->report_time;
  }
  int32_t attribution_credit() const {
    return data_->attribution_credit;
  }
 private:
  internal::WebUIConversionReport_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class WebUIImpressionDataView {
 public:
  WebUIImpressionDataView() {}

  WebUIImpressionDataView(
      internal::WebUIImpression_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetImpressionDataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadImpressionData(UserType* output) {
    
    auto* pointer = data_->impression_data.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetImpressionOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadImpressionOrigin(UserType* output) {
    
    auto* pointer = data_->impression_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, context_);
  }
  inline void GetConversionDestinationDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadConversionDestination(UserType* output) {
    
    auto* pointer = data_->conversion_destination.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, context_);
  }
  inline void GetReportingOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReportingOrigin(UserType* output) {
    
    auto* pointer = data_->reporting_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, context_);
  }
  double impression_time() const {
    return data_->impression_time;
  }
  double expiry_time() const {
    return data_->expiry_time;
  }
 private:
  internal::WebUIImpression_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::WebUIConversionReportDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::WebUIConversionReportDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::mojom::internal::WebUIConversionReport_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::impression_data(input)) in_impression_data = Traits::impression_data(input);
    typename decltype((*output)->impression_data)::BaseType::BufferWriter
        impression_data_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_impression_data, buffer, &impression_data_writer, context);
    (*output)->impression_data.Set(
        impression_data_writer.is_null() ? nullptr : impression_data_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->impression_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null impression_data in WebUIConversionReport struct");
    decltype(Traits::conversion_data(input)) in_conversion_data = Traits::conversion_data(input);
    typename decltype((*output)->conversion_data)::BaseType::BufferWriter
        conversion_data_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_conversion_data, buffer, &conversion_data_writer, context);
    (*output)->conversion_data.Set(
        conversion_data_writer.is_null() ? nullptr : conversion_data_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->conversion_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null conversion_data in WebUIConversionReport struct");
    decltype(Traits::conversion_origin(input)) in_conversion_origin = Traits::conversion_origin(input);
    typename decltype((*output)->conversion_origin)::BaseType::BufferWriter
        conversion_origin_writer;
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_conversion_origin, buffer, &conversion_origin_writer, context);
    (*output)->conversion_origin.Set(
        conversion_origin_writer.is_null() ? nullptr : conversion_origin_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->conversion_origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null conversion_origin in WebUIConversionReport struct");
    decltype(Traits::reporting_origin(input)) in_reporting_origin = Traits::reporting_origin(input);
    typename decltype((*output)->reporting_origin)::BaseType::BufferWriter
        reporting_origin_writer;
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_reporting_origin, buffer, &reporting_origin_writer, context);
    (*output)->reporting_origin.Set(
        reporting_origin_writer.is_null() ? nullptr : reporting_origin_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->reporting_origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reporting_origin in WebUIConversionReport struct");
    (*output)->report_time = Traits::report_time(input);
    (*output)->attribution_credit = Traits::attribution_credit(input);
  }

  static bool Deserialize(::mojom::internal::WebUIConversionReport_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojom::WebUIConversionReportDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::WebUIImpressionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::WebUIImpressionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::mojom::internal::WebUIImpression_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::impression_data(input)) in_impression_data = Traits::impression_data(input);
    typename decltype((*output)->impression_data)::BaseType::BufferWriter
        impression_data_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_impression_data, buffer, &impression_data_writer, context);
    (*output)->impression_data.Set(
        impression_data_writer.is_null() ? nullptr : impression_data_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->impression_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null impression_data in WebUIImpression struct");
    decltype(Traits::impression_origin(input)) in_impression_origin = Traits::impression_origin(input);
    typename decltype((*output)->impression_origin)::BaseType::BufferWriter
        impression_origin_writer;
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_impression_origin, buffer, &impression_origin_writer, context);
    (*output)->impression_origin.Set(
        impression_origin_writer.is_null() ? nullptr : impression_origin_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->impression_origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null impression_origin in WebUIImpression struct");
    decltype(Traits::conversion_destination(input)) in_conversion_destination = Traits::conversion_destination(input);
    typename decltype((*output)->conversion_destination)::BaseType::BufferWriter
        conversion_destination_writer;
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_conversion_destination, buffer, &conversion_destination_writer, context);
    (*output)->conversion_destination.Set(
        conversion_destination_writer.is_null() ? nullptr : conversion_destination_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->conversion_destination.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null conversion_destination in WebUIImpression struct");
    decltype(Traits::reporting_origin(input)) in_reporting_origin = Traits::reporting_origin(input);
    typename decltype((*output)->reporting_origin)::BaseType::BufferWriter
        reporting_origin_writer;
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_reporting_origin, buffer, &reporting_origin_writer, context);
    (*output)->reporting_origin.Set(
        reporting_origin_writer.is_null() ? nullptr : reporting_origin_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->reporting_origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reporting_origin in WebUIImpression struct");
    (*output)->impression_time = Traits::impression_time(input);
    (*output)->expiry_time = Traits::expiry_time(input);
  }

  static bool Deserialize(::mojom::internal::WebUIImpression_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojom::WebUIImpressionDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace mojom {

inline void WebUIConversionReportDataView::GetImpressionDataDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->impression_data.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void WebUIConversionReportDataView::GetConversionDataDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->conversion_data.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void WebUIConversionReportDataView::GetConversionOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->conversion_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, context_);
}
inline void WebUIConversionReportDataView::GetReportingOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->reporting_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, context_);
}


inline void WebUIImpressionDataView::GetImpressionDataDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->impression_data.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void WebUIImpressionDataView::GetImpressionOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->impression_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, context_);
}
inline void WebUIImpressionDataView::GetConversionDestinationDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->conversion_destination.Get();
  *output = ::url::mojom::OriginDataView(pointer, context_);
}
inline void WebUIImpressionDataView::GetReportingOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->reporting_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, context_);
}



}  // namespace mojom

#endif  // CONTENT_BROWSER_CONVERSIONS_CONVERSION_INTERNALS_MOJOM_SHARED_H_