// components/services/storage/public/mojom/blob_storage_context.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace storage {
namespace mojom {
namespace internal {
class  BlobDataItemReader_Read_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(BlobDataItemReader_Read_Params_Data));
      new (data()) BlobDataItemReader_Read_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    BlobDataItemReader_Read_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<BlobDataItemReader_Read_Params_Data>(index_);
    }
    BlobDataItemReader_Read_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t offset;
  uint64_t length;
  mojo::internal::Handle_Data pipe;
  uint8_t padfinal_[4];

 private:
  BlobDataItemReader_Read_Params_Data();
  ~BlobDataItemReader_Read_Params_Data() = delete;
};
static_assert(sizeof(BlobDataItemReader_Read_Params_Data) == 32,
              "Bad sizeof(BlobDataItemReader_Read_Params_Data)");
class  BlobDataItemReader_Read_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(BlobDataItemReader_Read_ResponseParams_Data));
      new (data()) BlobDataItemReader_Read_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    BlobDataItemReader_Read_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<BlobDataItemReader_Read_ResponseParams_Data>(index_);
    }
    BlobDataItemReader_Read_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t success;
  uint8_t padfinal_[4];

 private:
  BlobDataItemReader_Read_ResponseParams_Data();
  ~BlobDataItemReader_Read_ResponseParams_Data() = delete;
};
static_assert(sizeof(BlobDataItemReader_Read_ResponseParams_Data) == 16,
              "Bad sizeof(BlobDataItemReader_Read_ResponseParams_Data)");
class  BlobDataItemReader_ReadSideData_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(BlobDataItemReader_ReadSideData_Params_Data));
      new (data()) BlobDataItemReader_ReadSideData_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    BlobDataItemReader_ReadSideData_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<BlobDataItemReader_ReadSideData_Params_Data>(index_);
    }
    BlobDataItemReader_ReadSideData_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  BlobDataItemReader_ReadSideData_Params_Data();
  ~BlobDataItemReader_ReadSideData_Params_Data() = delete;
};
static_assert(sizeof(BlobDataItemReader_ReadSideData_Params_Data) == 8,
              "Bad sizeof(BlobDataItemReader_ReadSideData_Params_Data)");
class  BlobDataItemReader_ReadSideData_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(BlobDataItemReader_ReadSideData_ResponseParams_Data));
      new (data()) BlobDataItemReader_ReadSideData_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    BlobDataItemReader_ReadSideData_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<BlobDataItemReader_ReadSideData_ResponseParams_Data>(index_);
    }
    BlobDataItemReader_ReadSideData_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t success;
  uint8_t pad0_[4];
  ::mojo_base::mojom::internal::BigBuffer_Data data;

 private:
  BlobDataItemReader_ReadSideData_ResponseParams_Data();
  ~BlobDataItemReader_ReadSideData_ResponseParams_Data() = delete;
};
static_assert(sizeof(BlobDataItemReader_ReadSideData_ResponseParams_Data) == 32,
              "Bad sizeof(BlobDataItemReader_ReadSideData_ResponseParams_Data)");
class  BlobStorageContext_RegisterFromDataItem_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(BlobStorageContext_RegisterFromDataItem_Params_Data));
      new (data()) BlobStorageContext_RegisterFromDataItem_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    BlobStorageContext_RegisterFromDataItem_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<BlobStorageContext_RegisterFromDataItem_Params_Data>(index_);
    }
    BlobStorageContext_RegisterFromDataItem_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data blob;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> uuid;
  mojo::internal::Pointer<internal::BlobDataItem_Data> item;

 private:
  BlobStorageContext_RegisterFromDataItem_Params_Data();
  ~BlobStorageContext_RegisterFromDataItem_Params_Data() = delete;
};
static_assert(sizeof(BlobStorageContext_RegisterFromDataItem_Params_Data) == 32,
              "Bad sizeof(BlobStorageContext_RegisterFromDataItem_Params_Data)");
class  BlobStorageContext_RegisterFromMemory_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(BlobStorageContext_RegisterFromMemory_Params_Data));
      new (data()) BlobStorageContext_RegisterFromMemory_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    BlobStorageContext_RegisterFromMemory_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<BlobStorageContext_RegisterFromMemory_Params_Data>(index_);
    }
    BlobStorageContext_RegisterFromMemory_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data blob;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> uuid;
  ::mojo_base::mojom::internal::BigBuffer_Data data;

 private:
  BlobStorageContext_RegisterFromMemory_Params_Data();
  ~BlobStorageContext_RegisterFromMemory_Params_Data() = delete;
};
static_assert(sizeof(BlobStorageContext_RegisterFromMemory_Params_Data) == 40,
              "Bad sizeof(BlobStorageContext_RegisterFromMemory_Params_Data)");
class  BlobStorageContext_WriteBlobToFile_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(BlobStorageContext_WriteBlobToFile_Params_Data));
      new (data()) BlobStorageContext_WriteBlobToFile_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    BlobStorageContext_WriteBlobToFile_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<BlobStorageContext_WriteBlobToFile_Params_Data>(index_);
    }
    BlobStorageContext_WriteBlobToFile_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data blob;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> path;
  uint8_t flush_on_write : 1;
  uint8_t pad2_[7];
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> last_modified;

 private:
  BlobStorageContext_WriteBlobToFile_Params_Data();
  ~BlobStorageContext_WriteBlobToFile_Params_Data() = delete;
};
static_assert(sizeof(BlobStorageContext_WriteBlobToFile_Params_Data) == 40,
              "Bad sizeof(BlobStorageContext_WriteBlobToFile_Params_Data)");
class  BlobStorageContext_WriteBlobToFile_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(BlobStorageContext_WriteBlobToFile_ResponseParams_Data));
      new (data()) BlobStorageContext_WriteBlobToFile_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    BlobStorageContext_WriteBlobToFile_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<BlobStorageContext_WriteBlobToFile_ResponseParams_Data>(index_);
    }
    BlobStorageContext_WriteBlobToFile_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  uint8_t padfinal_[4];

 private:
  BlobStorageContext_WriteBlobToFile_ResponseParams_Data();
  ~BlobStorageContext_WriteBlobToFile_ResponseParams_Data() = delete;
};
static_assert(sizeof(BlobStorageContext_WriteBlobToFile_ResponseParams_Data) == 16,
              "Bad sizeof(BlobStorageContext_WriteBlobToFile_ResponseParams_Data)");

}  // namespace internal


class BlobDataItemReader_Read_ParamsDataView {
 public:
  BlobDataItemReader_Read_ParamsDataView() {}

  BlobDataItemReader_Read_ParamsDataView(
      internal::BlobDataItemReader_Read_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint64_t offset() const {
    return data_->offset;
  }
  uint64_t length() const {
    return data_->length;
  }
  mojo::ScopedDataPipeProducerHandle TakePipe() {
    mojo::ScopedDataPipeProducerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeProducerHandle>(
            &data_->pipe, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::BlobDataItemReader_Read_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class BlobDataItemReader_Read_ResponseParamsDataView {
 public:
  BlobDataItemReader_Read_ResponseParamsDataView() {}

  BlobDataItemReader_Read_ResponseParamsDataView(
      internal::BlobDataItemReader_Read_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t success() const {
    return data_->success;
  }
 private:
  internal::BlobDataItemReader_Read_ResponseParams_Data* data_ = nullptr;
};



class BlobDataItemReader_ReadSideData_ParamsDataView {
 public:
  BlobDataItemReader_ReadSideData_ParamsDataView() {}

  BlobDataItemReader_ReadSideData_ParamsDataView(
      internal::BlobDataItemReader_ReadSideData_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::BlobDataItemReader_ReadSideData_Params_Data* data_ = nullptr;
};



class BlobDataItemReader_ReadSideData_ResponseParamsDataView {
 public:
  BlobDataItemReader_ReadSideData_ResponseParamsDataView() {}

  BlobDataItemReader_ReadSideData_ResponseParamsDataView(
      internal::BlobDataItemReader_ReadSideData_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t success() const {
    return data_->success;
  }
  inline void GetDataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, context_);
  }
 private:
  internal::BlobDataItemReader_ReadSideData_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class BlobStorageContext_RegisterFromDataItem_ParamsDataView {
 public:
  BlobStorageContext_RegisterFromDataItem_ParamsDataView() {}

  BlobStorageContext_RegisterFromDataItem_ParamsDataView(
      internal::BlobStorageContext_RegisterFromDataItem_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeBlob() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobInterfaceBase>>(
            &data_->blob, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetUuidDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUuid(UserType* output) {
    
    auto* pointer = data_->uuid.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetItemDataView(
      BlobDataItemDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadItem(UserType* output) {
    
    auto* pointer = data_->item.Get();
    return mojo::internal::Deserialize<::storage::mojom::BlobDataItemDataView>(
        pointer, output, context_);
  }
 private:
  internal::BlobStorageContext_RegisterFromDataItem_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class BlobStorageContext_RegisterFromMemory_ParamsDataView {
 public:
  BlobStorageContext_RegisterFromMemory_ParamsDataView() {}

  BlobStorageContext_RegisterFromMemory_ParamsDataView(
      internal::BlobStorageContext_RegisterFromMemory_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeBlob() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobInterfaceBase>>(
            &data_->blob, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetUuidDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUuid(UserType* output) {
    
    auto* pointer = data_->uuid.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetDataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, context_);
  }
 private:
  internal::BlobStorageContext_RegisterFromMemory_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class BlobStorageContext_WriteBlobToFile_ParamsDataView {
 public:
  BlobStorageContext_WriteBlobToFile_ParamsDataView() {}

  BlobStorageContext_WriteBlobToFile_ParamsDataView(
      internal::BlobStorageContext_WriteBlobToFile_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeBlob() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
            &data_->blob, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, context_);
  }
  bool flush_on_write() const {
    return data_->flush_on_write;
  }
  inline void GetLastModifiedDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLastModified(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `last_modified` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLastModified` instead "
    "of `ReadLastModified if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->last_modified.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, context_);
  }
 private:
  internal::BlobStorageContext_WriteBlobToFile_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class BlobStorageContext_WriteBlobToFile_ResponseParamsDataView {
 public:
  BlobStorageContext_WriteBlobToFile_ResponseParamsDataView() {}

  BlobStorageContext_WriteBlobToFile_ResponseParamsDataView(
      internal::BlobStorageContext_WriteBlobToFile_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResult(UserType* output) const {
    auto data_value = data_->result;
    return mojo::internal::Deserialize<::storage::mojom::WriteBlobToFileResult>(
        data_value, output);
  }

  WriteBlobToFileResult result() const {
    return static_cast<WriteBlobToFileResult>(data_->result);
  }
 private:
  internal::BlobStorageContext_WriteBlobToFile_ResponseParams_Data* data_ = nullptr;
};








inline void BlobDataItemReader_ReadSideData_ResponseParamsDataView::GetDataDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->data;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, context_);
}


inline void BlobStorageContext_RegisterFromDataItem_ParamsDataView::GetUuidDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->uuid.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void BlobStorageContext_RegisterFromDataItem_ParamsDataView::GetItemDataView(
    BlobDataItemDataView* output) {
  auto pointer = data_->item.Get();
  *output = BlobDataItemDataView(pointer, context_);
}


inline void BlobStorageContext_RegisterFromMemory_ParamsDataView::GetUuidDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->uuid.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void BlobStorageContext_RegisterFromMemory_ParamsDataView::GetDataDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->data;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, context_);
}


inline void BlobStorageContext_WriteBlobToFile_ParamsDataView::GetPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, context_);
}
inline void BlobStorageContext_WriteBlobToFile_ParamsDataView::GetLastModifiedDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_modified.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace storage

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_PARAMS_DATA_H_