// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A0__F0

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 128, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 128, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 128, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 128, "PRE_LOAD_V": false})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 128, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 128, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 128, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 128, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr pstring_view PACKAGE_PATH
#if defined(_WIN32)
{ LR"xyzw(amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_16_F_F_0_0___gfx950)xyzw" };
#else
{ R"xyzw(amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_16_F_F_0_0___gfx950)xyzw" };
#endif
constexpr std::string_view FUNC_NAME { R"xyzw(＊fp16@16_16_F_F_0_0)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx950)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0x5642a603u, 0xae9d9a4au, 0, 16 }, // 5642a603ae9d9a4a = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_16_F_F_0_0___gfx950__P__0_2_32_16_False__CO__wave2_warp2_stg1--Arch_gfx950
    { 0x634a39d2u, 0xde55aa9du, 0, 33 }, // 634a39d2de55aa9d = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_16_F_F_0_0___gfx950__P__0_2_32_16_False__CO__wave3_warp2_stg1--Arch_gfx950
    { 0x97841364u, 0x48e1b7a7u, 0, 50 }, // 9784136448e1b7a7 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_16_F_F_0_0___gfx950__P__0_2_32_16_False__CO__wave4_warp2_stg1--Arch_gfx950
    { 0x39514c8du, 0x5c73ec15u, 67, 83 }, // 39514c8d5c73ec15 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_16_F_F_0_0___gfx950__P__0_2_64_32_False__CO__wave1_warp2_stg1--Arch_gfx950
    { 0xc2ff7dd9u, 0x569be6e3u, 67, 16 }, // c2ff7dd9569be6e3 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_16_F_F_0_0___gfx950__P__0_2_64_32_False__CO__wave2_warp2_stg1--Arch_gfx950
    { 0xfa96305du, 0x5ffdf337u, 67, 33 }, // fa96305d5ffdf337 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_16_F_F_0_0___gfx950__P__0_2_64_32_False__CO__wave3_warp2_stg1--Arch_gfx950
    { 0xb4c8d7d1u, 0x79976c26u, 67, 50 }, // b4c8d7d179976c26 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_16_F_F_0_0___gfx950__P__0_2_64_32_False__CO__wave4_warp2_stg1--Arch_gfx950
    { 0xa3cac5ceu, 0x77a2784du, 100, 16 }, // a3cac5ce77a2784d = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_16_F_F_0_0___gfx950__P__0_2_64_64_False__CO__wave2_warp2_stg1--Arch_gfx950
    { 0x9abfdd38u, 0xaed087f1u, 100, 116 }, // 9abfdd38aed087f1 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_16_F_F_0_0___gfx950__P__0_2_64_64_False__CO__wave2_warp4_stg1--Arch_gfx950
    { 0xaf88f7d7u, 0xb286fb91u, 100, 33 }, // af88f7d7b286fb91 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_16_F_F_0_0___gfx950__P__0_2_64_64_False__CO__wave3_warp2_stg1--Arch_gfx950
    { 0x6e3b4c9cu, 0xa4a5a872u, 100, 50 }, // 6e3b4c9ca4a5a872 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_16_F_F_0_0___gfx950__P__0_2_64_64_False__CO__wave4_warp2_stg1--Arch_gfx950
    { 0x50228febu, 0xe93a4012u, 100, 133 }, // 50228febe93a4012 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_16_F_F_0_0___gfx950__P__0_2_64_64_False__CO__wave4_warp4_stg1--Arch_gfx950
    { 0x5c8fd152u, 0x9646734fu, 150, 116 }, // 5c8fd1529646734f = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_16_F_F_0_0___gfx950__P__0_2_128_64_False__CO__wave2_warp4_stg1--Arch_gfx950
    { 0x2ac7a76au, 0xb364510bu, 150, 167 }, // 2ac7a76ab364510b = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_16_F_F_0_0___gfx950__P__0_2_128_64_False__CO__wave3_warp4_stg1--Arch_gfx950
    { 0xbd364ba4u, 0x071a9853u, 150, 133 }, // bd364ba4071a9853 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_16_F_F_0_0___gfx950__P__0_2_128_64_False__CO__wave4_warp4_stg1--Arch_gfx950
    { 0xc2b19995u, 0x639987acu, 184, 83 }, // c2b19995639987ac = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_16_F_F_0_0___gfx950__P__0_2_128_128_False__CO__wave1_warp2_stg1--Arch_gfx950
    { 0x19651e84u, 0xd3abb3e9u, 184, 202 }, // 19651e84d3abb3e9 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_16_F_F_0_0___gfx950__P__0_2_128_128_False__CO__wave1_warp4_stg1--Arch_gfx950
    { 0xca1dc651u, 0xf2a4da64u, 184, 116 }, // ca1dc651f2a4da64 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_16_F_F_0_0___gfx950__P__0_2_128_128_False__CO__wave2_warp4_stg1--Arch_gfx950
    { 0x44c37a3bu, 0x4347f527u, 184, 133 }, // 44c37a3b4347f527 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_16_F_F_0_0___gfx950__P__0_2_128_128_False__CO__wave4_warp4_stg1--Arch_gfx950
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx950_mod0
{{ 2, 4, 8, 8, 8,17,17,17,17,17},
 { 0, 3,11,11,17,17,17,17,17,17},
 { 1, 1,12,17,16,17,17, 7, 9, 9},
 { 3, 0, 4, 6, 9, 9, 9, 9, 9, 9},
 { 0, 1, 1, 4,13,17,17,17,17,17},
 { 6, 2, 2, 5, 6, 7,17,17,15,15},
 { 4, 4, 4, 4, 6, 7, 7, 7, 9, 7},
 { 5, 6, 4, 6, 6, 6, 4,14, 7,18},
 { 5, 6, 6, 6, 5, 6, 5, 4,14,10},
 { 4, 4, 6, 4, 5, 5, 5, 5,14, 5}}
// End of GPU gfx950_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A0__F0 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 0;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 0;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*fp16:16"
// B = 0
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_bz = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 16
// Head_dim = 16
// PADDED_HEAD = False
// ENABLE_DROPOUT = False
// dropout_p = 0
// philox_seed_ptr = 0
// philox_offset1 = 0
// philox_offset2 = 0
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 0
// Window_left = 0
// BIAS_TYPE = 0
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = 0
// Num_CU = "i32"

// SELECT * FROM FLASH$attn_fwd WHERE gpu IN ('gfx950_mod0') AND inputs$Q_dtype = 'torch.float16' AND inputs$BLOCK_DMODEL = 16 AND inputs$PADDED_HEAD = False AND inputs$ENABLE_DROPOUT = False AND inputs$CAUSAL_TYPE = 0 AND inputs$BIAS_TYPE = 0

// vim: set fileencoding=utf-8

