// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A4__F509

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr std::string_view PACKAGE_PATH { R"xyzw(amd-gfx120x/flash/attn_fwd/FONLY__＊fp32@16_160_T_T_0_1___gfx120x)xyzw" };
constexpr std::string_view FUNC_NAME { R"xyzw(＊fp32@16_160_T_T_0_1)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx1200)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0xcbb88999u, 0xf010ee47u, 458, 48 }, // cbb88999f010ee47 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp32@16_160_T_T_0_1___gfx120x__P__0_2_16_16_False__CO__wave1_warp2_stg1--Arch_gfx1200
    { 0xc2f81488u, 0x98e6aa26u, 458, 263 }, // c2f8148898e6aa26 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp32@16_160_T_T_0_1___gfx120x__P__0_2_16_16_False__CO__wave1_warp4_stg1--Arch_gfx1200
    { 0xe66a3aa2u, 0xe2c3590eu, 458, 65 }, // e66a3aa2e2c3590e = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp32@16_160_T_T_0_1___gfx120x__P__0_2_16_16_False__CO__wave2_warp2_stg1--Arch_gfx1200
    { 0xac38a353u, 0x88064e1cu, 458, 178 }, // ac38a35388064e1c = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp32@16_160_T_T_0_1___gfx120x__P__0_2_16_16_False__CO__wave2_warp4_stg1--Arch_gfx1200
    { 0xee2f77f6u, 0x47387f76u, 458, 82 }, // ee2f77f647387f76 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp32@16_160_T_T_0_1___gfx120x__P__0_2_16_16_False__CO__wave3_warp2_stg1--Arch_gfx1200
    { 0xdc2c5fa1u, 0x8a472e19u, 458, 16 }, // dc2c5fa18a472e19 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp32@16_160_T_T_0_1___gfx120x__P__0_2_16_16_False__CO__wave4_warp2_stg1--Arch_gfx1200
    { 0x2e5f10a0u, 0xb26db73eu, 474, 48 }, // 2e5f10a0b26db73e = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp32@16_160_T_T_0_1___gfx120x__P__0_2_16_16_True__CO__wave1_warp2_stg1--Arch_gfx1200
    { 0x689bbfdfu, 0xa62f56d8u, 474, 82 }, // 689bbfdfa62f56d8 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp32@16_160_T_T_0_1___gfx120x__P__0_2_16_16_True__CO__wave3_warp2_stg1--Arch_gfx1200
    { 0x6050a006u, 0xa1264483u, 474, 146 }, // 6050a006a1264483 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp32@16_160_T_T_0_1___gfx120x__P__0_2_16_16_True__CO__wave3_warp4_stg1--Arch_gfx1200
    { 0x14e0c987u, 0x999aa2b7u, 474, 16 }, // 14e0c987999aa2b7 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp32@16_160_T_T_0_1___gfx120x__P__0_2_16_16_True__CO__wave4_warp2_stg1--Arch_gfx1200
    { 0x56df8926u, 0x7ff09858u, 474, 195 }, // 56df89267ff09858 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp32@16_160_T_T_0_1___gfx120x__P__0_2_16_16_True__CO__wave4_warp4_stg1--Arch_gfx1200
    { 0xd5a0d04fu, 0xe395b92du, 489, 263 }, // d5a0d04fe395b92d = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp32@16_160_T_T_0_1___gfx120x__P__0_2_32_32_False__CO__wave1_warp4_stg1--Arch_gfx1200
    { 0x4544a44bu, 0x5a5b56bcu, 489, 146 }, // 4544a44b5a5b56bc = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp32@16_160_T_T_0_1___gfx120x__P__0_2_32_32_False__CO__wave3_warp4_stg1--Arch_gfx1200
    { 0x62c15256u, 0x811715a1u, 489, 195 }, // 62c15256811715a1 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp32@16_160_T_T_0_1___gfx120x__P__0_2_32_32_False__CO__wave4_warp4_stg1--Arch_gfx1200
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx1200_mod0
{{ 0, 5, 4, 3, 1, 1, 3, 3, 3, 3},
 { 0, 4, 2, 2, 2, 2,11,12,13,13},
 { 0, 5, 3, 3, 3, 3, 4, 0, 0, 5},
 { 0, 5, 4, 5, 2, 5, 2, 2, 2,10},
 { 0, 5, 5, 2, 2, 2, 2, 2, 8,10},
 { 6, 4, 2, 4, 2, 2, 2, 8,10,10},
 { 6, 5, 2, 2, 2, 2, 4, 2, 2, 2},
 { 6, 2, 2, 2, 2, 2, 2, 2, 2, 2},
 { 7, 5, 2, 2, 2, 2, 2, 2, 2, 2},
 { 9, 4, 2, 5, 2, 2, 2, 2, 2, 2}}
// End of GPU gfx1200_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A4__F509 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 10;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 10;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*fp32:16"
// B = "*fp32:16"
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 160
// Head_dim = "i32"
// PADDED_HEAD = True
// ENABLE_DROPOUT = True
// dropout_p = "fp32"
// philox_seed_ptr = "*u64"
// philox_offset1 = "*u64"
// philox_offset2 = "u64"
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 0
// Window_left = 0
// BIAS_TYPE = 1
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = 0
// Num_CU = "i32"

// vim: set fileencoding=utf-8

