// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A4__F201

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr std::string_view PACKAGE_PATH { R"xyzw(amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x)xyzw" };
constexpr std::string_view FUNC_NAME { R"xyzw(＊bf16@16_16_T_F_0_1)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx1200)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0x844175c3u, 0xa9163572u, 474, 65 }, // 844175c3a9163572 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_16_16_True__CO__wave2_warp2_stg1--Arch_gfx1200
    { 0xa63cdb1du, 0x38a07ee1u, 33, 48 }, // a63cdb1d38a07ee1 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_32_16_True__CO__wave1_warp2_stg1--Arch_gfx1200
    { 0x17e2b8e6u, 0xed8f3ddbu, 33, 82 }, // 17e2b8e6ed8f3ddb = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_32_16_True__CO__wave3_warp2_stg1--Arch_gfx1200
    { 0x4e5eaf60u, 0xbab0fbc8u, 489, 48 }, // 4e5eaf60bab0fbc8 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_32_32_False__CO__wave1_warp2_stg1--Arch_gfx1200
    { 0xa449f4ccu, 0xc2ddc721u, 489, 263 }, // a449f4ccc2ddc721 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_32_32_False__CO__wave1_warp4_stg1--Arch_gfx1200
    { 0x24619ecbu, 0x13cfe2f6u, 489, 65 }, // 24619ecb13cfe2f6 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_32_32_False__CO__wave2_warp2_stg1--Arch_gfx1200
    { 0xbfc8865du, 0xc971c8b1u, 489, 82 }, // bfc8865dc971c8b1 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_32_32_False__CO__wave3_warp2_stg1--Arch_gfx1200
    { 0x6f9c854fu, 0x02905a91u, 489, 16 }, // 6f9c854f02905a91 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_32_32_False__CO__wave4_warp2_stg1--Arch_gfx1200
    { 0x08d0cc87u, 0x622d0fc2u, 505, 48 }, // 08d0cc87622d0fc2 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_32_32_True__CO__wave1_warp2_stg1--Arch_gfx1200
    { 0xbfca464fu, 0x702fade5u, 505, 263 }, // bfca464f702fade5 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_32_32_True__CO__wave1_warp4_stg1--Arch_gfx1200
    { 0x013003beu, 0x4da63b70u, 505, 65 }, // 013003be4da63b70 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_32_32_True__CO__wave2_warp2_stg1--Arch_gfx1200
    { 0x54ad835au, 0xf82d714fu, 505, 178 }, // 54ad835af82d714f = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_32_32_True__CO__wave2_warp4_stg1--Arch_gfx1200
    { 0x66f7479cu, 0xdf91cde4u, 505, 82 }, // 66f7479cdf91cde4 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_32_32_True__CO__wave3_warp2_stg1--Arch_gfx1200
    { 0x1b28e7efu, 0x6de95637u, 505, 146 }, // 1b28e7ef6de95637 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_32_32_True__CO__wave3_warp4_stg1--Arch_gfx1200
    { 0x82fd2056u, 0xefff7060u, 505, 16 }, // 82fd2056efff7060 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_32_32_True__CO__wave4_warp2_stg1--Arch_gfx1200
    { 0xb23db499u, 0x53ed029au, 505, 195 }, // b23db49953ed029a = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_32_32_True__CO__wave4_warp4_stg1--Arch_gfx1200
    { 0xae5ff811u, 0xbb44dd69u, 99, 16 }, // ae5ff811bb44dd69 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_64_32_False__CO__wave4_warp2_stg1--Arch_gfx1200
    { 0xa762766au, 0x0f210b59u, 99, 195 }, // a762766a0f210b59 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_64_32_False__CO__wave4_warp4_stg1--Arch_gfx1200
    { 0xcbd13dadu, 0xdf3c7afcu, 115, 48 }, // cbd13daddf3c7afc = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_64_32_True__CO__wave1_warp2_stg1--Arch_gfx1200
    { 0x19ffef54u, 0x4f17b9f8u, 115, 263 }, // 19ffef544f17b9f8 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_64_32_True__CO__wave1_warp4_stg1--Arch_gfx1200
    { 0x7848eb87u, 0x1545f83bu, 115, 178 }, // 7848eb871545f83b = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_64_32_True__CO__wave2_warp4_stg1--Arch_gfx1200
    { 0xa02ef36fu, 0x569331dcu, 115, 82 }, // a02ef36f569331dc = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_64_32_True__CO__wave3_warp2_stg1--Arch_gfx1200
    { 0x0b57b0e4u, 0x88ab054du, 115, 146 }, // 0b57b0e488ab054d = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_64_32_True__CO__wave3_warp4_stg1--Arch_gfx1200
    { 0xd9d0705bu, 0x98d22cdeu, 115, 195 }, // d9d0705b98d22cde = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_0_1___gfx120x__P__0_2_64_32_True__CO__wave4_warp4_stg1--Arch_gfx1200
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx1200_mod0
{{ 1, 4,11, 9,13, 9,11, 9,11,15},
 {15,17,22,14,12,12,10,10, 8,10},
 {13,10, 3, 8,14,12,22,14,12, 8},
 { 6, 5, 3, 7, 7,22, 8,13,14, 8},
 { 8, 8, 8,10,10,15,23,11,12, 8},
 { 7,14,12,20,22, 9, 8,10,14,12},
 { 2,22,10,23,23,23,14, 8, 8,14},
 {21,14, 8,19,19, 5, 8, 8,12,12},
 {16,23,22,19,18,12,10, 0, 8,13},
 {21, 2,18,18,18, 7, 1, 0,10,12}}
// End of GPU gfx1200_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A4__F201 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 7;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 7;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*bf16:16"
// B = "*bf16:16"
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 16
// Head_dim = "i32"
// PADDED_HEAD = True
// ENABLE_DROPOUT = False
// dropout_p = 0
// philox_seed_ptr = 0
// philox_offset1 = 0
// philox_offset2 = 0
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 0
// Window_left = 0
// BIAS_TYPE = 1
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = 0
// Num_CU = "i32"

// vim: set fileencoding=utf-8

