/*
 * $Id: users.c,v 1.1 2001/03/15 22:16:13 jpormann Exp jpormann $
 *
 * procstatd - Copyright (c) 1999 by Robert G. Brown, rgb@phy.duke.edu
 *         GPL version 2b (b for beverage) granted.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * procstatd - A daemon to extract statistics from /proc/stat and publish them
 *         on demand via a socket connection or broadcast.
 */

#include "procstatd.h"

void init_users()
{

 int i,numfields;

 /* USERS */
 {
   struct utmp *utmpstruct;
   int numuser = 0;

   /* count the number of users */
   setutent();
   while ((utmpstruct = getutent())) {
     if((utmpstruct->ut_type == USER_PROCESS) &&
                (utmpstruct->ut_name[0] != '\0')) numuser++;
   }
   endutent();
   sprintf(stats[USERS].name,"users");		/* Label it. */
   stats[USERS].source = SYS_DATA;		/* Tag its source for xref */
   stats[USERS].avail = 1;			/* Yes, we found it */
   stats[USERS].current = numuser;		/* current value */
 }

} /* End init_users() */

void get_users()
{

 int i,numfields;
 /* USERS */
 {
   struct utmp *utmpstruct;
   int numuser = 0;

   /* count the number of users */
   setutent();
   while ((utmpstruct = getutent())) {
     if((utmpstruct->ut_type == USER_PROCESS) &&
                (utmpstruct->ut_name[0] != '\0')) numuser++;
   }
   endutent();
   stats[USERS].current = numuser;		/* current value */
 }

} /* End of get_users() */

void eval_users()
{
   stats[USERS].rate = stats[USERS].current;
   if(stats[USERS].rate < 0.0) stats[USERS].rate = 0.0;
}

void old_eval_users()
{

 int i,numfields;

 for(i=0;i<N_STATS;i++){

   switch(i) {
     /* 
      * USERS is a straight value
      */
     case USERS:
       stats[i].rate = stats[i].current;
       if(stats[i].rate < 0.0) stats[i].rate = 0.0;
       break;
     default:
       break;
   } /* End case switch */

 } /* End loop through enumerated types */

} /* End eval_users */
