/* DBus.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DBus.vala, do not modify */

/*
 * Copyright 2019-2025 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gdesktopappinfo.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>

#define NOTIFICATIONS_SERVER_X_CANONICAL_PRIVATE_SYNCHRONOUS "x-canonical-private-synchronous"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define NOTIFICATIONS_TYPE_SERVER (notifications_server_get_type ())
#define NOTIFICATIONS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOTIFICATIONS_TYPE_SERVER, NotificationsServer))
#define NOTIFICATIONS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOTIFICATIONS_TYPE_SERVER, NotificationsServerClass))
#define NOTIFICATIONS_IS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOTIFICATIONS_TYPE_SERVER))
#define NOTIFICATIONS_IS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOTIFICATIONS_TYPE_SERVER))
#define NOTIFICATIONS_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOTIFICATIONS_TYPE_SERVER, NotificationsServerClass))

typedef struct _NotificationsServer NotificationsServer;
typedef struct _NotificationsServerClass NotificationsServerClass;
typedef struct _NotificationsServerPrivate NotificationsServerPrivate;

#define NOTIFICATIONS_FDO_TYPE_ACTION_GROUP (notifications_fdo_action_group_get_type ())
#define NOTIFICATIONS_FDO_ACTION_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOTIFICATIONS_FDO_TYPE_ACTION_GROUP, NotificationsFdoActionGroup))
#define NOTIFICATIONS_FDO_ACTION_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOTIFICATIONS_FDO_TYPE_ACTION_GROUP, NotificationsFdoActionGroupClass))
#define NOTIFICATIONS_FDO_IS_ACTION_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOTIFICATIONS_FDO_TYPE_ACTION_GROUP))
#define NOTIFICATIONS_FDO_IS_ACTION_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOTIFICATIONS_FDO_TYPE_ACTION_GROUP))
#define NOTIFICATIONS_FDO_ACTION_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOTIFICATIONS_FDO_TYPE_ACTION_GROUP, NotificationsFdoActionGroupClass))

typedef struct _NotificationsFdoActionGroup NotificationsFdoActionGroup;
typedef struct _NotificationsFdoActionGroupClass NotificationsFdoActionGroupClass;

#define NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE (notifications_abstract_bubble_get_type ())
#define NOTIFICATIONS_ABSTRACT_BUBBLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE, NotificationsAbstractBubble))
#define NOTIFICATIONS_ABSTRACT_BUBBLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE, NotificationsAbstractBubbleClass))
#define NOTIFICATIONS_IS_ABSTRACT_BUBBLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE))
#define NOTIFICATIONS_IS_ABSTRACT_BUBBLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE))
#define NOTIFICATIONS_ABSTRACT_BUBBLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE, NotificationsAbstractBubbleClass))

typedef struct _NotificationsAbstractBubble NotificationsAbstractBubble;
typedef struct _NotificationsAbstractBubbleClass NotificationsAbstractBubbleClass;

#define NOTIFICATIONS_TYPE_BUBBLE (notifications_bubble_get_type ())
#define NOTIFICATIONS_BUBBLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOTIFICATIONS_TYPE_BUBBLE, NotificationsBubble))
#define NOTIFICATIONS_BUBBLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOTIFICATIONS_TYPE_BUBBLE, NotificationsBubbleClass))
#define NOTIFICATIONS_IS_BUBBLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOTIFICATIONS_TYPE_BUBBLE))
#define NOTIFICATIONS_IS_BUBBLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOTIFICATIONS_TYPE_BUBBLE))
#define NOTIFICATIONS_BUBBLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOTIFICATIONS_TYPE_BUBBLE, NotificationsBubbleClass))

typedef struct _NotificationsBubble NotificationsBubble;
typedef struct _NotificationsBubbleClass NotificationsBubbleClass;

#define NOTIFICATIONS_TYPE_CONFIRMATION (notifications_confirmation_get_type ())
#define NOTIFICATIONS_CONFIRMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOTIFICATIONS_TYPE_CONFIRMATION, NotificationsConfirmation))
#define NOTIFICATIONS_CONFIRMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOTIFICATIONS_TYPE_CONFIRMATION, NotificationsConfirmationClass))
#define NOTIFICATIONS_IS_CONFIRMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOTIFICATIONS_TYPE_CONFIRMATION))
#define NOTIFICATIONS_IS_CONFIRMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOTIFICATIONS_TYPE_CONFIRMATION))
#define NOTIFICATIONS_CONFIRMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOTIFICATIONS_TYPE_CONFIRMATION, NotificationsConfirmationClass))

typedef struct _NotificationsConfirmation NotificationsConfirmation;
typedef struct _NotificationsConfirmationClass NotificationsConfirmationClass;
enum  {
	NOTIFICATIONS_SERVER_0_PROPERTY,
	NOTIFICATIONS_SERVER_NUM_PROPERTIES
};
static GParamSpec* notifications_server_properties[NOTIFICATIONS_SERVER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	NOTIFICATIONS_CLOSE_REASON_EXPIRED = 1,
	NOTIFICATIONS_CLOSE_REASON_DISMISSED = 2,
	NOTIFICATIONS_CLOSE_REASON_CLOSE_NOTIFICATION_CALL = 3,
	NOTIFICATIONS_CLOSE_REASON_UNDEFINED = 4
} NotificationsCloseReason;

#define NOTIFICATIONS_TYPE_CLOSE_REASON (notifications_close_reason_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;

#define NOTIFICATIONS_TYPE_NOTIFICATION (notifications_notification_get_type ())
#define NOTIFICATIONS_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOTIFICATIONS_TYPE_NOTIFICATION, NotificationsNotification))
#define NOTIFICATIONS_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOTIFICATIONS_TYPE_NOTIFICATION, NotificationsNotificationClass))
#define NOTIFICATIONS_IS_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOTIFICATIONS_TYPE_NOTIFICATION))
#define NOTIFICATIONS_IS_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOTIFICATIONS_TYPE_NOTIFICATION))
#define NOTIFICATIONS_NOTIFICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOTIFICATIONS_TYPE_NOTIFICATION, NotificationsNotificationClass))

typedef struct _NotificationsNotification NotificationsNotification;
typedef struct _NotificationsNotificationClass NotificationsNotificationClass;

#define NOTIFICATIONS_NOTIFICATION_TYPE_BUTTON (notifications_notification_button_get_type ())
typedef struct _NotificationsNotificationButton NotificationsNotificationButton;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
enum  {
	NOTIFICATIONS_SERVER_ACTION_INVOKED_SIGNAL,
	NOTIFICATIONS_SERVER_NOTIFICATION_CLOSED_SIGNAL,
	NOTIFICATIONS_SERVER_NUM_SIGNALS
};
static guint notifications_server_signals[NOTIFICATIONS_SERVER_NUM_SIGNALS] = {0};
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _NotificationsServer {
	GObject parent_instance;
	NotificationsServerPrivate * priv;
};

struct _NotificationsServerClass {
	GObjectClass parent_class;
};

struct _NotificationsServerPrivate {
	guint32 id_counter;
	GDBusConnection* connection;
	NotificationsFdoActionGroup* action_group;
	GeeMap* bubbles;
	NotificationsConfirmation* confirmation;
	guint action_group_id;
	guint server_id;
};

struct _Block2Data {
	int _ref_count_;
	NotificationsServer* self;
	guint32 id;
};

struct _NotificationsNotificationButton {
	gchar* label;
	gchar* action_name;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	GSettings* app_settings;
};

static gint NotificationsServer_private_offset;
static gpointer notifications_server_parent_class = NULL;
VALA_EXTERN GSettings* notifications_application_settings;

VALA_EXTERN GType notifications_server_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotificationsServer, g_object_unref)
VALA_EXTERN guint notifications_server_register_object (void* object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error);
VALA_EXTERN GType notifications_fdo_action_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotificationsFdoActionGroup, g_object_unref)
VALA_EXTERN GType notifications_abstract_bubble_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotificationsAbstractBubble, g_object_unref)
VALA_EXTERN GType notifications_bubble_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotificationsBubble, g_object_unref)
VALA_EXTERN GType notifications_confirmation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotificationsConfirmation, g_object_unref)
VALA_EXTERN NotificationsServer* notifications_server_new (GDBusConnection* connection,
                                               GError** error);
VALA_EXTERN NotificationsServer* notifications_server_construct (GType object_type,
                                                     GDBusConnection* connection,
                                                     GError** error);
VALA_EXTERN NotificationsFdoActionGroup* notifications_fdo_action_group_new (NotificationsServer* server);
VALA_EXTERN NotificationsFdoActionGroup* notifications_fdo_action_group_construct (GType object_type,
                                                                       NotificationsServer* server);
static void __lambda8_ (NotificationsServer* self,
                 guint32 id);
static void notifications_server_close_bubble (NotificationsServer* self,
                                        guint32 id);
static void ___lambda8__notifications_server_action_invoked (NotificationsServer* _sender,
                                                      guint32 id,
                                                      const gchar* action_key,
                                                      gpointer self);
static void __lambda9_ (NotificationsServer* self,
                 guint32 id);
static void ___lambda9__notifications_server_notification_closed (NotificationsServer* _sender,
                                                           guint32 id,
                                                           guint32 reason,
                                                           gpointer self);
VALA_EXTERN void notifications_fdo_action_group_remove_actions (NotificationsFdoActionGroup* self,
                                                    guint32 id);
VALA_EXTERN void notifications_server_close_notification (NotificationsServer* self,
                                              guint32 id,
                                              GError** error);
VALA_EXTERN GType notifications_close_reason_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar** notifications_server_get_capabilities (NotificationsServer* self,
                                               gint* result_length1,
                                               GError** error);
VALA_EXTERN void notifications_server_get_server_information (NotificationsServer* self,
                                                  gchar** name,
                                                  gchar** vendor,
                                                  gchar** version,
                                                  gchar** spec_version,
                                                  GError** error);
VALA_EXTERN guint32 notifications_server_notify (NotificationsServer* self,
                                     const gchar* app_name,
                                     guint32 replaces_id,
                                     const gchar* app_icon,
                                     const gchar* summary,
                                     const gchar* body,
                                     gchar** actions,
                                     gint actions_length1,
                                     GHashTable* hints,
                                     gint32 expire_timeout,
                                     const char* sender,
                                     GError** error);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void notifications_server_send_confirmation (NotificationsServer* self,
                                             const gchar* icon_name,
                                             GHashTable* hints);
VALA_EXTERN GType notifications_notification_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotificationsNotification, g_object_unref)
VALA_EXTERN GType notifications_notification_button_get_type (void) G_GNUC_CONST ;
VALA_EXTERN NotificationsNotificationButton* notifications_notification_button_dup (const NotificationsNotificationButton* self);
VALA_EXTERN void notifications_notification_button_free (NotificationsNotificationButton* self);
VALA_EXTERN void notifications_notification_button_copy (const NotificationsNotificationButton* self,
                                             NotificationsNotificationButton* dest);
VALA_EXTERN void notifications_notification_button_destroy (NotificationsNotificationButton* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (NotificationsNotificationButton, notifications_notification_button_destroy)
static void _notifications_notification_button_free0_ (gpointer var);
VALA_EXTERN NotificationsNotification* notifications_notification_new (const gchar* app_name,
                                                           const gchar* app_icon,
                                                           const gchar* summary,
                                                           const gchar* body,
                                                           GDesktopAppInfo* app_info,
                                                           GHashTable* hints);
VALA_EXTERN NotificationsNotification* notifications_notification_construct (GType object_type,
                                                                 const gchar* app_name,
                                                                 const gchar* app_icon,
                                                                 const gchar* summary,
                                                                 const gchar* body,
                                                                 GDesktopAppInfo* app_info,
                                                                 GHashTable* hints);
VALA_EXTERN void notifications_notification_set_buttons (NotificationsNotification* self,
                                             GPtrArray* value);
VALA_EXTERN void notifications_notification_set_priority (NotificationsNotification* self,
                                              GNotificationPriority value);
VALA_EXTERN const gchar* notifications_fdo_action_group_add_action (NotificationsFdoActionGroup* self,
                                                        guint32 id,
                                                        const gchar* action);
VALA_EXTERN void notifications_notification_set_default_action_name (NotificationsNotification* self,
                                                         const gchar* value);
VALA_EXTERN GPtrArray* notifications_notification_get_buttons (NotificationsNotification* self);
VALA_EXTERN GNotificationPriority notifications_notification_get_priority (NotificationsNotification* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN const gchar* notifications_notification_get_app_id (NotificationsNotification* self);
VALA_EXTERN void notifications_bubble_set_notification (NotificationsBubble* self,
                                            NotificationsNotification* value);
VALA_EXTERN NotificationsBubble* notifications_bubble_new (NotificationsNotification* notification);
VALA_EXTERN NotificationsBubble* notifications_bubble_construct (GType object_type,
                                                     NotificationsNotification* notification);
static gboolean ______lambda12_ (Block3Data* _data3_);
static gboolean _______lambda12__gtk_window_close_request (GtkWindow* _sender,
                                                    gpointer self);
static void ______lambda13_ (Block3Data* _data3_,
                      NotificationsCloseReason res);
static void _______lambda13__notifications_abstract_bubble_closed (NotificationsAbstractBubble* _sender,
                                                            NotificationsCloseReason reason,
                                                            gpointer self);
VALA_EXTERN void notifications_abstract_bubble_present (NotificationsAbstractBubble* self);
static const gchar* notifications_server_category_to_sound_name (const gchar* category);
VALA_EXTERN void notifications_application_play_sound (const gchar* sound_name);
VALA_EXTERN NotificationsConfirmation* notifications_confirmation_new (const gchar* icon_name,
                                                           gdouble progress);
VALA_EXTERN NotificationsConfirmation* notifications_confirmation_construct (GType object_type,
                                                                 const gchar* icon_name,
                                                                 gdouble progress);
static gboolean ___lambda11_ (NotificationsServer* self);
static gboolean ____lambda11__gtk_window_close_request (GtkWindow* _sender,
                                                 gpointer self);
VALA_EXTERN void notifications_confirmation_set_icon_name (NotificationsConfirmation* self,
                                               const gchar* value);
VALA_EXTERN void notifications_confirmation_set_progress (NotificationsConfirmation* self,
                                              gdouble value);
static void g_cclosure_user_marshal_VOID__UINT_STRING (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static void notifications_server_finalize (GObject * obj);
static GType notifications_server_get_type_once (void);
static void _dbus_notifications_server_close_notification (NotificationsServer* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation);
static void _dbus_notifications_server_get_capabilities (NotificationsServer* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation);
static void _dbus_notifications_server_get_server_information (NotificationsServer* self,
                                                        GVariant* _parameters_,
                                                        GDBusMethodInvocation* invocation);
static void _dbus_notifications_server_notify (NotificationsServer* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation);
static void notifications_server_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data);
static GVariant* notifications_server_dbus_interface_get_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GError** error,
                                                            gpointer user_data);
static gboolean notifications_server_dbus_interface_set_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GVariant* value,
                                                           GError** error,
                                                           gpointer user_data);
static void _dbus_notifications_server_action_invoked (GObject* _sender,
                                                guint32 id,
                                                const gchar* action_key,
                                                gpointer* _data);
static void _dbus_notifications_server_notification_closed (GObject* _sender,
                                                     guint32 id,
                                                     guint32 reason,
                                                     gpointer* _data);
static void _notifications_server_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _notifications_server_dbus_arg_info_close_notification_id = {-1, "id", "u", NULL};
static const GDBusArgInfo * const _notifications_server_dbus_arg_info_close_notification_in[] = {&_notifications_server_dbus_arg_info_close_notification_id, NULL};
static const GDBusArgInfo * const _notifications_server_dbus_arg_info_close_notification_out[] = {NULL};
static const GDBusMethodInfo _notifications_server_dbus_method_info_close_notification = {-1, "CloseNotification", (GDBusArgInfo **) (&_notifications_server_dbus_arg_info_close_notification_in), (GDBusArgInfo **) (&_notifications_server_dbus_arg_info_close_notification_out), NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_get_capabilities_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _notifications_server_dbus_arg_info_get_capabilities_in[] = {NULL};
static const GDBusArgInfo * const _notifications_server_dbus_arg_info_get_capabilities_out[] = {&_notifications_server_dbus_arg_info_get_capabilities_result, NULL};
static const GDBusMethodInfo _notifications_server_dbus_method_info_get_capabilities = {-1, "GetCapabilities", (GDBusArgInfo **) (&_notifications_server_dbus_arg_info_get_capabilities_in), (GDBusArgInfo **) (&_notifications_server_dbus_arg_info_get_capabilities_out), NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_get_server_information_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_get_server_information_vendor = {-1, "vendor", "s", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_get_server_information_version = {-1, "version", "s", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_get_server_information_spec_version = {-1, "spec_version", "s", NULL};
static const GDBusArgInfo * const _notifications_server_dbus_arg_info_get_server_information_in[] = {NULL};
static const GDBusArgInfo * const _notifications_server_dbus_arg_info_get_server_information_out[] = {&_notifications_server_dbus_arg_info_get_server_information_name, &_notifications_server_dbus_arg_info_get_server_information_vendor, &_notifications_server_dbus_arg_info_get_server_information_version, &_notifications_server_dbus_arg_info_get_server_information_spec_version, NULL};
static const GDBusMethodInfo _notifications_server_dbus_method_info_get_server_information = {-1, "GetServerInformation", (GDBusArgInfo **) (&_notifications_server_dbus_arg_info_get_server_information_in), (GDBusArgInfo **) (&_notifications_server_dbus_arg_info_get_server_information_out), NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notify_app_name = {-1, "app_name", "s", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notify_replaces_id = {-1, "replaces_id", "u", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notify_app_icon = {-1, "app_icon", "s", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notify_summary = {-1, "summary", "s", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notify_body = {-1, "body", "s", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notify_actions = {-1, "actions", "as", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notify_hints = {-1, "hints", "a{sv}", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notify_expire_timeout = {-1, "expire_timeout", "i", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notify_result = {-1, "result", "u", NULL};
static const GDBusArgInfo * const _notifications_server_dbus_arg_info_notify_in[] = {&_notifications_server_dbus_arg_info_notify_app_name, &_notifications_server_dbus_arg_info_notify_replaces_id, &_notifications_server_dbus_arg_info_notify_app_icon, &_notifications_server_dbus_arg_info_notify_summary, &_notifications_server_dbus_arg_info_notify_body, &_notifications_server_dbus_arg_info_notify_actions, &_notifications_server_dbus_arg_info_notify_hints, &_notifications_server_dbus_arg_info_notify_expire_timeout, NULL};
static const GDBusArgInfo * const _notifications_server_dbus_arg_info_notify_out[] = {&_notifications_server_dbus_arg_info_notify_result, NULL};
static const GDBusMethodInfo _notifications_server_dbus_method_info_notify = {-1, "Notify", (GDBusArgInfo **) (&_notifications_server_dbus_arg_info_notify_in), (GDBusArgInfo **) (&_notifications_server_dbus_arg_info_notify_out), NULL};
static const GDBusMethodInfo * const _notifications_server_dbus_method_info[] = {&_notifications_server_dbus_method_info_close_notification, &_notifications_server_dbus_method_info_get_capabilities, &_notifications_server_dbus_method_info_get_server_information, &_notifications_server_dbus_method_info_notify, NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_action_invoked_id = {-1, "id", "u", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_action_invoked_action_key = {-1, "action_key", "s", NULL};
static const GDBusArgInfo * const _notifications_server_dbus_arg_info_action_invoked[] = {&_notifications_server_dbus_arg_info_action_invoked_id, &_notifications_server_dbus_arg_info_action_invoked_action_key, NULL};
static const GDBusSignalInfo _notifications_server_dbus_signal_info_action_invoked = {-1, "ActionInvoked", (GDBusArgInfo **) (&_notifications_server_dbus_arg_info_action_invoked), NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notification_closed_id = {-1, "id", "u", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notification_closed_reason = {-1, "reason", "u", NULL};
static const GDBusArgInfo * const _notifications_server_dbus_arg_info_notification_closed[] = {&_notifications_server_dbus_arg_info_notification_closed_id, &_notifications_server_dbus_arg_info_notification_closed_reason, NULL};
static const GDBusSignalInfo _notifications_server_dbus_signal_info_notification_closed = {-1, "NotificationClosed", (GDBusArgInfo **) (&_notifications_server_dbus_arg_info_notification_closed), NULL};
static const GDBusSignalInfo * const _notifications_server_dbus_signal_info[] = {&_notifications_server_dbus_signal_info_action_invoked, &_notifications_server_dbus_signal_info_notification_closed, NULL};
static const GDBusPropertyInfo * const _notifications_server_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _notifications_server_dbus_interface_info = {-1, "org.freedesktop.Notifications", (GDBusMethodInfo **) (&_notifications_server_dbus_method_info), (GDBusSignalInfo **) (&_notifications_server_dbus_signal_info), (GDBusPropertyInfo **) (&_notifications_server_dbus_property_info), NULL};
static const GDBusInterfaceVTable _notifications_server_dbus_interface_vtable = {notifications_server_dbus_interface_method_call, notifications_server_dbus_interface_get_property, notifications_server_dbus_interface_set_property};

static inline gpointer
notifications_server_get_instance_private (NotificationsServer* self)
{
	return G_STRUCT_MEMBER_P (self, NotificationsServer_private_offset);
}

static void
__lambda8_ (NotificationsServer* self,
            guint32 id)
{
	notifications_server_close_bubble (self, id);
}

static void
___lambda8__notifications_server_action_invoked (NotificationsServer* _sender,
                                                 guint32 id,
                                                 const gchar* action_key,
                                                 gpointer self)
{
	__lambda8_ ((NotificationsServer*) self, id);
}

static void
__lambda9_ (NotificationsServer* self,
            guint32 id)
{
	notifications_server_close_bubble (self, id);
}

static void
___lambda9__notifications_server_notification_closed (NotificationsServer* _sender,
                                                      guint32 id,
                                                      guint32 reason,
                                                      gpointer self)
{
	__lambda9_ ((NotificationsServer*) self, id);
}

NotificationsServer*
notifications_server_construct (GType object_type,
                                GDBusConnection* connection,
                                GError** error)
{
	NotificationsServer * self = NULL;
	GeeHashMap* _tmp0_;
	NotificationsFdoActionGroup* _tmp1_;
	guint _tmp2_ = 0U;
	guint _tmp3_;
	guint _tmp4_ = 0U;
	NotificationsFdoActionGroup* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (connection != NULL, NULL);
	self = (NotificationsServer*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, NOTIFICATIONS_TYPE_BUBBLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->bubbles);
	self->priv->bubbles = (GeeMap*) _tmp0_;
	_tmp1_ = notifications_fdo_action_group_new (self);
	_g_object_unref0 (self->priv->action_group);
	self->priv->action_group = _tmp1_;
	_tmp3_ = notifications_server_register_object (self, connection, "/org/freedesktop/Notifications", &_inner_error0_);
	_tmp2_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	self->priv->server_id = _tmp2_;
	_tmp5_ = self->priv->action_group;
	_tmp4_ = g_dbus_connection_export_action_group (connection, "/org/freedesktop/Notifications", (GActionGroup*) _tmp5_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	self->priv->action_group_id = _tmp4_;
	self->priv->connection = connection;
	g_signal_connect_object (self, "action-invoked", (GCallback) ___lambda8__notifications_server_action_invoked, self, 0);
	g_signal_connect_object (self, "notification-closed", (GCallback) ___lambda9__notifications_server_notification_closed, self, 0);
	return self;
}

NotificationsServer*
notifications_server_new (GDBusConnection* connection,
                          GError** error)
{
	return notifications_server_construct (NOTIFICATIONS_TYPE_SERVER, connection, error);
}

static void
notifications_server_close_bubble (NotificationsServer* self,
                                   guint32 id)
{
	NotificationsBubble* bubble = NULL;
	GeeMap* _tmp0_;
	gpointer _tmp1_ = NULL;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bubbles;
	_tmp2_ = gee_map_unset (_tmp0_, (gpointer) ((guintptr) id), &_tmp1_);
	_g_object_unref0 (bubble);
	bubble = (NotificationsBubble*) _tmp1_;
	if (_tmp2_) {
		NotificationsBubble* _tmp3_;
		NotificationsFdoActionGroup* _tmp5_;
		_tmp3_ = bubble;
		if (_tmp3_ != NULL) {
			NotificationsBubble* _tmp4_;
			_tmp4_ = bubble;
			gtk_window_close ((GtkWindow*) _tmp4_);
		}
		_tmp5_ = self->priv->action_group;
		notifications_fdo_action_group_remove_actions (_tmp5_, id);
	}
	_g_object_unref0 (bubble);
}

void
notifications_server_close_notification (NotificationsServer* self,
                                         guint32 id,
                                         GError** error)
{
	GeeMap* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bubbles;
	if (!gee_map_has_key (_tmp0_, (gpointer) ((guintptr) id))) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "");
		_inner_error0_ = _tmp1_;
		if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	g_signal_emit (self, notifications_server_signals[NOTIFICATIONS_SERVER_NOTIFICATION_CLOSED_SIGNAL], 0, id, (guint32) NOTIFICATIONS_CLOSE_REASON_CLOSE_NOTIFICATION_CALL);
}

gchar**
notifications_server_get_capabilities (NotificationsServer* self,
                                       gint* result_length1,
                                       GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("actions");
	_tmp1_ = g_strdup ("body");
	_tmp2_ = g_strdup ("body-markup");
	_tmp3_ = g_strdup (NOTIFICATIONS_SERVER_X_CANONICAL_PRIVATE_SYNCHRONOUS);
	_tmp4_ = g_new0 (gchar*, 4 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 4;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}

void
notifications_server_get_server_information (NotificationsServer* self,
                                             gchar** name,
                                             gchar** vendor,
                                             gchar** version,
                                             gchar** spec_version,
                                             GError** error)
{
	gchar* _vala_name = NULL;
	gchar* _vala_vendor = NULL;
	gchar* _vala_version = NULL;
	gchar* _vala_spec_version = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("io.elementary.notifications");
	_g_free0 (_vala_name);
	_vala_name = _tmp0_;
	_tmp1_ = g_strdup ("elementaryOS");
	_g_free0 (_vala_vendor);
	_vala_vendor = _tmp1_;
	_tmp2_ = g_strdup ("0.1");
	_g_free0 (_vala_version);
	_vala_version = _tmp2_;
	_tmp3_ = g_strdup ("1.3");
	_g_free0 (_vala_spec_version);
	_vala_spec_version = _tmp3_;
	if (name) {
		*name = _vala_name;
	} else {
		_g_free0 (_vala_name);
	}
	if (vendor) {
		*vendor = _vala_vendor;
	} else {
		_g_free0 (_vala_vendor);
	}
	if (version) {
		*version = _vala_version;
	} else {
		_g_free0 (_vala_version);
	}
	if (spec_version) {
		*spec_version = _vala_spec_version;
	} else {
		_g_free0 (_vala_spec_version);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		NotificationsServer* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
_notifications_notification_button_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (notifications_notification_button_free (var), NULL));
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gpointer
_notifications_notification_button_dup0 (gpointer self)
{
	return self ? notifications_notification_button_dup (self) : NULL;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		NotificationsServer* self;
		self = _data3_->_data2_->self;
		_g_object_unref0 (_data3_->app_settings);
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
______lambda12_ (Block3Data* _data3_)
{
	Block2Data* _data2_;
	NotificationsServer* self;
	GeeMap* _tmp0_;
	gboolean result;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	_tmp0_ = self->priv->bubbles;
	gee_map_set (_tmp0_, (gpointer) ((guintptr) _data2_->id), NULL);
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
_______lambda12__gtk_window_close_request (GtkWindow* _sender,
                                           gpointer self)
{
	gboolean result;
	result = ______lambda12_ (self);
	return result;
}

static void
______lambda13_ (Block3Data* _data3_,
                 NotificationsCloseReason res)
{
	Block2Data* _data2_;
	NotificationsServer* self;
	gboolean _tmp0_ = FALSE;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	if (res == NOTIFICATIONS_CLOSE_REASON_EXPIRED) {
		GSettings* _tmp1_;
		_tmp1_ = _data3_->app_settings;
		_tmp0_ = g_settings_get_boolean (_tmp1_, "remember");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	g_signal_emit (self, notifications_server_signals[NOTIFICATIONS_SERVER_NOTIFICATION_CLOSED_SIGNAL], 0, _data2_->id, (guint32) res);
}

static void
_______lambda13__notifications_abstract_bubble_closed (NotificationsAbstractBubble* _sender,
                                                       NotificationsCloseReason reason,
                                                       gpointer self)
{
	______lambda13_ (self, reason);
}

guint32
notifications_server_notify (NotificationsServer* self,
                             const gchar* app_name,
                             guint32 replaces_id,
                             const gchar* app_icon,
                             const gchar* summary,
                             const gchar* body,
                             gchar** actions,
                             gint actions_length1,
                             GHashTable* hints,
                             gint32 expire_timeout,
                             const char* sender,
                             GError** error)
{
	Block2Data* _data2_;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	guint32 _tmp11_ = 0U;
	GError* _inner_error0_ = NULL;
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (app_name != NULL, 0U);
	g_return_val_if_fail (app_icon != NULL, 0U);
	g_return_val_if_fail (summary != NULL, 0U);
	g_return_val_if_fail (body != NULL, 0U);
	g_return_val_if_fail (hints != NULL, 0U);
	g_return_val_if_fail (sender != NULL, 0U);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	if (g_hash_table_contains (hints, "desktop-entry")) {
		gconstpointer _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = g_hash_table_lookup (hints, "desktop-entry");
		_tmp6_ = g_variant_get_string ((GVariant*) _tmp5_, NULL);
		_tmp4_ = g_strcmp0 (_tmp6_, "gnome-power-panel") == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = g_hash_table_contains (hints, "urgency");
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gconstpointer _tmp7_;
		_tmp7_ = g_hash_table_lookup (hints, "urgency");
		_tmp2_ = ((gint) g_variant_get_byte ((GVariant*) _tmp7_)) == 2;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = g_strcmp0 (app_icon, "") == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = expire_timeout == ((gint32) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GError* _tmp8_;
		g_debug ("DBus.vala:103: Blocked GSD notification");
		_tmp8_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "Notification Blocked");
		_inner_error0_ = _tmp8_;
		if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			guint32 _tmp9_ = 0U;
			g_propagate_error (error, _inner_error0_);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			return _tmp9_;
		} else {
			guint32 _tmp10_ = 0U;
			block2_data_unref (_data2_);
			_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp10_;
		}
	}
	if (replaces_id != ((guint32) 0)) {
		_tmp11_ = replaces_id;
	} else {
		guint32 _tmp12_;
		self->priv->id_counter = self->priv->id_counter + 1;
		_tmp12_ = self->priv->id_counter;
		_tmp11_ = _tmp12_;
	}
	_data2_->id = _tmp11_;
	if (g_hash_table_contains (hints, NOTIFICATIONS_SERVER_X_CANONICAL_PRIVATE_SYNCHRONOUS)) {
		notifications_server_send_confirmation (self, app_icon, hints);
	} else {
		GDesktopAppInfo* app_info = NULL;
		gboolean _tmp13_ = FALSE;
		NotificationsNotification* notification = NULL;
		GDesktopAppInfo* _tmp21_;
		GPtrArray* _tmp22_;
		NotificationsNotification* _tmp23_ = NULL;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp55_ = FALSE;
		GSettings* _tmp56_;
		app_info = NULL;
		if (g_hash_table_contains (hints, "desktop-entry")) {
			gconstpointer _tmp14_;
			const GVariantType* _tmp15_;
			_tmp14_ = g_hash_table_lookup (hints, "desktop-entry");
			_tmp15_ = G_VARIANT_TYPE_STRING;
			_tmp13_ = g_variant_is_of_type ((GVariant*) _tmp14_, _tmp15_);
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			gconstpointer _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			GDesktopAppInfo* _tmp20_;
			_tmp16_ = g_hash_table_lookup (hints, "desktop-entry");
			_tmp17_ = g_variant_get_string ((GVariant*) _tmp16_, NULL);
			_tmp18_ = g_strdup_printf ("%s.desktop", _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_desktop_app_info_new (_tmp19_);
			_g_object_unref0 (app_info);
			app_info = _tmp20_;
			_g_free0 (_tmp19_);
		}
		_tmp21_ = app_info;
		_tmp22_ = g_ptr_array_new_full ((guint) (actions_length1 / 2), _notifications_notification_button_free0_);
		_tmp23_ = notifications_notification_new (app_name, app_icon, summary, body, _tmp21_, hints);
		notifications_notification_set_buttons (_tmp23_, _tmp22_);
		_g_ptr_array_unref0 (_tmp22_);
		notification = _tmp23_;
		if (g_hash_table_contains (hints, "urgency")) {
			gconstpointer _tmp25_;
			const GVariantType* _tmp26_;
			_tmp25_ = g_hash_table_lookup (hints, "urgency");
			_tmp26_ = G_VARIANT_TYPE_BYTE;
			_tmp24_ = g_variant_is_of_type ((GVariant*) _tmp25_, _tmp26_);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			gconstpointer _tmp27_;
			_tmp27_ = g_hash_table_lookup (hints, "urgency");
			switch (g_variant_get_byte ((GVariant*) _tmp27_)) {
				case 0:
				{
					NotificationsNotification* _tmp28_;
					_tmp28_ = notification;
					notifications_notification_set_priority (_tmp28_, G_NOTIFICATION_PRIORITY_LOW);
					break;
				}
				case 1:
				{
					NotificationsNotification* _tmp29_;
					_tmp29_ = notification;
					notifications_notification_set_priority (_tmp29_, G_NOTIFICATION_PRIORITY_NORMAL);
					break;
				}
				case 2:
				{
					NotificationsNotification* _tmp30_;
					_tmp30_ = notification;
					notifications_notification_set_priority (_tmp30_, G_NOTIFICATION_PRIORITY_URGENT);
					break;
				}
				default:
				{
					gconstpointer _tmp31_;
					_tmp31_ = g_hash_table_lookup (hints, "urgency");
					g_warning ("DBus.vala:136: unknown urgency value: %i, ignoring", (gint) g_variant_get_byte ((GVariant*) _tmp31_));
					break;
				}
			}
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp32_ = FALSE;
				_tmp32_ = TRUE;
				while (TRUE) {
					const gchar* _tmp33_;
					gchar* action_name = NULL;
					NotificationsFdoActionGroup* _tmp34_;
					const gchar* _tmp35_;
					const gchar* _tmp36_;
					gchar* _tmp37_;
					const gchar* _tmp38_;
					gchar* label = NULL;
					const gchar* _tmp41_;
					gchar* _tmp42_;
					const gchar* _tmp43_;
					NotificationsNotification* _tmp45_;
					GPtrArray* _tmp46_;
					GPtrArray* _tmp47_;
					const gchar* _tmp48_;
					gchar* _tmp49_;
					const gchar* _tmp50_;
					gchar* _tmp51_;
					NotificationsNotificationButton _tmp52_ = {0};
					NotificationsNotificationButton _tmp53_;
					NotificationsNotificationButton* _tmp54_;
					if (!_tmp32_) {
						i += 2;
					}
					_tmp32_ = FALSE;
					if (!(i < actions_length1)) {
						break;
					}
					_tmp33_ = actions[i];
					if (g_strcmp0 (_tmp33_, "") == 0) {
						continue;
					}
					_tmp34_ = self->priv->action_group;
					_tmp35_ = actions[i];
					_tmp36_ = notifications_fdo_action_group_add_action (_tmp34_, _data2_->id, _tmp35_);
					_tmp37_ = g_strconcat ("fdo.", _tmp36_, NULL);
					action_name = _tmp37_;
					_tmp38_ = actions[i];
					if (g_strcmp0 (_tmp38_, "default") == 0) {
						NotificationsNotification* _tmp39_;
						const gchar* _tmp40_;
						_tmp39_ = notification;
						_tmp40_ = action_name;
						notifications_notification_set_default_action_name (_tmp39_, _tmp40_);
						_g_free0 (action_name);
						continue;
					}
					_tmp41_ = actions[i + 1];
					_tmp42_ = string_strip (_tmp41_);
					label = _tmp42_;
					_tmp43_ = label;
					if (g_strcmp0 (_tmp43_, "") == 0) {
						const gchar* _tmp44_;
						_tmp44_ = actions[i];
						g_warning ("DBus.vala:155: action '%s' sent without a label, skipping…", _tmp44_);
						_g_free0 (label);
						_g_free0 (action_name);
						continue;
					}
					_tmp45_ = notification;
					_tmp46_ = notifications_notification_get_buttons (_tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = label;
					_tmp49_ = g_strdup (_tmp48_);
					_tmp50_ = action_name;
					_tmp51_ = g_strdup (_tmp50_);
					_g_free0 (_tmp52_.label);
					_tmp52_.label = _tmp49_;
					_g_free0 (_tmp52_.action_name);
					_tmp52_.action_name = _tmp51_;
					_tmp53_ = _tmp52_;
					_tmp54_ = _notifications_notification_button_dup0 (&_tmp53_);
					g_ptr_array_add (_tmp47_, _tmp54_);
					notifications_notification_button_destroy (&_tmp53_);
					_g_free0 (label);
					_g_free0 (action_name);
				}
			}
		}
		_tmp56_ = notifications_application_settings;
		if (!g_settings_get_boolean (_tmp56_, "do-not-disturb")) {
			_tmp55_ = TRUE;
		} else {
			NotificationsNotification* _tmp57_;
			GNotificationPriority _tmp58_;
			GNotificationPriority _tmp59_;
			_tmp57_ = notification;
			_tmp58_ = notifications_notification_get_priority (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp55_ = _tmp59_ == G_NOTIFICATION_PRIORITY_URGENT;
		}
		if (_tmp55_) {
			Block3Data* _data3_;
			GSettings* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			NotificationsNotification* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			GSettings* _tmp69_;
			GSettings* _tmp70_;
			GSettings* _tmp71_;
			GSettings* _tmp98_;
			_data3_ = g_slice_new0 (Block3Data);
			_data3_->_ref_count_ = 1;
			_data3_->_data2_ = block2_data_ref (_data2_);
			_tmp60_ = notifications_application_settings;
			g_object_get (_tmp60_, "path", &_tmp61_, NULL);
			_tmp62_ = _tmp61_;
			_tmp63_ = _tmp62_;
			_tmp64_ = notification;
			_tmp65_ = notifications_notification_get_app_id (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = g_strconcat (_tmp63_, "applications", "/", _tmp66_, "/", NULL);
			_tmp68_ = _tmp67_;
			_tmp69_ = g_settings_new_with_path ("io.elementary.notifications.applications", _tmp68_);
			_tmp70_ = _tmp69_;
			_g_free0 (_tmp68_);
			_g_free0 (_tmp63_);
			_data3_->app_settings = _tmp70_;
			_tmp71_ = _data3_->app_settings;
			if (g_settings_get_boolean (_tmp71_, "bubbles")) {
				gboolean _tmp72_ = FALSE;
				GeeMap* _tmp73_;
				GeeMap* _tmp95_;
				gpointer _tmp96_;
				NotificationsBubble* _tmp97_;
				_tmp73_ = self->priv->bubbles;
				if (gee_map_has_key (_tmp73_, (gpointer) ((guintptr) _data2_->id))) {
					GeeMap* _tmp74_;
					gpointer _tmp75_;
					NotificationsBubble* _tmp76_;
					_tmp74_ = self->priv->bubbles;
					_tmp75_ = gee_map_get (_tmp74_, (gpointer) ((guintptr) _data2_->id));
					_tmp76_ = (NotificationsBubble*) _tmp75_;
					_tmp72_ = _tmp76_ != NULL;
					_g_object_unref0 (_tmp76_);
				} else {
					_tmp72_ = FALSE;
				}
				if (_tmp72_) {
					GeeMap* _tmp77_;
					gpointer _tmp78_;
					NotificationsBubble* _tmp79_;
					NotificationsNotification* _tmp80_;
					_tmp77_ = self->priv->bubbles;
					_tmp78_ = gee_map_get (_tmp77_, (gpointer) ((guintptr) _data2_->id));
					_tmp79_ = (NotificationsBubble*) _tmp78_;
					_tmp80_ = notification;
					notifications_bubble_set_notification (_tmp79_, _tmp80_);
					_g_object_unref0 (_tmp79_);
				} else {
					GeeMap* _tmp81_;
					NotificationsNotification* _tmp82_;
					NotificationsBubble* _tmp83_;
					NotificationsBubble* _tmp84_;
					GeeMap* _tmp85_;
					gpointer _tmp86_;
					NotificationsBubble* _tmp87_;
					NotificationsFdoActionGroup* _tmp88_;
					GeeMap* _tmp89_;
					gpointer _tmp90_;
					NotificationsBubble* _tmp91_;
					GeeMap* _tmp92_;
					gpointer _tmp93_;
					NotificationsBubble* _tmp94_;
					_tmp81_ = self->priv->bubbles;
					_tmp82_ = notification;
					_tmp83_ = notifications_bubble_new (_tmp82_);
					g_object_ref_sink (_tmp83_);
					_tmp84_ = _tmp83_;
					gee_map_set (_tmp81_, (gpointer) ((guintptr) _data2_->id), _tmp84_);
					_g_object_unref0 (_tmp84_);
					_tmp85_ = self->priv->bubbles;
					_tmp86_ = gee_map_get (_tmp85_, (gpointer) ((guintptr) _data2_->id));
					_tmp87_ = (NotificationsBubble*) _tmp86_;
					_tmp88_ = self->priv->action_group;
					gtk_widget_insert_action_group ((GtkWidget*) _tmp87_, "fdo", (GActionGroup*) _tmp88_);
					_g_object_unref0 (_tmp87_);
					_tmp89_ = self->priv->bubbles;
					_tmp90_ = gee_map_get (_tmp89_, (gpointer) ((guintptr) _data2_->id));
					_tmp91_ = (NotificationsBubble*) _tmp90_;
					g_signal_connect_data ((GtkWindow*) _tmp91_, "close-request", (GCallback) _______lambda12__gtk_window_close_request, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
					_g_object_unref0 (_tmp91_);
					_tmp92_ = self->priv->bubbles;
					_tmp93_ = gee_map_get (_tmp92_, (gpointer) ((guintptr) _data2_->id));
					_tmp94_ = (NotificationsBubble*) _tmp93_;
					g_signal_connect_data ((NotificationsAbstractBubble*) _tmp94_, "closed", (GCallback) _______lambda13__notifications_abstract_bubble_closed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
					_g_object_unref0 (_tmp94_);
				}
				_tmp95_ = self->priv->bubbles;
				_tmp96_ = gee_map_get (_tmp95_, (gpointer) ((guintptr) _data2_->id));
				_tmp97_ = (NotificationsBubble*) _tmp96_;
				notifications_abstract_bubble_present ((NotificationsAbstractBubble*) _tmp97_);
				_g_object_unref0 (_tmp97_);
			}
			_tmp98_ = _data3_->app_settings;
			if (g_settings_get_boolean (_tmp98_, "sounds")) {
				const gchar* _tmp99_ = NULL;
				NotificationsNotification* _tmp100_;
				GNotificationPriority _tmp101_;
				GNotificationPriority _tmp102_;
				gchar* sound = NULL;
				gchar* _tmp103_;
				gboolean _tmp104_ = FALSE;
				const gchar* _tmp111_;
				_tmp100_ = notification;
				_tmp101_ = notifications_notification_get_priority (_tmp100_);
				_tmp102_ = _tmp101_;
				if (_tmp102_ != G_NOTIFICATION_PRIORITY_URGENT) {
					_tmp99_ = "dialog-information";
				} else {
					_tmp99_ = "dialog-warning";
				}
				_tmp103_ = g_strdup (_tmp99_);
				sound = _tmp103_;
				if (g_hash_table_contains (hints, "category")) {
					gconstpointer _tmp105_;
					const GVariantType* _tmp106_;
					_tmp105_ = g_hash_table_lookup (hints, "category");
					_tmp106_ = G_VARIANT_TYPE_STRING;
					_tmp104_ = g_variant_is_of_type ((GVariant*) _tmp105_, _tmp106_);
				} else {
					_tmp104_ = FALSE;
				}
				if (_tmp104_) {
					gconstpointer _tmp107_;
					const gchar* _tmp108_;
					const gchar* _tmp109_;
					gchar* _tmp110_;
					_tmp107_ = g_hash_table_lookup (hints, "category");
					_tmp108_ = g_variant_get_string ((GVariant*) _tmp107_, NULL);
					_tmp109_ = notifications_server_category_to_sound_name (_tmp108_);
					_tmp110_ = g_strdup (_tmp109_);
					_g_free0 (sound);
					sound = _tmp110_;
				}
				_tmp111_ = sound;
				notifications_application_play_sound (_tmp111_);
				_g_free0 (sound);
			}
			block3_data_unref (_data3_);
			_data3_ = NULL;
		}
		_g_object_unref0 (notification);
		_g_object_unref0 (app_info);
	}
	result = _data2_->id;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static gboolean
___lambda11_ (NotificationsServer* self)
{
	gboolean result;
	_g_object_unref0 (self->priv->confirmation);
	self->priv->confirmation = NULL;
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
____lambda11__gtk_window_close_request (GtkWindow* _sender,
                                        gpointer self)
{
	gboolean result;
	result = ___lambda11_ ((NotificationsServer*) self);
	return result;
}

static void
notifications_server_send_confirmation (NotificationsServer* self,
                                        const gchar* icon_name,
                                        GHashTable* hints)
{
	gdouble progress_value = 0.0;
	GVariant* val = NULL;
	gconstpointer _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gchar* confirmation_type = NULL;
	gconstpointer _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	NotificationsConfirmation* _tmp8_;
	NotificationsConfirmation* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	g_return_if_fail (hints != NULL);
	_tmp0_ = g_hash_table_lookup (hints, "value");
	_tmp1_ = _g_variant_ref0 ((GVariant*) _tmp0_);
	val = _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ != NULL) {
		GVariant* _tmp3_;
		_tmp3_ = val;
		progress_value = CLAMP (g_variant_get_int32 (_tmp3_), (gint32) 0, (gint32) 100) / 100.0;
	} else {
		progress_value = (gdouble) -1;
	}
	_tmp4_ = g_hash_table_lookup (hints, NOTIFICATIONS_SERVER_X_CANONICAL_PRIVATE_SYNCHRONOUS);
	_tmp5_ = g_variant_get_string ((GVariant*) _tmp4_, NULL);
	_tmp6_ = g_strdup (_tmp5_);
	confirmation_type = _tmp6_;
	_tmp7_ = confirmation_type;
	if (g_strcmp0 (_tmp7_, "indicator-sound") == 0) {
		notifications_application_play_sound ("audio-volume-change");
	}
	_tmp8_ = self->priv->confirmation;
	if (_tmp8_ == NULL) {
		NotificationsConfirmation* _tmp9_;
		NotificationsConfirmation* _tmp10_;
		_tmp9_ = notifications_confirmation_new (icon_name, progress_value);
		g_object_ref_sink (_tmp9_);
		_g_object_unref0 (self->priv->confirmation);
		self->priv->confirmation = _tmp9_;
		_tmp10_ = self->priv->confirmation;
		g_signal_connect_object ((GtkWindow*) _tmp10_, "close-request", (GCallback) ____lambda11__gtk_window_close_request, self, 0);
	} else {
		NotificationsConfirmation* _tmp11_;
		NotificationsConfirmation* _tmp12_;
		_tmp11_ = self->priv->confirmation;
		notifications_confirmation_set_icon_name (_tmp11_, icon_name);
		_tmp12_ = self->priv->confirmation;
		notifications_confirmation_set_progress (_tmp12_, progress_value);
	}
	_tmp13_ = self->priv->confirmation;
	notifications_abstract_bubble_present ((NotificationsAbstractBubble*) _tmp13_);
	_g_free0 (confirmation_type);
	_g_variant_unref0 (val);
}

static const gchar*
notifications_server_category_to_sound_name (const gchar* category)
{
	const gchar* sound = NULL;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	static GQuark _tmp1_label8 = 0;
	static GQuark _tmp1_label9 = 0;
	static GQuark _tmp1_label10 = 0;
	static GQuark _tmp1_label11 = 0;
	static GQuark _tmp1_label12 = 0;
	static GQuark _tmp1_label13 = 0;
	static GQuark _tmp1_label14 = 0;
	static GQuark _tmp1_label15 = 0;
	static GQuark _tmp1_label16 = 0;
	static GQuark _tmp1_label17 = 0;
	const gchar* _tmp3_;
	const gchar* result;
	g_return_val_if_fail (category != NULL, NULL);
	_tmp0_ = category;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("call")))) {
		switch (0) {
			default:
			{
				sound = "dialog-information";
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("call.ended")))) {
		switch (0) {
			default:
			{
				sound = "phone-hangup";
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("call.incoming")))) {
		switch (0) {
			default:
			{
				sound = "phone-incoming-call";
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("call.unanswered")))) {
		switch (0) {
			default:
			{
				sound = "phone-outgoing-busy";
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("device.added")))) {
		switch (0) {
			default:
			{
				sound = "device-added";
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("device.removed")))) {
		switch (0) {
			default:
			{
				sound = "device-removed";
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("im")))) {
		switch (0) {
			default:
			{
				sound = "message";
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("im.received")))) {
		switch (0) {
			default:
			{
				sound = "message-new-instant";
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string ("network.connected")))) {
		switch (0) {
			default:
			{
				sound = "network-connectivity-established";
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label9) ? _tmp1_label9 : (_tmp1_label9 = g_quark_from_static_string ("network.disconnected")))) {
		switch (0) {
			default:
			{
				sound = "network-connectivity-lost";
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label10) ? _tmp1_label10 : (_tmp1_label10 = g_quark_from_static_string ("presence.online")))) {
		switch (0) {
			default:
			{
				sound = "service-login";
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label11) ? _tmp1_label11 : (_tmp1_label11 = g_quark_from_static_string ("presence.offline")))) {
		switch (0) {
			default:
			{
				sound = "service-logout";
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label12) ? _tmp1_label12 : (_tmp1_label12 = g_quark_from_static_string ("x-gnome.music")))) {
		switch (0) {
			default:
			{
				sound = "";
				break;
			}
		}
	} else if (((((_tmp2_ == ((0 != _tmp1_label13) ? _tmp1_label13 : (_tmp1_label13 = g_quark_from_static_string ("device.error")))) || (_tmp2_ == ((0 != _tmp1_label14) ? _tmp1_label14 : (_tmp1_label14 = g_quark_from_static_string ("email.bounced"))))) || (_tmp2_ == ((0 != _tmp1_label15) ? _tmp1_label15 : (_tmp1_label15 = g_quark_from_static_string ("im.error"))))) || (_tmp2_ == ((0 != _tmp1_label16) ? _tmp1_label16 : (_tmp1_label16 = g_quark_from_static_string ("network.error"))))) || (_tmp2_ == ((0 != _tmp1_label17) ? _tmp1_label17 : (_tmp1_label17 = g_quark_from_static_string ("transfer.error"))))) {
		switch (0) {
			default:
			{
				sound = "dialog-error";
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				sound = "dialog-information";
				break;
			}
		}
	}
	_tmp3_ = sound;
	result = _tmp3_;
	return result;
}

static void
g_cclosure_user_marshal_VOID__UINT_STRING (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_STRING) (gpointer data1, guint32 arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint32 arg_1, guint32 arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}

static void
notifications_server_class_init (NotificationsServerClass * klass,
                                 gpointer klass_data)
{
	notifications_server_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NotificationsServer_private_offset);
	G_OBJECT_CLASS (klass)->finalize = notifications_server_finalize;
	notifications_server_signals[NOTIFICATIONS_SERVER_ACTION_INVOKED_SIGNAL] = g_signal_new ("action-invoked", NOTIFICATIONS_TYPE_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_STRING, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_STRING);
	notifications_server_signals[NOTIFICATIONS_SERVER_NOTIFICATION_CLOSED_SIGNAL] = g_signal_new ("notification-closed", NOTIFICATIONS_TYPE_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
}

static void
notifications_server_instance_init (NotificationsServer * self,
                                    gpointer klass)
{
	self->priv = notifications_server_get_instance_private (self);
	self->priv->id_counter = (guint32) 0;
}

static void
notifications_server_finalize (GObject * obj)
{
	NotificationsServer * self;
	GDBusConnection* _tmp0_;
	GDBusConnection* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NOTIFICATIONS_TYPE_SERVER, NotificationsServer);
	_tmp0_ = self->priv->connection;
	g_dbus_connection_unexport_action_group (_tmp0_, self->priv->action_group_id);
	_tmp1_ = self->priv->connection;
	g_dbus_connection_unregister_object (_tmp1_, self->priv->server_id);
	_g_object_unref0 (self->priv->action_group);
	_g_object_unref0 (self->priv->bubbles);
	_g_object_unref0 (self->priv->confirmation);
	G_OBJECT_CLASS (notifications_server_parent_class)->finalize (obj);
}

static GType
notifications_server_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotificationsServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notifications_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationsServer), 0, (GInstanceInitFunc) notifications_server_instance_init, NULL };
	GType notifications_server_type_id;
	notifications_server_type_id = g_type_register_static (G_TYPE_OBJECT, "NotificationsServer", &g_define_type_info, 0);
	g_type_set_qdata (notifications_server_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) notifications_server_register_object);
	NotificationsServer_private_offset = g_type_add_instance_private (notifications_server_type_id, sizeof (NotificationsServerPrivate));
	return notifications_server_type_id;
}

GType
notifications_server_get_type (void)
{
	static volatile gsize notifications_server_type_id__once = 0;
	if (g_once_init_enter (&notifications_server_type_id__once)) {
		GType notifications_server_type_id;
		notifications_server_type_id = notifications_server_get_type_once ();
		g_once_init_leave (&notifications_server_type_id__once, notifications_server_type_id);
	}
	return notifications_server_type_id__once;
}

static void
_dbus_notifications_server_close_notification (NotificationsServer* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 id = 0U;
	GVariant* _tmp0_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_get_uint32 (_tmp0_);
	g_variant_unref (_tmp0_);
	notifications_server_close_notification (self, id, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_notifications_server_get_capabilities (NotificationsServer* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp1_;
	GVariantBuilder _tmp2_;
	gint _tmp3_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = notifications_server_get_capabilities (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp1_ = result;
	g_variant_builder_init (&_tmp2_, G_VARIANT_TYPE ("as"));
	for (_tmp3_ = 0; _tmp3_ < result_length1; _tmp3_++) {
		g_variant_builder_add_value (&_tmp2_, g_variant_new_string (*_tmp1_));
		_tmp1_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp2_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_notifications_server_get_server_information (NotificationsServer* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* name = NULL;
	gchar* vendor = NULL;
	gchar* version = NULL;
	gchar* spec_version = NULL;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	notifications_server_get_server_information (self, &name, &vendor, &version, &spec_version, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (vendor));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (version));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (spec_version));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_g_free0 (name);
	_g_free0 (vendor);
	_g_free0 (version);
	_g_free0 (spec_version);
}

static void
_dbus_notifications_server_notify (NotificationsServer* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* app_name = NULL;
	GVariant* _tmp4_;
	guint32 replaces_id = 0U;
	GVariant* _tmp5_;
	gchar* app_icon = NULL;
	GVariant* _tmp6_;
	gchar* summary = NULL;
	GVariant* _tmp7_;
	gchar* body = NULL;
	GVariant* _tmp8_;
	gchar** actions = NULL;
	gint actions_length1 = 0;
	GVariant* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length;
	gint _tmp10__size;
	gint _tmp10__length1;
	GVariantIter _tmp11_;
	GVariant* _tmp12_;
	GHashTable* hints = NULL;
	GVariant* _tmp13_;
	GHashTable* _tmp14_;
	GVariantIter _tmp15_;
	GVariant* _tmp16_;
	GVariant* _tmp17_;
	gint32 expire_timeout = 0;
	GVariant* _tmp18_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32 result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	app_name = g_variant_dup_string (_tmp4_, NULL);
	g_variant_unref (_tmp4_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	replaces_id = g_variant_get_uint32 (_tmp5_);
	g_variant_unref (_tmp5_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	app_icon = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	summary = g_variant_dup_string (_tmp7_, NULL);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	body = g_variant_dup_string (_tmp8_, NULL);
	g_variant_unref (_tmp8_);
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp10_ = g_new (gchar*, 5);
	_tmp10__length = 0;
	_tmp10__size = 4;
	_tmp10__length1 = 0;
	g_variant_iter_init (&_tmp11_, _tmp9_);
	for (; (_tmp12_ = g_variant_iter_next_value (&_tmp11_)) != NULL; _tmp10__length1++) {
		if (_tmp10__size == _tmp10__length) {
			_tmp10__size = 2 * _tmp10__size;
			_tmp10_ = g_renew (gchar*, _tmp10_, _tmp10__size + 1);
		}
		_tmp10_[_tmp10__length++] = g_variant_dup_string (_tmp12_, NULL);
		g_variant_unref (_tmp12_);
	}
	actions_length1 = _tmp10__length1;
	_tmp10_[_tmp10__length] = NULL;
	actions = _tmp10_;
	g_variant_unref (_tmp9_);
	_tmp13_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp14_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp15_, _tmp13_);
	while (g_variant_iter_loop (&_tmp15_, "{?*}", &_tmp16_, &_tmp17_)) {
		g_hash_table_insert (_tmp14_, g_variant_dup_string (_tmp16_, NULL), g_variant_get_variant (_tmp17_));
	}
	hints = _tmp14_;
	g_variant_unref (_tmp13_);
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	expire_timeout = g_variant_get_int32 (_tmp18_);
	g_variant_unref (_tmp18_);
	result = notifications_server_notify (self, app_name, replaces_id, app_icon, summary, body, actions, actions_length1, hints, expire_timeout, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (app_name);
	_g_free0 (app_icon);
	_g_free0 (summary);
	_g_free0 (body);
	actions = (_vala_array_free (actions, actions_length1, (GDestroyNotify) g_free), NULL);
	_g_hash_table_unref0 (hints);
	;
}

static void
notifications_server_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "CloseNotification") == 0) {
		_dbus_notifications_server_close_notification (object, parameters, invocation);
	} else if (strcmp (method_name, "GetCapabilities") == 0) {
		_dbus_notifications_server_get_capabilities (object, parameters, invocation);
	} else if (strcmp (method_name, "GetServerInformation") == 0) {
		_dbus_notifications_server_get_server_information (object, parameters, invocation);
	} else if (strcmp (method_name, "Notify") == 0) {
		_dbus_notifications_server_notify (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
notifications_server_dbus_interface_get_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
notifications_server_dbus_interface_set_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GVariant* value,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_notifications_server_action_invoked (GObject* _sender,
                                           guint32 id,
                                           const gchar* action_key,
                                           gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (action_key));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Notifications", "ActionInvoked", _arguments, NULL);
}

static void
_dbus_notifications_server_notification_closed (GObject* _sender,
                                                guint32 id,
                                                guint32 reason,
                                                gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (reason));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Notifications", "NotificationClosed", _arguments, NULL);
}

guint
notifications_server_register_object (gpointer object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_notifications_server_dbus_interface_info), &_notifications_server_dbus_interface_vtable, data, _notifications_server_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "action-invoked", (GCallback) _dbus_notifications_server_action_invoked, data);
	g_signal_connect (object, "notification-closed", (GCallback) _dbus_notifications_server_notification_closed, data);
	return result;
}

static void
_notifications_server_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_notifications_server_action_invoked, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_notifications_server_notification_closed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

