/* GroupedFolderSourceItem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from GroupedFolderSourceItem.vala, do not modify */

/*
* Copyright 2021 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <camel/camel.h>
#include <gio/gio.h>
#include <gee.h>
#include <libedataserver/libedataserver.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAIL_SOURCE_LIST_TYPE_ITEM (mail_source_list_item_get_type ())
#define MAIL_SOURCE_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_SOURCE_LIST_TYPE_ITEM, MailSourceListItem))
#define MAIL_SOURCE_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_SOURCE_LIST_TYPE_ITEM, MailSourceListItemClass))
#define MAIL_SOURCE_LIST_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_SOURCE_LIST_TYPE_ITEM))
#define MAIL_SOURCE_LIST_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_SOURCE_LIST_TYPE_ITEM))
#define MAIL_SOURCE_LIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_SOURCE_LIST_TYPE_ITEM, MailSourceListItemClass))

typedef struct _MailSourceListItem MailSourceListItem;
typedef struct _MailSourceListItemClass MailSourceListItemClass;
typedef struct _MailSourceListItemPrivate MailSourceListItemPrivate;

#define MAIL_TYPE_GROUPED_FOLDER_SOURCE_ITEM (mail_grouped_folder_source_item_get_type ())
#define MAIL_GROUPED_FOLDER_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_GROUPED_FOLDER_SOURCE_ITEM, MailGroupedFolderSourceItem))
#define MAIL_GROUPED_FOLDER_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_GROUPED_FOLDER_SOURCE_ITEM, MailGroupedFolderSourceItemClass))
#define MAIL_IS_GROUPED_FOLDER_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_GROUPED_FOLDER_SOURCE_ITEM))
#define MAIL_IS_GROUPED_FOLDER_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_GROUPED_FOLDER_SOURCE_ITEM))
#define MAIL_GROUPED_FOLDER_SOURCE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_GROUPED_FOLDER_SOURCE_ITEM, MailGroupedFolderSourceItemClass))

typedef struct _MailGroupedFolderSourceItem MailGroupedFolderSourceItem;
typedef struct _MailGroupedFolderSourceItemClass MailGroupedFolderSourceItemClass;
typedef struct _MailGroupedFolderSourceItemPrivate MailGroupedFolderSourceItemPrivate;

#define MAIL_BACKEND_TYPE_SESSION (mail_backend_session_get_type ())
#define MAIL_BACKEND_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSession))
#define MAIL_BACKEND_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))
#define MAIL_BACKEND_IS_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_IS_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))

typedef struct _MailBackendSession MailBackendSession;
typedef struct _MailBackendSessionClass MailBackendSessionClass;

#define MAIL_BACKEND_TYPE_ACCOUNT (mail_backend_account_get_type ())
#define MAIL_BACKEND_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccount))
#define MAIL_BACKEND_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccountClass))
#define MAIL_BACKEND_IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_BACKEND_TYPE_ACCOUNT))
#define MAIL_BACKEND_IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_BACKEND_TYPE_ACCOUNT))
#define MAIL_BACKEND_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccountClass))

typedef struct _MailBackendAccount MailBackendAccount;
typedef struct _MailBackendAccountClass MailBackendAccountClass;
enum  {
	MAIL_GROUPED_FOLDER_SOURCE_ITEM_0_PROPERTY,
	MAIL_GROUPED_FOLDER_SOURCE_ITEM_SESSION_PROPERTY,
	MAIL_GROUPED_FOLDER_SOURCE_ITEM_FOLDER_TYPE_PROPERTY,
	MAIL_GROUPED_FOLDER_SOURCE_ITEM_NUM_PROPERTIES
};
static GParamSpec* mail_grouped_folder_source_item_properties[MAIL_GROUPED_FOLDER_SOURCE_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_CamelFolderInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_CamelFolderInfo_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MailGroupedFolderSourceItemLoadFolderInfoData MailGroupedFolderSourceItemLoadFolderInfoData;

struct _MailSourceListItem {
	GObject parent_instance;
	MailSourceListItemPrivate * priv;
};

struct _MailSourceListItemClass {
	GObjectClass parent_class;
	GtkMenu* (*get_context_menu) (MailSourceListItem* self);
	void (*edited) (MailSourceListItem* self, const gchar* new_name);
	void (*action_activated) (MailSourceListItem* self);
	void (*activated) (MailSourceListItem* self);
};

struct _MailGroupedFolderSourceItem {
	MailSourceListItem parent_instance;
	MailGroupedFolderSourceItemPrivate * priv;
};

struct _MailGroupedFolderSourceItemClass {
	MailSourceListItemClass parent_class;
};

struct _MailGroupedFolderSourceItemPrivate {
	MailBackendSession* _session;
	CamelFolderInfoFlags _folder_type;
	GCancellable* connect_cancellable;
	GeeHashMap* account_folderinfo;
	GRecMutex __lock_account_folderinfo;
};

struct _MailGroupedFolderSourceItemLoadFolderInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailGroupedFolderSourceItem* self;
	MailBackendAccount* account;
	CamelOfflineStore* offlinestore;
	CamelService* _tmp0_;
	CamelService* _tmp1_;
	CamelOfflineStore* _tmp2_;
	gchar* full_name;
	gchar* _tmp3_;
	CamelFolderInfo* folderinfo;
	const gchar* _tmp4_;
	CamelFolderInfo* _tmp5_;
	CamelOfflineStore* _tmp6_;
	const gchar* _tmp7_;
	GCancellable* _tmp8_;
	CamelFolderInfo* _tmp9_;
	CamelFolderInfo* _tmp10_;
	GError* e;
	GError* _tmp11_;
	const gchar* _tmp12_;
	CamelService* _tmp13_;
	CamelService* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	const gchar* _tmp18_;
	GeeHashMap* _tmp19_;
	GeeHashMap* _tmp20_;
	CamelFolderInfo* _tmp21_;
	GeeHashMap* _tmp22_;
	GError* _inner_error0_;
};

static gint MailGroupedFolderSourceItem_private_offset;
static gpointer mail_grouped_folder_source_item_parent_class = NULL;

VALA_EXTERN GType mail_source_list_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailSourceListItem, g_object_unref)
VALA_EXTERN GType mail_grouped_folder_source_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailGroupedFolderSourceItem, g_object_unref)
VALA_EXTERN GType mail_backend_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailBackendSession, g_object_unref)
VALA_EXTERN GType mail_backend_account_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailBackendAccount, g_object_unref)
VALA_EXTERN MailGroupedFolderSourceItem* mail_grouped_folder_source_item_new (MailBackendSession* session,
                                                                  CamelFolderInfoFlags folder_type);
VALA_EXTERN MailGroupedFolderSourceItem* mail_grouped_folder_source_item_construct (GType object_type,
                                                                        MailBackendSession* session,
                                                                        CamelFolderInfoFlags folder_type);
VALA_EXTERN GeeMap* mail_grouped_folder_source_item_get_folder_info_per_account (MailGroupedFolderSourceItem* self);
static CamelFolderInfo* _vala_CamelFolderInfo_copy (CamelFolderInfo* self);
static void _vala_CamelFolderInfo_free (CamelFolderInfo* self);
static void mail_grouped_folder_source_item_add_account (MailGroupedFolderSourceItem* self,
                                                  MailBackendAccount* account);
static void mail_grouped_folder_source_item_load_folder_info (MailGroupedFolderSourceItem* self,
                                                       MailBackendAccount* account,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static void mail_grouped_folder_source_item_load_folder_info_finish (MailGroupedFolderSourceItem* self,
                                                              GAsyncResult* _res_);
static void mail_grouped_folder_source_item_load_folder_info_data_free (gpointer _data);
static gboolean mail_grouped_folder_source_item_load_folder_info_co (MailGroupedFolderSourceItemLoadFolderInfoData* _data_);
VALA_EXTERN CamelService* mail_backend_account_get_service (MailBackendAccount* self);
static gchar* mail_grouped_folder_source_item_build_folder_full_name (MailGroupedFolderSourceItem* self,
                                                               MailBackendAccount* account);
static void mail_grouped_folder_source_item_load_folder_info_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static void mail_grouped_folder_source_item_update_infos (MailGroupedFolderSourceItem* self);
static void mail_grouped_folder_source_item_removed_account (MailGroupedFolderSourceItem* self,
                                                      MailBackendAccount* account);
VALA_EXTERN void mail_source_list_item_set_badge (MailSourceListItem* self,
                                      const gchar* value);
VALA_EXTERN MailBackendSession* mail_grouped_folder_source_item_get_session (MailGroupedFolderSourceItem* self);
VALA_EXTERN ESource* mail_backend_session_ref_source (MailBackendSession* self,
                                          const gchar* source_uid);
VALA_EXTERN CamelFolderInfoFlags mail_grouped_folder_source_item_get_folder_type (MailGroupedFolderSourceItem* self);
VALA_EXTERN gchar* mail_utils_strip_folder_full_name (const gchar* service_uid,
                                          const gchar* folder_uri);
static void mail_grouped_folder_source_item_set_session (MailGroupedFolderSourceItem* self,
                                                  MailBackendSession* value);
static void mail_grouped_folder_source_item_set_folder_type (MailGroupedFolderSourceItem* self,
                                                      CamelFolderInfoFlags value);
static GObject * mail_grouped_folder_source_item_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties);
VALA_EXTERN void mail_source_list_item_set_visible (MailSourceListItem* self,
                                        gboolean value);
VALA_EXTERN void mail_source_list_item_set_name (MailSourceListItem* self,
                                     const gchar* value);
VALA_EXTERN void mail_source_list_item_set_icon (MailSourceListItem* self,
                                     GIcon* value);
VALA_EXTERN const gchar* mail_source_list_item_get_name (MailSourceListItem* self);
VALA_EXTERN GeeLinkedList* mail_backend_session_get_accounts (MailBackendSession* self);
static gboolean _mail_grouped_folder_source_item___lambda12_ (MailGroupedFolderSourceItem* self,
                                                       MailBackendAccount* account);
static gboolean __mail_grouped_folder_source_item___lambda12__gee_forall_func (gpointer g,
                                                                        gpointer self);
static void _mail_grouped_folder_source_item_add_account_mail_backend_session_account_added (MailBackendSession* _sender,
                                                                                      MailBackendAccount* account,
                                                                                      gpointer self);
static void _mail_grouped_folder_source_item_removed_account_mail_backend_session_account_removed (MailBackendSession* _sender,
                                                                                            MailBackendAccount* account,
                                                                                            gpointer self);
static void mail_grouped_folder_source_item_finalize (GObject * obj);
static GType mail_grouped_folder_source_item_get_type_once (void);
static void _vala_mail_grouped_folder_source_item_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_mail_grouped_folder_source_item_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);

static inline gpointer
mail_grouped_folder_source_item_get_instance_private (MailGroupedFolderSourceItem* self)
{
	return G_STRUCT_MEMBER_P (self, MailGroupedFolderSourceItem_private_offset);
}

MailGroupedFolderSourceItem*
mail_grouped_folder_source_item_construct (GType object_type,
                                           MailBackendSession* session,
                                           CamelFolderInfoFlags folder_type)
{
	MailGroupedFolderSourceItem * self = NULL;
	g_return_val_if_fail (session != NULL, NULL);
	self = (MailGroupedFolderSourceItem*) g_object_new (object_type, "session", session, "folder-type", folder_type, NULL);
	return self;
}

MailGroupedFolderSourceItem*
mail_grouped_folder_source_item_new (MailBackendSession* session,
                                     CamelFolderInfoFlags folder_type)
{
	return mail_grouped_folder_source_item_construct (MAIL_TYPE_GROUPED_FOLDER_SOURCE_ITEM, session, folder_type);
}

static CamelFolderInfo*
_vala_CamelFolderInfo_copy (CamelFolderInfo* self)
{
	return g_boxed_copy (camel_folder_info_get_type (), self);
}

static void
_vala_CamelFolderInfo_free (CamelFolderInfo* self)
{
	g_boxed_free (camel_folder_info_get_type (), self);
}

GeeMap*
mail_grouped_folder_source_item_get_folder_info_per_account (MailGroupedFolderSourceItem* self)
{
	GeeHashMap* folder_info_per_account = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp22_;
	GeeMap* _tmp23_;
	GeeMap* _tmp24_;
	GError* _inner_error0_ = NULL;
	GeeMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_hash_map_new (MAIL_BACKEND_TYPE_ACCOUNT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, camel_folder_info_get_type (), (GBoxedCopyFunc) _vala_CamelFolderInfo_copy, (GDestroyNotify) _vala_CamelFolderInfo_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	folder_info_per_account = _tmp0_;
	{
		GeeHashMap* _tmp1_;
		_tmp1_ = self->priv->account_folderinfo;
		g_rec_mutex_lock (&self->priv->__lock_account_folderinfo);
		{
			{
				GeeIterator* _entry_it = NULL;
				GeeHashMap* _tmp2_;
				GeeIterator* _tmp3_;
				_tmp2_ = self->priv->account_folderinfo;
				_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
				_entry_it = _tmp3_;
				while (TRUE) {
					GeeIterator* _tmp4_;
					GeeMapEntry* entry = NULL;
					GeeIterator* _tmp5_;
					gpointer _tmp6_;
					GeeMapEntry* _tmp7_;
					gconstpointer _tmp8_;
					gconstpointer _tmp9_;
					_tmp4_ = _entry_it;
					if (!gee_iterator_next (_tmp4_)) {
						break;
					}
					_tmp5_ = _entry_it;
					_tmp6_ = gee_iterator_get (_tmp5_);
					entry = (GeeMapEntry*) _tmp6_;
					_tmp7_ = entry;
					_tmp8_ = gee_map_entry_get_value (_tmp7_);
					_tmp9_ = _tmp8_;
					if (((CamelFolderInfo*) _tmp9_) != NULL) {
						GeeHashMap* _tmp10_;
						GeeMapEntry* _tmp11_;
						gconstpointer _tmp12_;
						gconstpointer _tmp13_;
						GeeMapEntry* _tmp14_;
						gconstpointer _tmp15_;
						gconstpointer _tmp16_;
						_tmp10_ = folder_info_per_account;
						_tmp11_ = entry;
						_tmp12_ = gee_map_entry_get_key (_tmp11_);
						_tmp13_ = _tmp12_;
						_tmp14_ = entry;
						_tmp15_ = gee_map_entry_get_value (_tmp14_);
						_tmp16_ = _tmp15_;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, (MailBackendAccount*) _tmp13_, (CamelFolderInfo*) _tmp16_);
					} else {
						GeeHashMap* _tmp17_;
						GeeMapEntry* _tmp18_;
						gconstpointer _tmp19_;
						gconstpointer _tmp20_;
						_tmp17_ = folder_info_per_account;
						_tmp18_ = entry;
						_tmp19_ = gee_map_entry_get_key (_tmp18_);
						_tmp20_ = _tmp19_;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, (MailBackendAccount*) _tmp20_, NULL);
					}
					_g_object_unref0 (entry);
				}
				_g_object_unref0 (_entry_it);
			}
		}
		__finally0:
		{
			GeeHashMap* _tmp21_;
			_tmp21_ = self->priv->account_folderinfo;
			g_rec_mutex_unlock (&self->priv->__lock_account_folderinfo);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (folder_info_per_account);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp22_ = folder_info_per_account;
	_tmp23_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp22_);
	_tmp24_ = _tmp23_;
	result = _tmp24_;
	_g_object_unref0 (folder_info_per_account);
	return result;
}

static void
mail_grouped_folder_source_item_add_account (MailGroupedFolderSourceItem* self,
                                             MailBackendAccount* account)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account != NULL);
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->account_folderinfo;
		g_rec_mutex_lock (&self->priv->__lock_account_folderinfo);
		{
			GeeHashMap* _tmp1_;
			_tmp1_ = self->priv->account_folderinfo;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, account, NULL);
		}
		__finally0:
		{
			GeeHashMap* _tmp2_;
			_tmp2_ = self->priv->account_folderinfo;
			g_rec_mutex_unlock (&self->priv->__lock_account_folderinfo);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	mail_grouped_folder_source_item_load_folder_info (self, account, NULL, NULL);
}

static void
mail_grouped_folder_source_item_load_folder_info_data_free (gpointer _data)
{
	MailGroupedFolderSourceItemLoadFolderInfoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailGroupedFolderSourceItemLoadFolderInfoData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
mail_grouped_folder_source_item_load_folder_info (MailGroupedFolderSourceItem* self,
                                                  MailBackendAccount* account,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	MailGroupedFolderSourceItemLoadFolderInfoData* _data_;
	MailGroupedFolderSourceItem* _tmp0_;
	MailBackendAccount* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account != NULL);
	_data_ = g_slice_new0 (MailGroupedFolderSourceItemLoadFolderInfoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_grouped_folder_source_item_load_folder_info_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (account);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	mail_grouped_folder_source_item_load_folder_info_co (_data_);
}

static void
mail_grouped_folder_source_item_load_folder_info_finish (MailGroupedFolderSourceItem* self,
                                                         GAsyncResult* _res_)
{
	MailGroupedFolderSourceItemLoadFolderInfoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_grouped_folder_source_item_load_folder_info_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	MailGroupedFolderSourceItemLoadFolderInfoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_grouped_folder_source_item_load_folder_info_co (_data_);
}

static gboolean
mail_grouped_folder_source_item_load_folder_info_co (MailGroupedFolderSourceItemLoadFolderInfoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = mail_backend_account_get_service (_data_->account);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, camel_offline_store_get_type (), CamelOfflineStore));
	_data_->offlinestore = _data_->_tmp2_;
	_data_->_tmp3_ = mail_grouped_folder_source_item_build_folder_full_name (_data_->self, _data_->account);
	_data_->full_name = _data_->_tmp3_;
	_data_->folderinfo = NULL;
	_data_->_tmp4_ = _data_->full_name;
	if (_data_->_tmp4_ != NULL) {
		{
			_data_->_tmp6_ = _data_->offlinestore;
			_data_->_tmp7_ = _data_->full_name;
			_data_->_tmp8_ = _data_->self->priv->connect_cancellable;
			_data_->_state_ = 1;
			camel_store_get_folder_info ((CamelStore*) _data_->_tmp6_, _data_->_tmp7_, 0, G_PRIORITY_DEFAULT, _data_->_tmp8_, mail_grouped_folder_source_item_load_folder_info_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp9_ = camel_store_get_folder_info_finish ((CamelStore*) _data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp5_ = _data_->_tmp9_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp10_ = _data_->_tmp5_;
			_data_->_tmp5_ = NULL;
			__vala_CamelFolderInfo_free0 (_data_->folderinfo);
			_data_->folderinfo = _data_->_tmp10_;
			__vala_CamelFolderInfo_free0 (_data_->_tmp5_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp11_ = _data_->e;
			if (!g_error_matches (_data_->_tmp11_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				_data_->_tmp12_ = _data_->full_name;
				_data_->_tmp13_ = mail_backend_account_get_service (_data_->account);
				_data_->_tmp14_ = _data_->_tmp13_;
				_data_->_tmp15_ = camel_service_get_display_name (_data_->_tmp14_);
				_data_->_tmp16_ = _data_->_tmp15_;
				_data_->_tmp17_ = _data_->e;
				_data_->_tmp18_ = _data_->_tmp17_->message;
				g_warning ("GroupedFolderSourceItem.vala:102: Unable to fetch %s of account '%s': " \
"%s", _data_->_tmp12_, _data_->_tmp16_, _data_->_tmp18_);
			}
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			__vala_CamelFolderInfo_free0 (_data_->folderinfo);
			_g_free0 (_data_->full_name);
			_g_object_unref0 (_data_->offlinestore);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	{
		_data_->_tmp19_ = _data_->self->priv->account_folderinfo;
		g_rec_mutex_lock (&_data_->self->priv->__lock_account_folderinfo);
		{
			_data_->_tmp20_ = _data_->self->priv->account_folderinfo;
			_data_->_tmp21_ = _data_->folderinfo;
			gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp20_, _data_->account, _data_->_tmp21_);
		}
		__finally1:
		{
			_data_->_tmp22_ = _data_->self->priv->account_folderinfo;
			g_rec_mutex_unlock (&_data_->self->priv->__lock_account_folderinfo);
		}
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			__vala_CamelFolderInfo_free0 (_data_->folderinfo);
			_g_free0 (_data_->full_name);
			_g_object_unref0 (_data_->offlinestore);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	mail_grouped_folder_source_item_update_infos (_data_->self);
	__vala_CamelFolderInfo_free0 (_data_->folderinfo);
	_g_free0 (_data_->full_name);
	_g_object_unref0 (_data_->offlinestore);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_grouped_folder_source_item_removed_account (MailGroupedFolderSourceItem* self,
                                                 MailBackendAccount* account)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account != NULL);
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->account_folderinfo;
		g_rec_mutex_lock (&self->priv->__lock_account_folderinfo);
		{
			GeeHashMap* _tmp1_;
			_tmp1_ = self->priv->account_folderinfo;
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp1_, account, NULL);
		}
		__finally0:
		{
			GeeHashMap* _tmp2_;
			_tmp2_ = self->priv->account_folderinfo;
			g_rec_mutex_unlock (&self->priv->__lock_account_folderinfo);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
mail_grouped_folder_source_item_update_infos (MailGroupedFolderSourceItem* self)
{
	gint total_unread = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	mail_source_list_item_set_badge ((MailSourceListItem*) self, NULL);
	total_unread = 0;
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->account_folderinfo;
		g_rec_mutex_lock (&self->priv->__lock_account_folderinfo);
		{
			{
				GeeIterator* _entry_it = NULL;
				GeeHashMap* _tmp1_;
				GeeIterator* _tmp2_;
				_tmp1_ = self->priv->account_folderinfo;
				_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
				_entry_it = _tmp2_;
				while (TRUE) {
					GeeIterator* _tmp3_;
					GeeMapEntry* entry = NULL;
					GeeIterator* _tmp4_;
					gpointer _tmp5_;
					GeeMapEntry* _tmp6_;
					gconstpointer _tmp7_;
					gconstpointer _tmp8_;
					GeeMapEntry* _tmp9_;
					gconstpointer _tmp10_;
					gconstpointer _tmp11_;
					_tmp3_ = _entry_it;
					if (!gee_iterator_next (_tmp3_)) {
						break;
					}
					_tmp4_ = _entry_it;
					_tmp5_ = gee_iterator_get (_tmp4_);
					entry = (GeeMapEntry*) _tmp5_;
					_tmp6_ = entry;
					_tmp7_ = gee_map_entry_get_value (_tmp6_);
					_tmp8_ = _tmp7_;
					if (((CamelFolderInfo*) _tmp8_) == NULL) {
						_g_object_unref0 (entry);
						continue;
					}
					_tmp9_ = entry;
					_tmp10_ = gee_map_entry_get_value (_tmp9_);
					_tmp11_ = _tmp10_;
					total_unread += (gint) ((CamelFolderInfo*) _tmp11_)->unread;
					_g_object_unref0 (entry);
				}
				_g_object_unref0 (_entry_it);
			}
		}
		__finally0:
		{
			GeeHashMap* _tmp12_;
			_tmp12_ = self->priv->account_folderinfo;
			g_rec_mutex_unlock (&self->priv->__lock_account_folderinfo);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (total_unread > 0) {
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = g_strdup_printf ("%d", total_unread);
		_tmp14_ = _tmp13_;
		mail_source_list_item_set_badge ((MailSourceListItem*) self, _tmp14_);
		_g_free0 (_tmp14_);
	}
}

static gchar*
mail_grouped_folder_source_item_build_folder_full_name (MailGroupedFolderSourceItem* self,
                                                        MailBackendAccount* account)
{
	ESource* service_source = NULL;
	MailBackendSession* _tmp0_;
	CamelService* _tmp1_;
	CamelService* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ESource* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ESource* _tmp7_;
	ESourceMailAccount* mail_account_extension = NULL;
	ESource* _tmp9_;
	ESourceExtension* _tmp10_;
	ESourceMailAccount* _tmp11_;
	CamelFolderInfoFlags _tmp12_;
	CamelFolderInfoFlags _tmp18_;
	gchar* identity_uid = NULL;
	ESourceMailAccount* _tmp28_;
	gchar* _tmp29_;
	ESource* identity_source = NULL;
	MailBackendSession* _tmp30_;
	const gchar* _tmp31_;
	ESource* _tmp32_;
	gboolean _tmp33_ = FALSE;
	CamelFolderInfoFlags _tmp34_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (account != NULL, NULL);
	_tmp0_ = self->priv->_session;
	_tmp1_ = mail_backend_account_get_service (account);
	_tmp2_ = _tmp1_;
	_tmp3_ = camel_service_get_uid (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = mail_backend_session_ref_source (_tmp0_, _tmp4_);
	service_source = _tmp5_;
	_tmp7_ = service_source;
	if (_tmp7_ == NULL) {
		_tmp6_ = TRUE;
	} else {
		ESource* _tmp8_;
		_tmp8_ = service_source;
		_tmp6_ = !e_source_has_extension (_tmp8_, E_SOURCE_EXTENSION_MAIL_ACCOUNT);
	}
	if (_tmp6_) {
		result = NULL;
		_g_object_unref0 (service_source);
		return result;
	}
	_tmp9_ = service_source;
	_tmp10_ = e_source_get_extension (_tmp9_, E_SOURCE_EXTENSION_MAIL_ACCOUNT);
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, e_source_mail_account_get_type (), ESourceMailAccount));
	mail_account_extension = _tmp11_;
	_tmp12_ = self->priv->_folder_type;
	if (CAMEL_FOLDER_TYPE_INBOX == (_tmp12_ & CAMEL_FOLDER_TYPE_MASK)) {
		ESourceMailAccount* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp17_;
		_tmp13_ = mail_account_extension;
		_tmp14_ = e_source_backend_get_backend_name ((ESourceBackend*) _tmp13_);
		_tmp15_ = _tmp14_;
		if (g_ascii_strcasecmp ("ews", _tmp15_) == 0) {
			gchar* _tmp16_;
			_tmp16_ = g_strdup ("Inbox");
			result = _tmp16_;
			_g_object_unref0 (mail_account_extension);
			_g_object_unref0 (service_source);
			return result;
		}
		_tmp17_ = g_strdup ("INBOX");
		result = _tmp17_;
		_g_object_unref0 (mail_account_extension);
		_g_object_unref0 (service_source);
		return result;
	}
	_tmp18_ = self->priv->_folder_type;
	if (CAMEL_FOLDER_TYPE_ARCHIVE == (_tmp18_ & CAMEL_FOLDER_TYPE_MASK)) {
		CamelService* _tmp19_;
		CamelService* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		ESourceMailAccount* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp19_ = mail_backend_account_get_service (account);
		_tmp20_ = _tmp19_;
		_tmp21_ = camel_service_get_uid (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = mail_account_extension;
		_tmp24_ = e_source_mail_account_dup_archive_folder (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = mail_utils_strip_folder_full_name (_tmp22_, _tmp25_);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp25_);
		result = _tmp27_;
		_g_object_unref0 (mail_account_extension);
		_g_object_unref0 (service_source);
		return result;
	}
	_tmp28_ = mail_account_extension;
	_tmp29_ = e_source_mail_account_dup_identity_uid (_tmp28_);
	identity_uid = _tmp29_;
	_tmp30_ = self->priv->_session;
	_tmp31_ = identity_uid;
	_tmp32_ = mail_backend_session_ref_source (_tmp30_, _tmp31_);
	identity_source = _tmp32_;
	_tmp34_ = self->priv->_folder_type;
	if (CAMEL_FOLDER_TYPE_SENT == (_tmp34_ & CAMEL_FOLDER_TYPE_MASK)) {
		ESource* _tmp35_;
		_tmp35_ = identity_source;
		_tmp33_ = e_source_has_extension (_tmp35_, E_SOURCE_EXTENSION_MAIL_SUBMISSION);
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		ESourceMailSubmission* mail_submission_extension = NULL;
		ESource* _tmp36_;
		ESourceExtension* _tmp37_;
		CamelService* _tmp38_;
		CamelService* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		ESourceMailSubmission* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		gchar* _tmp45_;
		_tmp36_ = identity_source;
		_tmp37_ = e_source_get_extension (_tmp36_, E_SOURCE_EXTENSION_MAIL_SUBMISSION);
		mail_submission_extension = G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, e_source_mail_submission_get_type (), ESourceMailSubmission);
		_tmp38_ = mail_backend_account_get_service (account);
		_tmp39_ = _tmp38_;
		_tmp40_ = camel_service_get_uid (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = mail_submission_extension;
		_tmp43_ = e_source_mail_submission_get_sent_folder (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = mail_utils_strip_folder_full_name (_tmp41_, _tmp44_);
		result = _tmp45_;
		_g_object_unref0 (identity_source);
		_g_free0 (identity_uid);
		_g_object_unref0 (mail_account_extension);
		_g_object_unref0 (service_source);
		return result;
	}
	result = NULL;
	_g_object_unref0 (identity_source);
	_g_free0 (identity_uid);
	_g_object_unref0 (mail_account_extension);
	_g_object_unref0 (service_source);
	return result;
}

MailBackendSession*
mail_grouped_folder_source_item_get_session (MailGroupedFolderSourceItem* self)
{
	MailBackendSession* result;
	MailBackendSession* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_session;
	result = _tmp0_;
	return result;
}

static void
mail_grouped_folder_source_item_set_session (MailGroupedFolderSourceItem* self,
                                             MailBackendSession* value)
{
	MailBackendSession* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_grouped_folder_source_item_get_session (self);
	if (old_value != value) {
		MailBackendSession* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_session);
		self->priv->_session = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_grouped_folder_source_item_properties[MAIL_GROUPED_FOLDER_SOURCE_ITEM_SESSION_PROPERTY]);
	}
}

CamelFolderInfoFlags
mail_grouped_folder_source_item_get_folder_type (MailGroupedFolderSourceItem* self)
{
	CamelFolderInfoFlags result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_folder_type;
	return result;
}

static void
mail_grouped_folder_source_item_set_folder_type (MailGroupedFolderSourceItem* self,
                                                 CamelFolderInfoFlags value)
{
	CamelFolderInfoFlags old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_grouped_folder_source_item_get_folder_type (self);
	if (old_value != value) {
		self->priv->_folder_type = value;
		g_object_notify_by_pspec ((GObject *) self, mail_grouped_folder_source_item_properties[MAIL_GROUPED_FOLDER_SOURCE_ITEM_FOLDER_TYPE_PROPERTY]);
	}
}

static gboolean
_mail_grouped_folder_source_item___lambda12_ (MailGroupedFolderSourceItem* self,
                                              MailBackendAccount* account)
{
	gboolean result;
	g_return_val_if_fail (account != NULL, FALSE);
	mail_grouped_folder_source_item_add_account (self, account);
	result = TRUE;
	_g_object_unref0 (account);
	return result;
}

static gboolean
__mail_grouped_folder_source_item___lambda12__gee_forall_func (gpointer g,
                                                               gpointer self)
{
	gboolean result;
	result = _mail_grouped_folder_source_item___lambda12_ ((MailGroupedFolderSourceItem*) self, (MailBackendAccount*) g);
	return result;
}

static void
_mail_grouped_folder_source_item_add_account_mail_backend_session_account_added (MailBackendSession* _sender,
                                                                                 MailBackendAccount* account,
                                                                                 gpointer self)
{
	mail_grouped_folder_source_item_add_account ((MailGroupedFolderSourceItem*) self, account);
}

static void
_mail_grouped_folder_source_item_removed_account_mail_backend_session_account_removed (MailBackendSession* _sender,
                                                                                       MailBackendAccount* account,
                                                                                       gpointer self)
{
	mail_grouped_folder_source_item_removed_account ((MailGroupedFolderSourceItem*) self, account);
}

static GObject *
mail_grouped_folder_source_item_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MailGroupedFolderSourceItem * self;
	GCancellable* _tmp0_;
	GeeHashMap* _tmp1_;
	CamelFolderInfoFlags _tmp2_;
	MailBackendSession* _tmp16_;
	GeeLinkedList* _tmp17_;
	GeeLinkedList* _tmp18_;
	MailBackendSession* _tmp19_;
	MailBackendSession* _tmp20_;
	parent_class = G_OBJECT_CLASS (mail_grouped_folder_source_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_GROUPED_FOLDER_SOURCE_ITEM, MailGroupedFolderSourceItem);
	mail_source_list_item_set_visible ((MailSourceListItem*) self, TRUE);
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->connect_cancellable);
	self->priv->connect_cancellable = _tmp0_;
	_tmp1_ = gee_hash_map_new (MAIL_BACKEND_TYPE_ACCOUNT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, camel_folder_info_get_type (), (GBoxedCopyFunc) _vala_CamelFolderInfo_copy, (GDestroyNotify) _vala_CamelFolderInfo_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->account_folderinfo);
	self->priv->account_folderinfo = _tmp1_;
	_tmp2_ = self->priv->_folder_type;
	switch (_tmp2_ & CAMEL_FOLDER_TYPE_MASK) {
		case CAMEL_FOLDER_TYPE_INBOX:
		{
			GThemedIcon* _tmp3_;
			GThemedIcon* _tmp4_;
			mail_source_list_item_set_name ((MailSourceListItem*) self, C_ ("Inbox Folder", "Inbox"));
			_tmp3_ = (GThemedIcon*) g_themed_icon_new ("mail-inbox");
			_tmp4_ = _tmp3_;
			mail_source_list_item_set_icon ((MailSourceListItem*) self, (GIcon*) _tmp4_);
			_g_object_unref0 (_tmp4_);
			break;
		}
		case CAMEL_FOLDER_TYPE_ARCHIVE:
		{
			GThemedIcon* _tmp5_;
			GThemedIcon* _tmp6_;
			mail_source_list_item_set_name ((MailSourceListItem*) self, C_ ("Archive Folder", "Archive"));
			_tmp5_ = (GThemedIcon*) g_themed_icon_new ("mail-archive");
			_tmp6_ = _tmp5_;
			mail_source_list_item_set_icon ((MailSourceListItem*) self, (GIcon*) _tmp6_);
			_g_object_unref0 (_tmp6_);
			break;
		}
		case CAMEL_FOLDER_TYPE_SENT:
		{
			GThemedIcon* _tmp7_;
			GThemedIcon* _tmp8_;
			mail_source_list_item_set_name ((MailSourceListItem*) self, C_ ("Sent Folder", "Sent"));
			_tmp7_ = (GThemedIcon*) g_themed_icon_new ("mail-sent");
			_tmp8_ = _tmp7_;
			mail_source_list_item_set_icon ((MailSourceListItem*) self, (GIcon*) _tmp8_);
			_g_object_unref0 (_tmp8_);
			break;
		}
		default:
		{
			CamelFolderInfoFlags _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			GThemedIcon* _tmp12_;
			GThemedIcon* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp9_ = self->priv->_folder_type;
			_tmp10_ = g_strdup_printf ("%i", (gint) (_tmp9_ & CAMEL_FOLDER_TYPE_MASK));
			_tmp11_ = _tmp10_;
			mail_source_list_item_set_name ((MailSourceListItem*) self, _tmp11_);
			_g_free0 (_tmp11_);
			_tmp12_ = (GThemedIcon*) g_themed_icon_new ("folder");
			_tmp13_ = _tmp12_;
			mail_source_list_item_set_icon ((MailSourceListItem*) self, (GIcon*) _tmp13_);
			_g_object_unref0 (_tmp13_);
			_tmp14_ = mail_source_list_item_get_name ((MailSourceListItem*) self);
			_tmp15_ = _tmp14_;
			g_warning ("GroupedFolderSourceItem.vala:52: Unknown grouped folder type: %s", _tmp15_);
			break;
		}
	}
	_tmp16_ = self->priv->_session;
	_tmp17_ = mail_backend_session_get_accounts (_tmp16_);
	_tmp18_ = _tmp17_;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp18_, __mail_grouped_folder_source_item___lambda12__gee_forall_func, self);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = self->priv->_session;
	g_signal_connect_object (_tmp19_, "account-added", (GCallback) _mail_grouped_folder_source_item_add_account_mail_backend_session_account_added, self, 0);
	_tmp20_ = self->priv->_session;
	g_signal_connect_object (_tmp20_, "account-removed", (GCallback) _mail_grouped_folder_source_item_removed_account_mail_backend_session_account_removed, self, 0);
	return obj;
}

static void
mail_grouped_folder_source_item_class_init (MailGroupedFolderSourceItemClass * klass,
                                            gpointer klass_data)
{
	mail_grouped_folder_source_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailGroupedFolderSourceItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_mail_grouped_folder_source_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mail_grouped_folder_source_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = mail_grouped_folder_source_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = mail_grouped_folder_source_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_GROUPED_FOLDER_SOURCE_ITEM_SESSION_PROPERTY, mail_grouped_folder_source_item_properties[MAIL_GROUPED_FOLDER_SOURCE_ITEM_SESSION_PROPERTY] = g_param_spec_object ("session", "session", "session", MAIL_BACKEND_TYPE_SESSION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_GROUPED_FOLDER_SOURCE_ITEM_FOLDER_TYPE_PROPERTY, mail_grouped_folder_source_item_properties[MAIL_GROUPED_FOLDER_SOURCE_ITEM_FOLDER_TYPE_PROPERTY] = g_param_spec_flags ("folder-type", "folder-type", "folder-type", camel_folder_info_flags_get_type (), 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
mail_grouped_folder_source_item_instance_init (MailGroupedFolderSourceItem * self,
                                               gpointer klass)
{
	self->priv = mail_grouped_folder_source_item_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_account_folderinfo);
}

static void
mail_grouped_folder_source_item_finalize (GObject * obj)
{
	MailGroupedFolderSourceItem * self;
	GCancellable* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_GROUPED_FOLDER_SOURCE_ITEM, MailGroupedFolderSourceItem);
	_tmp0_ = self->priv->connect_cancellable;
	g_cancellable_cancel (_tmp0_);
	_g_object_unref0 (self->priv->_session);
	_g_object_unref0 (self->priv->connect_cancellable);
	g_rec_mutex_clear (&self->priv->__lock_account_folderinfo);
	_g_object_unref0 (self->priv->account_folderinfo);
	G_OBJECT_CLASS (mail_grouped_folder_source_item_parent_class)->finalize (obj);
}

static GType
mail_grouped_folder_source_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailGroupedFolderSourceItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_grouped_folder_source_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailGroupedFolderSourceItem), 0, (GInstanceInitFunc) mail_grouped_folder_source_item_instance_init, NULL };
	GType mail_grouped_folder_source_item_type_id;
	mail_grouped_folder_source_item_type_id = g_type_register_static (MAIL_SOURCE_LIST_TYPE_ITEM, "MailGroupedFolderSourceItem", &g_define_type_info, 0);
	MailGroupedFolderSourceItem_private_offset = g_type_add_instance_private (mail_grouped_folder_source_item_type_id, sizeof (MailGroupedFolderSourceItemPrivate));
	return mail_grouped_folder_source_item_type_id;
}

GType
mail_grouped_folder_source_item_get_type (void)
{
	static volatile gsize mail_grouped_folder_source_item_type_id__once = 0;
	if (g_once_init_enter (&mail_grouped_folder_source_item_type_id__once)) {
		GType mail_grouped_folder_source_item_type_id;
		mail_grouped_folder_source_item_type_id = mail_grouped_folder_source_item_get_type_once ();
		g_once_init_leave (&mail_grouped_folder_source_item_type_id__once, mail_grouped_folder_source_item_type_id);
	}
	return mail_grouped_folder_source_item_type_id__once;
}

static void
_vala_mail_grouped_folder_source_item_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	MailGroupedFolderSourceItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_GROUPED_FOLDER_SOURCE_ITEM, MailGroupedFolderSourceItem);
	switch (property_id) {
		case MAIL_GROUPED_FOLDER_SOURCE_ITEM_SESSION_PROPERTY:
		g_value_set_object (value, mail_grouped_folder_source_item_get_session (self));
		break;
		case MAIL_GROUPED_FOLDER_SOURCE_ITEM_FOLDER_TYPE_PROPERTY:
		g_value_set_flags (value, mail_grouped_folder_source_item_get_folder_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mail_grouped_folder_source_item_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	MailGroupedFolderSourceItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_GROUPED_FOLDER_SOURCE_ITEM, MailGroupedFolderSourceItem);
	switch (property_id) {
		case MAIL_GROUPED_FOLDER_SOURCE_ITEM_SESSION_PROPERTY:
		mail_grouped_folder_source_item_set_session (self, g_value_get_object (value));
		break;
		case MAIL_GROUPED_FOLDER_SOURCE_ITEM_FOLDER_TYPE_PROPERTY:
		mail_grouped_folder_source_item_set_folder_type (self, g_value_get_flags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

