use crate::app::App;
use crate::gobject_models::GEnclosure;
use crate::i18n::i18n;
use glib::{Object, Properties, subclass::prelude::*, subclass::*};
use gtk4::{CompositeTemplate, Widget, prelude::*, subclass::prelude::*};
use libadwaita::{Bin, subclass::prelude::*};
use std::cell::RefCell;

mod imp {
    use super::*;

    #[derive(Debug, Default, CompositeTemplate, Properties)]
    #[properties(wrapper_type = super::LinkPreview)]
    #[template(file = "data/resources/ui_templates/enclosures/link.blp")]
    pub struct LinkPreview {
        #[property(get, set, construct_only)]
        pub author: RefCell<String>,

        #[property(get, set, construct_only)]
        pub title: RefCell<String>,

        #[property(get, set, construct_only)]
        pub url: RefCell<String>,
    }

    #[glib::object_subclass]
    impl ObjectSubclass for LinkPreview {
        const NAME: &'static str = "LinkPreview";
        type Type = super::LinkPreview;
        type ParentType = Bin;

        fn class_init(klass: &mut Self::Class) {
            klass.bind_template();
            klass.bind_template_callbacks();
            klass.set_css_name("link_preview");
        }

        fn instance_init(obj: &InitializingObject<Self>) {
            obj.init_template();
        }
    }

    #[glib::derived_properties]
    impl ObjectImpl for LinkPreview {}

    impl WidgetImpl for LinkPreview {}

    impl BinImpl for LinkPreview {}

    #[gtk4::template_callbacks]
    impl LinkPreview {
        #[template_callback]
        fn on_click(&self) {
            App::open_url_in_default_browser(self.url.borrow().as_str());
        }
    }
}

glib::wrapper! {
    pub struct LinkPreview(ObjectSubclass<imp::LinkPreview>)
        @extends Widget, Bin;
}

impl From<&GEnclosure> for LinkPreview {
    fn from(value: &GEnclosure) -> Self {
        let author = value
            .author()
            .unwrap_or_else(|| value.feed_title().unwrap_or_else(|| i18n("Unkown Author")));
        let title = value
            .title()
            .unwrap_or_else(|| value.article_title().unwrap_or_else(|| i18n("Unknown Enclosure")));
        let url = value.url();

        Object::builder()
            .property("author", author)
            .property("title", title)
            .property("url", &url)
            .property("tooltip-text", &url)
            .build()
    }
}
