/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "meta-dbus-login1.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_VOID__STRING_STRING (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringStringFunc)
       (void *data1,
        const gchar *arg_session_id,
        const gchar *arg_object_path,
        void *data2);
  _GDbusCodegenMarshalVoid_StringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_VOID__UINT_STRING (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_UintStringFunc)
       (void *data1,
        guint arg_uid,
        const gchar *arg_object_path,
        void *data2);
  _GDbusCodegenMarshalVoid_UintStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_UintStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_uint (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_VOID__BOOLEAN_VARIANT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_BooleanVariantFunc)
       (void *data1,
        gboolean arg_start,
        GVariant *arg_metadata,
        void *data2);
  _GDbusCodegenMarshalVoid_BooleanVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_BooleanVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_boolean (param_values + 1),
            g_marshal_value_peek_variant (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_session_id,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_pid,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_UINT_STRING_STRING_STRING_STRING_STRING_UINT_STRING_STRING_BOOLEAN_STRING_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintUintStringStringStringStringStringUintStringStringBooleanStringStringVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_uid,
        guint arg_pid,
        const gchar *arg_service,
        const gchar *arg_type,
        const gchar *arg_class,
        const gchar *arg_desktop,
        const gchar *arg_seat_id,
        guint arg_vtnr,
        const gchar *arg_tty,
        const gchar *arg_display,
        gboolean arg_remote,
        const gchar *arg_remote_user,
        const gchar *arg_remote_host,
        GVariant *arg_properties,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintUintStringStringStringStringStringUintStringStringBooleanStringStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 16);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintUintStringStringStringStringStringUintStringStringBooleanStringStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              g_marshal_value_peek_uint (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              g_marshal_value_peek_string (param_values + 5),
              g_marshal_value_peek_string (param_values + 6),
              g_marshal_value_peek_string (param_values + 7),
              g_marshal_value_peek_string (param_values + 8),
              g_marshal_value_peek_uint (param_values + 9),
              g_marshal_value_peek_string (param_values + 10),
              g_marshal_value_peek_string (param_values + 11),
              g_marshal_value_peek_boolean (param_values + 12),
              g_marshal_value_peek_string (param_values + 13),
              g_marshal_value_peek_string (param_values + 14),
              g_marshal_value_peek_variant (param_values + 15),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_VARIANT_STRING_STRING_STRING_STRING_STRING_UINT_STRING_STRING_BOOLEAN_STRING_STRING_UINT64_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintVariantStringStringStringStringStringUintStringStringBooleanStringStringUint64VariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_uid,
        GVariant *arg_pidfd,
        const gchar *arg_service,
        const gchar *arg_type,
        const gchar *arg_class,
        const gchar *arg_desktop,
        const gchar *arg_seat_id,
        guint arg_vtnr,
        const gchar *arg_tty,
        const gchar *arg_display,
        gboolean arg_remote,
        const gchar *arg_remote_user,
        const gchar *arg_remote_host,
        guint64 arg_flags,
        GVariant *arg_properties,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintVariantStringStringStringStringStringUintStringStringBooleanStringStringUint64VariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 17);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintVariantStringStringStringStringStringUintStringStringBooleanStringStringUint64VariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              g_marshal_value_peek_variant (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              g_marshal_value_peek_string (param_values + 5),
              g_marshal_value_peek_string (param_values + 6),
              g_marshal_value_peek_string (param_values + 7),
              g_marshal_value_peek_string (param_values + 8),
              g_marshal_value_peek_uint (param_values + 9),
              g_marshal_value_peek_string (param_values + 10),
              g_marshal_value_peek_string (param_values + 11),
              g_marshal_value_peek_boolean (param_values + 12),
              g_marshal_value_peek_string (param_values + 13),
              g_marshal_value_peek_string (param_values + 14),
              g_marshal_value_peek_uint64 (param_values + 15),
              g_marshal_value_peek_variant (param_values + 16),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_session_id,
        const gchar *arg_seat_id,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringIntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_session_id,
        const gchar *arg_who,
        gint arg_signal_number,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_int (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintIntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_uid,
        gint arg_signal_number,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              g_marshal_value_peek_int (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_BOOLEAN_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintBooleanBooleanFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_uid,
        gboolean arg_enable,
        gboolean arg_interactive,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintBooleanBooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintBooleanBooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              g_marshal_value_peek_boolean (param_values + 3),
              g_marshal_value_peek_boolean (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringBooleanFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_seat_id,
        const gchar *arg_sysfs_path,
        gboolean arg_interactive,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringBooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringBooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_boolean (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBooleanFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gboolean arg_interactive,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boolean (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT64 (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUint64Func)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint64 arg_flags,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUint64Func callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUint64Func)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint64 (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_UINT64 (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringUint64Func)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_type,
        guint64 arg_usec,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringUint64Func callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringUint64Func)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_uint64 (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_what,
        const gchar *arg_who,
        const gchar *arg_why,
        const gchar *arg_mode,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              g_marshal_value_peek_string (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringBooleanFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_wall_message,
        gboolean arg_enable,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringBooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringBooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_boolean (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_VOID__UINT_UINT_STRING (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_UintUintStringFunc)
       (void *data1,
        guint arg_major,
        guint arg_minor,
        const gchar *arg_type,
        void *data2);
  _GDbusCodegenMarshalVoid_UintUintStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_UintUintStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_uint (param_values + 1),
            g_marshal_value_peek_uint (param_values + 2),
            g_marshal_value_peek_string (param_values + 3),
            data2);
}

static void
_g_dbus_codegen_marshal_VOID__UINT_UINT_VARIANT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_UintUintVariantFunc)
       (void *data1,
        guint arg_major,
        guint arg_minor,
        GVariant *arg_fd,
        void *data2);
  _GDbusCodegenMarshalVoid_UintUintVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_UintUintVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_uint (param_values + 1),
            g_marshal_value_peek_uint (param_values + 2),
            g_marshal_value_peek_variant (param_values + 3),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringIntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_who,
        gint arg_signal_number,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_int (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_tty_fd,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_UINT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectObjectUintUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GUnixFDList *arg_fd_list,
        guint arg_major,
        guint arg_minor,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectObjectUintUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectObjectUintUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_object (param_values + 2),
              g_marshal_value_peek_uint (param_values + 3),
              g_marshal_value_peek_uint (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_major,
        guint arg_minor,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              g_marshal_value_peek_uint (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_subsystem,
        const gchar *arg_name,
        guint arg_brightness,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_uint (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.login1.Manager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MetaDBusLogin1Manager
 * @title: MetaDBusLogin1Manager
 * @short_description: Generated C code for the org.freedesktop.login1.Manager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-login1-Manager.top_of_page">org.freedesktop.login1.Manager</link> D-Bus interface in C.
 */

enum
{
  META_DBUS__LOGIN1_MANAGER_SESSION_NEW,
  META_DBUS__LOGIN1_MANAGER_SESSION_REMOVED,
  META_DBUS__LOGIN1_MANAGER_USER_NEW,
  META_DBUS__LOGIN1_MANAGER_USER_REMOVED,
  META_DBUS__LOGIN1_MANAGER_SEAT_NEW,
  META_DBUS__LOGIN1_MANAGER_SEAT_REMOVED,
  META_DBUS__LOGIN1_MANAGER_PREPARE_FOR_SHUTDOWN,
  META_DBUS__LOGIN1_MANAGER_PREPARE_FOR_SHUTDOWN_WITH_METADATA,
  META_DBUS__LOGIN1_MANAGER_PREPARE_FOR_SLEEP,
};

static unsigned META_DBUS__LOGIN1_MANAGER_SIGNALS[9] = { 0 };

/* ---- Introspection data for org.freedesktop.login1.Manager ---- */

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_get_session_IN_ARG_session_id =
{
  {
    -1,
    (gchar *) "session_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_get_session_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_get_session_IN_ARG_session_id.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_get_session_OUT_ARG_object_path =
{
  {
    -1,
    (gchar *) "object_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_get_session_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_get_session_OUT_ARG_object_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_get_session =
{
  {
    -1,
    (gchar *) "GetSession",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_get_session_IN_ARG_pointers,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_get_session_OUT_ARG_pointers,
    NULL
  },
  "handle-get-session",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_get_session_by_pid_IN_ARG_pid =
{
  {
    -1,
    (gchar *) "pid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_get_session_by_pid_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_get_session_by_pid_IN_ARG_pid.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_get_session_by_pid_OUT_ARG_object_path =
{
  {
    -1,
    (gchar *) "object_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_get_session_by_pid_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_get_session_by_pid_OUT_ARG_object_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_get_session_by_pid =
{
  {
    -1,
    (gchar *) "GetSessionByPID",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_get_session_by_pid_IN_ARG_pointers,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_get_session_by_pid_OUT_ARG_pointers,
    NULL
  },
  "handle-get-session-by-pid",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_get_user_IN_ARG_uid =
{
  {
    -1,
    (gchar *) "uid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_get_user_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_get_user_IN_ARG_uid.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_get_user_OUT_ARG_object_path =
{
  {
    -1,
    (gchar *) "object_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_get_user_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_get_user_OUT_ARG_object_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_get_user =
{
  {
    -1,
    (gchar *) "GetUser",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_get_user_IN_ARG_pointers,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_get_user_OUT_ARG_pointers,
    NULL
  },
  "handle-get-user",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_get_user_by_pid_IN_ARG_pid =
{
  {
    -1,
    (gchar *) "pid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_get_user_by_pid_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_get_user_by_pid_IN_ARG_pid.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_get_user_by_pid_OUT_ARG_object_path =
{
  {
    -1,
    (gchar *) "object_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_get_user_by_pid_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_get_user_by_pid_OUT_ARG_object_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_get_user_by_pid =
{
  {
    -1,
    (gchar *) "GetUserByPID",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_get_user_by_pid_IN_ARG_pointers,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_get_user_by_pid_OUT_ARG_pointers,
    NULL
  },
  "handle-get-user-by-pid",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_get_seat_IN_ARG_seat_id =
{
  {
    -1,
    (gchar *) "seat_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_get_seat_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_get_seat_IN_ARG_seat_id.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_get_seat_OUT_ARG_object_path =
{
  {
    -1,
    (gchar *) "object_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_get_seat_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_get_seat_OUT_ARG_object_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_get_seat =
{
  {
    -1,
    (gchar *) "GetSeat",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_get_seat_IN_ARG_pointers,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_get_seat_OUT_ARG_pointers,
    NULL
  },
  "handle-get-seat",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_list_sessions_OUT_ARG_sessions =
{
  {
    -1,
    (gchar *) "sessions",
    (gchar *) "a(susso)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_list_sessions_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_list_sessions_OUT_ARG_sessions.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_list_sessions =
{
  {
    -1,
    (gchar *) "ListSessions",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_list_sessions_OUT_ARG_pointers,
    NULL
  },
  "handle-list-sessions",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_list_sessions_ex_OUT_ARG_sessions =
{
  {
    -1,
    (gchar *) "sessions",
    (gchar *) "a(sussussbto)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_list_sessions_ex_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_list_sessions_ex_OUT_ARG_sessions.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_list_sessions_ex =
{
  {
    -1,
    (gchar *) "ListSessionsEx",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_list_sessions_ex_OUT_ARG_pointers,
    NULL
  },
  "handle-list-sessions-ex",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_list_users_OUT_ARG_users =
{
  {
    -1,
    (gchar *) "users",
    (gchar *) "a(uso)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_list_users_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_list_users_OUT_ARG_users.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_list_users =
{
  {
    -1,
    (gchar *) "ListUsers",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_list_users_OUT_ARG_pointers,
    NULL
  },
  "handle-list-users",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_list_seats_OUT_ARG_seats =
{
  {
    -1,
    (gchar *) "seats",
    (gchar *) "a(so)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_list_seats_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_list_seats_OUT_ARG_seats.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_list_seats =
{
  {
    -1,
    (gchar *) "ListSeats",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_list_seats_OUT_ARG_pointers,
    NULL
  },
  "handle-list-seats",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_list_inhibitors_OUT_ARG_inhibitors =
{
  {
    -1,
    (gchar *) "inhibitors",
    (gchar *) "a(ssssuu)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_list_inhibitors_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_list_inhibitors_OUT_ARG_inhibitors.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_list_inhibitors =
{
  {
    -1,
    (gchar *) "ListInhibitors",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_list_inhibitors_OUT_ARG_pointers,
    NULL
  },
  "handle-list-inhibitors",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_IN_ARG_uid =
{
  {
    -1,
    (gchar *) "uid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_IN_ARG_pid =
{
  {
    -1,
    (gchar *) "pid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_IN_ARG_service =
{
  {
    -1,
    (gchar *) "service",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_IN_ARG_class =
{
  {
    -1,
    (gchar *) "class",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_IN_ARG_desktop =
{
  {
    -1,
    (gchar *) "desktop",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_IN_ARG_seat_id =
{
  {
    -1,
    (gchar *) "seat_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_IN_ARG_vtnr =
{
  {
    -1,
    (gchar *) "vtnr",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_IN_ARG_tty =
{
  {
    -1,
    (gchar *) "tty",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_IN_ARG_display =
{
  {
    -1,
    (gchar *) "display",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_IN_ARG_remote =
{
  {
    -1,
    (gchar *) "remote",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_IN_ARG_remote_user =
{
  {
    -1,
    (gchar *) "remote_user",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_IN_ARG_remote_host =
{
  {
    -1,
    (gchar *) "remote_host",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a(sv)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_create_session_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_create_session_IN_ARG_uid.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_IN_ARG_pid.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_IN_ARG_service.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_IN_ARG_type.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_IN_ARG_class.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_IN_ARG_desktop.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_IN_ARG_seat_id.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_IN_ARG_vtnr.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_IN_ARG_tty.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_IN_ARG_display.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_IN_ARG_remote.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_IN_ARG_remote_user.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_IN_ARG_remote_host.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_OUT_ARG_session_id =
{
  {
    -1,
    (gchar *) "session_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_OUT_ARG_object_path =
{
  {
    -1,
    (gchar *) "object_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_OUT_ARG_runtime_path =
{
  {
    -1,
    (gchar *) "runtime_path",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_OUT_ARG_fifo_fd =
{
  {
    -1,
    (gchar *) "fifo_fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_OUT_ARG_uid =
{
  {
    -1,
    (gchar *) "uid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_OUT_ARG_seat_id =
{
  {
    -1,
    (gchar *) "seat_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_OUT_ARG_vtnr =
{
  {
    -1,
    (gchar *) "vtnr",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_OUT_ARG_existing =
{
  {
    -1,
    (gchar *) "existing",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_create_session_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_create_session_OUT_ARG_session_id.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_OUT_ARG_object_path.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_OUT_ARG_runtime_path.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_OUT_ARG_fifo_fd.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_OUT_ARG_uid.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_OUT_ARG_seat_id.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_OUT_ARG_vtnr.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_OUT_ARG_existing.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_method_create_session_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.systemd1.Privileged",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_method_create_session_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_method_create_session_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_create_session =
{
  {
    -1,
    (gchar *) "CreateSession",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_create_session_IN_ARG_pointers,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_create_session_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_method_create_session_annotation_info_pointers
  },
  "handle-create-session",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_uid =
{
  {
    -1,
    (gchar *) "uid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_pidfd =
{
  {
    -1,
    (gchar *) "pidfd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_service =
{
  {
    -1,
    (gchar *) "service",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_class =
{
  {
    -1,
    (gchar *) "class",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_desktop =
{
  {
    -1,
    (gchar *) "desktop",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_seat_id =
{
  {
    -1,
    (gchar *) "seat_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_vtnr =
{
  {
    -1,
    (gchar *) "vtnr",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_tty =
{
  {
    -1,
    (gchar *) "tty",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_display =
{
  {
    -1,
    (gchar *) "display",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_remote =
{
  {
    -1,
    (gchar *) "remote",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_remote_user =
{
  {
    -1,
    (gchar *) "remote_user",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_remote_host =
{
  {
    -1,
    (gchar *) "remote_host",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a(sv)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_uid.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_pidfd.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_service.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_type.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_class.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_desktop.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_seat_id.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_vtnr.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_tty.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_display.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_remote.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_remote_user.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_remote_host.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_flags.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_OUT_ARG_session_id =
{
  {
    -1,
    (gchar *) "session_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_OUT_ARG_object_path =
{
  {
    -1,
    (gchar *) "object_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_OUT_ARG_runtime_path =
{
  {
    -1,
    (gchar *) "runtime_path",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_OUT_ARG_fifo_fd =
{
  {
    -1,
    (gchar *) "fifo_fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_OUT_ARG_uid =
{
  {
    -1,
    (gchar *) "uid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_OUT_ARG_seat_id =
{
  {
    -1,
    (gchar *) "seat_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_OUT_ARG_vtnr =
{
  {
    -1,
    (gchar *) "vtnr",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd_OUT_ARG_existing =
{
  {
    -1,
    (gchar *) "existing",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_create_session_with_pidfd_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_OUT_ARG_session_id.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_OUT_ARG_object_path.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_OUT_ARG_runtime_path.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_OUT_ARG_fifo_fd.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_OUT_ARG_uid.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_OUT_ARG_seat_id.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_OUT_ARG_vtnr.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_OUT_ARG_existing.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_method_create_session_with_pidfd_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.systemd1.Privileged",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_method_create_session_with_pidfd_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_method_create_session_with_pidfd_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_create_session_with_pidfd =
{
  {
    -1,
    (gchar *) "CreateSessionWithPIDFD",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_IN_ARG_pointers,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_create_session_with_pidfd_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_method_create_session_with_pidfd_annotation_info_pointers
  },
  "handle-create-session-with-pidfd",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_release_session_IN_ARG_session_id =
{
  {
    -1,
    (gchar *) "session_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_release_session_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_release_session_IN_ARG_session_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_release_session =
{
  {
    -1,
    (gchar *) "ReleaseSession",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_release_session_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-release-session",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_activate_session_IN_ARG_session_id =
{
  {
    -1,
    (gchar *) "session_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_activate_session_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_activate_session_IN_ARG_session_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_activate_session =
{
  {
    -1,
    (gchar *) "ActivateSession",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_activate_session_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-activate-session",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_activate_session_on_seat_IN_ARG_session_id =
{
  {
    -1,
    (gchar *) "session_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_activate_session_on_seat_IN_ARG_seat_id =
{
  {
    -1,
    (gchar *) "seat_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_activate_session_on_seat_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_activate_session_on_seat_IN_ARG_session_id.parent_struct,
  &_meta_dbus_login1_manager_method_info_activate_session_on_seat_IN_ARG_seat_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_activate_session_on_seat =
{
  {
    -1,
    (gchar *) "ActivateSessionOnSeat",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_activate_session_on_seat_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-activate-session-on-seat",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_lock_session_IN_ARG_session_id =
{
  {
    -1,
    (gchar *) "session_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_lock_session_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_lock_session_IN_ARG_session_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_lock_session =
{
  {
    -1,
    (gchar *) "LockSession",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_lock_session_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-lock-session",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_unlock_session_IN_ARG_session_id =
{
  {
    -1,
    (gchar *) "session_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_unlock_session_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_unlock_session_IN_ARG_session_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_unlock_session =
{
  {
    -1,
    (gchar *) "UnlockSession",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_unlock_session_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-unlock-session",
  FALSE
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_lock_sessions =
{
  {
    -1,
    (gchar *) "LockSessions",
    NULL,
    NULL,
    NULL
  },
  "handle-lock-sessions",
  FALSE
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_unlock_sessions =
{
  {
    -1,
    (gchar *) "UnlockSessions",
    NULL,
    NULL,
    NULL
  },
  "handle-unlock-sessions",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_kill_session_IN_ARG_session_id =
{
  {
    -1,
    (gchar *) "session_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_kill_session_IN_ARG_who =
{
  {
    -1,
    (gchar *) "who",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_kill_session_IN_ARG_signal_number =
{
  {
    -1,
    (gchar *) "signal_number",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_kill_session_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_kill_session_IN_ARG_session_id.parent_struct,
  &_meta_dbus_login1_manager_method_info_kill_session_IN_ARG_who.parent_struct,
  &_meta_dbus_login1_manager_method_info_kill_session_IN_ARG_signal_number.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_kill_session =
{
  {
    -1,
    (gchar *) "KillSession",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_kill_session_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-kill-session",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_kill_user_IN_ARG_uid =
{
  {
    -1,
    (gchar *) "uid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_kill_user_IN_ARG_signal_number =
{
  {
    -1,
    (gchar *) "signal_number",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_kill_user_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_kill_user_IN_ARG_uid.parent_struct,
  &_meta_dbus_login1_manager_method_info_kill_user_IN_ARG_signal_number.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_kill_user =
{
  {
    -1,
    (gchar *) "KillUser",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_kill_user_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-kill-user",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_terminate_session_IN_ARG_session_id =
{
  {
    -1,
    (gchar *) "session_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_terminate_session_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_terminate_session_IN_ARG_session_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_terminate_session =
{
  {
    -1,
    (gchar *) "TerminateSession",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_terminate_session_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-terminate-session",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_terminate_user_IN_ARG_uid =
{
  {
    -1,
    (gchar *) "uid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_terminate_user_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_terminate_user_IN_ARG_uid.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_terminate_user =
{
  {
    -1,
    (gchar *) "TerminateUser",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_terminate_user_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-terminate-user",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_terminate_seat_IN_ARG_seat_id =
{
  {
    -1,
    (gchar *) "seat_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_terminate_seat_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_terminate_seat_IN_ARG_seat_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_terminate_seat =
{
  {
    -1,
    (gchar *) "TerminateSeat",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_terminate_seat_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-terminate-seat",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_set_user_linger_IN_ARG_uid =
{
  {
    -1,
    (gchar *) "uid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_set_user_linger_IN_ARG_enable =
{
  {
    -1,
    (gchar *) "enable",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_set_user_linger_IN_ARG_interactive =
{
  {
    -1,
    (gchar *) "interactive",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_set_user_linger_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_set_user_linger_IN_ARG_uid.parent_struct,
  &_meta_dbus_login1_manager_method_info_set_user_linger_IN_ARG_enable.parent_struct,
  &_meta_dbus_login1_manager_method_info_set_user_linger_IN_ARG_interactive.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_set_user_linger =
{
  {
    -1,
    (gchar *) "SetUserLinger",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_set_user_linger_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-user-linger",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_attach_device_IN_ARG_seat_id =
{
  {
    -1,
    (gchar *) "seat_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_attach_device_IN_ARG_sysfs_path =
{
  {
    -1,
    (gchar *) "sysfs_path",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_attach_device_IN_ARG_interactive =
{
  {
    -1,
    (gchar *) "interactive",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_attach_device_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_attach_device_IN_ARG_seat_id.parent_struct,
  &_meta_dbus_login1_manager_method_info_attach_device_IN_ARG_sysfs_path.parent_struct,
  &_meta_dbus_login1_manager_method_info_attach_device_IN_ARG_interactive.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_attach_device =
{
  {
    -1,
    (gchar *) "AttachDevice",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_attach_device_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-attach-device",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_flush_devices_IN_ARG_interactive =
{
  {
    -1,
    (gchar *) "interactive",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_flush_devices_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_flush_devices_IN_ARG_interactive.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_flush_devices =
{
  {
    -1,
    (gchar *) "FlushDevices",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_flush_devices_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-flush-devices",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_power_off_IN_ARG_interactive =
{
  {
    -1,
    (gchar *) "interactive",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_power_off_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_power_off_IN_ARG_interactive.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_power_off =
{
  {
    -1,
    (gchar *) "PowerOff",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_power_off_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-power-off",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_power_off_with_flags_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_power_off_with_flags_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_power_off_with_flags_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_power_off_with_flags =
{
  {
    -1,
    (gchar *) "PowerOffWithFlags",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_power_off_with_flags_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-power-off-with-flags",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_reboot_IN_ARG_interactive =
{
  {
    -1,
    (gchar *) "interactive",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_reboot_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_reboot_IN_ARG_interactive.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_reboot =
{
  {
    -1,
    (gchar *) "Reboot",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_reboot_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-reboot",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_reboot_with_flags_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_reboot_with_flags_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_reboot_with_flags_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_reboot_with_flags =
{
  {
    -1,
    (gchar *) "RebootWithFlags",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_reboot_with_flags_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-reboot-with-flags",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_halt_IN_ARG_interactive =
{
  {
    -1,
    (gchar *) "interactive",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_halt_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_halt_IN_ARG_interactive.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_halt =
{
  {
    -1,
    (gchar *) "Halt",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_halt_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-halt",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_halt_with_flags_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_halt_with_flags_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_halt_with_flags_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_halt_with_flags =
{
  {
    -1,
    (gchar *) "HaltWithFlags",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_halt_with_flags_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-halt-with-flags",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_suspend_IN_ARG_interactive =
{
  {
    -1,
    (gchar *) "interactive",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_suspend_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_suspend_IN_ARG_interactive.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_suspend =
{
  {
    -1,
    (gchar *) "Suspend",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_suspend_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-suspend",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_suspend_with_flags_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_suspend_with_flags_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_suspend_with_flags_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_suspend_with_flags =
{
  {
    -1,
    (gchar *) "SuspendWithFlags",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_suspend_with_flags_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-suspend-with-flags",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_hibernate_IN_ARG_interactive =
{
  {
    -1,
    (gchar *) "interactive",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_hibernate_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_hibernate_IN_ARG_interactive.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_hibernate =
{
  {
    -1,
    (gchar *) "Hibernate",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_hibernate_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-hibernate",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_hibernate_with_flags_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_hibernate_with_flags_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_hibernate_with_flags_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_hibernate_with_flags =
{
  {
    -1,
    (gchar *) "HibernateWithFlags",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_hibernate_with_flags_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-hibernate-with-flags",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_hybrid_sleep_IN_ARG_interactive =
{
  {
    -1,
    (gchar *) "interactive",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_hybrid_sleep_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_hybrid_sleep_IN_ARG_interactive.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_hybrid_sleep =
{
  {
    -1,
    (gchar *) "HybridSleep",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_hybrid_sleep_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-hybrid-sleep",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_hybrid_sleep_with_flags_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_hybrid_sleep_with_flags_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_hybrid_sleep_with_flags_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_hybrid_sleep_with_flags =
{
  {
    -1,
    (gchar *) "HybridSleepWithFlags",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_hybrid_sleep_with_flags_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-hybrid-sleep-with-flags",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_suspend_then_hibernate_IN_ARG_interactive =
{
  {
    -1,
    (gchar *) "interactive",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_suspend_then_hibernate_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_suspend_then_hibernate_IN_ARG_interactive.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_suspend_then_hibernate =
{
  {
    -1,
    (gchar *) "SuspendThenHibernate",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_suspend_then_hibernate_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-suspend-then-hibernate",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_suspend_then_hibernate_with_flags_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_suspend_then_hibernate_with_flags_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_suspend_then_hibernate_with_flags_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_suspend_then_hibernate_with_flags =
{
  {
    -1,
    (gchar *) "SuspendThenHibernateWithFlags",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_suspend_then_hibernate_with_flags_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-suspend-then-hibernate-with-flags",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_sleep_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_sleep_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_sleep_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_sleep =
{
  {
    -1,
    (gchar *) "Sleep",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_sleep_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-sleep",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_can_power_off_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_can_power_off_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_can_power_off_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_can_power_off =
{
  {
    -1,
    (gchar *) "CanPowerOff",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_can_power_off_OUT_ARG_pointers,
    NULL
  },
  "handle-can-power-off",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_can_reboot_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_can_reboot_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_can_reboot_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_can_reboot =
{
  {
    -1,
    (gchar *) "CanReboot",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_can_reboot_OUT_ARG_pointers,
    NULL
  },
  "handle-can-reboot",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_can_halt_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_can_halt_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_can_halt_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_can_halt =
{
  {
    -1,
    (gchar *) "CanHalt",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_can_halt_OUT_ARG_pointers,
    NULL
  },
  "handle-can-halt",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_can_suspend_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_can_suspend_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_can_suspend_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_can_suspend =
{
  {
    -1,
    (gchar *) "CanSuspend",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_can_suspend_OUT_ARG_pointers,
    NULL
  },
  "handle-can-suspend",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_can_hibernate_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_can_hibernate_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_can_hibernate_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_can_hibernate =
{
  {
    -1,
    (gchar *) "CanHibernate",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_can_hibernate_OUT_ARG_pointers,
    NULL
  },
  "handle-can-hibernate",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_can_hybrid_sleep_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_can_hybrid_sleep_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_can_hybrid_sleep_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_can_hybrid_sleep =
{
  {
    -1,
    (gchar *) "CanHybridSleep",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_can_hybrid_sleep_OUT_ARG_pointers,
    NULL
  },
  "handle-can-hybrid-sleep",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_can_suspend_then_hibernate_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_can_suspend_then_hibernate_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_can_suspend_then_hibernate_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_can_suspend_then_hibernate =
{
  {
    -1,
    (gchar *) "CanSuspendThenHibernate",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_can_suspend_then_hibernate_OUT_ARG_pointers,
    NULL
  },
  "handle-can-suspend-then-hibernate",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_can_sleep_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_can_sleep_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_can_sleep_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_can_sleep =
{
  {
    -1,
    (gchar *) "CanSleep",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_can_sleep_OUT_ARG_pointers,
    NULL
  },
  "handle-can-sleep",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_schedule_shutdown_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_schedule_shutdown_IN_ARG_usec =
{
  {
    -1,
    (gchar *) "usec",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_schedule_shutdown_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_schedule_shutdown_IN_ARG_type.parent_struct,
  &_meta_dbus_login1_manager_method_info_schedule_shutdown_IN_ARG_usec.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_schedule_shutdown =
{
  {
    -1,
    (gchar *) "ScheduleShutdown",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_schedule_shutdown_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-schedule-shutdown",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_cancel_scheduled_shutdown_OUT_ARG_cancelled =
{
  {
    -1,
    (gchar *) "cancelled",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_cancel_scheduled_shutdown_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_cancel_scheduled_shutdown_OUT_ARG_cancelled.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_cancel_scheduled_shutdown =
{
  {
    -1,
    (gchar *) "CancelScheduledShutdown",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_cancel_scheduled_shutdown_OUT_ARG_pointers,
    NULL
  },
  "handle-cancel-scheduled-shutdown",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_inhibit_IN_ARG_what =
{
  {
    -1,
    (gchar *) "what",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_inhibit_IN_ARG_who =
{
  {
    -1,
    (gchar *) "who",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_inhibit_IN_ARG_why =
{
  {
    -1,
    (gchar *) "why",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_inhibit_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_inhibit_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_inhibit_IN_ARG_what.parent_struct,
  &_meta_dbus_login1_manager_method_info_inhibit_IN_ARG_who.parent_struct,
  &_meta_dbus_login1_manager_method_info_inhibit_IN_ARG_why.parent_struct,
  &_meta_dbus_login1_manager_method_info_inhibit_IN_ARG_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_inhibit_OUT_ARG_pipe_fd =
{
  {
    -1,
    (gchar *) "pipe_fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_inhibit_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_inhibit_OUT_ARG_pipe_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_inhibit =
{
  {
    -1,
    (gchar *) "Inhibit",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_inhibit_IN_ARG_pointers,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_inhibit_OUT_ARG_pointers,
    NULL
  },
  "handle-inhibit",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_can_reboot_parameter_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_can_reboot_parameter_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_can_reboot_parameter_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_can_reboot_parameter =
{
  {
    -1,
    (gchar *) "CanRebootParameter",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_can_reboot_parameter_OUT_ARG_pointers,
    NULL
  },
  "handle-can-reboot-parameter",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_set_reboot_parameter_IN_ARG_parameter =
{
  {
    -1,
    (gchar *) "parameter",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_set_reboot_parameter_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_set_reboot_parameter_IN_ARG_parameter.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_set_reboot_parameter =
{
  {
    -1,
    (gchar *) "SetRebootParameter",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_set_reboot_parameter_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-reboot-parameter",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_can_reboot_to_firmware_setup_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_can_reboot_to_firmware_setup_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_can_reboot_to_firmware_setup_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_can_reboot_to_firmware_setup =
{
  {
    -1,
    (gchar *) "CanRebootToFirmwareSetup",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_can_reboot_to_firmware_setup_OUT_ARG_pointers,
    NULL
  },
  "handle-can-reboot-to-firmware-setup",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_set_reboot_to_firmware_setup_IN_ARG_enable =
{
  {
    -1,
    (gchar *) "enable",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_set_reboot_to_firmware_setup_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_set_reboot_to_firmware_setup_IN_ARG_enable.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_set_reboot_to_firmware_setup =
{
  {
    -1,
    (gchar *) "SetRebootToFirmwareSetup",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_set_reboot_to_firmware_setup_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-reboot-to-firmware-setup",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_can_reboot_to_boot_loader_menu_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_can_reboot_to_boot_loader_menu_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_can_reboot_to_boot_loader_menu_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_can_reboot_to_boot_loader_menu =
{
  {
    -1,
    (gchar *) "CanRebootToBootLoaderMenu",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_can_reboot_to_boot_loader_menu_OUT_ARG_pointers,
    NULL
  },
  "handle-can-reboot-to-boot-loader-menu",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_set_reboot_to_boot_loader_menu_IN_ARG_timeout =
{
  {
    -1,
    (gchar *) "timeout",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_set_reboot_to_boot_loader_menu_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_set_reboot_to_boot_loader_menu_IN_ARG_timeout.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_set_reboot_to_boot_loader_menu =
{
  {
    -1,
    (gchar *) "SetRebootToBootLoaderMenu",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_set_reboot_to_boot_loader_menu_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-reboot-to-boot-loader-menu",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_can_reboot_to_boot_loader_entry_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_can_reboot_to_boot_loader_entry_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_can_reboot_to_boot_loader_entry_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_can_reboot_to_boot_loader_entry =
{
  {
    -1,
    (gchar *) "CanRebootToBootLoaderEntry",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_can_reboot_to_boot_loader_entry_OUT_ARG_pointers,
    NULL
  },
  "handle-can-reboot-to-boot-loader-entry",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_set_reboot_to_boot_loader_entry_IN_ARG_boot_loader_entry =
{
  {
    -1,
    (gchar *) "boot_loader_entry",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_set_reboot_to_boot_loader_entry_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_set_reboot_to_boot_loader_entry_IN_ARG_boot_loader_entry.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_set_reboot_to_boot_loader_entry =
{
  {
    -1,
    (gchar *) "SetRebootToBootLoaderEntry",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_set_reboot_to_boot_loader_entry_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-reboot-to-boot-loader-entry",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_set_wall_message_IN_ARG_wall_message =
{
  {
    -1,
    (gchar *) "wall_message",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_method_info_set_wall_message_IN_ARG_enable =
{
  {
    -1,
    (gchar *) "enable",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_method_info_set_wall_message_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_set_wall_message_IN_ARG_wall_message.parent_struct,
  &_meta_dbus_login1_manager_method_info_set_wall_message_IN_ARG_enable.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_manager_method_info_set_wall_message =
{
  {
    -1,
    (gchar *) "SetWallMessage",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_method_info_set_wall_message_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-wall-message",
  FALSE
};

static const GDBusMethodInfo * const _meta_dbus_login1_manager_method_info_pointers[] =
{
  &_meta_dbus_login1_manager_method_info_get_session.parent_struct,
  &_meta_dbus_login1_manager_method_info_get_session_by_pid.parent_struct,
  &_meta_dbus_login1_manager_method_info_get_user.parent_struct,
  &_meta_dbus_login1_manager_method_info_get_user_by_pid.parent_struct,
  &_meta_dbus_login1_manager_method_info_get_seat.parent_struct,
  &_meta_dbus_login1_manager_method_info_list_sessions.parent_struct,
  &_meta_dbus_login1_manager_method_info_list_sessions_ex.parent_struct,
  &_meta_dbus_login1_manager_method_info_list_users.parent_struct,
  &_meta_dbus_login1_manager_method_info_list_seats.parent_struct,
  &_meta_dbus_login1_manager_method_info_list_inhibitors.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session.parent_struct,
  &_meta_dbus_login1_manager_method_info_create_session_with_pidfd.parent_struct,
  &_meta_dbus_login1_manager_method_info_release_session.parent_struct,
  &_meta_dbus_login1_manager_method_info_activate_session.parent_struct,
  &_meta_dbus_login1_manager_method_info_activate_session_on_seat.parent_struct,
  &_meta_dbus_login1_manager_method_info_lock_session.parent_struct,
  &_meta_dbus_login1_manager_method_info_unlock_session.parent_struct,
  &_meta_dbus_login1_manager_method_info_lock_sessions.parent_struct,
  &_meta_dbus_login1_manager_method_info_unlock_sessions.parent_struct,
  &_meta_dbus_login1_manager_method_info_kill_session.parent_struct,
  &_meta_dbus_login1_manager_method_info_kill_user.parent_struct,
  &_meta_dbus_login1_manager_method_info_terminate_session.parent_struct,
  &_meta_dbus_login1_manager_method_info_terminate_user.parent_struct,
  &_meta_dbus_login1_manager_method_info_terminate_seat.parent_struct,
  &_meta_dbus_login1_manager_method_info_set_user_linger.parent_struct,
  &_meta_dbus_login1_manager_method_info_attach_device.parent_struct,
  &_meta_dbus_login1_manager_method_info_flush_devices.parent_struct,
  &_meta_dbus_login1_manager_method_info_power_off.parent_struct,
  &_meta_dbus_login1_manager_method_info_power_off_with_flags.parent_struct,
  &_meta_dbus_login1_manager_method_info_reboot.parent_struct,
  &_meta_dbus_login1_manager_method_info_reboot_with_flags.parent_struct,
  &_meta_dbus_login1_manager_method_info_halt.parent_struct,
  &_meta_dbus_login1_manager_method_info_halt_with_flags.parent_struct,
  &_meta_dbus_login1_manager_method_info_suspend.parent_struct,
  &_meta_dbus_login1_manager_method_info_suspend_with_flags.parent_struct,
  &_meta_dbus_login1_manager_method_info_hibernate.parent_struct,
  &_meta_dbus_login1_manager_method_info_hibernate_with_flags.parent_struct,
  &_meta_dbus_login1_manager_method_info_hybrid_sleep.parent_struct,
  &_meta_dbus_login1_manager_method_info_hybrid_sleep_with_flags.parent_struct,
  &_meta_dbus_login1_manager_method_info_suspend_then_hibernate.parent_struct,
  &_meta_dbus_login1_manager_method_info_suspend_then_hibernate_with_flags.parent_struct,
  &_meta_dbus_login1_manager_method_info_sleep.parent_struct,
  &_meta_dbus_login1_manager_method_info_can_power_off.parent_struct,
  &_meta_dbus_login1_manager_method_info_can_reboot.parent_struct,
  &_meta_dbus_login1_manager_method_info_can_halt.parent_struct,
  &_meta_dbus_login1_manager_method_info_can_suspend.parent_struct,
  &_meta_dbus_login1_manager_method_info_can_hibernate.parent_struct,
  &_meta_dbus_login1_manager_method_info_can_hybrid_sleep.parent_struct,
  &_meta_dbus_login1_manager_method_info_can_suspend_then_hibernate.parent_struct,
  &_meta_dbus_login1_manager_method_info_can_sleep.parent_struct,
  &_meta_dbus_login1_manager_method_info_schedule_shutdown.parent_struct,
  &_meta_dbus_login1_manager_method_info_cancel_scheduled_shutdown.parent_struct,
  &_meta_dbus_login1_manager_method_info_inhibit.parent_struct,
  &_meta_dbus_login1_manager_method_info_can_reboot_parameter.parent_struct,
  &_meta_dbus_login1_manager_method_info_set_reboot_parameter.parent_struct,
  &_meta_dbus_login1_manager_method_info_can_reboot_to_firmware_setup.parent_struct,
  &_meta_dbus_login1_manager_method_info_set_reboot_to_firmware_setup.parent_struct,
  &_meta_dbus_login1_manager_method_info_can_reboot_to_boot_loader_menu.parent_struct,
  &_meta_dbus_login1_manager_method_info_set_reboot_to_boot_loader_menu.parent_struct,
  &_meta_dbus_login1_manager_method_info_can_reboot_to_boot_loader_entry.parent_struct,
  &_meta_dbus_login1_manager_method_info_set_reboot_to_boot_loader_entry.parent_struct,
  &_meta_dbus_login1_manager_method_info_set_wall_message.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_signal_info_session_new_ARG_session_id =
{
  {
    -1,
    (gchar *) "session_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_signal_info_session_new_ARG_object_path =
{
  {
    -1,
    (gchar *) "object_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_signal_info_session_new_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_signal_info_session_new_ARG_session_id.parent_struct,
  &_meta_dbus_login1_manager_signal_info_session_new_ARG_object_path.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _meta_dbus_login1_manager_signal_info_session_new =
{
  {
    -1,
    (gchar *) "SessionNew",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_signal_info_session_new_ARG_pointers,
    NULL
  },
  "session-new"
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_signal_info_session_removed_ARG_session_id =
{
  {
    -1,
    (gchar *) "session_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_signal_info_session_removed_ARG_object_path =
{
  {
    -1,
    (gchar *) "object_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_signal_info_session_removed_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_signal_info_session_removed_ARG_session_id.parent_struct,
  &_meta_dbus_login1_manager_signal_info_session_removed_ARG_object_path.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _meta_dbus_login1_manager_signal_info_session_removed =
{
  {
    -1,
    (gchar *) "SessionRemoved",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_signal_info_session_removed_ARG_pointers,
    NULL
  },
  "session-removed"
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_signal_info_user_new_ARG_uid =
{
  {
    -1,
    (gchar *) "uid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_signal_info_user_new_ARG_object_path =
{
  {
    -1,
    (gchar *) "object_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_signal_info_user_new_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_signal_info_user_new_ARG_uid.parent_struct,
  &_meta_dbus_login1_manager_signal_info_user_new_ARG_object_path.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _meta_dbus_login1_manager_signal_info_user_new =
{
  {
    -1,
    (gchar *) "UserNew",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_signal_info_user_new_ARG_pointers,
    NULL
  },
  "user-new"
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_signal_info_user_removed_ARG_uid =
{
  {
    -1,
    (gchar *) "uid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_signal_info_user_removed_ARG_object_path =
{
  {
    -1,
    (gchar *) "object_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_signal_info_user_removed_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_signal_info_user_removed_ARG_uid.parent_struct,
  &_meta_dbus_login1_manager_signal_info_user_removed_ARG_object_path.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _meta_dbus_login1_manager_signal_info_user_removed =
{
  {
    -1,
    (gchar *) "UserRemoved",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_signal_info_user_removed_ARG_pointers,
    NULL
  },
  "user-removed"
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_signal_info_seat_new_ARG_seat_id =
{
  {
    -1,
    (gchar *) "seat_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_signal_info_seat_new_ARG_object_path =
{
  {
    -1,
    (gchar *) "object_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_signal_info_seat_new_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_signal_info_seat_new_ARG_seat_id.parent_struct,
  &_meta_dbus_login1_manager_signal_info_seat_new_ARG_object_path.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _meta_dbus_login1_manager_signal_info_seat_new =
{
  {
    -1,
    (gchar *) "SeatNew",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_signal_info_seat_new_ARG_pointers,
    NULL
  },
  "seat-new"
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_signal_info_seat_removed_ARG_seat_id =
{
  {
    -1,
    (gchar *) "seat_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_signal_info_seat_removed_ARG_object_path =
{
  {
    -1,
    (gchar *) "object_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_signal_info_seat_removed_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_signal_info_seat_removed_ARG_seat_id.parent_struct,
  &_meta_dbus_login1_manager_signal_info_seat_removed_ARG_object_path.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _meta_dbus_login1_manager_signal_info_seat_removed =
{
  {
    -1,
    (gchar *) "SeatRemoved",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_signal_info_seat_removed_ARG_pointers,
    NULL
  },
  "seat-removed"
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_signal_info_prepare_for_shutdown_ARG_start =
{
  {
    -1,
    (gchar *) "start",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_signal_info_prepare_for_shutdown_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_signal_info_prepare_for_shutdown_ARG_start.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _meta_dbus_login1_manager_signal_info_prepare_for_shutdown =
{
  {
    -1,
    (gchar *) "PrepareForShutdown",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_signal_info_prepare_for_shutdown_ARG_pointers,
    NULL
  },
  "prepare-for-shutdown"
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_signal_info_prepare_for_shutdown_with_metadata_ARG_start =
{
  {
    -1,
    (gchar *) "start",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_signal_info_prepare_for_shutdown_with_metadata_ARG_metadata =
{
  {
    -1,
    (gchar *) "metadata",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_signal_info_prepare_for_shutdown_with_metadata_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_signal_info_prepare_for_shutdown_with_metadata_ARG_start.parent_struct,
  &_meta_dbus_login1_manager_signal_info_prepare_for_shutdown_with_metadata_ARG_metadata.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _meta_dbus_login1_manager_signal_info_prepare_for_shutdown_with_metadata =
{
  {
    -1,
    (gchar *) "PrepareForShutdownWithMetadata",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_signal_info_prepare_for_shutdown_with_metadata_ARG_pointers,
    NULL
  },
  "prepare-for-shutdown-with-metadata"
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_manager_signal_info_prepare_for_sleep_ARG_start =
{
  {
    -1,
    (gchar *) "start",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_manager_signal_info_prepare_for_sleep_ARG_pointers[] =
{
  &_meta_dbus_login1_manager_signal_info_prepare_for_sleep_ARG_start.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _meta_dbus_login1_manager_signal_info_prepare_for_sleep =
{
  {
    -1,
    (gchar *) "PrepareForSleep",
    (GDBusArgInfo **) &_meta_dbus_login1_manager_signal_info_prepare_for_sleep_ARG_pointers,
    NULL
  },
  "prepare-for-sleep"
};

static const GDBusSignalInfo * const _meta_dbus_login1_manager_signal_info_pointers[] =
{
  &_meta_dbus_login1_manager_signal_info_session_new.parent_struct,
  &_meta_dbus_login1_manager_signal_info_session_removed.parent_struct,
  &_meta_dbus_login1_manager_signal_info_user_new.parent_struct,
  &_meta_dbus_login1_manager_signal_info_user_removed.parent_struct,
  &_meta_dbus_login1_manager_signal_info_seat_new.parent_struct,
  &_meta_dbus_login1_manager_signal_info_seat_removed.parent_struct,
  &_meta_dbus_login1_manager_signal_info_prepare_for_shutdown.parent_struct,
  &_meta_dbus_login1_manager_signal_info_prepare_for_shutdown_with_metadata.parent_struct,
  &_meta_dbus_login1_manager_signal_info_prepare_for_sleep.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_enable_wall_messages_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_enable_wall_messages_annotation_info_1 =
{
  -1,
  (gchar *) "org.freedesktop.systemd1.Privileged",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_enable_wall_messages_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_enable_wall_messages_annotation_info_0,
  &_meta_dbus_login1_manager_property_enable_wall_messages_annotation_info_1,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_enable_wall_messages =
{
  {
    -1,
    (gchar *) "EnableWallMessages",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_enable_wall_messages_annotation_info_pointers
  },
  "enable-wall-messages",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_wall_message_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_wall_message_annotation_info_1 =
{
  -1,
  (gchar *) "org.freedesktop.systemd1.Privileged",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_wall_message_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_wall_message_annotation_info_0,
  &_meta_dbus_login1_manager_property_wall_message_annotation_info_1,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_wall_message =
{
  {
    -1,
    (gchar *) "WallMessage",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_wall_message_annotation_info_pointers
  },
  "wall-message",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_nauto_vts_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_nauto_vts_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_nauto_vts_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_nauto_vts =
{
  {
    -1,
    (gchar *) "NAutoVTs",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_nauto_vts_annotation_info_pointers
  },
  "nauto-vts",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_kill_only_users_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_kill_only_users_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_kill_only_users_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_kill_only_users =
{
  {
    -1,
    (gchar *) "KillOnlyUsers",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_kill_only_users_annotation_info_pointers
  },
  "kill-only-users",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_kill_exclude_users_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_kill_exclude_users_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_kill_exclude_users_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_kill_exclude_users =
{
  {
    -1,
    (gchar *) "KillExcludeUsers",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_kill_exclude_users_annotation_info_pointers
  },
  "kill-exclude-users",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_kill_user_processes_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_kill_user_processes_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_kill_user_processes_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_kill_user_processes =
{
  {
    -1,
    (gchar *) "KillUserProcesses",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_kill_user_processes_annotation_info_pointers
  },
  "kill-user-processes",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_reboot_parameter_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_reboot_parameter_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_reboot_parameter_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_reboot_parameter =
{
  {
    -1,
    (gchar *) "RebootParameter",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_reboot_parameter_annotation_info_pointers
  },
  "reboot-parameter",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_reboot_to_firmware_setup_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_reboot_to_firmware_setup_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_reboot_to_firmware_setup_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_reboot_to_firmware_setup =
{
  {
    -1,
    (gchar *) "RebootToFirmwareSetup",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_reboot_to_firmware_setup_annotation_info_pointers
  },
  "reboot-to-firmware-setup",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_reboot_to_boot_loader_menu_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_reboot_to_boot_loader_menu_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_reboot_to_boot_loader_menu_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_reboot_to_boot_loader_menu =
{
  {
    -1,
    (gchar *) "RebootToBootLoaderMenu",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_reboot_to_boot_loader_menu_annotation_info_pointers
  },
  "reboot-to-boot-loader-menu",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_reboot_to_boot_loader_entry_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_reboot_to_boot_loader_entry_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_reboot_to_boot_loader_entry_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_reboot_to_boot_loader_entry =
{
  {
    -1,
    (gchar *) "RebootToBootLoaderEntry",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_reboot_to_boot_loader_entry_annotation_info_pointers
  },
  "reboot-to-boot-loader-entry",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_boot_loader_entries_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_boot_loader_entries_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_boot_loader_entries_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_boot_loader_entries =
{
  {
    -1,
    (gchar *) "BootLoaderEntries",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_boot_loader_entries_annotation_info_pointers
  },
  "boot-loader-entries",
  FALSE,
  FALSE
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_idle_hint =
{
  {
    -1,
    (gchar *) "IdleHint",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "idle-hint",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_idle_since_hint =
{
  {
    -1,
    (gchar *) "IdleSinceHint",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "idle-since-hint",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_idle_since_hint_monotonic =
{
  {
    -1,
    (gchar *) "IdleSinceHintMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "idle-since-hint-monotonic",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_block_inhibited =
{
  {
    -1,
    (gchar *) "BlockInhibited",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "block-inhibited",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_delay_inhibited =
{
  {
    -1,
    (gchar *) "DelayInhibited",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "delay-inhibited",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_inhibit_delay_max_usec_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_inhibit_delay_max_usec_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_inhibit_delay_max_usec_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_inhibit_delay_max_usec =
{
  {
    -1,
    (gchar *) "InhibitDelayMaxUSec",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_inhibit_delay_max_usec_annotation_info_pointers
  },
  "inhibit-delay-max-usec",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_user_stop_delay_usec_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_user_stop_delay_usec_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_user_stop_delay_usec_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_user_stop_delay_usec =
{
  {
    -1,
    (gchar *) "UserStopDelayUSec",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_user_stop_delay_usec_annotation_info_pointers
  },
  "user-stop-delay-usec",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_sleep_operation_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_sleep_operation_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_sleep_operation_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_sleep_operation =
{
  {
    -1,
    (gchar *) "SleepOperation",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_sleep_operation_annotation_info_pointers
  },
  "sleep-operation",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_handle_power_key_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_handle_power_key_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_handle_power_key_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_handle_power_key =
{
  {
    -1,
    (gchar *) "HandlePowerKey",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_handle_power_key_annotation_info_pointers
  },
  "handle-power-key",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_handle_power_key_long_press_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_handle_power_key_long_press_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_handle_power_key_long_press_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_handle_power_key_long_press =
{
  {
    -1,
    (gchar *) "HandlePowerKeyLongPress",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_handle_power_key_long_press_annotation_info_pointers
  },
  "handle-power-key-long-press",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_handle_reboot_key_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_handle_reboot_key_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_handle_reboot_key_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_handle_reboot_key =
{
  {
    -1,
    (gchar *) "HandleRebootKey",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_handle_reboot_key_annotation_info_pointers
  },
  "handle-reboot-key",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_handle_reboot_key_long_press_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_handle_reboot_key_long_press_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_handle_reboot_key_long_press_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_handle_reboot_key_long_press =
{
  {
    -1,
    (gchar *) "HandleRebootKeyLongPress",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_handle_reboot_key_long_press_annotation_info_pointers
  },
  "handle-reboot-key-long-press",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_handle_suspend_key_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_handle_suspend_key_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_handle_suspend_key_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_handle_suspend_key =
{
  {
    -1,
    (gchar *) "HandleSuspendKey",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_handle_suspend_key_annotation_info_pointers
  },
  "handle-suspend-key",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_handle_suspend_key_long_press_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_handle_suspend_key_long_press_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_handle_suspend_key_long_press_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_handle_suspend_key_long_press =
{
  {
    -1,
    (gchar *) "HandleSuspendKeyLongPress",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_handle_suspend_key_long_press_annotation_info_pointers
  },
  "handle-suspend-key-long-press",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_handle_hibernate_key_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_handle_hibernate_key_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_handle_hibernate_key_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_handle_hibernate_key =
{
  {
    -1,
    (gchar *) "HandleHibernateKey",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_handle_hibernate_key_annotation_info_pointers
  },
  "handle-hibernate-key",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_handle_hibernate_key_long_press_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_handle_hibernate_key_long_press_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_handle_hibernate_key_long_press_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_handle_hibernate_key_long_press =
{
  {
    -1,
    (gchar *) "HandleHibernateKeyLongPress",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_handle_hibernate_key_long_press_annotation_info_pointers
  },
  "handle-hibernate-key-long-press",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_handle_lid_switch_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_handle_lid_switch_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_handle_lid_switch_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_handle_lid_switch =
{
  {
    -1,
    (gchar *) "HandleLidSwitch",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_handle_lid_switch_annotation_info_pointers
  },
  "handle-lid-switch",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_handle_lid_switch_external_power_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_handle_lid_switch_external_power_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_handle_lid_switch_external_power_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_handle_lid_switch_external_power =
{
  {
    -1,
    (gchar *) "HandleLidSwitchExternalPower",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_handle_lid_switch_external_power_annotation_info_pointers
  },
  "handle-lid-switch-external-power",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_handle_lid_switch_docked_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_handle_lid_switch_docked_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_handle_lid_switch_docked_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_handle_lid_switch_docked =
{
  {
    -1,
    (gchar *) "HandleLidSwitchDocked",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_handle_lid_switch_docked_annotation_info_pointers
  },
  "handle-lid-switch-docked",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_holdoff_timeout_usec_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_holdoff_timeout_usec_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_holdoff_timeout_usec_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_holdoff_timeout_usec =
{
  {
    -1,
    (gchar *) "HoldoffTimeoutUSec",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_holdoff_timeout_usec_annotation_info_pointers
  },
  "holdoff-timeout-usec",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_idle_action_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_idle_action_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_idle_action_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_idle_action =
{
  {
    -1,
    (gchar *) "IdleAction",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_idle_action_annotation_info_pointers
  },
  "idle-action",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_idle_action_usec_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_idle_action_usec_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_idle_action_usec_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_idle_action_usec =
{
  {
    -1,
    (gchar *) "IdleActionUSec",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_idle_action_usec_annotation_info_pointers
  },
  "idle-action-usec",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_preparing_for_shutdown_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_preparing_for_shutdown_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_preparing_for_shutdown_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_preparing_for_shutdown =
{
  {
    -1,
    (gchar *) "PreparingForShutdown",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_preparing_for_shutdown_annotation_info_pointers
  },
  "preparing-for-shutdown",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_preparing_for_sleep_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_preparing_for_sleep_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_preparing_for_sleep_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_preparing_for_sleep =
{
  {
    -1,
    (gchar *) "PreparingForSleep",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_preparing_for_sleep_annotation_info_pointers
  },
  "preparing-for-sleep",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_scheduled_shutdown_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_scheduled_shutdown_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_scheduled_shutdown_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_scheduled_shutdown =
{
  {
    -1,
    (gchar *) "ScheduledShutdown",
    (gchar *) "(st)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_scheduled_shutdown_annotation_info_pointers
  },
  "scheduled-shutdown",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_docked_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_docked_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_docked_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_docked =
{
  {
    -1,
    (gchar *) "Docked",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_docked_annotation_info_pointers
  },
  "docked",
  FALSE,
  FALSE
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_lid_closed =
{
  {
    -1,
    (gchar *) "LidClosed",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "lid-closed",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_on_external_power_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_on_external_power_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_on_external_power_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_on_external_power =
{
  {
    -1,
    (gchar *) "OnExternalPower",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_on_external_power_annotation_info_pointers
  },
  "on-external-power",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_remove_ipc_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_remove_ipc_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_remove_ipc_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_remove_ipc =
{
  {
    -1,
    (gchar *) "RemoveIPC",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_remove_ipc_annotation_info_pointers
  },
  "remove-ipc",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_runtime_directory_size_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_runtime_directory_size_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_runtime_directory_size_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_runtime_directory_size =
{
  {
    -1,
    (gchar *) "RuntimeDirectorySize",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_runtime_directory_size_annotation_info_pointers
  },
  "runtime-directory-size",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_runtime_directory_inodes_max_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_runtime_directory_inodes_max_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_runtime_directory_inodes_max_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_runtime_directory_inodes_max =
{
  {
    -1,
    (gchar *) "RuntimeDirectoryInodesMax",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_runtime_directory_inodes_max_annotation_info_pointers
  },
  "runtime-directory-inodes-max",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_inhibitors_max_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_inhibitors_max_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_inhibitors_max_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_inhibitors_max =
{
  {
    -1,
    (gchar *) "InhibitorsMax",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_inhibitors_max_annotation_info_pointers
  },
  "inhibitors-max",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_ncurrent_inhibitors_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_ncurrent_inhibitors_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_ncurrent_inhibitors_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_ncurrent_inhibitors =
{
  {
    -1,
    (gchar *) "NCurrentInhibitors",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_ncurrent_inhibitors_annotation_info_pointers
  },
  "ncurrent-inhibitors",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_sessions_max_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_sessions_max_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_sessions_max_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_sessions_max =
{
  {
    -1,
    (gchar *) "SessionsMax",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_sessions_max_annotation_info_pointers
  },
  "sessions-max",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_ncurrent_sessions_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_ncurrent_sessions_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_ncurrent_sessions_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_ncurrent_sessions =
{
  {
    -1,
    (gchar *) "NCurrentSessions",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_ncurrent_sessions_annotation_info_pointers
  },
  "ncurrent-sessions",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_manager_property_stop_idle_session_usec_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_manager_property_stop_idle_session_usec_annotation_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_stop_idle_session_usec_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_manager_property_info_stop_idle_session_usec =
{
  {
    -1,
    (gchar *) "StopIdleSessionUSec",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_manager_property_stop_idle_session_usec_annotation_info_pointers
  },
  "stop-idle-session-usec",
  FALSE,
  FALSE
};

static const GDBusPropertyInfo * const _meta_dbus_login1_manager_property_info_pointers[] =
{
  &_meta_dbus_login1_manager_property_info_enable_wall_messages.parent_struct,
  &_meta_dbus_login1_manager_property_info_wall_message.parent_struct,
  &_meta_dbus_login1_manager_property_info_nauto_vts.parent_struct,
  &_meta_dbus_login1_manager_property_info_kill_only_users.parent_struct,
  &_meta_dbus_login1_manager_property_info_kill_exclude_users.parent_struct,
  &_meta_dbus_login1_manager_property_info_kill_user_processes.parent_struct,
  &_meta_dbus_login1_manager_property_info_reboot_parameter.parent_struct,
  &_meta_dbus_login1_manager_property_info_reboot_to_firmware_setup.parent_struct,
  &_meta_dbus_login1_manager_property_info_reboot_to_boot_loader_menu.parent_struct,
  &_meta_dbus_login1_manager_property_info_reboot_to_boot_loader_entry.parent_struct,
  &_meta_dbus_login1_manager_property_info_boot_loader_entries.parent_struct,
  &_meta_dbus_login1_manager_property_info_idle_hint.parent_struct,
  &_meta_dbus_login1_manager_property_info_idle_since_hint.parent_struct,
  &_meta_dbus_login1_manager_property_info_idle_since_hint_monotonic.parent_struct,
  &_meta_dbus_login1_manager_property_info_block_inhibited.parent_struct,
  &_meta_dbus_login1_manager_property_info_delay_inhibited.parent_struct,
  &_meta_dbus_login1_manager_property_info_inhibit_delay_max_usec.parent_struct,
  &_meta_dbus_login1_manager_property_info_user_stop_delay_usec.parent_struct,
  &_meta_dbus_login1_manager_property_info_sleep_operation.parent_struct,
  &_meta_dbus_login1_manager_property_info_handle_power_key.parent_struct,
  &_meta_dbus_login1_manager_property_info_handle_power_key_long_press.parent_struct,
  &_meta_dbus_login1_manager_property_info_handle_reboot_key.parent_struct,
  &_meta_dbus_login1_manager_property_info_handle_reboot_key_long_press.parent_struct,
  &_meta_dbus_login1_manager_property_info_handle_suspend_key.parent_struct,
  &_meta_dbus_login1_manager_property_info_handle_suspend_key_long_press.parent_struct,
  &_meta_dbus_login1_manager_property_info_handle_hibernate_key.parent_struct,
  &_meta_dbus_login1_manager_property_info_handle_hibernate_key_long_press.parent_struct,
  &_meta_dbus_login1_manager_property_info_handle_lid_switch.parent_struct,
  &_meta_dbus_login1_manager_property_info_handle_lid_switch_external_power.parent_struct,
  &_meta_dbus_login1_manager_property_info_handle_lid_switch_docked.parent_struct,
  &_meta_dbus_login1_manager_property_info_holdoff_timeout_usec.parent_struct,
  &_meta_dbus_login1_manager_property_info_idle_action.parent_struct,
  &_meta_dbus_login1_manager_property_info_idle_action_usec.parent_struct,
  &_meta_dbus_login1_manager_property_info_preparing_for_shutdown.parent_struct,
  &_meta_dbus_login1_manager_property_info_preparing_for_sleep.parent_struct,
  &_meta_dbus_login1_manager_property_info_scheduled_shutdown.parent_struct,
  &_meta_dbus_login1_manager_property_info_docked.parent_struct,
  &_meta_dbus_login1_manager_property_info_lid_closed.parent_struct,
  &_meta_dbus_login1_manager_property_info_on_external_power.parent_struct,
  &_meta_dbus_login1_manager_property_info_remove_ipc.parent_struct,
  &_meta_dbus_login1_manager_property_info_runtime_directory_size.parent_struct,
  &_meta_dbus_login1_manager_property_info_runtime_directory_inodes_max.parent_struct,
  &_meta_dbus_login1_manager_property_info_inhibitors_max.parent_struct,
  &_meta_dbus_login1_manager_property_info_ncurrent_inhibitors.parent_struct,
  &_meta_dbus_login1_manager_property_info_sessions_max.parent_struct,
  &_meta_dbus_login1_manager_property_info_ncurrent_sessions.parent_struct,
  &_meta_dbus_login1_manager_property_info_stop_idle_session_usec.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _meta_dbus_login1_manager_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.login1.Manager",
    (GDBusMethodInfo **) &_meta_dbus_login1_manager_method_info_pointers,
    (GDBusSignalInfo **) &_meta_dbus_login1_manager_signal_info_pointers,
    (GDBusPropertyInfo **) &_meta_dbus_login1_manager_property_info_pointers,
    NULL
  },
  "login1-manager",
};


/**
 * meta_dbus_login1_manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-login1-Manager.top_of_page">org.freedesktop.login1.Manager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
meta_dbus_login1_manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_meta_dbus_login1_manager_interface_info.parent_struct;
}

/**
 * meta_dbus_login1_manager_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MetaDBusLogin1Manager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
meta_dbus_login1_manager_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "enable-wall-messages");
  g_object_class_override_property (klass, property_id_begin++, "wall-message");
  g_object_class_override_property (klass, property_id_begin++, "nauto-vts");
  g_object_class_override_property (klass, property_id_begin++, "kill-only-users");
  g_object_class_override_property (klass, property_id_begin++, "kill-exclude-users");
  g_object_class_override_property (klass, property_id_begin++, "kill-user-processes");
  g_object_class_override_property (klass, property_id_begin++, "reboot-parameter");
  g_object_class_override_property (klass, property_id_begin++, "reboot-to-firmware-setup");
  g_object_class_override_property (klass, property_id_begin++, "reboot-to-boot-loader-menu");
  g_object_class_override_property (klass, property_id_begin++, "reboot-to-boot-loader-entry");
  g_object_class_override_property (klass, property_id_begin++, "boot-loader-entries");
  g_object_class_override_property (klass, property_id_begin++, "idle-hint");
  g_object_class_override_property (klass, property_id_begin++, "idle-since-hint");
  g_object_class_override_property (klass, property_id_begin++, "idle-since-hint-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "block-inhibited");
  g_object_class_override_property (klass, property_id_begin++, "delay-inhibited");
  g_object_class_override_property (klass, property_id_begin++, "inhibit-delay-max-usec");
  g_object_class_override_property (klass, property_id_begin++, "user-stop-delay-usec");
  g_object_class_override_property (klass, property_id_begin++, "sleep-operation");
  g_object_class_override_property (klass, property_id_begin++, "handle-power-key");
  g_object_class_override_property (klass, property_id_begin++, "handle-power-key-long-press");
  g_object_class_override_property (klass, property_id_begin++, "handle-reboot-key");
  g_object_class_override_property (klass, property_id_begin++, "handle-reboot-key-long-press");
  g_object_class_override_property (klass, property_id_begin++, "handle-suspend-key");
  g_object_class_override_property (klass, property_id_begin++, "handle-suspend-key-long-press");
  g_object_class_override_property (klass, property_id_begin++, "handle-hibernate-key");
  g_object_class_override_property (klass, property_id_begin++, "handle-hibernate-key-long-press");
  g_object_class_override_property (klass, property_id_begin++, "handle-lid-switch");
  g_object_class_override_property (klass, property_id_begin++, "handle-lid-switch-external-power");
  g_object_class_override_property (klass, property_id_begin++, "handle-lid-switch-docked");
  g_object_class_override_property (klass, property_id_begin++, "holdoff-timeout-usec");
  g_object_class_override_property (klass, property_id_begin++, "idle-action");
  g_object_class_override_property (klass, property_id_begin++, "idle-action-usec");
  g_object_class_override_property (klass, property_id_begin++, "preparing-for-shutdown");
  g_object_class_override_property (klass, property_id_begin++, "preparing-for-sleep");
  g_object_class_override_property (klass, property_id_begin++, "scheduled-shutdown");
  g_object_class_override_property (klass, property_id_begin++, "docked");
  g_object_class_override_property (klass, property_id_begin++, "lid-closed");
  g_object_class_override_property (klass, property_id_begin++, "on-external-power");
  g_object_class_override_property (klass, property_id_begin++, "remove-ipc");
  g_object_class_override_property (klass, property_id_begin++, "runtime-directory-size");
  g_object_class_override_property (klass, property_id_begin++, "runtime-directory-inodes-max");
  g_object_class_override_property (klass, property_id_begin++, "inhibitors-max");
  g_object_class_override_property (klass, property_id_begin++, "ncurrent-inhibitors");
  g_object_class_override_property (klass, property_id_begin++, "sessions-max");
  g_object_class_override_property (klass, property_id_begin++, "ncurrent-sessions");
  g_object_class_override_property (klass, property_id_begin++, "stop-idle-session-usec");
  return property_id_begin - 1;
}


inline static void
meta_dbus_login1_manager_signal_marshal_session_new (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_signal_marshal_session_removed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_signal_marshal_user_new (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__UINT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_signal_marshal_user_removed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__UINT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_signal_marshal_seat_new (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_signal_marshal_seat_removed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_signal_marshal_prepare_for_shutdown (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_signal_marshal_prepare_for_shutdown_with_metadata (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__BOOLEAN_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_signal_marshal_prepare_for_sleep (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_get_session (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_get_session_by_pid (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_get_user (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_get_user_by_pid (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_get_seat (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_list_sessions (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_list_sessions_ex (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_list_users (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_list_seats (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_list_inhibitors (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_create_session (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_UINT_STRING_STRING_STRING_STRING_STRING_UINT_STRING_STRING_BOOLEAN_STRING_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_create_session_with_pidfd (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_VARIANT_STRING_STRING_STRING_STRING_STRING_UINT_STRING_STRING_BOOLEAN_STRING_STRING_UINT64_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_release_session (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_activate_session (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_activate_session_on_seat (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_lock_session (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_unlock_session (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_lock_sessions (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_unlock_sessions (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_kill_session (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_kill_user (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_terminate_session (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_terminate_user (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_terminate_seat (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_set_user_linger (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_BOOLEAN_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_attach_device (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_flush_devices (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_power_off (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_power_off_with_flags (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT64 (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_reboot (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_reboot_with_flags (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT64 (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_halt (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_halt_with_flags (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT64 (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_suspend (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_suspend_with_flags (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT64 (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_hibernate (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_hibernate_with_flags (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT64 (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_hybrid_sleep (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_hybrid_sleep_with_flags (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT64 (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_suspend_then_hibernate (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_suspend_then_hibernate_with_flags (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT64 (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_sleep (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT64 (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_can_power_off (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_can_reboot (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_can_halt (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_can_suspend (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_can_hibernate (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_can_hybrid_sleep (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_can_suspend_then_hibernate (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_can_sleep (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_schedule_shutdown (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_UINT64 (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_cancel_scheduled_shutdown (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_inhibit (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_can_reboot_parameter (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_set_reboot_parameter (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_can_reboot_to_firmware_setup (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_set_reboot_to_firmware_setup (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_can_reboot_to_boot_loader_menu (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_set_reboot_to_boot_loader_menu (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT64 (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_can_reboot_to_boot_loader_entry (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_set_reboot_to_boot_loader_entry (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_manager_method_marshal_set_wall_message (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * MetaDBusLogin1Manager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Manager.top_of_page">org.freedesktop.login1.Manager</link>.
 */

/**
 * MetaDBusLogin1ManagerIface:
 * @parent_iface: The parent interface.
 * @handle_activate_session: Handler for the #MetaDBusLogin1Manager::handle-activate-session signal.
 * @handle_activate_session_on_seat: Handler for the #MetaDBusLogin1Manager::handle-activate-session-on-seat signal.
 * @handle_attach_device: Handler for the #MetaDBusLogin1Manager::handle-attach-device signal.
 * @handle_can_halt: Handler for the #MetaDBusLogin1Manager::handle-can-halt signal.
 * @handle_can_hibernate: Handler for the #MetaDBusLogin1Manager::handle-can-hibernate signal.
 * @handle_can_hybrid_sleep: Handler for the #MetaDBusLogin1Manager::handle-can-hybrid-sleep signal.
 * @handle_can_power_off: Handler for the #MetaDBusLogin1Manager::handle-can-power-off signal.
 * @handle_can_reboot: Handler for the #MetaDBusLogin1Manager::handle-can-reboot signal.
 * @handle_can_reboot_parameter: Handler for the #MetaDBusLogin1Manager::handle-can-reboot-parameter signal.
 * @handle_can_reboot_to_boot_loader_entry: Handler for the #MetaDBusLogin1Manager::handle-can-reboot-to-boot-loader-entry signal.
 * @handle_can_reboot_to_boot_loader_menu: Handler for the #MetaDBusLogin1Manager::handle-can-reboot-to-boot-loader-menu signal.
 * @handle_can_reboot_to_firmware_setup: Handler for the #MetaDBusLogin1Manager::handle-can-reboot-to-firmware-setup signal.
 * @handle_can_sleep: Handler for the #MetaDBusLogin1Manager::handle-can-sleep signal.
 * @handle_can_suspend: Handler for the #MetaDBusLogin1Manager::handle-can-suspend signal.
 * @handle_can_suspend_then_hibernate: Handler for the #MetaDBusLogin1Manager::handle-can-suspend-then-hibernate signal.
 * @handle_cancel_scheduled_shutdown: Handler for the #MetaDBusLogin1Manager::handle-cancel-scheduled-shutdown signal.
 * @handle_create_session: Handler for the #MetaDBusLogin1Manager::handle-create-session signal.
 * @handle_create_session_with_pidfd: Handler for the #MetaDBusLogin1Manager::handle-create-session-with-pidfd signal.
 * @handle_flush_devices: Handler for the #MetaDBusLogin1Manager::handle-flush-devices signal.
 * @handle_get_seat: Handler for the #MetaDBusLogin1Manager::handle-get-seat signal.
 * @handle_get_session: Handler for the #MetaDBusLogin1Manager::handle-get-session signal.
 * @handle_get_session_by_pid: Handler for the #MetaDBusLogin1Manager::handle-get-session-by-pid signal.
 * @handle_get_user: Handler for the #MetaDBusLogin1Manager::handle-get-user signal.
 * @handle_get_user_by_pid: Handler for the #MetaDBusLogin1Manager::handle-get-user-by-pid signal.
 * @handle_halt: Handler for the #MetaDBusLogin1Manager::handle-halt signal.
 * @handle_halt_with_flags: Handler for the #MetaDBusLogin1Manager::handle-halt-with-flags signal.
 * @handle_hibernate: Handler for the #MetaDBusLogin1Manager::handle-hibernate signal.
 * @handle_hibernate_with_flags: Handler for the #MetaDBusLogin1Manager::handle-hibernate-with-flags signal.
 * @handle_hybrid_sleep: Handler for the #MetaDBusLogin1Manager::handle-hybrid-sleep signal.
 * @handle_hybrid_sleep_with_flags: Handler for the #MetaDBusLogin1Manager::handle-hybrid-sleep-with-flags signal.
 * @handle_inhibit: Handler for the #MetaDBusLogin1Manager::handle-inhibit signal.
 * @handle_kill_session: Handler for the #MetaDBusLogin1Manager::handle-kill-session signal.
 * @handle_kill_user: Handler for the #MetaDBusLogin1Manager::handle-kill-user signal.
 * @handle_list_inhibitors: Handler for the #MetaDBusLogin1Manager::handle-list-inhibitors signal.
 * @handle_list_seats: Handler for the #MetaDBusLogin1Manager::handle-list-seats signal.
 * @handle_list_sessions: Handler for the #MetaDBusLogin1Manager::handle-list-sessions signal.
 * @handle_list_sessions_ex: Handler for the #MetaDBusLogin1Manager::handle-list-sessions-ex signal.
 * @handle_list_users: Handler for the #MetaDBusLogin1Manager::handle-list-users signal.
 * @handle_lock_session: Handler for the #MetaDBusLogin1Manager::handle-lock-session signal.
 * @handle_lock_sessions: Handler for the #MetaDBusLogin1Manager::handle-lock-sessions signal.
 * @handle_power_off: Handler for the #MetaDBusLogin1Manager::handle-power-off signal.
 * @handle_power_off_with_flags: Handler for the #MetaDBusLogin1Manager::handle-power-off-with-flags signal.
 * @handle_reboot: Handler for the #MetaDBusLogin1Manager::handle-reboot signal.
 * @handle_reboot_with_flags: Handler for the #MetaDBusLogin1Manager::handle-reboot-with-flags signal.
 * @handle_release_session: Handler for the #MetaDBusLogin1Manager::handle-release-session signal.
 * @handle_schedule_shutdown: Handler for the #MetaDBusLogin1Manager::handle-schedule-shutdown signal.
 * @handle_set_reboot_parameter: Handler for the #MetaDBusLogin1Manager::handle-set-reboot-parameter signal.
 * @handle_set_reboot_to_boot_loader_entry: Handler for the #MetaDBusLogin1Manager::handle-set-reboot-to-boot-loader-entry signal.
 * @handle_set_reboot_to_boot_loader_menu: Handler for the #MetaDBusLogin1Manager::handle-set-reboot-to-boot-loader-menu signal.
 * @handle_set_reboot_to_firmware_setup: Handler for the #MetaDBusLogin1Manager::handle-set-reboot-to-firmware-setup signal.
 * @handle_set_user_linger: Handler for the #MetaDBusLogin1Manager::handle-set-user-linger signal.
 * @handle_set_wall_message: Handler for the #MetaDBusLogin1Manager::handle-set-wall-message signal.
 * @handle_sleep: Handler for the #MetaDBusLogin1Manager::handle-sleep signal.
 * @handle_suspend: Handler for the #MetaDBusLogin1Manager::handle-suspend signal.
 * @handle_suspend_then_hibernate: Handler for the #MetaDBusLogin1Manager::handle-suspend-then-hibernate signal.
 * @handle_suspend_then_hibernate_with_flags: Handler for the #MetaDBusLogin1Manager::handle-suspend-then-hibernate-with-flags signal.
 * @handle_suspend_with_flags: Handler for the #MetaDBusLogin1Manager::handle-suspend-with-flags signal.
 * @handle_terminate_seat: Handler for the #MetaDBusLogin1Manager::handle-terminate-seat signal.
 * @handle_terminate_session: Handler for the #MetaDBusLogin1Manager::handle-terminate-session signal.
 * @handle_terminate_user: Handler for the #MetaDBusLogin1Manager::handle-terminate-user signal.
 * @handle_unlock_session: Handler for the #MetaDBusLogin1Manager::handle-unlock-session signal.
 * @handle_unlock_sessions: Handler for the #MetaDBusLogin1Manager::handle-unlock-sessions signal.
 * @get_block_inhibited: Getter for the #MetaDBusLogin1Manager:block-inhibited property.
 * @get_boot_loader_entries: Getter for the #MetaDBusLogin1Manager:boot-loader-entries property.
 * @get_delay_inhibited: Getter for the #MetaDBusLogin1Manager:delay-inhibited property.
 * @get_docked: Getter for the #MetaDBusLogin1Manager:docked property.
 * @get_enable_wall_messages: Getter for the #MetaDBusLogin1Manager:enable-wall-messages property.
 * @get_handle_hibernate_key: Getter for the #MetaDBusLogin1Manager:handle-hibernate-key property.
 * @get_handle_hibernate_key_long_press: Getter for the #MetaDBusLogin1Manager:handle-hibernate-key-long-press property.
 * @get_handle_lid_switch: Getter for the #MetaDBusLogin1Manager:handle-lid-switch property.
 * @get_handle_lid_switch_docked: Getter for the #MetaDBusLogin1Manager:handle-lid-switch-docked property.
 * @get_handle_lid_switch_external_power: Getter for the #MetaDBusLogin1Manager:handle-lid-switch-external-power property.
 * @get_handle_power_key: Getter for the #MetaDBusLogin1Manager:handle-power-key property.
 * @get_handle_power_key_long_press: Getter for the #MetaDBusLogin1Manager:handle-power-key-long-press property.
 * @get_handle_reboot_key: Getter for the #MetaDBusLogin1Manager:handle-reboot-key property.
 * @get_handle_reboot_key_long_press: Getter for the #MetaDBusLogin1Manager:handle-reboot-key-long-press property.
 * @get_handle_suspend_key: Getter for the #MetaDBusLogin1Manager:handle-suspend-key property.
 * @get_handle_suspend_key_long_press: Getter for the #MetaDBusLogin1Manager:handle-suspend-key-long-press property.
 * @get_holdoff_timeout_usec: Getter for the #MetaDBusLogin1Manager:holdoff-timeout-usec property.
 * @get_idle_action: Getter for the #MetaDBusLogin1Manager:idle-action property.
 * @get_idle_action_usec: Getter for the #MetaDBusLogin1Manager:idle-action-usec property.
 * @get_idle_hint: Getter for the #MetaDBusLogin1Manager:idle-hint property.
 * @get_idle_since_hint: Getter for the #MetaDBusLogin1Manager:idle-since-hint property.
 * @get_idle_since_hint_monotonic: Getter for the #MetaDBusLogin1Manager:idle-since-hint-monotonic property.
 * @get_inhibit_delay_max_usec: Getter for the #MetaDBusLogin1Manager:inhibit-delay-max-usec property.
 * @get_inhibitors_max: Getter for the #MetaDBusLogin1Manager:inhibitors-max property.
 * @get_kill_exclude_users: Getter for the #MetaDBusLogin1Manager:kill-exclude-users property.
 * @get_kill_only_users: Getter for the #MetaDBusLogin1Manager:kill-only-users property.
 * @get_kill_user_processes: Getter for the #MetaDBusLogin1Manager:kill-user-processes property.
 * @get_lid_closed: Getter for the #MetaDBusLogin1Manager:lid-closed property.
 * @get_nauto_vts: Getter for the #MetaDBusLogin1Manager:nauto-vts property.
 * @get_ncurrent_inhibitors: Getter for the #MetaDBusLogin1Manager:ncurrent-inhibitors property.
 * @get_ncurrent_sessions: Getter for the #MetaDBusLogin1Manager:ncurrent-sessions property.
 * @get_on_external_power: Getter for the #MetaDBusLogin1Manager:on-external-power property.
 * @get_preparing_for_shutdown: Getter for the #MetaDBusLogin1Manager:preparing-for-shutdown property.
 * @get_preparing_for_sleep: Getter for the #MetaDBusLogin1Manager:preparing-for-sleep property.
 * @get_reboot_parameter: Getter for the #MetaDBusLogin1Manager:reboot-parameter property.
 * @get_reboot_to_boot_loader_entry: Getter for the #MetaDBusLogin1Manager:reboot-to-boot-loader-entry property.
 * @get_reboot_to_boot_loader_menu: Getter for the #MetaDBusLogin1Manager:reboot-to-boot-loader-menu property.
 * @get_reboot_to_firmware_setup: Getter for the #MetaDBusLogin1Manager:reboot-to-firmware-setup property.
 * @get_remove_ipc: Getter for the #MetaDBusLogin1Manager:remove-ipc property.
 * @get_runtime_directory_inodes_max: Getter for the #MetaDBusLogin1Manager:runtime-directory-inodes-max property.
 * @get_runtime_directory_size: Getter for the #MetaDBusLogin1Manager:runtime-directory-size property.
 * @get_scheduled_shutdown: Getter for the #MetaDBusLogin1Manager:scheduled-shutdown property.
 * @get_sessions_max: Getter for the #MetaDBusLogin1Manager:sessions-max property.
 * @get_sleep_operation: Getter for the #MetaDBusLogin1Manager:sleep-operation property.
 * @get_stop_idle_session_usec: Getter for the #MetaDBusLogin1Manager:stop-idle-session-usec property.
 * @get_user_stop_delay_usec: Getter for the #MetaDBusLogin1Manager:user-stop-delay-usec property.
 * @get_wall_message: Getter for the #MetaDBusLogin1Manager:wall-message property.
 * @prepare_for_shutdown: Handler for the #MetaDBusLogin1Manager::prepare-for-shutdown signal.
 * @prepare_for_shutdown_with_metadata: Handler for the #MetaDBusLogin1Manager::prepare-for-shutdown-with-metadata signal.
 * @prepare_for_sleep: Handler for the #MetaDBusLogin1Manager::prepare-for-sleep signal.
 * @seat_new: Handler for the #MetaDBusLogin1Manager::seat-new signal.
 * @seat_removed: Handler for the #MetaDBusLogin1Manager::seat-removed signal.
 * @session_new: Handler for the #MetaDBusLogin1Manager::session-new signal.
 * @session_removed: Handler for the #MetaDBusLogin1Manager::session-removed signal.
 * @user_new: Handler for the #MetaDBusLogin1Manager::user-new signal.
 * @user_removed: Handler for the #MetaDBusLogin1Manager::user-removed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Manager.top_of_page">org.freedesktop.login1.Manager</link>.
 */

typedef MetaDBusLogin1ManagerIface MetaDBusLogin1ManagerInterface;
G_DEFINE_INTERFACE (MetaDBusLogin1Manager, meta_dbus_login1_manager, G_TYPE_OBJECT)

static void
meta_dbus_login1_manager_default_init (MetaDBusLogin1ManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MetaDBusLogin1Manager::handle-get-session:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.GetSession">GetSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_get_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_get_session),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_get_session,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MetaDBusLogin1Manager::handle-get-session-by-pid:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pid: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.GetSessionByPID">GetSessionByPID()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_get_session_by_pid() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-session-by-pid",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_get_session_by_pid),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_get_session_by_pid,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * MetaDBusLogin1Manager::handle-get-user:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uid: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.GetUser">GetUser()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_get_user() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-user",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_get_user),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_get_user,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * MetaDBusLogin1Manager::handle-get-user-by-pid:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pid: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.GetUserByPID">GetUserByPID()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_get_user_by_pid() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-user-by-pid",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_get_user_by_pid),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_get_user_by_pid,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * MetaDBusLogin1Manager::handle-get-seat:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_seat_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.GetSeat">GetSeat()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_get_seat() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-seat",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_get_seat),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_get_seat,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MetaDBusLogin1Manager::handle-list-sessions:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ListSessions">ListSessions()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_list_sessions() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-sessions",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_list_sessions),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_list_sessions,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Manager::handle-list-sessions-ex:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ListSessionsEx">ListSessionsEx()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_list_sessions_ex() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-sessions-ex",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_list_sessions_ex),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_list_sessions_ex,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Manager::handle-list-users:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ListUsers">ListUsers()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_list_users() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-users",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_list_users),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_list_users,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Manager::handle-list-seats:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ListSeats">ListSeats()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_list_seats() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-seats",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_list_seats),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_list_seats,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Manager::handle-list-inhibitors:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ListInhibitors">ListInhibitors()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_list_inhibitors() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-inhibitors",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_list_inhibitors),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_list_inhibitors,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Manager::handle-create-session:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uid: Argument passed by remote caller.
   * @arg_pid: Argument passed by remote caller.
   * @arg_service: Argument passed by remote caller.
   * @arg_type: Argument passed by remote caller.
   * @arg_class: Argument passed by remote caller.
   * @arg_desktop: Argument passed by remote caller.
   * @arg_seat_id: Argument passed by remote caller.
   * @arg_vtnr: Argument passed by remote caller.
   * @arg_tty: Argument passed by remote caller.
   * @arg_display: Argument passed by remote caller.
   * @arg_remote: Argument passed by remote caller.
   * @arg_remote_user: Argument passed by remote caller.
   * @arg_remote_host: Argument passed by remote caller.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CreateSession">CreateSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_create_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_create_session),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_create_session,
    G_TYPE_BOOLEAN,
    15,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * MetaDBusLogin1Manager::handle-create-session-with-pidfd:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uid: Argument passed by remote caller.
   * @arg_pidfd: Argument passed by remote caller.
   * @arg_service: Argument passed by remote caller.
   * @arg_type: Argument passed by remote caller.
   * @arg_class: Argument passed by remote caller.
   * @arg_desktop: Argument passed by remote caller.
   * @arg_seat_id: Argument passed by remote caller.
   * @arg_vtnr: Argument passed by remote caller.
   * @arg_tty: Argument passed by remote caller.
   * @arg_display: Argument passed by remote caller.
   * @arg_remote: Argument passed by remote caller.
   * @arg_remote_user: Argument passed by remote caller.
   * @arg_remote_host: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CreateSessionWithPIDFD">CreateSessionWithPIDFD()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_create_session_with_pidfd() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-session-with-pidfd",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_create_session_with_pidfd),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_create_session_with_pidfd,
    G_TYPE_BOOLEAN,
    16,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_VARIANT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT64, G_TYPE_VARIANT);

  /**
   * MetaDBusLogin1Manager::handle-release-session:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ReleaseSession">ReleaseSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_release_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_release_session),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_release_session,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MetaDBusLogin1Manager::handle-activate-session:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ActivateSession">ActivateSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_activate_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-activate-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_activate_session),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_activate_session,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MetaDBusLogin1Manager::handle-activate-session-on-seat:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_id: Argument passed by remote caller.
   * @arg_seat_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ActivateSessionOnSeat">ActivateSessionOnSeat()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_activate_session_on_seat() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-activate-session-on-seat",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_activate_session_on_seat),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_activate_session_on_seat,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * MetaDBusLogin1Manager::handle-lock-session:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.LockSession">LockSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_lock_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-lock-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_lock_session),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_lock_session,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MetaDBusLogin1Manager::handle-unlock-session:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.UnlockSession">UnlockSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_unlock_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unlock-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_unlock_session),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_unlock_session,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MetaDBusLogin1Manager::handle-lock-sessions:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.LockSessions">LockSessions()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_lock_sessions() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-lock-sessions",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_lock_sessions),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_lock_sessions,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Manager::handle-unlock-sessions:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.UnlockSessions">UnlockSessions()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_unlock_sessions() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unlock-sessions",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_unlock_sessions),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_unlock_sessions,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Manager::handle-kill-session:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_id: Argument passed by remote caller.
   * @arg_who: Argument passed by remote caller.
   * @arg_signal_number: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.KillSession">KillSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_kill_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-kill-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_kill_session),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_kill_session,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT);

  /**
   * MetaDBusLogin1Manager::handle-kill-user:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uid: Argument passed by remote caller.
   * @arg_signal_number: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.KillUser">KillUser()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_kill_user() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-kill-user",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_kill_user),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_kill_user,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_INT);

  /**
   * MetaDBusLogin1Manager::handle-terminate-session:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.TerminateSession">TerminateSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_terminate_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-terminate-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_terminate_session),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_terminate_session,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MetaDBusLogin1Manager::handle-terminate-user:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uid: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.TerminateUser">TerminateUser()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_terminate_user() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-terminate-user",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_terminate_user),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_terminate_user,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * MetaDBusLogin1Manager::handle-terminate-seat:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_seat_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.TerminateSeat">TerminateSeat()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_terminate_seat() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-terminate-seat",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_terminate_seat),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_terminate_seat,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MetaDBusLogin1Manager::handle-set-user-linger:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uid: Argument passed by remote caller.
   * @arg_enable: Argument passed by remote caller.
   * @arg_interactive: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetUserLinger">SetUserLinger()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_set_user_linger() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-user-linger",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_set_user_linger),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_set_user_linger,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);

  /**
   * MetaDBusLogin1Manager::handle-attach-device:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_seat_id: Argument passed by remote caller.
   * @arg_sysfs_path: Argument passed by remote caller.
   * @arg_interactive: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.AttachDevice">AttachDevice()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_attach_device() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-attach-device",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_attach_device),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_attach_device,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);

  /**
   * MetaDBusLogin1Manager::handle-flush-devices:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_interactive: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.FlushDevices">FlushDevices()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_flush_devices() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-flush-devices",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_flush_devices),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_flush_devices,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * MetaDBusLogin1Manager::handle-power-off:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_interactive: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.PowerOff">PowerOff()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_power_off() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-power-off",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_power_off),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_power_off,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * MetaDBusLogin1Manager::handle-power-off-with-flags:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.PowerOffWithFlags">PowerOffWithFlags()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_power_off_with_flags() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-power-off-with-flags",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_power_off_with_flags),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_power_off_with_flags,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64);

  /**
   * MetaDBusLogin1Manager::handle-reboot:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_interactive: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Reboot">Reboot()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_reboot() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reboot",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_reboot),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_reboot,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * MetaDBusLogin1Manager::handle-reboot-with-flags:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.RebootWithFlags">RebootWithFlags()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_reboot_with_flags() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reboot-with-flags",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_reboot_with_flags),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_reboot_with_flags,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64);

  /**
   * MetaDBusLogin1Manager::handle-halt:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_interactive: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Halt">Halt()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_halt() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-halt",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_halt),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_halt,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * MetaDBusLogin1Manager::handle-halt-with-flags:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.HaltWithFlags">HaltWithFlags()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_halt_with_flags() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-halt-with-flags",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_halt_with_flags),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_halt_with_flags,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64);

  /**
   * MetaDBusLogin1Manager::handle-suspend:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_interactive: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Suspend">Suspend()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_suspend() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-suspend",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_suspend),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_suspend,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * MetaDBusLogin1Manager::handle-suspend-with-flags:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SuspendWithFlags">SuspendWithFlags()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_suspend_with_flags() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-suspend-with-flags",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_suspend_with_flags),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_suspend_with_flags,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64);

  /**
   * MetaDBusLogin1Manager::handle-hibernate:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_interactive: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Hibernate">Hibernate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_hibernate() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-hibernate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_hibernate),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_hibernate,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * MetaDBusLogin1Manager::handle-hibernate-with-flags:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.HibernateWithFlags">HibernateWithFlags()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_hibernate_with_flags() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-hibernate-with-flags",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_hibernate_with_flags),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_hibernate_with_flags,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64);

  /**
   * MetaDBusLogin1Manager::handle-hybrid-sleep:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_interactive: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.HybridSleep">HybridSleep()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_hybrid_sleep() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-hybrid-sleep",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_hybrid_sleep),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_hybrid_sleep,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * MetaDBusLogin1Manager::handle-hybrid-sleep-with-flags:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.HybridSleepWithFlags">HybridSleepWithFlags()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_hybrid_sleep_with_flags() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-hybrid-sleep-with-flags",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_hybrid_sleep_with_flags),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_hybrid_sleep_with_flags,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64);

  /**
   * MetaDBusLogin1Manager::handle-suspend-then-hibernate:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_interactive: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SuspendThenHibernate">SuspendThenHibernate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_suspend_then_hibernate() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-suspend-then-hibernate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_suspend_then_hibernate),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_suspend_then_hibernate,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * MetaDBusLogin1Manager::handle-suspend-then-hibernate-with-flags:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SuspendThenHibernateWithFlags">SuspendThenHibernateWithFlags()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_suspend_then_hibernate_with_flags() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-suspend-then-hibernate-with-flags",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_suspend_then_hibernate_with_flags),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_suspend_then_hibernate_with_flags,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64);

  /**
   * MetaDBusLogin1Manager::handle-sleep:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Sleep">Sleep()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_sleep() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-sleep",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_sleep),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_sleep,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64);

  /**
   * MetaDBusLogin1Manager::handle-can-power-off:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanPowerOff">CanPowerOff()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_can_power_off() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-can-power-off",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_can_power_off),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_can_power_off,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Manager::handle-can-reboot:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanReboot">CanReboot()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_can_reboot() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-can-reboot",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_can_reboot),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_can_reboot,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Manager::handle-can-halt:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanHalt">CanHalt()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_can_halt() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-can-halt",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_can_halt),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_can_halt,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Manager::handle-can-suspend:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanSuspend">CanSuspend()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_can_suspend() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-can-suspend",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_can_suspend),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_can_suspend,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Manager::handle-can-hibernate:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanHibernate">CanHibernate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_can_hibernate() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-can-hibernate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_can_hibernate),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_can_hibernate,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Manager::handle-can-hybrid-sleep:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanHybridSleep">CanHybridSleep()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_can_hybrid_sleep() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-can-hybrid-sleep",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_can_hybrid_sleep),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_can_hybrid_sleep,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Manager::handle-can-suspend-then-hibernate:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanSuspendThenHibernate">CanSuspendThenHibernate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_can_suspend_then_hibernate() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-can-suspend-then-hibernate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_can_suspend_then_hibernate),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_can_suspend_then_hibernate,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Manager::handle-can-sleep:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanSleep">CanSleep()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_can_sleep() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-can-sleep",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_can_sleep),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_can_sleep,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Manager::handle-schedule-shutdown:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_type: Argument passed by remote caller.
   * @arg_usec: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ScheduleShutdown">ScheduleShutdown()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_schedule_shutdown() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-schedule-shutdown",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_schedule_shutdown),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_schedule_shutdown,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_UINT64);

  /**
   * MetaDBusLogin1Manager::handle-cancel-scheduled-shutdown:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CancelScheduledShutdown">CancelScheduledShutdown()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_cancel_scheduled_shutdown() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-cancel-scheduled-shutdown",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_cancel_scheduled_shutdown),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_cancel_scheduled_shutdown,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Manager::handle-inhibit:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_what: Argument passed by remote caller.
   * @arg_who: Argument passed by remote caller.
   * @arg_why: Argument passed by remote caller.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Inhibit">Inhibit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_inhibit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-inhibit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_inhibit),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_inhibit,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * MetaDBusLogin1Manager::handle-can-reboot-parameter:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanRebootParameter">CanRebootParameter()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_can_reboot_parameter() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-can-reboot-parameter",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_can_reboot_parameter),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_can_reboot_parameter,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Manager::handle-set-reboot-parameter:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_parameter: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetRebootParameter">SetRebootParameter()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_set_reboot_parameter() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-reboot-parameter",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_set_reboot_parameter),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_set_reboot_parameter,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MetaDBusLogin1Manager::handle-can-reboot-to-firmware-setup:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanRebootToFirmwareSetup">CanRebootToFirmwareSetup()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_can_reboot_to_firmware_setup() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-can-reboot-to-firmware-setup",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_can_reboot_to_firmware_setup),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_can_reboot_to_firmware_setup,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Manager::handle-set-reboot-to-firmware-setup:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_enable: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetRebootToFirmwareSetup">SetRebootToFirmwareSetup()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_set_reboot_to_firmware_setup() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-reboot-to-firmware-setup",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_set_reboot_to_firmware_setup),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_set_reboot_to_firmware_setup,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * MetaDBusLogin1Manager::handle-can-reboot-to-boot-loader-menu:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanRebootToBootLoaderMenu">CanRebootToBootLoaderMenu()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_can_reboot_to_boot_loader_menu() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-can-reboot-to-boot-loader-menu",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_can_reboot_to_boot_loader_menu),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_can_reboot_to_boot_loader_menu,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Manager::handle-set-reboot-to-boot-loader-menu:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_timeout: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetRebootToBootLoaderMenu">SetRebootToBootLoaderMenu()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_set_reboot_to_boot_loader_menu() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-reboot-to-boot-loader-menu",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_set_reboot_to_boot_loader_menu),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_set_reboot_to_boot_loader_menu,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64);

  /**
   * MetaDBusLogin1Manager::handle-can-reboot-to-boot-loader-entry:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanRebootToBootLoaderEntry">CanRebootToBootLoaderEntry()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_can_reboot_to_boot_loader_entry() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-can-reboot-to-boot-loader-entry",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_can_reboot_to_boot_loader_entry),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_can_reboot_to_boot_loader_entry,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Manager::handle-set-reboot-to-boot-loader-entry:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_boot_loader_entry: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetRebootToBootLoaderEntry">SetRebootToBootLoaderEntry()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_set_reboot_to_boot_loader_entry() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-reboot-to-boot-loader-entry",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_set_reboot_to_boot_loader_entry),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_set_reboot_to_boot_loader_entry,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MetaDBusLogin1Manager::handle-set-wall-message:
   * @object: A #MetaDBusLogin1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_wall_message: Argument passed by remote caller.
   * @arg_enable: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetWallMessage">SetWallMessage()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_manager_complete_set_wall_message() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-wall-message",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, handle_set_wall_message),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_manager_method_marshal_set_wall_message,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN);

  /* GObject signals for received D-Bus signals: */
  /**
   * MetaDBusLogin1Manager::session-new:
   * @object: A #MetaDBusLogin1Manager.
   * @arg_session_id: Argument.
   * @arg_object_path: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-login1-Manager.SessionNew">"SessionNew"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__LOGIN1_MANAGER_SIGNALS[META_DBUS__LOGIN1_MANAGER_SESSION_NEW] =
    g_signal_new ("session-new",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, session_new),
      NULL,
      NULL,
      meta_dbus_login1_manager_signal_marshal_session_new,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * MetaDBusLogin1Manager::session-removed:
   * @object: A #MetaDBusLogin1Manager.
   * @arg_session_id: Argument.
   * @arg_object_path: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-login1-Manager.SessionRemoved">"SessionRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__LOGIN1_MANAGER_SIGNALS[META_DBUS__LOGIN1_MANAGER_SESSION_REMOVED] =
    g_signal_new ("session-removed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, session_removed),
      NULL,
      NULL,
      meta_dbus_login1_manager_signal_marshal_session_removed,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * MetaDBusLogin1Manager::user-new:
   * @object: A #MetaDBusLogin1Manager.
   * @arg_uid: Argument.
   * @arg_object_path: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-login1-Manager.UserNew">"UserNew"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__LOGIN1_MANAGER_SIGNALS[META_DBUS__LOGIN1_MANAGER_USER_NEW] =
    g_signal_new ("user-new",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, user_new),
      NULL,
      NULL,
      meta_dbus_login1_manager_signal_marshal_user_new,
      G_TYPE_NONE,
      2, G_TYPE_UINT, G_TYPE_STRING);

  /**
   * MetaDBusLogin1Manager::user-removed:
   * @object: A #MetaDBusLogin1Manager.
   * @arg_uid: Argument.
   * @arg_object_path: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-login1-Manager.UserRemoved">"UserRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__LOGIN1_MANAGER_SIGNALS[META_DBUS__LOGIN1_MANAGER_USER_REMOVED] =
    g_signal_new ("user-removed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, user_removed),
      NULL,
      NULL,
      meta_dbus_login1_manager_signal_marshal_user_removed,
      G_TYPE_NONE,
      2, G_TYPE_UINT, G_TYPE_STRING);

  /**
   * MetaDBusLogin1Manager::seat-new:
   * @object: A #MetaDBusLogin1Manager.
   * @arg_seat_id: Argument.
   * @arg_object_path: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-login1-Manager.SeatNew">"SeatNew"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__LOGIN1_MANAGER_SIGNALS[META_DBUS__LOGIN1_MANAGER_SEAT_NEW] =
    g_signal_new ("seat-new",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, seat_new),
      NULL,
      NULL,
      meta_dbus_login1_manager_signal_marshal_seat_new,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * MetaDBusLogin1Manager::seat-removed:
   * @object: A #MetaDBusLogin1Manager.
   * @arg_seat_id: Argument.
   * @arg_object_path: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-login1-Manager.SeatRemoved">"SeatRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__LOGIN1_MANAGER_SIGNALS[META_DBUS__LOGIN1_MANAGER_SEAT_REMOVED] =
    g_signal_new ("seat-removed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, seat_removed),
      NULL,
      NULL,
      meta_dbus_login1_manager_signal_marshal_seat_removed,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * MetaDBusLogin1Manager::prepare-for-shutdown:
   * @object: A #MetaDBusLogin1Manager.
   * @arg_start: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-login1-Manager.PrepareForShutdown">"PrepareForShutdown"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__LOGIN1_MANAGER_SIGNALS[META_DBUS__LOGIN1_MANAGER_PREPARE_FOR_SHUTDOWN] =
    g_signal_new ("prepare-for-shutdown",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, prepare_for_shutdown),
      NULL,
      NULL,
      meta_dbus_login1_manager_signal_marshal_prepare_for_shutdown,
      G_TYPE_NONE,
      1, G_TYPE_BOOLEAN);

  /**
   * MetaDBusLogin1Manager::prepare-for-shutdown-with-metadata:
   * @object: A #MetaDBusLogin1Manager.
   * @arg_start: Argument.
   * @arg_metadata: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-login1-Manager.PrepareForShutdownWithMetadata">"PrepareForShutdownWithMetadata"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__LOGIN1_MANAGER_SIGNALS[META_DBUS__LOGIN1_MANAGER_PREPARE_FOR_SHUTDOWN_WITH_METADATA] =
    g_signal_new ("prepare-for-shutdown-with-metadata",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, prepare_for_shutdown_with_metadata),
      NULL,
      NULL,
      meta_dbus_login1_manager_signal_marshal_prepare_for_shutdown_with_metadata,
      G_TYPE_NONE,
      2, G_TYPE_BOOLEAN, G_TYPE_VARIANT);

  /**
   * MetaDBusLogin1Manager::prepare-for-sleep:
   * @object: A #MetaDBusLogin1Manager.
   * @arg_start: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-login1-Manager.PrepareForSleep">"PrepareForSleep"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__LOGIN1_MANAGER_SIGNALS[META_DBUS__LOGIN1_MANAGER_PREPARE_FOR_SLEEP] =
    g_signal_new ("prepare-for-sleep",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusLogin1ManagerIface, prepare_for_sleep),
      NULL,
      NULL,
      meta_dbus_login1_manager_signal_marshal_prepare_for_sleep,
      G_TYPE_NONE,
      1, G_TYPE_BOOLEAN);

  /* GObject properties for D-Bus properties: */
  /**
   * MetaDBusLogin1Manager:enable-wall-messages:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.EnableWallMessages">"EnableWallMessages"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("enable-wall-messages", "EnableWallMessages", "EnableWallMessages", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:wall-message:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.WallMessage">"WallMessage"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("wall-message", "WallMessage", "WallMessage", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:nauto-vts:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.NAutoVTs">"NAutoVTs"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("nauto-vts", "NAutoVTs", "NAutoVTs", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:kill-only-users:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.KillOnlyUsers">"KillOnlyUsers"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("kill-only-users", "KillOnlyUsers", "KillOnlyUsers", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:kill-exclude-users:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.KillExcludeUsers">"KillExcludeUsers"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("kill-exclude-users", "KillExcludeUsers", "KillExcludeUsers", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:kill-user-processes:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.KillUserProcesses">"KillUserProcesses"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("kill-user-processes", "KillUserProcesses", "KillUserProcesses", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:reboot-parameter:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.RebootParameter">"RebootParameter"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("reboot-parameter", "RebootParameter", "RebootParameter", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:reboot-to-firmware-setup:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.RebootToFirmwareSetup">"RebootToFirmwareSetup"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("reboot-to-firmware-setup", "RebootToFirmwareSetup", "RebootToFirmwareSetup", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:reboot-to-boot-loader-menu:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.RebootToBootLoaderMenu">"RebootToBootLoaderMenu"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("reboot-to-boot-loader-menu", "RebootToBootLoaderMenu", "RebootToBootLoaderMenu", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:reboot-to-boot-loader-entry:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.RebootToBootLoaderEntry">"RebootToBootLoaderEntry"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("reboot-to-boot-loader-entry", "RebootToBootLoaderEntry", "RebootToBootLoaderEntry", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:boot-loader-entries:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.BootLoaderEntries">"BootLoaderEntries"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("boot-loader-entries", "BootLoaderEntries", "BootLoaderEntries", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:idle-hint:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.IdleHint">"IdleHint"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("idle-hint", "IdleHint", "IdleHint", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:idle-since-hint:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.IdleSinceHint">"IdleSinceHint"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("idle-since-hint", "IdleSinceHint", "IdleSinceHint", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:idle-since-hint-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.IdleSinceHintMonotonic">"IdleSinceHintMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("idle-since-hint-monotonic", "IdleSinceHintMonotonic", "IdleSinceHintMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:block-inhibited:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.BlockInhibited">"BlockInhibited"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("block-inhibited", "BlockInhibited", "BlockInhibited", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:delay-inhibited:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.DelayInhibited">"DelayInhibited"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("delay-inhibited", "DelayInhibited", "DelayInhibited", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:inhibit-delay-max-usec:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.InhibitDelayMaxUSec">"InhibitDelayMaxUSec"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("inhibit-delay-max-usec", "InhibitDelayMaxUSec", "InhibitDelayMaxUSec", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:user-stop-delay-usec:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.UserStopDelayUSec">"UserStopDelayUSec"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("user-stop-delay-usec", "UserStopDelayUSec", "UserStopDelayUSec", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:sleep-operation:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.SleepOperation">"SleepOperation"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("sleep-operation", "SleepOperation", "SleepOperation", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:handle-power-key:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandlePowerKey">"HandlePowerKey"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("handle-power-key", "HandlePowerKey", "HandlePowerKey", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:handle-power-key-long-press:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandlePowerKeyLongPress">"HandlePowerKeyLongPress"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("handle-power-key-long-press", "HandlePowerKeyLongPress", "HandlePowerKeyLongPress", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:handle-reboot-key:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleRebootKey">"HandleRebootKey"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("handle-reboot-key", "HandleRebootKey", "HandleRebootKey", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:handle-reboot-key-long-press:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleRebootKeyLongPress">"HandleRebootKeyLongPress"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("handle-reboot-key-long-press", "HandleRebootKeyLongPress", "HandleRebootKeyLongPress", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:handle-suspend-key:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleSuspendKey">"HandleSuspendKey"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("handle-suspend-key", "HandleSuspendKey", "HandleSuspendKey", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:handle-suspend-key-long-press:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleSuspendKeyLongPress">"HandleSuspendKeyLongPress"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("handle-suspend-key-long-press", "HandleSuspendKeyLongPress", "HandleSuspendKeyLongPress", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:handle-hibernate-key:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleHibernateKey">"HandleHibernateKey"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("handle-hibernate-key", "HandleHibernateKey", "HandleHibernateKey", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:handle-hibernate-key-long-press:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleHibernateKeyLongPress">"HandleHibernateKeyLongPress"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("handle-hibernate-key-long-press", "HandleHibernateKeyLongPress", "HandleHibernateKeyLongPress", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:handle-lid-switch:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleLidSwitch">"HandleLidSwitch"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("handle-lid-switch", "HandleLidSwitch", "HandleLidSwitch", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:handle-lid-switch-external-power:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleLidSwitchExternalPower">"HandleLidSwitchExternalPower"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("handle-lid-switch-external-power", "HandleLidSwitchExternalPower", "HandleLidSwitchExternalPower", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:handle-lid-switch-docked:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleLidSwitchDocked">"HandleLidSwitchDocked"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("handle-lid-switch-docked", "HandleLidSwitchDocked", "HandleLidSwitchDocked", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:holdoff-timeout-usec:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.HoldoffTimeoutUSec">"HoldoffTimeoutUSec"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("holdoff-timeout-usec", "HoldoffTimeoutUSec", "HoldoffTimeoutUSec", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:idle-action:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.IdleAction">"IdleAction"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("idle-action", "IdleAction", "IdleAction", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:idle-action-usec:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.IdleActionUSec">"IdleActionUSec"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("idle-action-usec", "IdleActionUSec", "IdleActionUSec", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:preparing-for-shutdown:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.PreparingForShutdown">"PreparingForShutdown"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("preparing-for-shutdown", "PreparingForShutdown", "PreparingForShutdown", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:preparing-for-sleep:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.PreparingForSleep">"PreparingForSleep"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("preparing-for-sleep", "PreparingForSleep", "PreparingForSleep", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:scheduled-shutdown:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.ScheduledShutdown">"ScheduledShutdown"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("scheduled-shutdown", "ScheduledShutdown", "ScheduledShutdown", G_VARIANT_TYPE ("(st)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:docked:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.Docked">"Docked"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("docked", "Docked", "Docked", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:lid-closed:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.LidClosed">"LidClosed"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("lid-closed", "LidClosed", "LidClosed", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:on-external-power:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.OnExternalPower">"OnExternalPower"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("on-external-power", "OnExternalPower", "OnExternalPower", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:remove-ipc:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.RemoveIPC">"RemoveIPC"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("remove-ipc", "RemoveIPC", "RemoveIPC", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:runtime-directory-size:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.RuntimeDirectorySize">"RuntimeDirectorySize"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("runtime-directory-size", "RuntimeDirectorySize", "RuntimeDirectorySize", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:runtime-directory-inodes-max:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.RuntimeDirectoryInodesMax">"RuntimeDirectoryInodesMax"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("runtime-directory-inodes-max", "RuntimeDirectoryInodesMax", "RuntimeDirectoryInodesMax", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:inhibitors-max:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.InhibitorsMax">"InhibitorsMax"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("inhibitors-max", "InhibitorsMax", "InhibitorsMax", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:ncurrent-inhibitors:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.NCurrentInhibitors">"NCurrentInhibitors"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("ncurrent-inhibitors", "NCurrentInhibitors", "NCurrentInhibitors", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:sessions-max:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.SessionsMax">"SessionsMax"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("sessions-max", "SessionsMax", "SessionsMax", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:ncurrent-sessions:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.NCurrentSessions">"NCurrentSessions"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("ncurrent-sessions", "NCurrentSessions", "NCurrentSessions", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Manager:stop-idle-session-usec:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Manager.StopIdleSessionUSec">"StopIdleSessionUSec"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("stop-idle-session-usec", "StopIdleSessionUSec", "StopIdleSessionUSec", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * meta_dbus_login1_manager_get_enable_wall_messages: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.EnableWallMessages">"EnableWallMessages"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
meta_dbus_login1_manager_get_enable_wall_messages (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), FALSE);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_enable_wall_messages (object);
}

/**
 * meta_dbus_login1_manager_set_enable_wall_messages: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.EnableWallMessages">"EnableWallMessages"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
meta_dbus_login1_manager_set_enable_wall_messages (MetaDBusLogin1Manager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "enable-wall-messages", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_wall_message: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.WallMessage">"WallMessage"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_wall_message() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_manager_get_wall_message (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_wall_message (object);
}

/**
 * meta_dbus_login1_manager_dup_wall_message: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.WallMessage">"WallMessage"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_manager_dup_wall_message (MetaDBusLogin1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "wall-message", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_wall_message: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.WallMessage">"WallMessage"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
meta_dbus_login1_manager_set_wall_message (MetaDBusLogin1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "wall-message", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_nauto_vts: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.NAutoVTs">"NAutoVTs"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
meta_dbus_login1_manager_get_nauto_vts (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), 0);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_nauto_vts (object);
}

/**
 * meta_dbus_login1_manager_set_nauto_vts: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.NAutoVTs">"NAutoVTs"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_nauto_vts (MetaDBusLogin1Manager *object, guint value)
{
  g_object_set (G_OBJECT (object), "nauto-vts", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_kill_only_users: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.KillOnlyUsers">"KillOnlyUsers"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_kill_only_users() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
meta_dbus_login1_manager_get_kill_only_users (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_kill_only_users (object);
}

/**
 * meta_dbus_login1_manager_dup_kill_only_users: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.KillOnlyUsers">"KillOnlyUsers"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
meta_dbus_login1_manager_dup_kill_only_users (MetaDBusLogin1Manager *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "kill-only-users", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_kill_only_users: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.KillOnlyUsers">"KillOnlyUsers"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_kill_only_users (MetaDBusLogin1Manager *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "kill-only-users", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_kill_exclude_users: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.KillExcludeUsers">"KillExcludeUsers"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_kill_exclude_users() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
meta_dbus_login1_manager_get_kill_exclude_users (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_kill_exclude_users (object);
}

/**
 * meta_dbus_login1_manager_dup_kill_exclude_users: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.KillExcludeUsers">"KillExcludeUsers"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
meta_dbus_login1_manager_dup_kill_exclude_users (MetaDBusLogin1Manager *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "kill-exclude-users", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_kill_exclude_users: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.KillExcludeUsers">"KillExcludeUsers"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_kill_exclude_users (MetaDBusLogin1Manager *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "kill-exclude-users", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_kill_user_processes: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.KillUserProcesses">"KillUserProcesses"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
meta_dbus_login1_manager_get_kill_user_processes (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), FALSE);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_kill_user_processes (object);
}

/**
 * meta_dbus_login1_manager_set_kill_user_processes: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.KillUserProcesses">"KillUserProcesses"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_kill_user_processes (MetaDBusLogin1Manager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "kill-user-processes", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_reboot_parameter: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.RebootParameter">"RebootParameter"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_reboot_parameter() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_manager_get_reboot_parameter (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_reboot_parameter (object);
}

/**
 * meta_dbus_login1_manager_dup_reboot_parameter: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.RebootParameter">"RebootParameter"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_manager_dup_reboot_parameter (MetaDBusLogin1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "reboot-parameter", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_reboot_parameter: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.RebootParameter">"RebootParameter"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_reboot_parameter (MetaDBusLogin1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "reboot-parameter", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_reboot_to_firmware_setup: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.RebootToFirmwareSetup">"RebootToFirmwareSetup"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
meta_dbus_login1_manager_get_reboot_to_firmware_setup (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), FALSE);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_reboot_to_firmware_setup (object);
}

/**
 * meta_dbus_login1_manager_set_reboot_to_firmware_setup: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.RebootToFirmwareSetup">"RebootToFirmwareSetup"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_reboot_to_firmware_setup (MetaDBusLogin1Manager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "reboot-to-firmware-setup", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_reboot_to_boot_loader_menu: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.RebootToBootLoaderMenu">"RebootToBootLoaderMenu"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
meta_dbus_login1_manager_get_reboot_to_boot_loader_menu (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), 0);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_reboot_to_boot_loader_menu (object);
}

/**
 * meta_dbus_login1_manager_set_reboot_to_boot_loader_menu: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.RebootToBootLoaderMenu">"RebootToBootLoaderMenu"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_reboot_to_boot_loader_menu (MetaDBusLogin1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "reboot-to-boot-loader-menu", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_reboot_to_boot_loader_entry: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.RebootToBootLoaderEntry">"RebootToBootLoaderEntry"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_reboot_to_boot_loader_entry() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_manager_get_reboot_to_boot_loader_entry (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_reboot_to_boot_loader_entry (object);
}

/**
 * meta_dbus_login1_manager_dup_reboot_to_boot_loader_entry: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.RebootToBootLoaderEntry">"RebootToBootLoaderEntry"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_manager_dup_reboot_to_boot_loader_entry (MetaDBusLogin1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "reboot-to-boot-loader-entry", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_reboot_to_boot_loader_entry: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.RebootToBootLoaderEntry">"RebootToBootLoaderEntry"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_reboot_to_boot_loader_entry (MetaDBusLogin1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "reboot-to-boot-loader-entry", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_boot_loader_entries: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.BootLoaderEntries">"BootLoaderEntries"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_boot_loader_entries() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
meta_dbus_login1_manager_get_boot_loader_entries (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_boot_loader_entries (object);
}

/**
 * meta_dbus_login1_manager_dup_boot_loader_entries: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.BootLoaderEntries">"BootLoaderEntries"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
meta_dbus_login1_manager_dup_boot_loader_entries (MetaDBusLogin1Manager *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "boot-loader-entries", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_boot_loader_entries: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.BootLoaderEntries">"BootLoaderEntries"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_boot_loader_entries (MetaDBusLogin1Manager *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "boot-loader-entries", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_idle_hint: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.IdleHint">"IdleHint"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
meta_dbus_login1_manager_get_idle_hint (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), FALSE);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_idle_hint (object);
}

/**
 * meta_dbus_login1_manager_set_idle_hint: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.IdleHint">"IdleHint"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_idle_hint (MetaDBusLogin1Manager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "idle-hint", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_idle_since_hint: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.IdleSinceHint">"IdleSinceHint"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
meta_dbus_login1_manager_get_idle_since_hint (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), 0);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_idle_since_hint (object);
}

/**
 * meta_dbus_login1_manager_set_idle_since_hint: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.IdleSinceHint">"IdleSinceHint"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_idle_since_hint (MetaDBusLogin1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "idle-since-hint", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_idle_since_hint_monotonic: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.IdleSinceHintMonotonic">"IdleSinceHintMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
meta_dbus_login1_manager_get_idle_since_hint_monotonic (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), 0);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_idle_since_hint_monotonic (object);
}

/**
 * meta_dbus_login1_manager_set_idle_since_hint_monotonic: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.IdleSinceHintMonotonic">"IdleSinceHintMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_idle_since_hint_monotonic (MetaDBusLogin1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "idle-since-hint-monotonic", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_block_inhibited: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.BlockInhibited">"BlockInhibited"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_block_inhibited() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_manager_get_block_inhibited (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_block_inhibited (object);
}

/**
 * meta_dbus_login1_manager_dup_block_inhibited: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.BlockInhibited">"BlockInhibited"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_manager_dup_block_inhibited (MetaDBusLogin1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "block-inhibited", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_block_inhibited: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.BlockInhibited">"BlockInhibited"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_block_inhibited (MetaDBusLogin1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "block-inhibited", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_delay_inhibited: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.DelayInhibited">"DelayInhibited"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_delay_inhibited() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_manager_get_delay_inhibited (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_delay_inhibited (object);
}

/**
 * meta_dbus_login1_manager_dup_delay_inhibited: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.DelayInhibited">"DelayInhibited"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_manager_dup_delay_inhibited (MetaDBusLogin1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "delay-inhibited", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_delay_inhibited: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.DelayInhibited">"DelayInhibited"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_delay_inhibited (MetaDBusLogin1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "delay-inhibited", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_inhibit_delay_max_usec: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.InhibitDelayMaxUSec">"InhibitDelayMaxUSec"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
meta_dbus_login1_manager_get_inhibit_delay_max_usec (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), 0);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_inhibit_delay_max_usec (object);
}

/**
 * meta_dbus_login1_manager_set_inhibit_delay_max_usec: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.InhibitDelayMaxUSec">"InhibitDelayMaxUSec"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_inhibit_delay_max_usec (MetaDBusLogin1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "inhibit-delay-max-usec", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_user_stop_delay_usec: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.UserStopDelayUSec">"UserStopDelayUSec"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
meta_dbus_login1_manager_get_user_stop_delay_usec (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), 0);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_user_stop_delay_usec (object);
}

/**
 * meta_dbus_login1_manager_set_user_stop_delay_usec: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.UserStopDelayUSec">"UserStopDelayUSec"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_user_stop_delay_usec (MetaDBusLogin1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "user-stop-delay-usec", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_sleep_operation: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.SleepOperation">"SleepOperation"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_sleep_operation() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
meta_dbus_login1_manager_get_sleep_operation (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_sleep_operation (object);
}

/**
 * meta_dbus_login1_manager_dup_sleep_operation: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.SleepOperation">"SleepOperation"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
meta_dbus_login1_manager_dup_sleep_operation (MetaDBusLogin1Manager *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "sleep-operation", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_sleep_operation: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.SleepOperation">"SleepOperation"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_sleep_operation (MetaDBusLogin1Manager *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "sleep-operation", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_handle_power_key: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandlePowerKey">"HandlePowerKey"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_handle_power_key() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_manager_get_handle_power_key (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_handle_power_key (object);
}

/**
 * meta_dbus_login1_manager_dup_handle_power_key: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandlePowerKey">"HandlePowerKey"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_manager_dup_handle_power_key (MetaDBusLogin1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "handle-power-key", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_handle_power_key: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandlePowerKey">"HandlePowerKey"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_handle_power_key (MetaDBusLogin1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "handle-power-key", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_handle_power_key_long_press: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandlePowerKeyLongPress">"HandlePowerKeyLongPress"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_handle_power_key_long_press() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_manager_get_handle_power_key_long_press (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_handle_power_key_long_press (object);
}

/**
 * meta_dbus_login1_manager_dup_handle_power_key_long_press: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandlePowerKeyLongPress">"HandlePowerKeyLongPress"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_manager_dup_handle_power_key_long_press (MetaDBusLogin1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "handle-power-key-long-press", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_handle_power_key_long_press: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandlePowerKeyLongPress">"HandlePowerKeyLongPress"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_handle_power_key_long_press (MetaDBusLogin1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "handle-power-key-long-press", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_handle_reboot_key: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleRebootKey">"HandleRebootKey"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_handle_reboot_key() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_manager_get_handle_reboot_key (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_handle_reboot_key (object);
}

/**
 * meta_dbus_login1_manager_dup_handle_reboot_key: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleRebootKey">"HandleRebootKey"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_manager_dup_handle_reboot_key (MetaDBusLogin1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "handle-reboot-key", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_handle_reboot_key: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleRebootKey">"HandleRebootKey"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_handle_reboot_key (MetaDBusLogin1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "handle-reboot-key", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_handle_reboot_key_long_press: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleRebootKeyLongPress">"HandleRebootKeyLongPress"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_handle_reboot_key_long_press() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_manager_get_handle_reboot_key_long_press (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_handle_reboot_key_long_press (object);
}

/**
 * meta_dbus_login1_manager_dup_handle_reboot_key_long_press: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleRebootKeyLongPress">"HandleRebootKeyLongPress"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_manager_dup_handle_reboot_key_long_press (MetaDBusLogin1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "handle-reboot-key-long-press", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_handle_reboot_key_long_press: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleRebootKeyLongPress">"HandleRebootKeyLongPress"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_handle_reboot_key_long_press (MetaDBusLogin1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "handle-reboot-key-long-press", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_handle_suspend_key: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleSuspendKey">"HandleSuspendKey"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_handle_suspend_key() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_manager_get_handle_suspend_key (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_handle_suspend_key (object);
}

/**
 * meta_dbus_login1_manager_dup_handle_suspend_key: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleSuspendKey">"HandleSuspendKey"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_manager_dup_handle_suspend_key (MetaDBusLogin1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "handle-suspend-key", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_handle_suspend_key: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleSuspendKey">"HandleSuspendKey"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_handle_suspend_key (MetaDBusLogin1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "handle-suspend-key", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_handle_suspend_key_long_press: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleSuspendKeyLongPress">"HandleSuspendKeyLongPress"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_handle_suspend_key_long_press() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_manager_get_handle_suspend_key_long_press (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_handle_suspend_key_long_press (object);
}

/**
 * meta_dbus_login1_manager_dup_handle_suspend_key_long_press: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleSuspendKeyLongPress">"HandleSuspendKeyLongPress"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_manager_dup_handle_suspend_key_long_press (MetaDBusLogin1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "handle-suspend-key-long-press", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_handle_suspend_key_long_press: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleSuspendKeyLongPress">"HandleSuspendKeyLongPress"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_handle_suspend_key_long_press (MetaDBusLogin1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "handle-suspend-key-long-press", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_handle_hibernate_key: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleHibernateKey">"HandleHibernateKey"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_handle_hibernate_key() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_manager_get_handle_hibernate_key (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_handle_hibernate_key (object);
}

/**
 * meta_dbus_login1_manager_dup_handle_hibernate_key: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleHibernateKey">"HandleHibernateKey"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_manager_dup_handle_hibernate_key (MetaDBusLogin1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "handle-hibernate-key", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_handle_hibernate_key: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleHibernateKey">"HandleHibernateKey"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_handle_hibernate_key (MetaDBusLogin1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "handle-hibernate-key", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_handle_hibernate_key_long_press: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleHibernateKeyLongPress">"HandleHibernateKeyLongPress"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_handle_hibernate_key_long_press() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_manager_get_handle_hibernate_key_long_press (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_handle_hibernate_key_long_press (object);
}

/**
 * meta_dbus_login1_manager_dup_handle_hibernate_key_long_press: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleHibernateKeyLongPress">"HandleHibernateKeyLongPress"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_manager_dup_handle_hibernate_key_long_press (MetaDBusLogin1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "handle-hibernate-key-long-press", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_handle_hibernate_key_long_press: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleHibernateKeyLongPress">"HandleHibernateKeyLongPress"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_handle_hibernate_key_long_press (MetaDBusLogin1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "handle-hibernate-key-long-press", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_handle_lid_switch: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleLidSwitch">"HandleLidSwitch"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_handle_lid_switch() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_manager_get_handle_lid_switch (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_handle_lid_switch (object);
}

/**
 * meta_dbus_login1_manager_dup_handle_lid_switch: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleLidSwitch">"HandleLidSwitch"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_manager_dup_handle_lid_switch (MetaDBusLogin1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "handle-lid-switch", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_handle_lid_switch: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleLidSwitch">"HandleLidSwitch"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_handle_lid_switch (MetaDBusLogin1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "handle-lid-switch", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_handle_lid_switch_external_power: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleLidSwitchExternalPower">"HandleLidSwitchExternalPower"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_handle_lid_switch_external_power() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_manager_get_handle_lid_switch_external_power (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_handle_lid_switch_external_power (object);
}

/**
 * meta_dbus_login1_manager_dup_handle_lid_switch_external_power: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleLidSwitchExternalPower">"HandleLidSwitchExternalPower"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_manager_dup_handle_lid_switch_external_power (MetaDBusLogin1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "handle-lid-switch-external-power", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_handle_lid_switch_external_power: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleLidSwitchExternalPower">"HandleLidSwitchExternalPower"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_handle_lid_switch_external_power (MetaDBusLogin1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "handle-lid-switch-external-power", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_handle_lid_switch_docked: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleLidSwitchDocked">"HandleLidSwitchDocked"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_handle_lid_switch_docked() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_manager_get_handle_lid_switch_docked (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_handle_lid_switch_docked (object);
}

/**
 * meta_dbus_login1_manager_dup_handle_lid_switch_docked: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleLidSwitchDocked">"HandleLidSwitchDocked"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_manager_dup_handle_lid_switch_docked (MetaDBusLogin1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "handle-lid-switch-docked", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_handle_lid_switch_docked: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HandleLidSwitchDocked">"HandleLidSwitchDocked"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_handle_lid_switch_docked (MetaDBusLogin1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "handle-lid-switch-docked", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_holdoff_timeout_usec: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HoldoffTimeoutUSec">"HoldoffTimeoutUSec"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
meta_dbus_login1_manager_get_holdoff_timeout_usec (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), 0);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_holdoff_timeout_usec (object);
}

/**
 * meta_dbus_login1_manager_set_holdoff_timeout_usec: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.HoldoffTimeoutUSec">"HoldoffTimeoutUSec"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_holdoff_timeout_usec (MetaDBusLogin1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "holdoff-timeout-usec", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_idle_action: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.IdleAction">"IdleAction"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_idle_action() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_manager_get_idle_action (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_idle_action (object);
}

/**
 * meta_dbus_login1_manager_dup_idle_action: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.IdleAction">"IdleAction"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_manager_dup_idle_action (MetaDBusLogin1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "idle-action", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_idle_action: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.IdleAction">"IdleAction"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_idle_action (MetaDBusLogin1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "idle-action", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_idle_action_usec: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.IdleActionUSec">"IdleActionUSec"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
meta_dbus_login1_manager_get_idle_action_usec (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), 0);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_idle_action_usec (object);
}

/**
 * meta_dbus_login1_manager_set_idle_action_usec: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.IdleActionUSec">"IdleActionUSec"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_idle_action_usec (MetaDBusLogin1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "idle-action-usec", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_preparing_for_shutdown: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.PreparingForShutdown">"PreparingForShutdown"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
meta_dbus_login1_manager_get_preparing_for_shutdown (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), FALSE);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_preparing_for_shutdown (object);
}

/**
 * meta_dbus_login1_manager_set_preparing_for_shutdown: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.PreparingForShutdown">"PreparingForShutdown"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_preparing_for_shutdown (MetaDBusLogin1Manager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "preparing-for-shutdown", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_preparing_for_sleep: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.PreparingForSleep">"PreparingForSleep"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
meta_dbus_login1_manager_get_preparing_for_sleep (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), FALSE);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_preparing_for_sleep (object);
}

/**
 * meta_dbus_login1_manager_set_preparing_for_sleep: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.PreparingForSleep">"PreparingForSleep"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_preparing_for_sleep (MetaDBusLogin1Manager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "preparing-for-sleep", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_scheduled_shutdown: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.ScheduledShutdown">"ScheduledShutdown"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_manager_dup_scheduled_shutdown() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
meta_dbus_login1_manager_get_scheduled_shutdown (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), NULL);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_scheduled_shutdown (object);
}

/**
 * meta_dbus_login1_manager_dup_scheduled_shutdown: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.ScheduledShutdown">"ScheduledShutdown"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
meta_dbus_login1_manager_dup_scheduled_shutdown (MetaDBusLogin1Manager *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "scheduled-shutdown", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_manager_set_scheduled_shutdown: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.ScheduledShutdown">"ScheduledShutdown"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_scheduled_shutdown (MetaDBusLogin1Manager *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "scheduled-shutdown", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_docked: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.Docked">"Docked"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
meta_dbus_login1_manager_get_docked (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), FALSE);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_docked (object);
}

/**
 * meta_dbus_login1_manager_set_docked: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.Docked">"Docked"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_docked (MetaDBusLogin1Manager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "docked", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_lid_closed: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.LidClosed">"LidClosed"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
meta_dbus_login1_manager_get_lid_closed (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), FALSE);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_lid_closed (object);
}

/**
 * meta_dbus_login1_manager_set_lid_closed: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.LidClosed">"LidClosed"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_lid_closed (MetaDBusLogin1Manager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "lid-closed", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_on_external_power: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.OnExternalPower">"OnExternalPower"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
meta_dbus_login1_manager_get_on_external_power (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), FALSE);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_on_external_power (object);
}

/**
 * meta_dbus_login1_manager_set_on_external_power: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.OnExternalPower">"OnExternalPower"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_on_external_power (MetaDBusLogin1Manager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "on-external-power", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_remove_ipc: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.RemoveIPC">"RemoveIPC"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
meta_dbus_login1_manager_get_remove_ipc (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), FALSE);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_remove_ipc (object);
}

/**
 * meta_dbus_login1_manager_set_remove_ipc: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.RemoveIPC">"RemoveIPC"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_remove_ipc (MetaDBusLogin1Manager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "remove-ipc", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_runtime_directory_size: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.RuntimeDirectorySize">"RuntimeDirectorySize"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
meta_dbus_login1_manager_get_runtime_directory_size (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), 0);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_runtime_directory_size (object);
}

/**
 * meta_dbus_login1_manager_set_runtime_directory_size: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.RuntimeDirectorySize">"RuntimeDirectorySize"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_runtime_directory_size (MetaDBusLogin1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "runtime-directory-size", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_runtime_directory_inodes_max: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.RuntimeDirectoryInodesMax">"RuntimeDirectoryInodesMax"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
meta_dbus_login1_manager_get_runtime_directory_inodes_max (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), 0);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_runtime_directory_inodes_max (object);
}

/**
 * meta_dbus_login1_manager_set_runtime_directory_inodes_max: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.RuntimeDirectoryInodesMax">"RuntimeDirectoryInodesMax"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_runtime_directory_inodes_max (MetaDBusLogin1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "runtime-directory-inodes-max", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_inhibitors_max: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.InhibitorsMax">"InhibitorsMax"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
meta_dbus_login1_manager_get_inhibitors_max (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), 0);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_inhibitors_max (object);
}

/**
 * meta_dbus_login1_manager_set_inhibitors_max: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.InhibitorsMax">"InhibitorsMax"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_inhibitors_max (MetaDBusLogin1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "inhibitors-max", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_ncurrent_inhibitors: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.NCurrentInhibitors">"NCurrentInhibitors"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
meta_dbus_login1_manager_get_ncurrent_inhibitors (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), 0);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_ncurrent_inhibitors (object);
}

/**
 * meta_dbus_login1_manager_set_ncurrent_inhibitors: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.NCurrentInhibitors">"NCurrentInhibitors"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_ncurrent_inhibitors (MetaDBusLogin1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "ncurrent-inhibitors", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_sessions_max: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.SessionsMax">"SessionsMax"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
meta_dbus_login1_manager_get_sessions_max (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), 0);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_sessions_max (object);
}

/**
 * meta_dbus_login1_manager_set_sessions_max: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.SessionsMax">"SessionsMax"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_sessions_max (MetaDBusLogin1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "sessions-max", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_ncurrent_sessions: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.NCurrentSessions">"NCurrentSessions"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
meta_dbus_login1_manager_get_ncurrent_sessions (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), 0);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_ncurrent_sessions (object);
}

/**
 * meta_dbus_login1_manager_set_ncurrent_sessions: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.NCurrentSessions">"NCurrentSessions"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_ncurrent_sessions (MetaDBusLogin1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "ncurrent-sessions", value, NULL);
}

/**
 * meta_dbus_login1_manager_get_stop_idle_session_usec: (skip)
 * @object: A #MetaDBusLogin1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Manager.StopIdleSessionUSec">"StopIdleSessionUSec"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
meta_dbus_login1_manager_get_stop_idle_session_usec (MetaDBusLogin1Manager *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_MANAGER (object), 0);

  return META_DBUS_LOGIN1_MANAGER_GET_IFACE (object)->get_stop_idle_session_usec (object);
}

/**
 * meta_dbus_login1_manager_set_stop_idle_session_usec: (skip)
 * @object: A #MetaDBusLogin1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Manager.StopIdleSessionUSec">"StopIdleSessionUSec"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_manager_set_stop_idle_session_usec (MetaDBusLogin1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "stop-idle-session-usec", value, NULL);
}

/**
 * meta_dbus_login1_manager_emit_session_new:
 * @object: A #MetaDBusLogin1Manager.
 * @arg_session_id: Argument to pass with the signal.
 * @arg_object_path: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-login1-Manager.SessionNew">"SessionNew"</link> D-Bus signal.
 */
void
meta_dbus_login1_manager_emit_session_new (
    MetaDBusLogin1Manager *object,
    const gchar *arg_session_id,
    const gchar *arg_object_path)
{
  g_signal_emit (object, META_DBUS__LOGIN1_MANAGER_SIGNALS[META_DBUS__LOGIN1_MANAGER_SESSION_NEW], 0, arg_session_id, arg_object_path);
}

/**
 * meta_dbus_login1_manager_emit_session_removed:
 * @object: A #MetaDBusLogin1Manager.
 * @arg_session_id: Argument to pass with the signal.
 * @arg_object_path: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-login1-Manager.SessionRemoved">"SessionRemoved"</link> D-Bus signal.
 */
void
meta_dbus_login1_manager_emit_session_removed (
    MetaDBusLogin1Manager *object,
    const gchar *arg_session_id,
    const gchar *arg_object_path)
{
  g_signal_emit (object, META_DBUS__LOGIN1_MANAGER_SIGNALS[META_DBUS__LOGIN1_MANAGER_SESSION_REMOVED], 0, arg_session_id, arg_object_path);
}

/**
 * meta_dbus_login1_manager_emit_user_new:
 * @object: A #MetaDBusLogin1Manager.
 * @arg_uid: Argument to pass with the signal.
 * @arg_object_path: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-login1-Manager.UserNew">"UserNew"</link> D-Bus signal.
 */
void
meta_dbus_login1_manager_emit_user_new (
    MetaDBusLogin1Manager *object,
    guint arg_uid,
    const gchar *arg_object_path)
{
  g_signal_emit (object, META_DBUS__LOGIN1_MANAGER_SIGNALS[META_DBUS__LOGIN1_MANAGER_USER_NEW], 0, arg_uid, arg_object_path);
}

/**
 * meta_dbus_login1_manager_emit_user_removed:
 * @object: A #MetaDBusLogin1Manager.
 * @arg_uid: Argument to pass with the signal.
 * @arg_object_path: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-login1-Manager.UserRemoved">"UserRemoved"</link> D-Bus signal.
 */
void
meta_dbus_login1_manager_emit_user_removed (
    MetaDBusLogin1Manager *object,
    guint arg_uid,
    const gchar *arg_object_path)
{
  g_signal_emit (object, META_DBUS__LOGIN1_MANAGER_SIGNALS[META_DBUS__LOGIN1_MANAGER_USER_REMOVED], 0, arg_uid, arg_object_path);
}

/**
 * meta_dbus_login1_manager_emit_seat_new:
 * @object: A #MetaDBusLogin1Manager.
 * @arg_seat_id: Argument to pass with the signal.
 * @arg_object_path: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-login1-Manager.SeatNew">"SeatNew"</link> D-Bus signal.
 */
void
meta_dbus_login1_manager_emit_seat_new (
    MetaDBusLogin1Manager *object,
    const gchar *arg_seat_id,
    const gchar *arg_object_path)
{
  g_signal_emit (object, META_DBUS__LOGIN1_MANAGER_SIGNALS[META_DBUS__LOGIN1_MANAGER_SEAT_NEW], 0, arg_seat_id, arg_object_path);
}

/**
 * meta_dbus_login1_manager_emit_seat_removed:
 * @object: A #MetaDBusLogin1Manager.
 * @arg_seat_id: Argument to pass with the signal.
 * @arg_object_path: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-login1-Manager.SeatRemoved">"SeatRemoved"</link> D-Bus signal.
 */
void
meta_dbus_login1_manager_emit_seat_removed (
    MetaDBusLogin1Manager *object,
    const gchar *arg_seat_id,
    const gchar *arg_object_path)
{
  g_signal_emit (object, META_DBUS__LOGIN1_MANAGER_SIGNALS[META_DBUS__LOGIN1_MANAGER_SEAT_REMOVED], 0, arg_seat_id, arg_object_path);
}

/**
 * meta_dbus_login1_manager_emit_prepare_for_shutdown:
 * @object: A #MetaDBusLogin1Manager.
 * @arg_start: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-login1-Manager.PrepareForShutdown">"PrepareForShutdown"</link> D-Bus signal.
 */
void
meta_dbus_login1_manager_emit_prepare_for_shutdown (
    MetaDBusLogin1Manager *object,
    gboolean arg_start)
{
  g_signal_emit (object, META_DBUS__LOGIN1_MANAGER_SIGNALS[META_DBUS__LOGIN1_MANAGER_PREPARE_FOR_SHUTDOWN], 0, arg_start);
}

/**
 * meta_dbus_login1_manager_emit_prepare_for_shutdown_with_metadata:
 * @object: A #MetaDBusLogin1Manager.
 * @arg_start: Argument to pass with the signal.
 * @arg_metadata: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-login1-Manager.PrepareForShutdownWithMetadata">"PrepareForShutdownWithMetadata"</link> D-Bus signal.
 */
void
meta_dbus_login1_manager_emit_prepare_for_shutdown_with_metadata (
    MetaDBusLogin1Manager *object,
    gboolean arg_start,
    GVariant *arg_metadata)
{
  g_signal_emit (object, META_DBUS__LOGIN1_MANAGER_SIGNALS[META_DBUS__LOGIN1_MANAGER_PREPARE_FOR_SHUTDOWN_WITH_METADATA], 0, arg_start, arg_metadata);
}

/**
 * meta_dbus_login1_manager_emit_prepare_for_sleep:
 * @object: A #MetaDBusLogin1Manager.
 * @arg_start: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-login1-Manager.PrepareForSleep">"PrepareForSleep"</link> D-Bus signal.
 */
void
meta_dbus_login1_manager_emit_prepare_for_sleep (
    MetaDBusLogin1Manager *object,
    gboolean arg_start)
{
  g_signal_emit (object, META_DBUS__LOGIN1_MANAGER_SIGNALS[META_DBUS__LOGIN1_MANAGER_PREPARE_FOR_SLEEP], 0, arg_start);
}

/**
 * meta_dbus_login1_manager_call_get_session:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_session_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.GetSession">GetSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_get_session_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_get_session_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_get_session (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_session_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetSession",
    g_variant_new ("(s)",
                   arg_session_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_get_session_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_object_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_get_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_get_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_get_session_finish (
    MetaDBusLogin1Manager *proxy,
    gchar **out_object_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_object_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_get_session_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_session_id: Argument to pass with the method invocation.
 * @out_object_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.GetSession">GetSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_get_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_get_session_sync (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_session_id,
    gchar **out_object_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetSession",
    g_variant_new ("(s)",
                   arg_session_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_object_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_get_session_by_pid:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_pid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.GetSessionByPID">GetSessionByPID()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_get_session_by_pid_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_get_session_by_pid_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_get_session_by_pid (
    MetaDBusLogin1Manager *proxy,
    guint arg_pid,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetSessionByPID",
    g_variant_new ("(u)",
                   arg_pid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_get_session_by_pid_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_object_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_get_session_by_pid().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_get_session_by_pid().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_get_session_by_pid_finish (
    MetaDBusLogin1Manager *proxy,
    gchar **out_object_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_object_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_get_session_by_pid_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_pid: Argument to pass with the method invocation.
 * @out_object_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.GetSessionByPID">GetSessionByPID()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_get_session_by_pid() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_get_session_by_pid_sync (
    MetaDBusLogin1Manager *proxy,
    guint arg_pid,
    gchar **out_object_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetSessionByPID",
    g_variant_new ("(u)",
                   arg_pid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_object_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_get_user:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_uid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.GetUser">GetUser()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_get_user_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_get_user_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_get_user (
    MetaDBusLogin1Manager *proxy,
    guint arg_uid,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetUser",
    g_variant_new ("(u)",
                   arg_uid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_get_user_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_object_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_get_user().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_get_user().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_get_user_finish (
    MetaDBusLogin1Manager *proxy,
    gchar **out_object_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_object_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_get_user_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_uid: Argument to pass with the method invocation.
 * @out_object_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.GetUser">GetUser()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_get_user() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_get_user_sync (
    MetaDBusLogin1Manager *proxy,
    guint arg_uid,
    gchar **out_object_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetUser",
    g_variant_new ("(u)",
                   arg_uid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_object_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_get_user_by_pid:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_pid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.GetUserByPID">GetUserByPID()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_get_user_by_pid_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_get_user_by_pid_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_get_user_by_pid (
    MetaDBusLogin1Manager *proxy,
    guint arg_pid,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetUserByPID",
    g_variant_new ("(u)",
                   arg_pid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_get_user_by_pid_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_object_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_get_user_by_pid().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_get_user_by_pid().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_get_user_by_pid_finish (
    MetaDBusLogin1Manager *proxy,
    gchar **out_object_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_object_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_get_user_by_pid_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_pid: Argument to pass with the method invocation.
 * @out_object_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.GetUserByPID">GetUserByPID()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_get_user_by_pid() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_get_user_by_pid_sync (
    MetaDBusLogin1Manager *proxy,
    guint arg_pid,
    gchar **out_object_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetUserByPID",
    g_variant_new ("(u)",
                   arg_pid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_object_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_get_seat:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_seat_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.GetSeat">GetSeat()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_get_seat_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_get_seat_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_get_seat (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_seat_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetSeat",
    g_variant_new ("(s)",
                   arg_seat_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_get_seat_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_object_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_get_seat().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_get_seat().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_get_seat_finish (
    MetaDBusLogin1Manager *proxy,
    gchar **out_object_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_object_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_get_seat_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_seat_id: Argument to pass with the method invocation.
 * @out_object_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.GetSeat">GetSeat()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_get_seat() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_get_seat_sync (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_seat_id,
    gchar **out_object_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetSeat",
    g_variant_new ("(s)",
                   arg_seat_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_object_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_list_sessions:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ListSessions">ListSessions()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_list_sessions_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_list_sessions_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_list_sessions (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListSessions",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_list_sessions_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_sessions: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_list_sessions().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_list_sessions().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_list_sessions_finish (
    MetaDBusLogin1Manager *proxy,
    GVariant **out_sessions,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(susso))",
                 out_sessions);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_list_sessions_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_sessions: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ListSessions">ListSessions()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_list_sessions() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_list_sessions_sync (
    MetaDBusLogin1Manager *proxy,
    GVariant **out_sessions,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListSessions",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(susso))",
                 out_sessions);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_list_sessions_ex:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ListSessionsEx">ListSessionsEx()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_list_sessions_ex_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_list_sessions_ex_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_list_sessions_ex (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListSessionsEx",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_list_sessions_ex_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_sessions: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_list_sessions_ex().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_list_sessions_ex().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_list_sessions_ex_finish (
    MetaDBusLogin1Manager *proxy,
    GVariant **out_sessions,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sussussbto))",
                 out_sessions);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_list_sessions_ex_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_sessions: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ListSessionsEx">ListSessionsEx()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_list_sessions_ex() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_list_sessions_ex_sync (
    MetaDBusLogin1Manager *proxy,
    GVariant **out_sessions,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListSessionsEx",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sussussbto))",
                 out_sessions);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_list_users:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ListUsers">ListUsers()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_list_users_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_list_users_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_list_users (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListUsers",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_list_users_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_users: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_list_users().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_list_users().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_list_users_finish (
    MetaDBusLogin1Manager *proxy,
    GVariant **out_users,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(uso))",
                 out_users);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_list_users_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_users: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ListUsers">ListUsers()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_list_users() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_list_users_sync (
    MetaDBusLogin1Manager *proxy,
    GVariant **out_users,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListUsers",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(uso))",
                 out_users);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_list_seats:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ListSeats">ListSeats()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_list_seats_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_list_seats_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_list_seats (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListSeats",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_list_seats_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_seats: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_list_seats().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_list_seats().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_list_seats_finish (
    MetaDBusLogin1Manager *proxy,
    GVariant **out_seats,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(so))",
                 out_seats);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_list_seats_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_seats: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ListSeats">ListSeats()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_list_seats() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_list_seats_sync (
    MetaDBusLogin1Manager *proxy,
    GVariant **out_seats,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListSeats",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(so))",
                 out_seats);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_list_inhibitors:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ListInhibitors">ListInhibitors()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_list_inhibitors_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_list_inhibitors_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_list_inhibitors (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListInhibitors",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_list_inhibitors_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_inhibitors: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_list_inhibitors().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_list_inhibitors().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_list_inhibitors_finish (
    MetaDBusLogin1Manager *proxy,
    GVariant **out_inhibitors,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ssssuu))",
                 out_inhibitors);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_list_inhibitors_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_inhibitors: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ListInhibitors">ListInhibitors()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_list_inhibitors() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_list_inhibitors_sync (
    MetaDBusLogin1Manager *proxy,
    GVariant **out_inhibitors,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListInhibitors",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ssssuu))",
                 out_inhibitors);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_create_session:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_uid: Argument to pass with the method invocation.
 * @arg_pid: Argument to pass with the method invocation.
 * @arg_service: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_class: Argument to pass with the method invocation.
 * @arg_desktop: Argument to pass with the method invocation.
 * @arg_seat_id: Argument to pass with the method invocation.
 * @arg_vtnr: Argument to pass with the method invocation.
 * @arg_tty: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_remote: Argument to pass with the method invocation.
 * @arg_remote_user: Argument to pass with the method invocation.
 * @arg_remote_host: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CreateSession">CreateSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_create_session_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_create_session_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_create_session (
    MetaDBusLogin1Manager *proxy,
    guint arg_uid,
    guint arg_pid,
    const gchar *arg_service,
    const gchar *arg_type,
    const gchar *arg_class,
    const gchar *arg_desktop,
    const gchar *arg_seat_id,
    guint arg_vtnr,
    const gchar *arg_tty,
    const gchar *arg_display,
    gboolean arg_remote,
    const gchar *arg_remote_user,
    const gchar *arg_remote_host,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("(uusssssussbss@a(sv))",
                   arg_uid,
                   arg_pid,
                   arg_service,
                   arg_type,
                   arg_class,
                   arg_desktop,
                   arg_seat_id,
                   arg_vtnr,
                   arg_tty,
                   arg_display,
                   arg_remote,
                   arg_remote_user,
                   arg_remote_host,
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_create_session_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_session_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_object_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_runtime_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fifo_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_uid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_seat_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_vtnr: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_existing: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_create_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_create_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_create_session_finish (
    MetaDBusLogin1Manager *proxy,
    gchar **out_session_id,
    gchar **out_object_path,
    gchar **out_runtime_path,
    GVariant **out_fifo_fd,
    guint *out_uid,
    gchar **out_seat_id,
    guint *out_vtnr,
    gboolean *out_existing,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(sos@husub)",
                 out_session_id,
                 out_object_path,
                 out_runtime_path,
                 out_fifo_fd,
                 out_uid,
                 out_seat_id,
                 out_vtnr,
                 out_existing);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_create_session_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_uid: Argument to pass with the method invocation.
 * @arg_pid: Argument to pass with the method invocation.
 * @arg_service: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_class: Argument to pass with the method invocation.
 * @arg_desktop: Argument to pass with the method invocation.
 * @arg_seat_id: Argument to pass with the method invocation.
 * @arg_vtnr: Argument to pass with the method invocation.
 * @arg_tty: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_remote: Argument to pass with the method invocation.
 * @arg_remote_user: Argument to pass with the method invocation.
 * @arg_remote_host: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @out_session_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_object_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_runtime_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fifo_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_uid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_seat_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_vtnr: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_existing: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CreateSession">CreateSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_create_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_create_session_sync (
    MetaDBusLogin1Manager *proxy,
    guint arg_uid,
    guint arg_pid,
    const gchar *arg_service,
    const gchar *arg_type,
    const gchar *arg_class,
    const gchar *arg_desktop,
    const gchar *arg_seat_id,
    guint arg_vtnr,
    const gchar *arg_tty,
    const gchar *arg_display,
    gboolean arg_remote,
    const gchar *arg_remote_user,
    const gchar *arg_remote_host,
    GVariant *arg_properties,
    gchar **out_session_id,
    gchar **out_object_path,
    gchar **out_runtime_path,
    GVariant **out_fifo_fd,
    guint *out_uid,
    gchar **out_seat_id,
    guint *out_vtnr,
    gboolean *out_existing,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("(uusssssussbss@a(sv))",
                   arg_uid,
                   arg_pid,
                   arg_service,
                   arg_type,
                   arg_class,
                   arg_desktop,
                   arg_seat_id,
                   arg_vtnr,
                   arg_tty,
                   arg_display,
                   arg_remote,
                   arg_remote_user,
                   arg_remote_host,
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(sos@husub)",
                 out_session_id,
                 out_object_path,
                 out_runtime_path,
                 out_fifo_fd,
                 out_uid,
                 out_seat_id,
                 out_vtnr,
                 out_existing);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_create_session_with_pidfd:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_uid: Argument to pass with the method invocation.
 * @arg_pidfd: Argument to pass with the method invocation.
 * @arg_service: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_class: Argument to pass with the method invocation.
 * @arg_desktop: Argument to pass with the method invocation.
 * @arg_seat_id: Argument to pass with the method invocation.
 * @arg_vtnr: Argument to pass with the method invocation.
 * @arg_tty: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_remote: Argument to pass with the method invocation.
 * @arg_remote_user: Argument to pass with the method invocation.
 * @arg_remote_host: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CreateSessionWithPIDFD">CreateSessionWithPIDFD()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_create_session_with_pidfd_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_create_session_with_pidfd_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_create_session_with_pidfd (
    MetaDBusLogin1Manager *proxy,
    guint arg_uid,
    GVariant *arg_pidfd,
    const gchar *arg_service,
    const gchar *arg_type,
    const gchar *arg_class,
    const gchar *arg_desktop,
    const gchar *arg_seat_id,
    guint arg_vtnr,
    const gchar *arg_tty,
    const gchar *arg_display,
    gboolean arg_remote,
    const gchar *arg_remote_user,
    const gchar *arg_remote_host,
    guint64 arg_flags,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateSessionWithPIDFD",
    g_variant_new ("(u@hsssssussbsst@a(sv))",
                   arg_uid,
                   arg_pidfd,
                   arg_service,
                   arg_type,
                   arg_class,
                   arg_desktop,
                   arg_seat_id,
                   arg_vtnr,
                   arg_tty,
                   arg_display,
                   arg_remote,
                   arg_remote_user,
                   arg_remote_host,
                   arg_flags,
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_create_session_with_pidfd_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_session_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_object_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_runtime_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fifo_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_uid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_seat_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_vtnr: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_existing: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_create_session_with_pidfd().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_create_session_with_pidfd().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_create_session_with_pidfd_finish (
    MetaDBusLogin1Manager *proxy,
    gchar **out_session_id,
    gchar **out_object_path,
    gchar **out_runtime_path,
    GVariant **out_fifo_fd,
    guint *out_uid,
    gchar **out_seat_id,
    guint *out_vtnr,
    gboolean *out_existing,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(sos@husub)",
                 out_session_id,
                 out_object_path,
                 out_runtime_path,
                 out_fifo_fd,
                 out_uid,
                 out_seat_id,
                 out_vtnr,
                 out_existing);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_create_session_with_pidfd_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_uid: Argument to pass with the method invocation.
 * @arg_pidfd: Argument to pass with the method invocation.
 * @arg_service: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_class: Argument to pass with the method invocation.
 * @arg_desktop: Argument to pass with the method invocation.
 * @arg_seat_id: Argument to pass with the method invocation.
 * @arg_vtnr: Argument to pass with the method invocation.
 * @arg_tty: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_remote: Argument to pass with the method invocation.
 * @arg_remote_user: Argument to pass with the method invocation.
 * @arg_remote_host: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @out_session_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_object_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_runtime_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fifo_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_uid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_seat_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_vtnr: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_existing: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CreateSessionWithPIDFD">CreateSessionWithPIDFD()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_create_session_with_pidfd() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_create_session_with_pidfd_sync (
    MetaDBusLogin1Manager *proxy,
    guint arg_uid,
    GVariant *arg_pidfd,
    const gchar *arg_service,
    const gchar *arg_type,
    const gchar *arg_class,
    const gchar *arg_desktop,
    const gchar *arg_seat_id,
    guint arg_vtnr,
    const gchar *arg_tty,
    const gchar *arg_display,
    gboolean arg_remote,
    const gchar *arg_remote_user,
    const gchar *arg_remote_host,
    guint64 arg_flags,
    GVariant *arg_properties,
    gchar **out_session_id,
    gchar **out_object_path,
    gchar **out_runtime_path,
    GVariant **out_fifo_fd,
    guint *out_uid,
    gchar **out_seat_id,
    guint *out_vtnr,
    gboolean *out_existing,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateSessionWithPIDFD",
    g_variant_new ("(u@hsssssussbsst@a(sv))",
                   arg_uid,
                   arg_pidfd,
                   arg_service,
                   arg_type,
                   arg_class,
                   arg_desktop,
                   arg_seat_id,
                   arg_vtnr,
                   arg_tty,
                   arg_display,
                   arg_remote,
                   arg_remote_user,
                   arg_remote_host,
                   arg_flags,
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(sos@husub)",
                 out_session_id,
                 out_object_path,
                 out_runtime_path,
                 out_fifo_fd,
                 out_uid,
                 out_seat_id,
                 out_vtnr,
                 out_existing);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_release_session:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_session_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ReleaseSession">ReleaseSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_release_session_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_release_session_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_release_session (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_session_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReleaseSession",
    g_variant_new ("(s)",
                   arg_session_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_release_session_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_release_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_release_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_release_session_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_release_session_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_session_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ReleaseSession">ReleaseSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_release_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_release_session_sync (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_session_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReleaseSession",
    g_variant_new ("(s)",
                   arg_session_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_activate_session:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_session_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ActivateSession">ActivateSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_activate_session_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_activate_session_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_activate_session (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_session_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ActivateSession",
    g_variant_new ("(s)",
                   arg_session_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_activate_session_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_activate_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_activate_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_activate_session_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_activate_session_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_session_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ActivateSession">ActivateSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_activate_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_activate_session_sync (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_session_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ActivateSession",
    g_variant_new ("(s)",
                   arg_session_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_activate_session_on_seat:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_session_id: Argument to pass with the method invocation.
 * @arg_seat_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ActivateSessionOnSeat">ActivateSessionOnSeat()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_activate_session_on_seat_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_activate_session_on_seat_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_activate_session_on_seat (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_session_id,
    const gchar *arg_seat_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ActivateSessionOnSeat",
    g_variant_new ("(ss)",
                   arg_session_id,
                   arg_seat_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_activate_session_on_seat_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_activate_session_on_seat().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_activate_session_on_seat().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_activate_session_on_seat_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_activate_session_on_seat_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_session_id: Argument to pass with the method invocation.
 * @arg_seat_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ActivateSessionOnSeat">ActivateSessionOnSeat()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_activate_session_on_seat() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_activate_session_on_seat_sync (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_session_id,
    const gchar *arg_seat_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ActivateSessionOnSeat",
    g_variant_new ("(ss)",
                   arg_session_id,
                   arg_seat_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_lock_session:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_session_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.LockSession">LockSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_lock_session_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_lock_session_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_lock_session (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_session_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "LockSession",
    g_variant_new ("(s)",
                   arg_session_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_lock_session_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_lock_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_lock_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_lock_session_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_lock_session_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_session_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.LockSession">LockSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_lock_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_lock_session_sync (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_session_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "LockSession",
    g_variant_new ("(s)",
                   arg_session_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_unlock_session:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_session_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.UnlockSession">UnlockSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_unlock_session_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_unlock_session_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_unlock_session (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_session_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UnlockSession",
    g_variant_new ("(s)",
                   arg_session_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_unlock_session_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_unlock_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_unlock_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_unlock_session_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_unlock_session_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_session_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.UnlockSession">UnlockSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_unlock_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_unlock_session_sync (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_session_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UnlockSession",
    g_variant_new ("(s)",
                   arg_session_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_lock_sessions:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.LockSessions">LockSessions()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_lock_sessions_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_lock_sessions_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_lock_sessions (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "LockSessions",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_lock_sessions_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_lock_sessions().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_lock_sessions().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_lock_sessions_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_lock_sessions_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.LockSessions">LockSessions()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_lock_sessions() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_lock_sessions_sync (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "LockSessions",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_unlock_sessions:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.UnlockSessions">UnlockSessions()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_unlock_sessions_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_unlock_sessions_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_unlock_sessions (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UnlockSessions",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_unlock_sessions_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_unlock_sessions().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_unlock_sessions().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_unlock_sessions_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_unlock_sessions_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.UnlockSessions">UnlockSessions()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_unlock_sessions() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_unlock_sessions_sync (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UnlockSessions",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_kill_session:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_session_id: Argument to pass with the method invocation.
 * @arg_who: Argument to pass with the method invocation.
 * @arg_signal_number: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.KillSession">KillSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_kill_session_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_kill_session_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_kill_session (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_session_id,
    const gchar *arg_who,
    gint arg_signal_number,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "KillSession",
    g_variant_new ("(ssi)",
                   arg_session_id,
                   arg_who,
                   arg_signal_number),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_kill_session_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_kill_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_kill_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_kill_session_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_kill_session_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_session_id: Argument to pass with the method invocation.
 * @arg_who: Argument to pass with the method invocation.
 * @arg_signal_number: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.KillSession">KillSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_kill_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_kill_session_sync (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_session_id,
    const gchar *arg_who,
    gint arg_signal_number,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "KillSession",
    g_variant_new ("(ssi)",
                   arg_session_id,
                   arg_who,
                   arg_signal_number),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_kill_user:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_uid: Argument to pass with the method invocation.
 * @arg_signal_number: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.KillUser">KillUser()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_kill_user_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_kill_user_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_kill_user (
    MetaDBusLogin1Manager *proxy,
    guint arg_uid,
    gint arg_signal_number,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "KillUser",
    g_variant_new ("(ui)",
                   arg_uid,
                   arg_signal_number),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_kill_user_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_kill_user().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_kill_user().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_kill_user_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_kill_user_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_uid: Argument to pass with the method invocation.
 * @arg_signal_number: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.KillUser">KillUser()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_kill_user() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_kill_user_sync (
    MetaDBusLogin1Manager *proxy,
    guint arg_uid,
    gint arg_signal_number,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "KillUser",
    g_variant_new ("(ui)",
                   arg_uid,
                   arg_signal_number),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_terminate_session:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_session_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.TerminateSession">TerminateSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_terminate_session_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_terminate_session_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_terminate_session (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_session_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "TerminateSession",
    g_variant_new ("(s)",
                   arg_session_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_terminate_session_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_terminate_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_terminate_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_terminate_session_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_terminate_session_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_session_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.TerminateSession">TerminateSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_terminate_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_terminate_session_sync (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_session_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "TerminateSession",
    g_variant_new ("(s)",
                   arg_session_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_terminate_user:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_uid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.TerminateUser">TerminateUser()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_terminate_user_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_terminate_user_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_terminate_user (
    MetaDBusLogin1Manager *proxy,
    guint arg_uid,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "TerminateUser",
    g_variant_new ("(u)",
                   arg_uid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_terminate_user_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_terminate_user().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_terminate_user().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_terminate_user_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_terminate_user_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_uid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.TerminateUser">TerminateUser()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_terminate_user() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_terminate_user_sync (
    MetaDBusLogin1Manager *proxy,
    guint arg_uid,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "TerminateUser",
    g_variant_new ("(u)",
                   arg_uid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_terminate_seat:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_seat_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.TerminateSeat">TerminateSeat()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_terminate_seat_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_terminate_seat_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_terminate_seat (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_seat_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "TerminateSeat",
    g_variant_new ("(s)",
                   arg_seat_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_terminate_seat_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_terminate_seat().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_terminate_seat().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_terminate_seat_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_terminate_seat_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_seat_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.TerminateSeat">TerminateSeat()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_terminate_seat() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_terminate_seat_sync (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_seat_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "TerminateSeat",
    g_variant_new ("(s)",
                   arg_seat_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_set_user_linger:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_uid: Argument to pass with the method invocation.
 * @arg_enable: Argument to pass with the method invocation.
 * @arg_interactive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetUserLinger">SetUserLinger()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_set_user_linger_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_set_user_linger_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_set_user_linger (
    MetaDBusLogin1Manager *proxy,
    guint arg_uid,
    gboolean arg_enable,
    gboolean arg_interactive,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetUserLinger",
    g_variant_new ("(ubb)",
                   arg_uid,
                   arg_enable,
                   arg_interactive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_set_user_linger_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_set_user_linger().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_set_user_linger().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_set_user_linger_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_set_user_linger_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_uid: Argument to pass with the method invocation.
 * @arg_enable: Argument to pass with the method invocation.
 * @arg_interactive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetUserLinger">SetUserLinger()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_set_user_linger() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_set_user_linger_sync (
    MetaDBusLogin1Manager *proxy,
    guint arg_uid,
    gboolean arg_enable,
    gboolean arg_interactive,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetUserLinger",
    g_variant_new ("(ubb)",
                   arg_uid,
                   arg_enable,
                   arg_interactive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_attach_device:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_seat_id: Argument to pass with the method invocation.
 * @arg_sysfs_path: Argument to pass with the method invocation.
 * @arg_interactive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.AttachDevice">AttachDevice()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_attach_device_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_attach_device_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_attach_device (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_seat_id,
    const gchar *arg_sysfs_path,
    gboolean arg_interactive,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AttachDevice",
    g_variant_new ("(ssb)",
                   arg_seat_id,
                   arg_sysfs_path,
                   arg_interactive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_attach_device_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_attach_device().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_attach_device().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_attach_device_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_attach_device_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_seat_id: Argument to pass with the method invocation.
 * @arg_sysfs_path: Argument to pass with the method invocation.
 * @arg_interactive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.AttachDevice">AttachDevice()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_attach_device() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_attach_device_sync (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_seat_id,
    const gchar *arg_sysfs_path,
    gboolean arg_interactive,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AttachDevice",
    g_variant_new ("(ssb)",
                   arg_seat_id,
                   arg_sysfs_path,
                   arg_interactive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_flush_devices:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_interactive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.FlushDevices">FlushDevices()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_flush_devices_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_flush_devices_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_flush_devices (
    MetaDBusLogin1Manager *proxy,
    gboolean arg_interactive,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "FlushDevices",
    g_variant_new ("(b)",
                   arg_interactive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_flush_devices_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_flush_devices().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_flush_devices().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_flush_devices_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_flush_devices_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_interactive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.FlushDevices">FlushDevices()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_flush_devices() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_flush_devices_sync (
    MetaDBusLogin1Manager *proxy,
    gboolean arg_interactive,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "FlushDevices",
    g_variant_new ("(b)",
                   arg_interactive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_power_off:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_interactive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.PowerOff">PowerOff()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_power_off_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_power_off_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_power_off (
    MetaDBusLogin1Manager *proxy,
    gboolean arg_interactive,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PowerOff",
    g_variant_new ("(b)",
                   arg_interactive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_power_off_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_power_off().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_power_off().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_power_off_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_power_off_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_interactive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.PowerOff">PowerOff()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_power_off() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_power_off_sync (
    MetaDBusLogin1Manager *proxy,
    gboolean arg_interactive,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PowerOff",
    g_variant_new ("(b)",
                   arg_interactive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_power_off_with_flags:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.PowerOffWithFlags">PowerOffWithFlags()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_power_off_with_flags_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_power_off_with_flags_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_power_off_with_flags (
    MetaDBusLogin1Manager *proxy,
    guint64 arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PowerOffWithFlags",
    g_variant_new ("(t)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_power_off_with_flags_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_power_off_with_flags().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_power_off_with_flags().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_power_off_with_flags_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_power_off_with_flags_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.PowerOffWithFlags">PowerOffWithFlags()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_power_off_with_flags() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_power_off_with_flags_sync (
    MetaDBusLogin1Manager *proxy,
    guint64 arg_flags,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PowerOffWithFlags",
    g_variant_new ("(t)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_reboot:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_interactive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Reboot">Reboot()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_reboot_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_reboot_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_reboot (
    MetaDBusLogin1Manager *proxy,
    gboolean arg_interactive,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Reboot",
    g_variant_new ("(b)",
                   arg_interactive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_reboot_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_reboot().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_reboot().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_reboot_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_reboot_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_interactive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Reboot">Reboot()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_reboot() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_reboot_sync (
    MetaDBusLogin1Manager *proxy,
    gboolean arg_interactive,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Reboot",
    g_variant_new ("(b)",
                   arg_interactive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_reboot_with_flags:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.RebootWithFlags">RebootWithFlags()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_reboot_with_flags_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_reboot_with_flags_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_reboot_with_flags (
    MetaDBusLogin1Manager *proxy,
    guint64 arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RebootWithFlags",
    g_variant_new ("(t)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_reboot_with_flags_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_reboot_with_flags().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_reboot_with_flags().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_reboot_with_flags_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_reboot_with_flags_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.RebootWithFlags">RebootWithFlags()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_reboot_with_flags() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_reboot_with_flags_sync (
    MetaDBusLogin1Manager *proxy,
    guint64 arg_flags,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RebootWithFlags",
    g_variant_new ("(t)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_halt:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_interactive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Halt">Halt()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_halt_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_halt_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_halt (
    MetaDBusLogin1Manager *proxy,
    gboolean arg_interactive,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Halt",
    g_variant_new ("(b)",
                   arg_interactive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_halt_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_halt().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_halt().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_halt_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_halt_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_interactive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Halt">Halt()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_halt() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_halt_sync (
    MetaDBusLogin1Manager *proxy,
    gboolean arg_interactive,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Halt",
    g_variant_new ("(b)",
                   arg_interactive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_halt_with_flags:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.HaltWithFlags">HaltWithFlags()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_halt_with_flags_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_halt_with_flags_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_halt_with_flags (
    MetaDBusLogin1Manager *proxy,
    guint64 arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "HaltWithFlags",
    g_variant_new ("(t)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_halt_with_flags_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_halt_with_flags().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_halt_with_flags().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_halt_with_flags_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_halt_with_flags_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.HaltWithFlags">HaltWithFlags()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_halt_with_flags() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_halt_with_flags_sync (
    MetaDBusLogin1Manager *proxy,
    guint64 arg_flags,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "HaltWithFlags",
    g_variant_new ("(t)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_suspend:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_interactive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Suspend">Suspend()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_suspend_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_suspend_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_suspend (
    MetaDBusLogin1Manager *proxy,
    gboolean arg_interactive,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Suspend",
    g_variant_new ("(b)",
                   arg_interactive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_suspend_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_suspend().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_suspend().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_suspend_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_suspend_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_interactive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Suspend">Suspend()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_suspend() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_suspend_sync (
    MetaDBusLogin1Manager *proxy,
    gboolean arg_interactive,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Suspend",
    g_variant_new ("(b)",
                   arg_interactive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_suspend_with_flags:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SuspendWithFlags">SuspendWithFlags()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_suspend_with_flags_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_suspend_with_flags_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_suspend_with_flags (
    MetaDBusLogin1Manager *proxy,
    guint64 arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SuspendWithFlags",
    g_variant_new ("(t)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_suspend_with_flags_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_suspend_with_flags().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_suspend_with_flags().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_suspend_with_flags_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_suspend_with_flags_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SuspendWithFlags">SuspendWithFlags()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_suspend_with_flags() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_suspend_with_flags_sync (
    MetaDBusLogin1Manager *proxy,
    guint64 arg_flags,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SuspendWithFlags",
    g_variant_new ("(t)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_hibernate:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_interactive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Hibernate">Hibernate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_hibernate_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_hibernate_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_hibernate (
    MetaDBusLogin1Manager *proxy,
    gboolean arg_interactive,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Hibernate",
    g_variant_new ("(b)",
                   arg_interactive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_hibernate_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_hibernate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_hibernate().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_hibernate_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_hibernate_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_interactive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Hibernate">Hibernate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_hibernate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_hibernate_sync (
    MetaDBusLogin1Manager *proxy,
    gboolean arg_interactive,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Hibernate",
    g_variant_new ("(b)",
                   arg_interactive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_hibernate_with_flags:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.HibernateWithFlags">HibernateWithFlags()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_hibernate_with_flags_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_hibernate_with_flags_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_hibernate_with_flags (
    MetaDBusLogin1Manager *proxy,
    guint64 arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "HibernateWithFlags",
    g_variant_new ("(t)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_hibernate_with_flags_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_hibernate_with_flags().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_hibernate_with_flags().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_hibernate_with_flags_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_hibernate_with_flags_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.HibernateWithFlags">HibernateWithFlags()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_hibernate_with_flags() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_hibernate_with_flags_sync (
    MetaDBusLogin1Manager *proxy,
    guint64 arg_flags,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "HibernateWithFlags",
    g_variant_new ("(t)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_hybrid_sleep:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_interactive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.HybridSleep">HybridSleep()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_hybrid_sleep_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_hybrid_sleep_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_hybrid_sleep (
    MetaDBusLogin1Manager *proxy,
    gboolean arg_interactive,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "HybridSleep",
    g_variant_new ("(b)",
                   arg_interactive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_hybrid_sleep_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_hybrid_sleep().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_hybrid_sleep().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_hybrid_sleep_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_hybrid_sleep_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_interactive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.HybridSleep">HybridSleep()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_hybrid_sleep() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_hybrid_sleep_sync (
    MetaDBusLogin1Manager *proxy,
    gboolean arg_interactive,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "HybridSleep",
    g_variant_new ("(b)",
                   arg_interactive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_hybrid_sleep_with_flags:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.HybridSleepWithFlags">HybridSleepWithFlags()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_hybrid_sleep_with_flags_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_hybrid_sleep_with_flags_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_hybrid_sleep_with_flags (
    MetaDBusLogin1Manager *proxy,
    guint64 arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "HybridSleepWithFlags",
    g_variant_new ("(t)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_hybrid_sleep_with_flags_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_hybrid_sleep_with_flags().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_hybrid_sleep_with_flags().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_hybrid_sleep_with_flags_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_hybrid_sleep_with_flags_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.HybridSleepWithFlags">HybridSleepWithFlags()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_hybrid_sleep_with_flags() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_hybrid_sleep_with_flags_sync (
    MetaDBusLogin1Manager *proxy,
    guint64 arg_flags,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "HybridSleepWithFlags",
    g_variant_new ("(t)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_suspend_then_hibernate:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_interactive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SuspendThenHibernate">SuspendThenHibernate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_suspend_then_hibernate_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_suspend_then_hibernate_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_suspend_then_hibernate (
    MetaDBusLogin1Manager *proxy,
    gboolean arg_interactive,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SuspendThenHibernate",
    g_variant_new ("(b)",
                   arg_interactive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_suspend_then_hibernate_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_suspend_then_hibernate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_suspend_then_hibernate().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_suspend_then_hibernate_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_suspend_then_hibernate_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_interactive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SuspendThenHibernate">SuspendThenHibernate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_suspend_then_hibernate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_suspend_then_hibernate_sync (
    MetaDBusLogin1Manager *proxy,
    gboolean arg_interactive,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SuspendThenHibernate",
    g_variant_new ("(b)",
                   arg_interactive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_suspend_then_hibernate_with_flags:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SuspendThenHibernateWithFlags">SuspendThenHibernateWithFlags()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_suspend_then_hibernate_with_flags_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_suspend_then_hibernate_with_flags_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_suspend_then_hibernate_with_flags (
    MetaDBusLogin1Manager *proxy,
    guint64 arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SuspendThenHibernateWithFlags",
    g_variant_new ("(t)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_suspend_then_hibernate_with_flags_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_suspend_then_hibernate_with_flags().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_suspend_then_hibernate_with_flags().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_suspend_then_hibernate_with_flags_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_suspend_then_hibernate_with_flags_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SuspendThenHibernateWithFlags">SuspendThenHibernateWithFlags()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_suspend_then_hibernate_with_flags() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_suspend_then_hibernate_with_flags_sync (
    MetaDBusLogin1Manager *proxy,
    guint64 arg_flags,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SuspendThenHibernateWithFlags",
    g_variant_new ("(t)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_sleep:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Sleep">Sleep()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_sleep_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_sleep_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_sleep (
    MetaDBusLogin1Manager *proxy,
    guint64 arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Sleep",
    g_variant_new ("(t)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_sleep_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_sleep().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_sleep().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_sleep_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_sleep_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Sleep">Sleep()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_sleep() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_sleep_sync (
    MetaDBusLogin1Manager *proxy,
    guint64 arg_flags,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Sleep",
    g_variant_new ("(t)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_power_off:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanPowerOff">CanPowerOff()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_can_power_off_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_can_power_off_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_can_power_off (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanPowerOff",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_can_power_off_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_can_power_off().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_can_power_off().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_power_off_finish (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_power_off_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanPowerOff">CanPowerOff()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_can_power_off() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_power_off_sync (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanPowerOff",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_reboot:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanReboot">CanReboot()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_can_reboot_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_can_reboot_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_can_reboot (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanReboot",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_can_reboot_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_can_reboot().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_can_reboot().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_reboot_finish (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_reboot_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanReboot">CanReboot()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_can_reboot() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_reboot_sync (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanReboot",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_halt:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanHalt">CanHalt()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_can_halt_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_can_halt_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_can_halt (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanHalt",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_can_halt_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_can_halt().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_can_halt().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_halt_finish (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_halt_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanHalt">CanHalt()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_can_halt() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_halt_sync (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanHalt",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_suspend:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanSuspend">CanSuspend()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_can_suspend_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_can_suspend_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_can_suspend (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanSuspend",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_can_suspend_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_can_suspend().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_can_suspend().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_suspend_finish (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_suspend_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanSuspend">CanSuspend()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_can_suspend() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_suspend_sync (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanSuspend",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_hibernate:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanHibernate">CanHibernate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_can_hibernate_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_can_hibernate_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_can_hibernate (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanHibernate",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_can_hibernate_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_can_hibernate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_can_hibernate().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_hibernate_finish (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_hibernate_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanHibernate">CanHibernate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_can_hibernate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_hibernate_sync (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanHibernate",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_hybrid_sleep:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanHybridSleep">CanHybridSleep()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_can_hybrid_sleep_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_can_hybrid_sleep_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_can_hybrid_sleep (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanHybridSleep",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_can_hybrid_sleep_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_can_hybrid_sleep().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_can_hybrid_sleep().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_hybrid_sleep_finish (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_hybrid_sleep_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanHybridSleep">CanHybridSleep()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_can_hybrid_sleep() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_hybrid_sleep_sync (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanHybridSleep",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_suspend_then_hibernate:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanSuspendThenHibernate">CanSuspendThenHibernate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_can_suspend_then_hibernate_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_can_suspend_then_hibernate_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_can_suspend_then_hibernate (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanSuspendThenHibernate",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_can_suspend_then_hibernate_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_can_suspend_then_hibernate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_can_suspend_then_hibernate().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_suspend_then_hibernate_finish (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_suspend_then_hibernate_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanSuspendThenHibernate">CanSuspendThenHibernate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_can_suspend_then_hibernate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_suspend_then_hibernate_sync (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanSuspendThenHibernate",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_sleep:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanSleep">CanSleep()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_can_sleep_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_can_sleep_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_can_sleep (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanSleep",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_can_sleep_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_can_sleep().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_can_sleep().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_sleep_finish (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_sleep_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanSleep">CanSleep()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_can_sleep() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_sleep_sync (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanSleep",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_schedule_shutdown:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_usec: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ScheduleShutdown">ScheduleShutdown()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_schedule_shutdown_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_schedule_shutdown_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_schedule_shutdown (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_type,
    guint64 arg_usec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ScheduleShutdown",
    g_variant_new ("(st)",
                   arg_type,
                   arg_usec),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_schedule_shutdown_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_schedule_shutdown().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_schedule_shutdown().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_schedule_shutdown_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_schedule_shutdown_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_usec: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ScheduleShutdown">ScheduleShutdown()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_schedule_shutdown() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_schedule_shutdown_sync (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_type,
    guint64 arg_usec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ScheduleShutdown",
    g_variant_new ("(st)",
                   arg_type,
                   arg_usec),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_cancel_scheduled_shutdown:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CancelScheduledShutdown">CancelScheduledShutdown()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_cancel_scheduled_shutdown_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_cancel_scheduled_shutdown_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_cancel_scheduled_shutdown (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CancelScheduledShutdown",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_cancel_scheduled_shutdown_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_cancelled: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_cancel_scheduled_shutdown().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_cancel_scheduled_shutdown().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_cancel_scheduled_shutdown_finish (
    MetaDBusLogin1Manager *proxy,
    gboolean *out_cancelled,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_cancelled);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_cancel_scheduled_shutdown_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_cancelled: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CancelScheduledShutdown">CancelScheduledShutdown()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_cancel_scheduled_shutdown() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_cancel_scheduled_shutdown_sync (
    MetaDBusLogin1Manager *proxy,
    gboolean *out_cancelled,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CancelScheduledShutdown",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_cancelled);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_inhibit:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_what: Argument to pass with the method invocation.
 * @arg_who: Argument to pass with the method invocation.
 * @arg_why: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Inhibit">Inhibit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_inhibit_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_inhibit_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_inhibit (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_what,
    const gchar *arg_who,
    const gchar *arg_why,
    const gchar *arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Inhibit",
    g_variant_new ("(ssss)",
                   arg_what,
                   arg_who,
                   arg_why,
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_inhibit_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_pipe_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_inhibit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_inhibit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_inhibit_finish (
    MetaDBusLogin1Manager *proxy,
    GVariant **out_pipe_fd,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_pipe_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_inhibit_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_what: Argument to pass with the method invocation.
 * @arg_who: Argument to pass with the method invocation.
 * @arg_why: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @out_pipe_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Inhibit">Inhibit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_inhibit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_inhibit_sync (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_what,
    const gchar *arg_who,
    const gchar *arg_why,
    const gchar *arg_mode,
    GVariant **out_pipe_fd,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Inhibit",
    g_variant_new ("(ssss)",
                   arg_what,
                   arg_who,
                   arg_why,
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_pipe_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_reboot_parameter:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanRebootParameter">CanRebootParameter()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_can_reboot_parameter_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_can_reboot_parameter_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_can_reboot_parameter (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanRebootParameter",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_can_reboot_parameter_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_can_reboot_parameter().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_can_reboot_parameter().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_reboot_parameter_finish (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_reboot_parameter_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanRebootParameter">CanRebootParameter()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_can_reboot_parameter() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_reboot_parameter_sync (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanRebootParameter",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_set_reboot_parameter:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_parameter: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetRebootParameter">SetRebootParameter()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_set_reboot_parameter_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_set_reboot_parameter_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_set_reboot_parameter (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_parameter,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetRebootParameter",
    g_variant_new ("(s)",
                   arg_parameter),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_set_reboot_parameter_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_set_reboot_parameter().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_set_reboot_parameter().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_set_reboot_parameter_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_set_reboot_parameter_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_parameter: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetRebootParameter">SetRebootParameter()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_set_reboot_parameter() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_set_reboot_parameter_sync (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_parameter,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetRebootParameter",
    g_variant_new ("(s)",
                   arg_parameter),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_reboot_to_firmware_setup:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanRebootToFirmwareSetup">CanRebootToFirmwareSetup()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_can_reboot_to_firmware_setup_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_can_reboot_to_firmware_setup_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_can_reboot_to_firmware_setup (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanRebootToFirmwareSetup",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_can_reboot_to_firmware_setup_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_can_reboot_to_firmware_setup().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_can_reboot_to_firmware_setup().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_reboot_to_firmware_setup_finish (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_reboot_to_firmware_setup_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanRebootToFirmwareSetup">CanRebootToFirmwareSetup()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_can_reboot_to_firmware_setup() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_reboot_to_firmware_setup_sync (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanRebootToFirmwareSetup",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_set_reboot_to_firmware_setup:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_enable: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetRebootToFirmwareSetup">SetRebootToFirmwareSetup()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_set_reboot_to_firmware_setup_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_set_reboot_to_firmware_setup_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_set_reboot_to_firmware_setup (
    MetaDBusLogin1Manager *proxy,
    gboolean arg_enable,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetRebootToFirmwareSetup",
    g_variant_new ("(b)",
                   arg_enable),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_set_reboot_to_firmware_setup_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_set_reboot_to_firmware_setup().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_set_reboot_to_firmware_setup().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_set_reboot_to_firmware_setup_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_set_reboot_to_firmware_setup_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_enable: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetRebootToFirmwareSetup">SetRebootToFirmwareSetup()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_set_reboot_to_firmware_setup() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_set_reboot_to_firmware_setup_sync (
    MetaDBusLogin1Manager *proxy,
    gboolean arg_enable,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetRebootToFirmwareSetup",
    g_variant_new ("(b)",
                   arg_enable),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_reboot_to_boot_loader_menu:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanRebootToBootLoaderMenu">CanRebootToBootLoaderMenu()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_can_reboot_to_boot_loader_menu_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_can_reboot_to_boot_loader_menu_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_can_reboot_to_boot_loader_menu (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanRebootToBootLoaderMenu",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_can_reboot_to_boot_loader_menu_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_can_reboot_to_boot_loader_menu().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_can_reboot_to_boot_loader_menu().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_reboot_to_boot_loader_menu_finish (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_reboot_to_boot_loader_menu_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanRebootToBootLoaderMenu">CanRebootToBootLoaderMenu()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_can_reboot_to_boot_loader_menu() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_reboot_to_boot_loader_menu_sync (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanRebootToBootLoaderMenu",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_set_reboot_to_boot_loader_menu:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_timeout: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetRebootToBootLoaderMenu">SetRebootToBootLoaderMenu()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_set_reboot_to_boot_loader_menu_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_set_reboot_to_boot_loader_menu_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_set_reboot_to_boot_loader_menu (
    MetaDBusLogin1Manager *proxy,
    guint64 arg_timeout,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetRebootToBootLoaderMenu",
    g_variant_new ("(t)",
                   arg_timeout),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_set_reboot_to_boot_loader_menu_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_set_reboot_to_boot_loader_menu().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_set_reboot_to_boot_loader_menu().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_set_reboot_to_boot_loader_menu_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_set_reboot_to_boot_loader_menu_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_timeout: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetRebootToBootLoaderMenu">SetRebootToBootLoaderMenu()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_set_reboot_to_boot_loader_menu() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_set_reboot_to_boot_loader_menu_sync (
    MetaDBusLogin1Manager *proxy,
    guint64 arg_timeout,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetRebootToBootLoaderMenu",
    g_variant_new ("(t)",
                   arg_timeout),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_reboot_to_boot_loader_entry:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanRebootToBootLoaderEntry">CanRebootToBootLoaderEntry()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_can_reboot_to_boot_loader_entry_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_can_reboot_to_boot_loader_entry_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_can_reboot_to_boot_loader_entry (
    MetaDBusLogin1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanRebootToBootLoaderEntry",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_can_reboot_to_boot_loader_entry_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_can_reboot_to_boot_loader_entry().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_can_reboot_to_boot_loader_entry().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_reboot_to_boot_loader_entry_finish (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_can_reboot_to_boot_loader_entry_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanRebootToBootLoaderEntry">CanRebootToBootLoaderEntry()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_can_reboot_to_boot_loader_entry() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_can_reboot_to_boot_loader_entry_sync (
    MetaDBusLogin1Manager *proxy,
    gchar **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanRebootToBootLoaderEntry",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_set_reboot_to_boot_loader_entry:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_boot_loader_entry: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetRebootToBootLoaderEntry">SetRebootToBootLoaderEntry()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_set_reboot_to_boot_loader_entry_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_set_reboot_to_boot_loader_entry_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_set_reboot_to_boot_loader_entry (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_boot_loader_entry,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetRebootToBootLoaderEntry",
    g_variant_new ("(s)",
                   arg_boot_loader_entry),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_set_reboot_to_boot_loader_entry_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_set_reboot_to_boot_loader_entry().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_set_reboot_to_boot_loader_entry().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_set_reboot_to_boot_loader_entry_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_set_reboot_to_boot_loader_entry_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_boot_loader_entry: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetRebootToBootLoaderEntry">SetRebootToBootLoaderEntry()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_set_reboot_to_boot_loader_entry() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_set_reboot_to_boot_loader_entry_sync (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_boot_loader_entry,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetRebootToBootLoaderEntry",
    g_variant_new ("(s)",
                   arg_boot_loader_entry),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_set_wall_message:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_wall_message: Argument to pass with the method invocation.
 * @arg_enable: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetWallMessage">SetWallMessage()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_call_set_wall_message_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_call_set_wall_message_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_manager_call_set_wall_message (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_wall_message,
    gboolean arg_enable,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetWallMessage",
    g_variant_new ("(sb)",
                   arg_wall_message,
                   arg_enable),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_manager_call_set_wall_message_finish:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_call_set_wall_message().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_manager_call_set_wall_message().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_set_wall_message_finish (
    MetaDBusLogin1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_call_set_wall_message_sync:
 * @proxy: A #MetaDBusLogin1ManagerProxy.
 * @arg_wall_message: Argument to pass with the method invocation.
 * @arg_enable: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetWallMessage">SetWallMessage()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_call_set_wall_message() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_manager_call_set_wall_message_sync (
    MetaDBusLogin1Manager *proxy,
    const gchar *arg_wall_message,
    gboolean arg_enable,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetWallMessage",
    g_variant_new ("(sb)",
                   arg_wall_message,
                   arg_enable),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_manager_complete_get_session:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @object_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.GetSession">GetSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_get_session (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *object_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   object_path));
}

/**
 * meta_dbus_login1_manager_complete_get_session_by_pid:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @object_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.GetSessionByPID">GetSessionByPID()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_get_session_by_pid (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *object_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   object_path));
}

/**
 * meta_dbus_login1_manager_complete_get_user:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @object_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.GetUser">GetUser()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_get_user (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *object_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   object_path));
}

/**
 * meta_dbus_login1_manager_complete_get_user_by_pid:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @object_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.GetUserByPID">GetUserByPID()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_get_user_by_pid (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *object_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   object_path));
}

/**
 * meta_dbus_login1_manager_complete_get_seat:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @object_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.GetSeat">GetSeat()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_get_seat (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *object_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   object_path));
}

/**
 * meta_dbus_login1_manager_complete_list_sessions:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @sessions: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ListSessions">ListSessions()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_list_sessions (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *sessions)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(susso))",
                   sessions));
}

/**
 * meta_dbus_login1_manager_complete_list_sessions_ex:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @sessions: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ListSessionsEx">ListSessionsEx()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_list_sessions_ex (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *sessions)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(sussussbto))",
                   sessions));
}

/**
 * meta_dbus_login1_manager_complete_list_users:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @users: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ListUsers">ListUsers()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_list_users (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *users)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(uso))",
                   users));
}

/**
 * meta_dbus_login1_manager_complete_list_seats:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @seats: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ListSeats">ListSeats()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_list_seats (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *seats)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(so))",
                   seats));
}

/**
 * meta_dbus_login1_manager_complete_list_inhibitors:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @inhibitors: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ListInhibitors">ListInhibitors()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_list_inhibitors (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *inhibitors)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(ssssuu))",
                   inhibitors));
}

/**
 * meta_dbus_login1_manager_complete_create_session:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @session_id: Parameter to return.
 * @object_path: Parameter to return.
 * @runtime_path: Parameter to return.
 * @fifo_fd: Parameter to return.
 * @uid: Parameter to return.
 * @seat_id: Parameter to return.
 * @vtnr: Parameter to return.
 * @existing: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CreateSession">CreateSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_create_session (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *session_id,
    const gchar *object_path,
    const gchar *runtime_path,
    GVariant *fifo_fd,
    guint uid,
    const gchar *seat_id,
    guint vtnr,
    gboolean existing)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(sos@husub)",
                   session_id,
                   object_path,
                   runtime_path,
                   fifo_fd,
                   uid,
                   seat_id,
                   vtnr,
                   existing));
}

/**
 * meta_dbus_login1_manager_complete_create_session_with_pidfd:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @session_id: Parameter to return.
 * @object_path: Parameter to return.
 * @runtime_path: Parameter to return.
 * @fifo_fd: Parameter to return.
 * @uid: Parameter to return.
 * @seat_id: Parameter to return.
 * @vtnr: Parameter to return.
 * @existing: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CreateSessionWithPIDFD">CreateSessionWithPIDFD()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_create_session_with_pidfd (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *session_id,
    const gchar *object_path,
    const gchar *runtime_path,
    GVariant *fifo_fd,
    guint uid,
    const gchar *seat_id,
    guint vtnr,
    gboolean existing)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(sos@husub)",
                   session_id,
                   object_path,
                   runtime_path,
                   fifo_fd,
                   uid,
                   seat_id,
                   vtnr,
                   existing));
}

/**
 * meta_dbus_login1_manager_complete_release_session:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ReleaseSession">ReleaseSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_release_session (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_activate_session:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ActivateSession">ActivateSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_activate_session (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_activate_session_on_seat:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ActivateSessionOnSeat">ActivateSessionOnSeat()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_activate_session_on_seat (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_lock_session:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.LockSession">LockSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_lock_session (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_unlock_session:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.UnlockSession">UnlockSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_unlock_session (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_lock_sessions:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.LockSessions">LockSessions()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_lock_sessions (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_unlock_sessions:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.UnlockSessions">UnlockSessions()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_unlock_sessions (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_kill_session:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.KillSession">KillSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_kill_session (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_kill_user:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.KillUser">KillUser()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_kill_user (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_terminate_session:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.TerminateSession">TerminateSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_terminate_session (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_terminate_user:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.TerminateUser">TerminateUser()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_terminate_user (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_terminate_seat:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.TerminateSeat">TerminateSeat()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_terminate_seat (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_set_user_linger:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetUserLinger">SetUserLinger()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_set_user_linger (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_attach_device:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.AttachDevice">AttachDevice()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_attach_device (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_flush_devices:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.FlushDevices">FlushDevices()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_flush_devices (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_power_off:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.PowerOff">PowerOff()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_power_off (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_power_off_with_flags:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.PowerOffWithFlags">PowerOffWithFlags()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_power_off_with_flags (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_reboot:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Reboot">Reboot()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_reboot (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_reboot_with_flags:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.RebootWithFlags">RebootWithFlags()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_reboot_with_flags (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_halt:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Halt">Halt()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_halt (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_halt_with_flags:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.HaltWithFlags">HaltWithFlags()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_halt_with_flags (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_suspend:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Suspend">Suspend()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_suspend (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_suspend_with_flags:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SuspendWithFlags">SuspendWithFlags()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_suspend_with_flags (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_hibernate:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Hibernate">Hibernate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_hibernate (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_hibernate_with_flags:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.HibernateWithFlags">HibernateWithFlags()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_hibernate_with_flags (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_hybrid_sleep:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.HybridSleep">HybridSleep()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_hybrid_sleep (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_hybrid_sleep_with_flags:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.HybridSleepWithFlags">HybridSleepWithFlags()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_hybrid_sleep_with_flags (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_suspend_then_hibernate:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SuspendThenHibernate">SuspendThenHibernate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_suspend_then_hibernate (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_suspend_then_hibernate_with_flags:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SuspendThenHibernateWithFlags">SuspendThenHibernateWithFlags()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_suspend_then_hibernate_with_flags (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_sleep:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Sleep">Sleep()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_sleep (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_can_power_off:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanPowerOff">CanPowerOff()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_can_power_off (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   result));
}

/**
 * meta_dbus_login1_manager_complete_can_reboot:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanReboot">CanReboot()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_can_reboot (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   result));
}

/**
 * meta_dbus_login1_manager_complete_can_halt:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanHalt">CanHalt()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_can_halt (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   result));
}

/**
 * meta_dbus_login1_manager_complete_can_suspend:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanSuspend">CanSuspend()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_can_suspend (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   result));
}

/**
 * meta_dbus_login1_manager_complete_can_hibernate:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanHibernate">CanHibernate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_can_hibernate (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   result));
}

/**
 * meta_dbus_login1_manager_complete_can_hybrid_sleep:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanHybridSleep">CanHybridSleep()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_can_hybrid_sleep (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   result));
}

/**
 * meta_dbus_login1_manager_complete_can_suspend_then_hibernate:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanSuspendThenHibernate">CanSuspendThenHibernate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_can_suspend_then_hibernate (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   result));
}

/**
 * meta_dbus_login1_manager_complete_can_sleep:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanSleep">CanSleep()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_can_sleep (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   result));
}

/**
 * meta_dbus_login1_manager_complete_schedule_shutdown:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.ScheduleShutdown">ScheduleShutdown()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_schedule_shutdown (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_cancel_scheduled_shutdown:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @cancelled: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CancelScheduledShutdown">CancelScheduledShutdown()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_cancel_scheduled_shutdown (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean cancelled)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   cancelled));
}

/**
 * meta_dbus_login1_manager_complete_inhibit:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @pipe_fd: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.Inhibit">Inhibit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_inhibit (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *pipe_fd)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@h)",
                   pipe_fd));
}

/**
 * meta_dbus_login1_manager_complete_can_reboot_parameter:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanRebootParameter">CanRebootParameter()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_can_reboot_parameter (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   result));
}

/**
 * meta_dbus_login1_manager_complete_set_reboot_parameter:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetRebootParameter">SetRebootParameter()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_set_reboot_parameter (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_can_reboot_to_firmware_setup:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanRebootToFirmwareSetup">CanRebootToFirmwareSetup()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_can_reboot_to_firmware_setup (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   result));
}

/**
 * meta_dbus_login1_manager_complete_set_reboot_to_firmware_setup:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetRebootToFirmwareSetup">SetRebootToFirmwareSetup()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_set_reboot_to_firmware_setup (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_can_reboot_to_boot_loader_menu:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanRebootToBootLoaderMenu">CanRebootToBootLoaderMenu()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_can_reboot_to_boot_loader_menu (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   result));
}

/**
 * meta_dbus_login1_manager_complete_set_reboot_to_boot_loader_menu:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetRebootToBootLoaderMenu">SetRebootToBootLoaderMenu()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_set_reboot_to_boot_loader_menu (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_can_reboot_to_boot_loader_entry:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.CanRebootToBootLoaderEntry">CanRebootToBootLoaderEntry()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_can_reboot_to_boot_loader_entry (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   result));
}

/**
 * meta_dbus_login1_manager_complete_set_reboot_to_boot_loader_entry:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetRebootToBootLoaderEntry">SetRebootToBootLoaderEntry()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_set_reboot_to_boot_loader_entry (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_manager_complete_set_wall_message:
 * @object: A #MetaDBusLogin1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Manager.SetWallMessage">SetWallMessage()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_manager_complete_set_wall_message (
    MetaDBusLogin1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MetaDBusLogin1ManagerProxy:
 *
 * The #MetaDBusLogin1ManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDBusLogin1ManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDBusLogin1ManagerProxy.
 */

struct _MetaDBusLogin1ManagerProxyPrivate
{
  GData *qdata;
};

static void meta_dbus_login1_manager_proxy_iface_init (MetaDBusLogin1ManagerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDBusLogin1ManagerProxy, meta_dbus_login1_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MetaDBusLogin1ManagerProxy)
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_LOGIN1_MANAGER, meta_dbus_login1_manager_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDBusLogin1ManagerProxy, meta_dbus_login1_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_LOGIN1_MANAGER, meta_dbus_login1_manager_proxy_iface_init))

#endif
static void
meta_dbus_login1_manager_proxy_finalize (GObject *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (meta_dbus_login1_manager_proxy_parent_class)->finalize (object);
}

static void
meta_dbus_login1_manager_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 47);
  info = (const _ExtendedGDBusPropertyInfo *) _meta_dbus_login1_manager_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
meta_dbus_login1_manager_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.login1.Manager: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
meta_dbus_login1_manager_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 47);
  info = (const _ExtendedGDBusPropertyInfo *) _meta_dbus_login1_manager_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.login1.Manager", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) meta_dbus_login1_manager_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
meta_dbus_login1_manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_meta_dbus_login1_manager_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], META_DBUS_TYPE_LOGIN1_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_TYPE_LOGIN1_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
meta_dbus_login1_manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_login1_manager_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_login1_manager_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
meta_dbus_login1_manager_proxy_get_enable_wall_messages (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "EnableWallMessages");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_manager_proxy_get_wall_message (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "WallMessage");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
meta_dbus_login1_manager_proxy_get_nauto_vts (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "NAutoVTs");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
meta_dbus_login1_manager_proxy_get_kill_only_users (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "KillOnlyUsers");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "KillOnlyUsers");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "KillOnlyUsers", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
meta_dbus_login1_manager_proxy_get_kill_exclude_users (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "KillExcludeUsers");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "KillExcludeUsers");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "KillExcludeUsers", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
meta_dbus_login1_manager_proxy_get_kill_user_processes (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "KillUserProcesses");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_manager_proxy_get_reboot_parameter (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RebootParameter");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
meta_dbus_login1_manager_proxy_get_reboot_to_firmware_setup (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RebootToFirmwareSetup");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
meta_dbus_login1_manager_proxy_get_reboot_to_boot_loader_menu (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RebootToBootLoaderMenu");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_manager_proxy_get_reboot_to_boot_loader_entry (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RebootToBootLoaderEntry");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
meta_dbus_login1_manager_proxy_get_boot_loader_entries (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "BootLoaderEntries");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "BootLoaderEntries");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "BootLoaderEntries", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
meta_dbus_login1_manager_proxy_get_idle_hint (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IdleHint");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
meta_dbus_login1_manager_proxy_get_idle_since_hint (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IdleSinceHint");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
meta_dbus_login1_manager_proxy_get_idle_since_hint_monotonic (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IdleSinceHintMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_manager_proxy_get_block_inhibited (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "BlockInhibited");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_manager_proxy_get_delay_inhibited (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DelayInhibited");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
meta_dbus_login1_manager_proxy_get_inhibit_delay_max_usec (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InhibitDelayMaxUSec");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
meta_dbus_login1_manager_proxy_get_user_stop_delay_usec (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UserStopDelayUSec");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
meta_dbus_login1_manager_proxy_get_sleep_operation (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "SleepOperation");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SleepOperation");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "SleepOperation", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_manager_proxy_get_handle_power_key (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HandlePowerKey");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_manager_proxy_get_handle_power_key_long_press (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HandlePowerKeyLongPress");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_manager_proxy_get_handle_reboot_key (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HandleRebootKey");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_manager_proxy_get_handle_reboot_key_long_press (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HandleRebootKeyLongPress");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_manager_proxy_get_handle_suspend_key (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HandleSuspendKey");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_manager_proxy_get_handle_suspend_key_long_press (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HandleSuspendKeyLongPress");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_manager_proxy_get_handle_hibernate_key (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HandleHibernateKey");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_manager_proxy_get_handle_hibernate_key_long_press (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HandleHibernateKeyLongPress");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_manager_proxy_get_handle_lid_switch (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HandleLidSwitch");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_manager_proxy_get_handle_lid_switch_external_power (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HandleLidSwitchExternalPower");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_manager_proxy_get_handle_lid_switch_docked (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HandleLidSwitchDocked");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
meta_dbus_login1_manager_proxy_get_holdoff_timeout_usec (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HoldoffTimeoutUSec");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_manager_proxy_get_idle_action (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IdleAction");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
meta_dbus_login1_manager_proxy_get_idle_action_usec (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IdleActionUSec");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
meta_dbus_login1_manager_proxy_get_preparing_for_shutdown (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PreparingForShutdown");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
meta_dbus_login1_manager_proxy_get_preparing_for_sleep (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PreparingForSleep");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
meta_dbus_login1_manager_proxy_get_scheduled_shutdown (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ScheduledShutdown");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static gboolean 
meta_dbus_login1_manager_proxy_get_docked (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Docked");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
meta_dbus_login1_manager_proxy_get_lid_closed (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LidClosed");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
meta_dbus_login1_manager_proxy_get_on_external_power (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OnExternalPower");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
meta_dbus_login1_manager_proxy_get_remove_ipc (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RemoveIPC");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
meta_dbus_login1_manager_proxy_get_runtime_directory_size (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RuntimeDirectorySize");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
meta_dbus_login1_manager_proxy_get_runtime_directory_inodes_max (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RuntimeDirectoryInodesMax");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
meta_dbus_login1_manager_proxy_get_inhibitors_max (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InhibitorsMax");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
meta_dbus_login1_manager_proxy_get_ncurrent_inhibitors (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "NCurrentInhibitors");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
meta_dbus_login1_manager_proxy_get_sessions_max (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SessionsMax");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
meta_dbus_login1_manager_proxy_get_ncurrent_sessions (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "NCurrentSessions");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
meta_dbus_login1_manager_proxy_get_stop_idle_session_usec (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerProxy *proxy = META_DBUS_LOGIN1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "StopIdleSessionUSec");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
meta_dbus_login1_manager_proxy_init (MetaDBusLogin1ManagerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = meta_dbus_login1_manager_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, META_DBUS_TYPE_LOGIN1_MANAGER_PROXY, MetaDBusLogin1ManagerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), meta_dbus_login1_manager_interface_info ());
}

static void
meta_dbus_login1_manager_proxy_class_init (MetaDBusLogin1ManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = meta_dbus_login1_manager_proxy_finalize;
  gobject_class->get_property = meta_dbus_login1_manager_proxy_get_property;
  gobject_class->set_property = meta_dbus_login1_manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = meta_dbus_login1_manager_proxy_g_signal;
  proxy_class->g_properties_changed = meta_dbus_login1_manager_proxy_g_properties_changed;

  meta_dbus_login1_manager_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDBusLogin1ManagerProxyPrivate));
#endif
}

static void
meta_dbus_login1_manager_proxy_iface_init (MetaDBusLogin1ManagerIface *iface)
{
  iface->get_enable_wall_messages = meta_dbus_login1_manager_proxy_get_enable_wall_messages;
  iface->get_wall_message = meta_dbus_login1_manager_proxy_get_wall_message;
  iface->get_nauto_vts = meta_dbus_login1_manager_proxy_get_nauto_vts;
  iface->get_kill_only_users = meta_dbus_login1_manager_proxy_get_kill_only_users;
  iface->get_kill_exclude_users = meta_dbus_login1_manager_proxy_get_kill_exclude_users;
  iface->get_kill_user_processes = meta_dbus_login1_manager_proxy_get_kill_user_processes;
  iface->get_reboot_parameter = meta_dbus_login1_manager_proxy_get_reboot_parameter;
  iface->get_reboot_to_firmware_setup = meta_dbus_login1_manager_proxy_get_reboot_to_firmware_setup;
  iface->get_reboot_to_boot_loader_menu = meta_dbus_login1_manager_proxy_get_reboot_to_boot_loader_menu;
  iface->get_reboot_to_boot_loader_entry = meta_dbus_login1_manager_proxy_get_reboot_to_boot_loader_entry;
  iface->get_boot_loader_entries = meta_dbus_login1_manager_proxy_get_boot_loader_entries;
  iface->get_idle_hint = meta_dbus_login1_manager_proxy_get_idle_hint;
  iface->get_idle_since_hint = meta_dbus_login1_manager_proxy_get_idle_since_hint;
  iface->get_idle_since_hint_monotonic = meta_dbus_login1_manager_proxy_get_idle_since_hint_monotonic;
  iface->get_block_inhibited = meta_dbus_login1_manager_proxy_get_block_inhibited;
  iface->get_delay_inhibited = meta_dbus_login1_manager_proxy_get_delay_inhibited;
  iface->get_inhibit_delay_max_usec = meta_dbus_login1_manager_proxy_get_inhibit_delay_max_usec;
  iface->get_user_stop_delay_usec = meta_dbus_login1_manager_proxy_get_user_stop_delay_usec;
  iface->get_sleep_operation = meta_dbus_login1_manager_proxy_get_sleep_operation;
  iface->get_handle_power_key = meta_dbus_login1_manager_proxy_get_handle_power_key;
  iface->get_handle_power_key_long_press = meta_dbus_login1_manager_proxy_get_handle_power_key_long_press;
  iface->get_handle_reboot_key = meta_dbus_login1_manager_proxy_get_handle_reboot_key;
  iface->get_handle_reboot_key_long_press = meta_dbus_login1_manager_proxy_get_handle_reboot_key_long_press;
  iface->get_handle_suspend_key = meta_dbus_login1_manager_proxy_get_handle_suspend_key;
  iface->get_handle_suspend_key_long_press = meta_dbus_login1_manager_proxy_get_handle_suspend_key_long_press;
  iface->get_handle_hibernate_key = meta_dbus_login1_manager_proxy_get_handle_hibernate_key;
  iface->get_handle_hibernate_key_long_press = meta_dbus_login1_manager_proxy_get_handle_hibernate_key_long_press;
  iface->get_handle_lid_switch = meta_dbus_login1_manager_proxy_get_handle_lid_switch;
  iface->get_handle_lid_switch_external_power = meta_dbus_login1_manager_proxy_get_handle_lid_switch_external_power;
  iface->get_handle_lid_switch_docked = meta_dbus_login1_manager_proxy_get_handle_lid_switch_docked;
  iface->get_holdoff_timeout_usec = meta_dbus_login1_manager_proxy_get_holdoff_timeout_usec;
  iface->get_idle_action = meta_dbus_login1_manager_proxy_get_idle_action;
  iface->get_idle_action_usec = meta_dbus_login1_manager_proxy_get_idle_action_usec;
  iface->get_preparing_for_shutdown = meta_dbus_login1_manager_proxy_get_preparing_for_shutdown;
  iface->get_preparing_for_sleep = meta_dbus_login1_manager_proxy_get_preparing_for_sleep;
  iface->get_scheduled_shutdown = meta_dbus_login1_manager_proxy_get_scheduled_shutdown;
  iface->get_docked = meta_dbus_login1_manager_proxy_get_docked;
  iface->get_lid_closed = meta_dbus_login1_manager_proxy_get_lid_closed;
  iface->get_on_external_power = meta_dbus_login1_manager_proxy_get_on_external_power;
  iface->get_remove_ipc = meta_dbus_login1_manager_proxy_get_remove_ipc;
  iface->get_runtime_directory_size = meta_dbus_login1_manager_proxy_get_runtime_directory_size;
  iface->get_runtime_directory_inodes_max = meta_dbus_login1_manager_proxy_get_runtime_directory_inodes_max;
  iface->get_inhibitors_max = meta_dbus_login1_manager_proxy_get_inhibitors_max;
  iface->get_ncurrent_inhibitors = meta_dbus_login1_manager_proxy_get_ncurrent_inhibitors;
  iface->get_sessions_max = meta_dbus_login1_manager_proxy_get_sessions_max;
  iface->get_ncurrent_sessions = meta_dbus_login1_manager_proxy_get_ncurrent_sessions;
  iface->get_stop_idle_session_usec = meta_dbus_login1_manager_proxy_get_stop_idle_session_usec;
}

/**
 * meta_dbus_login1_manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Manager.top_of_page">org.freedesktop.login1.Manager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_proxy_new_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_login1_manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_TYPE_LOGIN1_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.login1.Manager", NULL);
}

/**
 * meta_dbus_login1_manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_login1_manager_proxy_new().
 *
 * Returns: (transfer full) (type MetaDBusLogin1ManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusLogin1Manager *
meta_dbus_login1_manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_LOGIN1_MANAGER (ret);
  else
    return NULL;
}

/**
 * meta_dbus_login1_manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Manager.top_of_page">org.freedesktop.login1.Manager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDBusLogin1ManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusLogin1Manager *
meta_dbus_login1_manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_TYPE_LOGIN1_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.login1.Manager", NULL);
  if (ret != NULL)
    return META_DBUS_LOGIN1_MANAGER (ret);
  else
    return NULL;
}


/**
 * meta_dbus_login1_manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like meta_dbus_login1_manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_login1_manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_TYPE_LOGIN1_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.login1.Manager", NULL);
}

/**
 * meta_dbus_login1_manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_login1_manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MetaDBusLogin1ManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusLogin1Manager *
meta_dbus_login1_manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_LOGIN1_MANAGER (ret);
  else
    return NULL;
}

/**
 * meta_dbus_login1_manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like meta_dbus_login1_manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDBusLogin1ManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusLogin1Manager *
meta_dbus_login1_manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_TYPE_LOGIN1_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.login1.Manager", NULL);
  if (ret != NULL)
    return META_DBUS_LOGIN1_MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MetaDBusLogin1ManagerSkeleton:
 *
 * The #MetaDBusLogin1ManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDBusLogin1ManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDBusLogin1ManagerSkeleton.
 */

struct _MetaDBusLogin1ManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_meta_dbus_login1_manager_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], META_DBUS_TYPE_LOGIN1_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_TYPE_LOGIN1_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_meta_dbus_login1_manager_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_login1_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_meta_dbus_login1_manager_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_login1_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _meta_dbus_login1_manager_skeleton_vtable =
{
  _meta_dbus_login1_manager_skeleton_handle_method_call,
  _meta_dbus_login1_manager_skeleton_handle_get_property,
  _meta_dbus_login1_manager_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
meta_dbus_login1_manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return meta_dbus_login1_manager_interface_info ();
}

static GDBusInterfaceVTable *
meta_dbus_login1_manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_meta_dbus_login1_manager_skeleton_vtable;
}

static GVariant *
meta_dbus_login1_manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_meta_dbus_login1_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _meta_dbus_login1_manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _meta_dbus_login1_manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _meta_dbus_login1_manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.login1.Manager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _meta_dbus_login1_manager_emit_changed (gpointer user_data);

static void
meta_dbus_login1_manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _meta_dbus_login1_manager_emit_changed (skeleton);
}

static void
_meta_dbus_login1_manager_on_signal_session_new (
    MetaDBusLogin1Manager *object,
    const gchar *arg_session_id,
    const gchar *arg_object_path)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(so)",
                   arg_session_id,
                   arg_object_path));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.login1.Manager", "SessionNew",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_meta_dbus_login1_manager_on_signal_session_removed (
    MetaDBusLogin1Manager *object,
    const gchar *arg_session_id,
    const gchar *arg_object_path)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(so)",
                   arg_session_id,
                   arg_object_path));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.login1.Manager", "SessionRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_meta_dbus_login1_manager_on_signal_user_new (
    MetaDBusLogin1Manager *object,
    guint arg_uid,
    const gchar *arg_object_path)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(uo)",
                   arg_uid,
                   arg_object_path));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.login1.Manager", "UserNew",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_meta_dbus_login1_manager_on_signal_user_removed (
    MetaDBusLogin1Manager *object,
    guint arg_uid,
    const gchar *arg_object_path)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(uo)",
                   arg_uid,
                   arg_object_path));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.login1.Manager", "UserRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_meta_dbus_login1_manager_on_signal_seat_new (
    MetaDBusLogin1Manager *object,
    const gchar *arg_seat_id,
    const gchar *arg_object_path)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(so)",
                   arg_seat_id,
                   arg_object_path));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.login1.Manager", "SeatNew",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_meta_dbus_login1_manager_on_signal_seat_removed (
    MetaDBusLogin1Manager *object,
    const gchar *arg_seat_id,
    const gchar *arg_object_path)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(so)",
                   arg_seat_id,
                   arg_object_path));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.login1.Manager", "SeatRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_meta_dbus_login1_manager_on_signal_prepare_for_shutdown (
    MetaDBusLogin1Manager *object,
    gboolean arg_start)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(b)",
                   arg_start));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.login1.Manager", "PrepareForShutdown",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_meta_dbus_login1_manager_on_signal_prepare_for_shutdown_with_metadata (
    MetaDBusLogin1Manager *object,
    gboolean arg_start,
    GVariant *arg_metadata)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(b@a{sv})",
                   arg_start,
                   arg_metadata));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.login1.Manager", "PrepareForShutdownWithMetadata",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_meta_dbus_login1_manager_on_signal_prepare_for_sleep (
    MetaDBusLogin1Manager *object,
    gboolean arg_start)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(b)",
                   arg_start));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.login1.Manager", "PrepareForSleep",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void meta_dbus_login1_manager_skeleton_iface_init (MetaDBusLogin1ManagerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDBusLogin1ManagerSkeleton, meta_dbus_login1_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MetaDBusLogin1ManagerSkeleton)
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_LOGIN1_MANAGER, meta_dbus_login1_manager_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDBusLogin1ManagerSkeleton, meta_dbus_login1_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_LOGIN1_MANAGER, meta_dbus_login1_manager_skeleton_iface_init))

#endif
static void
meta_dbus_login1_manager_skeleton_finalize (GObject *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  guint n;
  for (n = 0; n < 47; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (meta_dbus_login1_manager_skeleton_parent_class)->finalize (object);
}

static void
meta_dbus_login1_manager_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 47);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_meta_dbus_login1_manager_emit_changed (gpointer user_data)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.login1.Manager",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_meta_dbus_login1_manager_schedule_emit_changed (MetaDBusLogin1ManagerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
meta_dbus_login1_manager_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _meta_dbus_login1_manager_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _meta_dbus_login1_manager_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
meta_dbus_login1_manager_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 47);
  info = (const _ExtendedGDBusPropertyInfo *) _meta_dbus_login1_manager_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _meta_dbus_login1_manager_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
meta_dbus_login1_manager_skeleton_init (MetaDBusLogin1ManagerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = meta_dbus_login1_manager_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, META_DBUS_TYPE_LOGIN1_MANAGER_SKELETON, MetaDBusLogin1ManagerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 47);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[12], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[13], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[14], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[15], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[16], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[17], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[18], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[19], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[20], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[21], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[22], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[23], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[24], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[25], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[26], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[27], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[28], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[29], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[30], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[31], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[32], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[33], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[34], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[35], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[36], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[37], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[38], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[39], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[40], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[41], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[42], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[43], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[44], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[45], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[46], G_TYPE_UINT64);
}

static gboolean 
meta_dbus_login1_manager_skeleton_get_enable_wall_messages (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
meta_dbus_login1_manager_skeleton_get_wall_message (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
meta_dbus_login1_manager_skeleton_get_nauto_vts (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
meta_dbus_login1_manager_skeleton_get_kill_only_users (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
meta_dbus_login1_manager_skeleton_get_kill_exclude_users (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
meta_dbus_login1_manager_skeleton_get_kill_user_processes (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
meta_dbus_login1_manager_skeleton_get_reboot_parameter (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
meta_dbus_login1_manager_skeleton_get_reboot_to_firmware_setup (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
meta_dbus_login1_manager_skeleton_get_reboot_to_boot_loader_menu (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint64 (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
meta_dbus_login1_manager_skeleton_get_reboot_to_boot_loader_entry (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
meta_dbus_login1_manager_skeleton_get_boot_loader_entries (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[10]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
meta_dbus_login1_manager_skeleton_get_idle_hint (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[11]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
meta_dbus_login1_manager_skeleton_get_idle_since_hint (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint64 (&(skeleton->priv->properties[12]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
meta_dbus_login1_manager_skeleton_get_idle_since_hint_monotonic (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint64 (&(skeleton->priv->properties[13]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
meta_dbus_login1_manager_skeleton_get_block_inhibited (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[14]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
meta_dbus_login1_manager_skeleton_get_delay_inhibited (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[15]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
meta_dbus_login1_manager_skeleton_get_inhibit_delay_max_usec (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint64 (&(skeleton->priv->properties[16]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
meta_dbus_login1_manager_skeleton_get_user_stop_delay_usec (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint64 (&(skeleton->priv->properties[17]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
meta_dbus_login1_manager_skeleton_get_sleep_operation (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[18]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
meta_dbus_login1_manager_skeleton_get_handle_power_key (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[19]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
meta_dbus_login1_manager_skeleton_get_handle_power_key_long_press (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[20]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
meta_dbus_login1_manager_skeleton_get_handle_reboot_key (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[21]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
meta_dbus_login1_manager_skeleton_get_handle_reboot_key_long_press (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[22]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
meta_dbus_login1_manager_skeleton_get_handle_suspend_key (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[23]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
meta_dbus_login1_manager_skeleton_get_handle_suspend_key_long_press (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[24]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
meta_dbus_login1_manager_skeleton_get_handle_hibernate_key (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[25]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
meta_dbus_login1_manager_skeleton_get_handle_hibernate_key_long_press (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[26]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
meta_dbus_login1_manager_skeleton_get_handle_lid_switch (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[27]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
meta_dbus_login1_manager_skeleton_get_handle_lid_switch_external_power (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[28]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
meta_dbus_login1_manager_skeleton_get_handle_lid_switch_docked (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[29]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
meta_dbus_login1_manager_skeleton_get_holdoff_timeout_usec (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint64 (&(skeleton->priv->properties[30]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
meta_dbus_login1_manager_skeleton_get_idle_action (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[31]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
meta_dbus_login1_manager_skeleton_get_idle_action_usec (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint64 (&(skeleton->priv->properties[32]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
meta_dbus_login1_manager_skeleton_get_preparing_for_shutdown (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[33]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
meta_dbus_login1_manager_skeleton_get_preparing_for_sleep (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[34]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
meta_dbus_login1_manager_skeleton_get_scheduled_shutdown (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[35]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
meta_dbus_login1_manager_skeleton_get_docked (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[36]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
meta_dbus_login1_manager_skeleton_get_lid_closed (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[37]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
meta_dbus_login1_manager_skeleton_get_on_external_power (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[38]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
meta_dbus_login1_manager_skeleton_get_remove_ipc (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[39]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
meta_dbus_login1_manager_skeleton_get_runtime_directory_size (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint64 (&(skeleton->priv->properties[40]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
meta_dbus_login1_manager_skeleton_get_runtime_directory_inodes_max (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint64 (&(skeleton->priv->properties[41]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
meta_dbus_login1_manager_skeleton_get_inhibitors_max (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint64 (&(skeleton->priv->properties[42]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
meta_dbus_login1_manager_skeleton_get_ncurrent_inhibitors (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint64 (&(skeleton->priv->properties[43]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
meta_dbus_login1_manager_skeleton_get_sessions_max (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint64 (&(skeleton->priv->properties[44]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
meta_dbus_login1_manager_skeleton_get_ncurrent_sessions (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint64 (&(skeleton->priv->properties[45]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
meta_dbus_login1_manager_skeleton_get_stop_idle_session_usec (MetaDBusLogin1Manager *object)
{
  MetaDBusLogin1ManagerSkeleton *skeleton = META_DBUS_LOGIN1_MANAGER_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint64 (&(skeleton->priv->properties[46]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
meta_dbus_login1_manager_skeleton_class_init (MetaDBusLogin1ManagerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = meta_dbus_login1_manager_skeleton_finalize;
  gobject_class->get_property = meta_dbus_login1_manager_skeleton_get_property;
  gobject_class->set_property = meta_dbus_login1_manager_skeleton_set_property;
  gobject_class->notify       = meta_dbus_login1_manager_skeleton_notify;


  meta_dbus_login1_manager_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = meta_dbus_login1_manager_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = meta_dbus_login1_manager_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = meta_dbus_login1_manager_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = meta_dbus_login1_manager_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDBusLogin1ManagerSkeletonPrivate));
#endif
}

static void
meta_dbus_login1_manager_skeleton_iface_init (MetaDBusLogin1ManagerIface *iface)
{
  iface->session_new = _meta_dbus_login1_manager_on_signal_session_new;
  iface->session_removed = _meta_dbus_login1_manager_on_signal_session_removed;
  iface->user_new = _meta_dbus_login1_manager_on_signal_user_new;
  iface->user_removed = _meta_dbus_login1_manager_on_signal_user_removed;
  iface->seat_new = _meta_dbus_login1_manager_on_signal_seat_new;
  iface->seat_removed = _meta_dbus_login1_manager_on_signal_seat_removed;
  iface->prepare_for_shutdown = _meta_dbus_login1_manager_on_signal_prepare_for_shutdown;
  iface->prepare_for_shutdown_with_metadata = _meta_dbus_login1_manager_on_signal_prepare_for_shutdown_with_metadata;
  iface->prepare_for_sleep = _meta_dbus_login1_manager_on_signal_prepare_for_sleep;
  iface->get_enable_wall_messages = meta_dbus_login1_manager_skeleton_get_enable_wall_messages;
  iface->get_wall_message = meta_dbus_login1_manager_skeleton_get_wall_message;
  iface->get_nauto_vts = meta_dbus_login1_manager_skeleton_get_nauto_vts;
  iface->get_kill_only_users = meta_dbus_login1_manager_skeleton_get_kill_only_users;
  iface->get_kill_exclude_users = meta_dbus_login1_manager_skeleton_get_kill_exclude_users;
  iface->get_kill_user_processes = meta_dbus_login1_manager_skeleton_get_kill_user_processes;
  iface->get_reboot_parameter = meta_dbus_login1_manager_skeleton_get_reboot_parameter;
  iface->get_reboot_to_firmware_setup = meta_dbus_login1_manager_skeleton_get_reboot_to_firmware_setup;
  iface->get_reboot_to_boot_loader_menu = meta_dbus_login1_manager_skeleton_get_reboot_to_boot_loader_menu;
  iface->get_reboot_to_boot_loader_entry = meta_dbus_login1_manager_skeleton_get_reboot_to_boot_loader_entry;
  iface->get_boot_loader_entries = meta_dbus_login1_manager_skeleton_get_boot_loader_entries;
  iface->get_idle_hint = meta_dbus_login1_manager_skeleton_get_idle_hint;
  iface->get_idle_since_hint = meta_dbus_login1_manager_skeleton_get_idle_since_hint;
  iface->get_idle_since_hint_monotonic = meta_dbus_login1_manager_skeleton_get_idle_since_hint_monotonic;
  iface->get_block_inhibited = meta_dbus_login1_manager_skeleton_get_block_inhibited;
  iface->get_delay_inhibited = meta_dbus_login1_manager_skeleton_get_delay_inhibited;
  iface->get_inhibit_delay_max_usec = meta_dbus_login1_manager_skeleton_get_inhibit_delay_max_usec;
  iface->get_user_stop_delay_usec = meta_dbus_login1_manager_skeleton_get_user_stop_delay_usec;
  iface->get_sleep_operation = meta_dbus_login1_manager_skeleton_get_sleep_operation;
  iface->get_handle_power_key = meta_dbus_login1_manager_skeleton_get_handle_power_key;
  iface->get_handle_power_key_long_press = meta_dbus_login1_manager_skeleton_get_handle_power_key_long_press;
  iface->get_handle_reboot_key = meta_dbus_login1_manager_skeleton_get_handle_reboot_key;
  iface->get_handle_reboot_key_long_press = meta_dbus_login1_manager_skeleton_get_handle_reboot_key_long_press;
  iface->get_handle_suspend_key = meta_dbus_login1_manager_skeleton_get_handle_suspend_key;
  iface->get_handle_suspend_key_long_press = meta_dbus_login1_manager_skeleton_get_handle_suspend_key_long_press;
  iface->get_handle_hibernate_key = meta_dbus_login1_manager_skeleton_get_handle_hibernate_key;
  iface->get_handle_hibernate_key_long_press = meta_dbus_login1_manager_skeleton_get_handle_hibernate_key_long_press;
  iface->get_handle_lid_switch = meta_dbus_login1_manager_skeleton_get_handle_lid_switch;
  iface->get_handle_lid_switch_external_power = meta_dbus_login1_manager_skeleton_get_handle_lid_switch_external_power;
  iface->get_handle_lid_switch_docked = meta_dbus_login1_manager_skeleton_get_handle_lid_switch_docked;
  iface->get_holdoff_timeout_usec = meta_dbus_login1_manager_skeleton_get_holdoff_timeout_usec;
  iface->get_idle_action = meta_dbus_login1_manager_skeleton_get_idle_action;
  iface->get_idle_action_usec = meta_dbus_login1_manager_skeleton_get_idle_action_usec;
  iface->get_preparing_for_shutdown = meta_dbus_login1_manager_skeleton_get_preparing_for_shutdown;
  iface->get_preparing_for_sleep = meta_dbus_login1_manager_skeleton_get_preparing_for_sleep;
  iface->get_scheduled_shutdown = meta_dbus_login1_manager_skeleton_get_scheduled_shutdown;
  iface->get_docked = meta_dbus_login1_manager_skeleton_get_docked;
  iface->get_lid_closed = meta_dbus_login1_manager_skeleton_get_lid_closed;
  iface->get_on_external_power = meta_dbus_login1_manager_skeleton_get_on_external_power;
  iface->get_remove_ipc = meta_dbus_login1_manager_skeleton_get_remove_ipc;
  iface->get_runtime_directory_size = meta_dbus_login1_manager_skeleton_get_runtime_directory_size;
  iface->get_runtime_directory_inodes_max = meta_dbus_login1_manager_skeleton_get_runtime_directory_inodes_max;
  iface->get_inhibitors_max = meta_dbus_login1_manager_skeleton_get_inhibitors_max;
  iface->get_ncurrent_inhibitors = meta_dbus_login1_manager_skeleton_get_ncurrent_inhibitors;
  iface->get_sessions_max = meta_dbus_login1_manager_skeleton_get_sessions_max;
  iface->get_ncurrent_sessions = meta_dbus_login1_manager_skeleton_get_ncurrent_sessions;
  iface->get_stop_idle_session_usec = meta_dbus_login1_manager_skeleton_get_stop_idle_session_usec;
}

/**
 * meta_dbus_login1_manager_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Manager.top_of_page">org.freedesktop.login1.Manager</link>.
 *
 * Returns: (transfer full) (type MetaDBusLogin1ManagerSkeleton): The skeleton object.
 */
MetaDBusLogin1Manager *
meta_dbus_login1_manager_skeleton_new (void)
{
  return META_DBUS_LOGIN1_MANAGER (g_object_new (META_DBUS_TYPE_LOGIN1_MANAGER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.login1.Session
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MetaDBusLogin1Session
 * @title: MetaDBusLogin1Session
 * @short_description: Generated C code for the org.freedesktop.login1.Session D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-login1-Session.top_of_page">org.freedesktop.login1.Session</link> D-Bus interface in C.
 */

enum
{
  META_DBUS__LOGIN1_SESSION_PAUSE_DEVICE,
  META_DBUS__LOGIN1_SESSION_RESUME_DEVICE,
  META_DBUS__LOGIN1_SESSION_LOCK,
  META_DBUS__LOGIN1_SESSION_UNLOCK,
};

static unsigned META_DBUS__LOGIN1_SESSION_SIGNALS[4] = { 0 };

/* ---- Introspection data for org.freedesktop.login1.Session ---- */

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_terminate =
{
  {
    -1,
    (gchar *) "Terminate",
    NULL,
    NULL,
    NULL
  },
  "handle-terminate",
  FALSE
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_activate =
{
  {
    -1,
    (gchar *) "Activate",
    NULL,
    NULL,
    NULL
  },
  "handle-activate",
  FALSE
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_lock =
{
  {
    -1,
    (gchar *) "Lock",
    NULL,
    NULL,
    NULL
  },
  "handle-lock",
  FALSE
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_unlock =
{
  {
    -1,
    (gchar *) "Unlock",
    NULL,
    NULL,
    NULL
  },
  "handle-unlock",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_set_idle_hint_IN_ARG_idle =
{
  {
    -1,
    (gchar *) "idle",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_session_method_info_set_idle_hint_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_session_method_info_set_idle_hint_IN_ARG_idle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_set_idle_hint =
{
  {
    -1,
    (gchar *) "SetIdleHint",
    (GDBusArgInfo **) &_meta_dbus_login1_session_method_info_set_idle_hint_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-idle-hint",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_set_locked_hint_IN_ARG_locked =
{
  {
    -1,
    (gchar *) "locked",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_session_method_info_set_locked_hint_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_session_method_info_set_locked_hint_IN_ARG_locked.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_set_locked_hint =
{
  {
    -1,
    (gchar *) "SetLockedHint",
    (GDBusArgInfo **) &_meta_dbus_login1_session_method_info_set_locked_hint_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-locked-hint",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_kill_IN_ARG_who =
{
  {
    -1,
    (gchar *) "who",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_kill_IN_ARG_signal_number =
{
  {
    -1,
    (gchar *) "signal_number",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_session_method_info_kill_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_session_method_info_kill_IN_ARG_who.parent_struct,
  &_meta_dbus_login1_session_method_info_kill_IN_ARG_signal_number.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_kill =
{
  {
    -1,
    (gchar *) "Kill",
    (GDBusArgInfo **) &_meta_dbus_login1_session_method_info_kill_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-kill",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_take_control_IN_ARG_force =
{
  {
    -1,
    (gchar *) "force",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_session_method_info_take_control_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_session_method_info_take_control_IN_ARG_force.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_take_control =
{
  {
    -1,
    (gchar *) "TakeControl",
    (GDBusArgInfo **) &_meta_dbus_login1_session_method_info_take_control_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-take-control",
  FALSE
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_release_control =
{
  {
    -1,
    (gchar *) "ReleaseControl",
    NULL,
    NULL,
    NULL
  },
  "handle-release-control",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_set_type_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_session_method_info_set_type_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_session_method_info_set_type_IN_ARG_type.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_set_type =
{
  {
    -1,
    (gchar *) "SetType",
    (GDBusArgInfo **) &_meta_dbus_login1_session_method_info_set_type_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-type",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_set_display_IN_ARG_display =
{
  {
    -1,
    (gchar *) "display",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_session_method_info_set_display_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_session_method_info_set_display_IN_ARG_display.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_set_display =
{
  {
    -1,
    (gchar *) "SetDisplay",
    (GDBusArgInfo **) &_meta_dbus_login1_session_method_info_set_display_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-display",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_set_tty_IN_ARG_tty_fd =
{
  {
    -1,
    (gchar *) "tty_fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_session_method_info_set_tty_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_session_method_info_set_tty_IN_ARG_tty_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_set_tty =
{
  {
    -1,
    (gchar *) "SetTTY",
    (GDBusArgInfo **) &_meta_dbus_login1_session_method_info_set_tty_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-tty",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_take_device_IN_ARG_major =
{
  {
    -1,
    (gchar *) "major",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_take_device_IN_ARG_minor =
{
  {
    -1,
    (gchar *) "minor",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_session_method_info_take_device_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_session_method_info_take_device_IN_ARG_major.parent_struct,
  &_meta_dbus_login1_session_method_info_take_device_IN_ARG_minor.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_take_device_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_take_device_OUT_ARG_inactive =
{
  {
    -1,
    (gchar *) "inactive",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_session_method_info_take_device_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_session_method_info_take_device_OUT_ARG_fd.parent_struct,
  &_meta_dbus_login1_session_method_info_take_device_OUT_ARG_inactive.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_take_device =
{
  {
    -1,
    (gchar *) "TakeDevice",
    (GDBusArgInfo **) &_meta_dbus_login1_session_method_info_take_device_IN_ARG_pointers,
    (GDBusArgInfo **) &_meta_dbus_login1_session_method_info_take_device_OUT_ARG_pointers,
    NULL
  },
  "handle-take-device",
  TRUE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_release_device_IN_ARG_major =
{
  {
    -1,
    (gchar *) "major",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_release_device_IN_ARG_minor =
{
  {
    -1,
    (gchar *) "minor",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_session_method_info_release_device_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_session_method_info_release_device_IN_ARG_major.parent_struct,
  &_meta_dbus_login1_session_method_info_release_device_IN_ARG_minor.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_release_device =
{
  {
    -1,
    (gchar *) "ReleaseDevice",
    (GDBusArgInfo **) &_meta_dbus_login1_session_method_info_release_device_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-release-device",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_pause_device_complete_IN_ARG_major =
{
  {
    -1,
    (gchar *) "major",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_pause_device_complete_IN_ARG_minor =
{
  {
    -1,
    (gchar *) "minor",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_session_method_info_pause_device_complete_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_session_method_info_pause_device_complete_IN_ARG_major.parent_struct,
  &_meta_dbus_login1_session_method_info_pause_device_complete_IN_ARG_minor.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_pause_device_complete =
{
  {
    -1,
    (gchar *) "PauseDeviceComplete",
    (GDBusArgInfo **) &_meta_dbus_login1_session_method_info_pause_device_complete_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-pause-device-complete",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_set_brightness_IN_ARG_subsystem =
{
  {
    -1,
    (gchar *) "subsystem",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_set_brightness_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_set_brightness_IN_ARG_brightness =
{
  {
    -1,
    (gchar *) "brightness",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_session_method_info_set_brightness_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_session_method_info_set_brightness_IN_ARG_subsystem.parent_struct,
  &_meta_dbus_login1_session_method_info_set_brightness_IN_ARG_name.parent_struct,
  &_meta_dbus_login1_session_method_info_set_brightness_IN_ARG_brightness.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_set_brightness =
{
  {
    -1,
    (gchar *) "SetBrightness",
    (GDBusArgInfo **) &_meta_dbus_login1_session_method_info_set_brightness_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-brightness",
  FALSE
};

static const GDBusMethodInfo * const _meta_dbus_login1_session_method_info_pointers[] =
{
  &_meta_dbus_login1_session_method_info_terminate.parent_struct,
  &_meta_dbus_login1_session_method_info_activate.parent_struct,
  &_meta_dbus_login1_session_method_info_lock.parent_struct,
  &_meta_dbus_login1_session_method_info_unlock.parent_struct,
  &_meta_dbus_login1_session_method_info_set_idle_hint.parent_struct,
  &_meta_dbus_login1_session_method_info_set_locked_hint.parent_struct,
  &_meta_dbus_login1_session_method_info_kill.parent_struct,
  &_meta_dbus_login1_session_method_info_take_control.parent_struct,
  &_meta_dbus_login1_session_method_info_release_control.parent_struct,
  &_meta_dbus_login1_session_method_info_set_type.parent_struct,
  &_meta_dbus_login1_session_method_info_set_display.parent_struct,
  &_meta_dbus_login1_session_method_info_set_tty.parent_struct,
  &_meta_dbus_login1_session_method_info_take_device.parent_struct,
  &_meta_dbus_login1_session_method_info_release_device.parent_struct,
  &_meta_dbus_login1_session_method_info_pause_device_complete.parent_struct,
  &_meta_dbus_login1_session_method_info_set_brightness.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_signal_info_pause_device_ARG_major =
{
  {
    -1,
    (gchar *) "major",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_signal_info_pause_device_ARG_minor =
{
  {
    -1,
    (gchar *) "minor",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_signal_info_pause_device_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_session_signal_info_pause_device_ARG_pointers[] =
{
  &_meta_dbus_login1_session_signal_info_pause_device_ARG_major.parent_struct,
  &_meta_dbus_login1_session_signal_info_pause_device_ARG_minor.parent_struct,
  &_meta_dbus_login1_session_signal_info_pause_device_ARG_type.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _meta_dbus_login1_session_signal_info_pause_device =
{
  {
    -1,
    (gchar *) "PauseDevice",
    (GDBusArgInfo **) &_meta_dbus_login1_session_signal_info_pause_device_ARG_pointers,
    NULL
  },
  "pause-device"
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_signal_info_resume_device_ARG_major =
{
  {
    -1,
    (gchar *) "major",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_signal_info_resume_device_ARG_minor =
{
  {
    -1,
    (gchar *) "minor",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_signal_info_resume_device_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_session_signal_info_resume_device_ARG_pointers[] =
{
  &_meta_dbus_login1_session_signal_info_resume_device_ARG_major.parent_struct,
  &_meta_dbus_login1_session_signal_info_resume_device_ARG_minor.parent_struct,
  &_meta_dbus_login1_session_signal_info_resume_device_ARG_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _meta_dbus_login1_session_signal_info_resume_device =
{
  {
    -1,
    (gchar *) "ResumeDevice",
    (GDBusArgInfo **) &_meta_dbus_login1_session_signal_info_resume_device_ARG_pointers,
    NULL
  },
  "resume-device"
};

static const _ExtendedGDBusSignalInfo _meta_dbus_login1_session_signal_info_lock =
{
  {
    -1,
    (gchar *) "Lock",
    NULL,
    NULL
  },
  "lock"
};

static const _ExtendedGDBusSignalInfo _meta_dbus_login1_session_signal_info_unlock =
{
  {
    -1,
    (gchar *) "Unlock",
    NULL,
    NULL
  },
  "unlock"
};

static const GDBusSignalInfo * const _meta_dbus_login1_session_signal_info_pointers[] =
{
  &_meta_dbus_login1_session_signal_info_pause_device.parent_struct,
  &_meta_dbus_login1_session_signal_info_resume_device.parent_struct,
  &_meta_dbus_login1_session_signal_info_lock.parent_struct,
  &_meta_dbus_login1_session_signal_info_unlock.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _meta_dbus_login1_session_property_id_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_session_property_id_annotation_info_pointers[] =
{
  &_meta_dbus_login1_session_property_id_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_id =
{
  {
    -1,
    (gchar *) "Id",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_session_property_id_annotation_info_pointers
  },
  "id",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_session_property_user_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_session_property_user_annotation_info_pointers[] =
{
  &_meta_dbus_login1_session_property_user_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_user =
{
  {
    -1,
    (gchar *) "User",
    (gchar *) "(uo)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_session_property_user_annotation_info_pointers
  },
  "user",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_session_property_name_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_session_property_name_annotation_info_pointers[] =
{
  &_meta_dbus_login1_session_property_name_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_name =
{
  {
    -1,
    (gchar *) "Name",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_session_property_name_annotation_info_pointers
  },
  "name",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_session_property_timestamp_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_session_property_timestamp_annotation_info_pointers[] =
{
  &_meta_dbus_login1_session_property_timestamp_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_timestamp =
{
  {
    -1,
    (gchar *) "Timestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_session_property_timestamp_annotation_info_pointers
  },
  "timestamp",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_session_property_timestamp_monotonic_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_session_property_timestamp_monotonic_annotation_info_pointers[] =
{
  &_meta_dbus_login1_session_property_timestamp_monotonic_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "TimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_session_property_timestamp_monotonic_annotation_info_pointers
  },
  "timestamp-monotonic",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_session_property_vtnr_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_session_property_vtnr_annotation_info_pointers[] =
{
  &_meta_dbus_login1_session_property_vtnr_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_vtnr =
{
  {
    -1,
    (gchar *) "VTNr",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_session_property_vtnr_annotation_info_pointers
  },
  "vtnr",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_session_property_seat_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_session_property_seat_annotation_info_pointers[] =
{
  &_meta_dbus_login1_session_property_seat_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_seat =
{
  {
    -1,
    (gchar *) "Seat",
    (gchar *) "(so)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_session_property_seat_annotation_info_pointers
  },
  "seat",
  FALSE,
  FALSE
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_tty =
{
  {
    -1,
    (gchar *) "TTY",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "tty",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_display =
{
  {
    -1,
    (gchar *) "Display",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "display",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _meta_dbus_login1_session_property_remote_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_session_property_remote_annotation_info_pointers[] =
{
  &_meta_dbus_login1_session_property_remote_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_remote =
{
  {
    -1,
    (gchar *) "Remote",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_session_property_remote_annotation_info_pointers
  },
  "remote",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_session_property_remote_host_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_session_property_remote_host_annotation_info_pointers[] =
{
  &_meta_dbus_login1_session_property_remote_host_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_remote_host =
{
  {
    -1,
    (gchar *) "RemoteHost",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_session_property_remote_host_annotation_info_pointers
  },
  "remote-host",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_session_property_remote_user_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_session_property_remote_user_annotation_info_pointers[] =
{
  &_meta_dbus_login1_session_property_remote_user_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_remote_user =
{
  {
    -1,
    (gchar *) "RemoteUser",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_session_property_remote_user_annotation_info_pointers
  },
  "remote-user",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_session_property_service_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_session_property_service_annotation_info_pointers[] =
{
  &_meta_dbus_login1_session_property_service_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_service =
{
  {
    -1,
    (gchar *) "Service",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_session_property_service_annotation_info_pointers
  },
  "service",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_session_property_desktop_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_session_property_desktop_annotation_info_pointers[] =
{
  &_meta_dbus_login1_session_property_desktop_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_desktop =
{
  {
    -1,
    (gchar *) "Desktop",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_session_property_desktop_annotation_info_pointers
  },
  "desktop",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_session_property_scope_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_session_property_scope_annotation_info_pointers[] =
{
  &_meta_dbus_login1_session_property_scope_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_scope =
{
  {
    -1,
    (gchar *) "Scope",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_session_property_scope_annotation_info_pointers
  },
  "scope",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_session_property_leader_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_session_property_leader_annotation_info_pointers[] =
{
  &_meta_dbus_login1_session_property_leader_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_leader =
{
  {
    -1,
    (gchar *) "Leader",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_session_property_leader_annotation_info_pointers
  },
  "leader",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _meta_dbus_login1_session_property_audit_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_session_property_audit_annotation_info_pointers[] =
{
  &_meta_dbus_login1_session_property_audit_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_audit =
{
  {
    -1,
    (gchar *) "Audit",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_session_property_audit_annotation_info_pointers
  },
  "audit",
  FALSE,
  FALSE
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_type_ =
{
  {
    -1,
    (gchar *) "Type",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "type",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _meta_dbus_login1_session_property_class_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _meta_dbus_login1_session_property_class_annotation_info_pointers[] =
{
  &_meta_dbus_login1_session_property_class_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_class =
{
  {
    -1,
    (gchar *) "Class",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_meta_dbus_login1_session_property_class_annotation_info_pointers
  },
  "class",
  FALSE,
  FALSE
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_active =
{
  {
    -1,
    (gchar *) "Active",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "active",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_state =
{
  {
    -1,
    (gchar *) "State",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_idle_hint =
{
  {
    -1,
    (gchar *) "IdleHint",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "idle-hint",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_idle_since_hint =
{
  {
    -1,
    (gchar *) "IdleSinceHint",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "idle-since-hint",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_idle_since_hint_monotonic =
{
  {
    -1,
    (gchar *) "IdleSinceHintMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "idle-since-hint-monotonic",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_locked_hint =
{
  {
    -1,
    (gchar *) "LockedHint",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "locked-hint",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _meta_dbus_login1_session_property_info_pointers[] =
{
  &_meta_dbus_login1_session_property_info_id.parent_struct,
  &_meta_dbus_login1_session_property_info_user.parent_struct,
  &_meta_dbus_login1_session_property_info_name.parent_struct,
  &_meta_dbus_login1_session_property_info_timestamp.parent_struct,
  &_meta_dbus_login1_session_property_info_timestamp_monotonic.parent_struct,
  &_meta_dbus_login1_session_property_info_vtnr.parent_struct,
  &_meta_dbus_login1_session_property_info_seat.parent_struct,
  &_meta_dbus_login1_session_property_info_tty.parent_struct,
  &_meta_dbus_login1_session_property_info_display.parent_struct,
  &_meta_dbus_login1_session_property_info_remote.parent_struct,
  &_meta_dbus_login1_session_property_info_remote_host.parent_struct,
  &_meta_dbus_login1_session_property_info_remote_user.parent_struct,
  &_meta_dbus_login1_session_property_info_service.parent_struct,
  &_meta_dbus_login1_session_property_info_desktop.parent_struct,
  &_meta_dbus_login1_session_property_info_scope.parent_struct,
  &_meta_dbus_login1_session_property_info_leader.parent_struct,
  &_meta_dbus_login1_session_property_info_audit.parent_struct,
  &_meta_dbus_login1_session_property_info_type_.parent_struct,
  &_meta_dbus_login1_session_property_info_class.parent_struct,
  &_meta_dbus_login1_session_property_info_active.parent_struct,
  &_meta_dbus_login1_session_property_info_state.parent_struct,
  &_meta_dbus_login1_session_property_info_idle_hint.parent_struct,
  &_meta_dbus_login1_session_property_info_idle_since_hint.parent_struct,
  &_meta_dbus_login1_session_property_info_idle_since_hint_monotonic.parent_struct,
  &_meta_dbus_login1_session_property_info_locked_hint.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _meta_dbus_login1_session_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.login1.Session",
    (GDBusMethodInfo **) &_meta_dbus_login1_session_method_info_pointers,
    (GDBusSignalInfo **) &_meta_dbus_login1_session_signal_info_pointers,
    (GDBusPropertyInfo **) &_meta_dbus_login1_session_property_info_pointers,
    NULL
  },
  "login1-session",
};


/**
 * meta_dbus_login1_session_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-login1-Session.top_of_page">org.freedesktop.login1.Session</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
meta_dbus_login1_session_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_meta_dbus_login1_session_interface_info.parent_struct;
}

/**
 * meta_dbus_login1_session_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MetaDBusLogin1Session interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
meta_dbus_login1_session_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "id");
  g_object_class_override_property (klass, property_id_begin++, "user");
  g_object_class_override_property (klass, property_id_begin++, "name");
  g_object_class_override_property (klass, property_id_begin++, "timestamp");
  g_object_class_override_property (klass, property_id_begin++, "timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "vtnr");
  g_object_class_override_property (klass, property_id_begin++, "seat");
  g_object_class_override_property (klass, property_id_begin++, "tty");
  g_object_class_override_property (klass, property_id_begin++, "display");
  g_object_class_override_property (klass, property_id_begin++, "remote");
  g_object_class_override_property (klass, property_id_begin++, "remote-host");
  g_object_class_override_property (klass, property_id_begin++, "remote-user");
  g_object_class_override_property (klass, property_id_begin++, "service");
  g_object_class_override_property (klass, property_id_begin++, "desktop");
  g_object_class_override_property (klass, property_id_begin++, "scope");
  g_object_class_override_property (klass, property_id_begin++, "leader");
  g_object_class_override_property (klass, property_id_begin++, "audit");
  g_object_class_override_property (klass, property_id_begin++, "type");
  g_object_class_override_property (klass, property_id_begin++, "class");
  g_object_class_override_property (klass, property_id_begin++, "active");
  g_object_class_override_property (klass, property_id_begin++, "state");
  g_object_class_override_property (klass, property_id_begin++, "idle-hint");
  g_object_class_override_property (klass, property_id_begin++, "idle-since-hint");
  g_object_class_override_property (klass, property_id_begin++, "idle-since-hint-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "locked-hint");
  return property_id_begin - 1;
}


inline static void
meta_dbus_login1_session_signal_marshal_pause_device (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__UINT_UINT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_session_signal_marshal_resume_device (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__UINT_UINT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_session_signal_marshal_lock (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_session_signal_marshal_unlock (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_session_method_marshal_terminate (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_session_method_marshal_activate (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_session_method_marshal_lock (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_session_method_marshal_unlock (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_session_method_marshal_set_idle_hint (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_session_method_marshal_set_locked_hint (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_session_method_marshal_kill (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_session_method_marshal_take_control (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_session_method_marshal_release_control (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_session_method_marshal_set_type (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_session_method_marshal_set_display (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_session_method_marshal_set_tty (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_session_method_marshal_take_device (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_UINT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_session_method_marshal_release_device (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_session_method_marshal_pause_device_complete (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_login1_session_method_marshal_set_brightness (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * MetaDBusLogin1Session:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Session.top_of_page">org.freedesktop.login1.Session</link>.
 */

/**
 * MetaDBusLogin1SessionIface:
 * @parent_iface: The parent interface.
 * @handle_activate: Handler for the #MetaDBusLogin1Session::handle-activate signal.
 * @handle_kill: Handler for the #MetaDBusLogin1Session::handle-kill signal.
 * @handle_lock: Handler for the #MetaDBusLogin1Session::handle-lock signal.
 * @handle_pause_device_complete: Handler for the #MetaDBusLogin1Session::handle-pause-device-complete signal.
 * @handle_release_control: Handler for the #MetaDBusLogin1Session::handle-release-control signal.
 * @handle_release_device: Handler for the #MetaDBusLogin1Session::handle-release-device signal.
 * @handle_set_brightness: Handler for the #MetaDBusLogin1Session::handle-set-brightness signal.
 * @handle_set_display: Handler for the #MetaDBusLogin1Session::handle-set-display signal.
 * @handle_set_idle_hint: Handler for the #MetaDBusLogin1Session::handle-set-idle-hint signal.
 * @handle_set_locked_hint: Handler for the #MetaDBusLogin1Session::handle-set-locked-hint signal.
 * @handle_set_tty: Handler for the #MetaDBusLogin1Session::handle-set-tty signal.
 * @handle_set_type: Handler for the #MetaDBusLogin1Session::handle-set-type signal.
 * @handle_take_control: Handler for the #MetaDBusLogin1Session::handle-take-control signal.
 * @handle_take_device: Handler for the #MetaDBusLogin1Session::handle-take-device signal.
 * @handle_terminate: Handler for the #MetaDBusLogin1Session::handle-terminate signal.
 * @handle_unlock: Handler for the #MetaDBusLogin1Session::handle-unlock signal.
 * @get_active: Getter for the #MetaDBusLogin1Session:active property.
 * @get_audit: Getter for the #MetaDBusLogin1Session:audit property.
 * @get_class: Getter for the #MetaDBusLogin1Session:class property.
 * @get_desktop: Getter for the #MetaDBusLogin1Session:desktop property.
 * @get_display: Getter for the #MetaDBusLogin1Session:display property.
 * @get_id: Getter for the #MetaDBusLogin1Session:id property.
 * @get_idle_hint: Getter for the #MetaDBusLogin1Session:idle-hint property.
 * @get_idle_since_hint: Getter for the #MetaDBusLogin1Session:idle-since-hint property.
 * @get_idle_since_hint_monotonic: Getter for the #MetaDBusLogin1Session:idle-since-hint-monotonic property.
 * @get_leader: Getter for the #MetaDBusLogin1Session:leader property.
 * @get_locked_hint: Getter for the #MetaDBusLogin1Session:locked-hint property.
 * @get_name: Getter for the #MetaDBusLogin1Session:name property.
 * @get_remote: Getter for the #MetaDBusLogin1Session:remote property.
 * @get_remote_host: Getter for the #MetaDBusLogin1Session:remote-host property.
 * @get_remote_user: Getter for the #MetaDBusLogin1Session:remote-user property.
 * @get_scope: Getter for the #MetaDBusLogin1Session:scope property.
 * @get_seat: Getter for the #MetaDBusLogin1Session:seat property.
 * @get_service: Getter for the #MetaDBusLogin1Session:service property.
 * @get_state: Getter for the #MetaDBusLogin1Session:state property.
 * @get_timestamp: Getter for the #MetaDBusLogin1Session:timestamp property.
 * @get_timestamp_monotonic: Getter for the #MetaDBusLogin1Session:timestamp-monotonic property.
 * @get_tty: Getter for the #MetaDBusLogin1Session:tty property.
 * @get_type_: Getter for the #MetaDBusLogin1Session:type property.
 * @get_user: Getter for the #MetaDBusLogin1Session:user property.
 * @get_vtnr: Getter for the #MetaDBusLogin1Session:vtnr property.
 * @lock: Handler for the #MetaDBusLogin1Session::lock signal.
 * @pause_device: Handler for the #MetaDBusLogin1Session::pause-device signal.
 * @resume_device: Handler for the #MetaDBusLogin1Session::resume-device signal.
 * @unlock: Handler for the #MetaDBusLogin1Session::unlock signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Session.top_of_page">org.freedesktop.login1.Session</link>.
 */

typedef MetaDBusLogin1SessionIface MetaDBusLogin1SessionInterface;
G_DEFINE_INTERFACE (MetaDBusLogin1Session, meta_dbus_login1_session, G_TYPE_OBJECT)

static void
meta_dbus_login1_session_default_init (MetaDBusLogin1SessionIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MetaDBusLogin1Session::handle-terminate:
   * @object: A #MetaDBusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.Terminate">Terminate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_terminate() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-terminate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1SessionIface, handle_terminate),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_session_method_marshal_terminate,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Session::handle-activate:
   * @object: A #MetaDBusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.Activate">Activate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_activate() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-activate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1SessionIface, handle_activate),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_session_method_marshal_activate,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Session::handle-lock:
   * @object: A #MetaDBusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.Lock">Lock()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_lock() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-lock",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1SessionIface, handle_lock),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_session_method_marshal_lock,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Session::handle-unlock:
   * @object: A #MetaDBusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.Unlock">Unlock()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_unlock() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unlock",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1SessionIface, handle_unlock),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_session_method_marshal_unlock,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Session::handle-set-idle-hint:
   * @object: A #MetaDBusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_idle: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetIdleHint">SetIdleHint()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_set_idle_hint() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-idle-hint",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1SessionIface, handle_set_idle_hint),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_session_method_marshal_set_idle_hint,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * MetaDBusLogin1Session::handle-set-locked-hint:
   * @object: A #MetaDBusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_locked: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetLockedHint">SetLockedHint()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_set_locked_hint() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-locked-hint",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1SessionIface, handle_set_locked_hint),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_session_method_marshal_set_locked_hint,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * MetaDBusLogin1Session::handle-kill:
   * @object: A #MetaDBusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_who: Argument passed by remote caller.
   * @arg_signal_number: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.Kill">Kill()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_kill() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-kill",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1SessionIface, handle_kill),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_session_method_marshal_kill,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_INT);

  /**
   * MetaDBusLogin1Session::handle-take-control:
   * @object: A #MetaDBusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_force: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeControl">TakeControl()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_take_control() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-take-control",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1SessionIface, handle_take_control),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_session_method_marshal_take_control,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * MetaDBusLogin1Session::handle-release-control:
   * @object: A #MetaDBusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseControl">ReleaseControl()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_release_control() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release-control",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1SessionIface, handle_release_control),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_session_method_marshal_release_control,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusLogin1Session::handle-set-type:
   * @object: A #MetaDBusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_type: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetType">SetType()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_set_type() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-type",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1SessionIface, handle_set_type),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_session_method_marshal_set_type,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MetaDBusLogin1Session::handle-set-display:
   * @object: A #MetaDBusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_display: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetDisplay">SetDisplay()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_set_display() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-display",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1SessionIface, handle_set_display),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_session_method_marshal_set_display,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MetaDBusLogin1Session::handle-set-tty:
   * @object: A #MetaDBusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_tty_fd: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetTTY">SetTTY()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_set_tty() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-tty",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1SessionIface, handle_set_tty),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_session_method_marshal_set_tty,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * MetaDBusLogin1Session::handle-take-device:
   * @object: A #MetaDBusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_major: Argument passed by remote caller.
   * @arg_minor: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeDevice">TakeDevice()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_take_device() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-take-device",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1SessionIface, handle_take_device),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_session_method_marshal_take_device,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_UINT, G_TYPE_UINT);

  /**
   * MetaDBusLogin1Session::handle-release-device:
   * @object: A #MetaDBusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_major: Argument passed by remote caller.
   * @arg_minor: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseDevice">ReleaseDevice()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_release_device() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release-device",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1SessionIface, handle_release_device),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_session_method_marshal_release_device,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_UINT);

  /**
   * MetaDBusLogin1Session::handle-pause-device-complete:
   * @object: A #MetaDBusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_major: Argument passed by remote caller.
   * @arg_minor: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.PauseDeviceComplete">PauseDeviceComplete()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_pause_device_complete() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pause-device-complete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1SessionIface, handle_pause_device_complete),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_session_method_marshal_pause_device_complete,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_UINT);

  /**
   * MetaDBusLogin1Session::handle-set-brightness:
   * @object: A #MetaDBusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_subsystem: Argument passed by remote caller.
   * @arg_name: Argument passed by remote caller.
   * @arg_brightness: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetBrightness">SetBrightness()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_set_brightness() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-brightness",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusLogin1SessionIface, handle_set_brightness),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_login1_session_method_marshal_set_brightness,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT);

  /* GObject signals for received D-Bus signals: */
  /**
   * MetaDBusLogin1Session::pause-device:
   * @object: A #MetaDBusLogin1Session.
   * @arg_major: Argument.
   * @arg_minor: Argument.
   * @arg_type: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-login1-Session.PauseDevice">"PauseDevice"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__LOGIN1_SESSION_SIGNALS[META_DBUS__LOGIN1_SESSION_PAUSE_DEVICE] =
    g_signal_new ("pause-device",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusLogin1SessionIface, pause_device),
      NULL,
      NULL,
      meta_dbus_login1_session_signal_marshal_pause_device,
      G_TYPE_NONE,
      3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING);

  /**
   * MetaDBusLogin1Session::resume-device:
   * @object: A #MetaDBusLogin1Session.
   * @arg_major: Argument.
   * @arg_minor: Argument.
   * @arg_fd: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-login1-Session.ResumeDevice">"ResumeDevice"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__LOGIN1_SESSION_SIGNALS[META_DBUS__LOGIN1_SESSION_RESUME_DEVICE] =
    g_signal_new ("resume-device",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusLogin1SessionIface, resume_device),
      NULL,
      NULL,
      meta_dbus_login1_session_signal_marshal_resume_device,
      G_TYPE_NONE,
      3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_VARIANT);

  /**
   * MetaDBusLogin1Session::lock:
   * @object: A #MetaDBusLogin1Session.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-login1-Session.Lock">"Lock"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__LOGIN1_SESSION_SIGNALS[META_DBUS__LOGIN1_SESSION_LOCK] =
    g_signal_new ("lock",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusLogin1SessionIface, lock),
      NULL,
      NULL,
      meta_dbus_login1_session_signal_marshal_lock,
      G_TYPE_NONE,
      0);

  /**
   * MetaDBusLogin1Session::unlock:
   * @object: A #MetaDBusLogin1Session.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-login1-Session.Unlock">"Unlock"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__LOGIN1_SESSION_SIGNALS[META_DBUS__LOGIN1_SESSION_UNLOCK] =
    g_signal_new ("unlock",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusLogin1SessionIface, unlock),
      NULL,
      NULL,
      meta_dbus_login1_session_signal_marshal_unlock,
      G_TYPE_NONE,
      0);

  /* GObject properties for D-Bus properties: */
  /**
   * MetaDBusLogin1Session:id:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.Id">"Id"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("id", "Id", "Id", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:user:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.User">"User"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("user", "User", "User", G_VARIANT_TYPE ("(uo)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.Name">"Name"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("name", "Name", "Name", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.Timestamp">"Timestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("timestamp", "Timestamp", "Timestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.TimestampMonotonic">"TimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("timestamp-monotonic", "TimestampMonotonic", "TimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:vtnr:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.VTNr">"VTNr"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("vtnr", "VTNr", "VTNr", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:seat:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.Seat">"Seat"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("seat", "Seat", "Seat", G_VARIANT_TYPE ("(so)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:tty:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.TTY">"TTY"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("tty", "TTY", "TTY", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:display:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.Display">"Display"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("display", "Display", "Display", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:remote:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.Remote">"Remote"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("remote", "Remote", "Remote", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:remote-host:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.RemoteHost">"RemoteHost"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("remote-host", "RemoteHost", "RemoteHost", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:remote-user:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.RemoteUser">"RemoteUser"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("remote-user", "RemoteUser", "RemoteUser", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:service:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.Service">"Service"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("service", "Service", "Service", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:desktop:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.Desktop">"Desktop"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("desktop", "Desktop", "Desktop", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:scope:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.Scope">"Scope"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("scope", "Scope", "Scope", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:leader:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.Leader">"Leader"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("leader", "Leader", "Leader", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:audit:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.Audit">"Audit"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("audit", "Audit", "Audit", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:type:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.Type">"Type"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("type", "Type", "Type", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:class:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.Class">"Class"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("class", "Class", "Class", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:active:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.Active">"Active"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("active", "Active", "Active", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.State">"State"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("state", "State", "State", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:idle-hint:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.IdleHint">"IdleHint"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("idle-hint", "IdleHint", "IdleHint", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:idle-since-hint:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.IdleSinceHint">"IdleSinceHint"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("idle-since-hint", "IdleSinceHint", "IdleSinceHint", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:idle-since-hint-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.IdleSinceHintMonotonic">"IdleSinceHintMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("idle-since-hint-monotonic", "IdleSinceHintMonotonic", "IdleSinceHintMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusLogin1Session:locked-hint:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.LockedHint">"LockedHint"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("locked-hint", "LockedHint", "LockedHint", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * meta_dbus_login1_session_get_id: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Id">"Id"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_session_dup_id() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_session_get_id (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), NULL);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_id (object);
}

/**
 * meta_dbus_login1_session_dup_id: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Id">"Id"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_session_dup_id (MetaDBusLogin1Session *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "id", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_session_set_id: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.Id">"Id"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_id (MetaDBusLogin1Session *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "id", value, NULL);
}

/**
 * meta_dbus_login1_session_get_user: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.User">"User"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_session_dup_user() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
meta_dbus_login1_session_get_user (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), NULL);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_user (object);
}

/**
 * meta_dbus_login1_session_dup_user: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Session.User">"User"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
meta_dbus_login1_session_dup_user (MetaDBusLogin1Session *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "user", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_session_set_user: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.User">"User"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_user (MetaDBusLogin1Session *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "user", value, NULL);
}

/**
 * meta_dbus_login1_session_get_name: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_session_dup_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_session_get_name (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), NULL);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_name (object);
}

/**
 * meta_dbus_login1_session_dup_name: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_session_dup_name (MetaDBusLogin1Session *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "name", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_session_set_name: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.Name">"Name"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_name (MetaDBusLogin1Session *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "name", value, NULL);
}

/**
 * meta_dbus_login1_session_get_timestamp: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Timestamp">"Timestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
meta_dbus_login1_session_get_timestamp (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), 0);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_timestamp (object);
}

/**
 * meta_dbus_login1_session_set_timestamp: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.Timestamp">"Timestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_timestamp (MetaDBusLogin1Session *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "timestamp", value, NULL);
}

/**
 * meta_dbus_login1_session_get_timestamp_monotonic: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.TimestampMonotonic">"TimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
meta_dbus_login1_session_get_timestamp_monotonic (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), 0);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_timestamp_monotonic (object);
}

/**
 * meta_dbus_login1_session_set_timestamp_monotonic: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.TimestampMonotonic">"TimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_timestamp_monotonic (MetaDBusLogin1Session *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "timestamp-monotonic", value, NULL);
}

/**
 * meta_dbus_login1_session_get_vtnr: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.VTNr">"VTNr"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
meta_dbus_login1_session_get_vtnr (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), 0);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_vtnr (object);
}

/**
 * meta_dbus_login1_session_set_vtnr: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.VTNr">"VTNr"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_vtnr (MetaDBusLogin1Session *object, guint value)
{
  g_object_set (G_OBJECT (object), "vtnr", value, NULL);
}

/**
 * meta_dbus_login1_session_get_seat: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Seat">"Seat"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_session_dup_seat() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
meta_dbus_login1_session_get_seat (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), NULL);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_seat (object);
}

/**
 * meta_dbus_login1_session_dup_seat: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Seat">"Seat"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
meta_dbus_login1_session_dup_seat (MetaDBusLogin1Session *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "seat", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_session_set_seat: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.Seat">"Seat"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_seat (MetaDBusLogin1Session *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "seat", value, NULL);
}

/**
 * meta_dbus_login1_session_get_tty: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.TTY">"TTY"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_session_dup_tty() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_session_get_tty (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), NULL);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_tty (object);
}

/**
 * meta_dbus_login1_session_dup_tty: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Session.TTY">"TTY"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_session_dup_tty (MetaDBusLogin1Session *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "tty", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_session_set_tty: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.TTY">"TTY"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_tty (MetaDBusLogin1Session *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "tty", value, NULL);
}

/**
 * meta_dbus_login1_session_get_display: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Display">"Display"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_session_dup_display() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_session_get_display (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), NULL);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_display (object);
}

/**
 * meta_dbus_login1_session_dup_display: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Display">"Display"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_session_dup_display (MetaDBusLogin1Session *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "display", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_session_set_display: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.Display">"Display"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_display (MetaDBusLogin1Session *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "display", value, NULL);
}

/**
 * meta_dbus_login1_session_get_remote: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Remote">"Remote"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
meta_dbus_login1_session_get_remote (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), FALSE);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_remote (object);
}

/**
 * meta_dbus_login1_session_set_remote: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.Remote">"Remote"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_remote (MetaDBusLogin1Session *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "remote", value, NULL);
}

/**
 * meta_dbus_login1_session_get_remote_host: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.RemoteHost">"RemoteHost"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_session_dup_remote_host() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_session_get_remote_host (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), NULL);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_remote_host (object);
}

/**
 * meta_dbus_login1_session_dup_remote_host: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Session.RemoteHost">"RemoteHost"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_session_dup_remote_host (MetaDBusLogin1Session *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "remote-host", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_session_set_remote_host: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.RemoteHost">"RemoteHost"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_remote_host (MetaDBusLogin1Session *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "remote-host", value, NULL);
}

/**
 * meta_dbus_login1_session_get_remote_user: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.RemoteUser">"RemoteUser"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_session_dup_remote_user() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_session_get_remote_user (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), NULL);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_remote_user (object);
}

/**
 * meta_dbus_login1_session_dup_remote_user: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Session.RemoteUser">"RemoteUser"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_session_dup_remote_user (MetaDBusLogin1Session *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "remote-user", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_session_set_remote_user: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.RemoteUser">"RemoteUser"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_remote_user (MetaDBusLogin1Session *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "remote-user", value, NULL);
}

/**
 * meta_dbus_login1_session_get_service: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Service">"Service"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_session_dup_service() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_session_get_service (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), NULL);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_service (object);
}

/**
 * meta_dbus_login1_session_dup_service: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Service">"Service"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_session_dup_service (MetaDBusLogin1Session *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "service", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_session_set_service: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.Service">"Service"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_service (MetaDBusLogin1Session *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "service", value, NULL);
}

/**
 * meta_dbus_login1_session_get_desktop: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Desktop">"Desktop"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_session_dup_desktop() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_session_get_desktop (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), NULL);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_desktop (object);
}

/**
 * meta_dbus_login1_session_dup_desktop: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Desktop">"Desktop"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_session_dup_desktop (MetaDBusLogin1Session *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "desktop", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_session_set_desktop: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.Desktop">"Desktop"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_desktop (MetaDBusLogin1Session *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "desktop", value, NULL);
}

/**
 * meta_dbus_login1_session_get_scope: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Scope">"Scope"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_session_dup_scope() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_session_get_scope (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), NULL);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_scope (object);
}

/**
 * meta_dbus_login1_session_dup_scope: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Scope">"Scope"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_session_dup_scope (MetaDBusLogin1Session *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "scope", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_session_set_scope: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.Scope">"Scope"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_scope (MetaDBusLogin1Session *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "scope", value, NULL);
}

/**
 * meta_dbus_login1_session_get_leader: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Leader">"Leader"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
meta_dbus_login1_session_get_leader (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), 0);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_leader (object);
}

/**
 * meta_dbus_login1_session_set_leader: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.Leader">"Leader"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_leader (MetaDBusLogin1Session *object, guint value)
{
  g_object_set (G_OBJECT (object), "leader", value, NULL);
}

/**
 * meta_dbus_login1_session_get_audit: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Audit">"Audit"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
meta_dbus_login1_session_get_audit (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), 0);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_audit (object);
}

/**
 * meta_dbus_login1_session_set_audit: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.Audit">"Audit"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_audit (MetaDBusLogin1Session *object, guint value)
{
  g_object_set (G_OBJECT (object), "audit", value, NULL);
}

/**
 * meta_dbus_login1_session_get_type_: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Type">"Type"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_session_dup_type_() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_session_get_type_ (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), NULL);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_type_ (object);
}

/**
 * meta_dbus_login1_session_dup_type_: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Type">"Type"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_session_dup_type_ (MetaDBusLogin1Session *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "type", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_session_set_type_: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.Type">"Type"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_type_ (MetaDBusLogin1Session *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "type", value, NULL);
}

/**
 * meta_dbus_login1_session_get_class: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Class">"Class"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_session_dup_class() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_session_get_class (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), NULL);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_class (object);
}

/**
 * meta_dbus_login1_session_dup_class: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Class">"Class"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_session_dup_class (MetaDBusLogin1Session *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "class", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_session_set_class: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.Class">"Class"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_class (MetaDBusLogin1Session *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "class", value, NULL);
}

/**
 * meta_dbus_login1_session_get_active: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Active">"Active"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
meta_dbus_login1_session_get_active (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), FALSE);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_active (object);
}

/**
 * meta_dbus_login1_session_set_active: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.Active">"Active"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_active (MetaDBusLogin1Session *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "active", value, NULL);
}

/**
 * meta_dbus_login1_session_get_state: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.State">"State"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_login1_session_dup_state() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_login1_session_get_state (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), NULL);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_state (object);
}

/**
 * meta_dbus_login1_session_dup_state: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-login1-Session.State">"State"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_login1_session_dup_state (MetaDBusLogin1Session *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "state", &value, NULL);
  return value;
}

/**
 * meta_dbus_login1_session_set_state: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.State">"State"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_state (MetaDBusLogin1Session *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "state", value, NULL);
}

/**
 * meta_dbus_login1_session_get_idle_hint: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.IdleHint">"IdleHint"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
meta_dbus_login1_session_get_idle_hint (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), FALSE);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_idle_hint (object);
}

/**
 * meta_dbus_login1_session_set_idle_hint: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.IdleHint">"IdleHint"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_idle_hint (MetaDBusLogin1Session *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "idle-hint", value, NULL);
}

/**
 * meta_dbus_login1_session_get_idle_since_hint: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.IdleSinceHint">"IdleSinceHint"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
meta_dbus_login1_session_get_idle_since_hint (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), 0);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_idle_since_hint (object);
}

/**
 * meta_dbus_login1_session_set_idle_since_hint: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.IdleSinceHint">"IdleSinceHint"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_idle_since_hint (MetaDBusLogin1Session *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "idle-since-hint", value, NULL);
}

/**
 * meta_dbus_login1_session_get_idle_since_hint_monotonic: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.IdleSinceHintMonotonic">"IdleSinceHintMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
meta_dbus_login1_session_get_idle_since_hint_monotonic (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), 0);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_idle_since_hint_monotonic (object);
}

/**
 * meta_dbus_login1_session_set_idle_since_hint_monotonic: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.IdleSinceHintMonotonic">"IdleSinceHintMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_idle_since_hint_monotonic (MetaDBusLogin1Session *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "idle-since-hint-monotonic", value, NULL);
}

/**
 * meta_dbus_login1_session_get_locked_hint: (skip)
 * @object: A #MetaDBusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.LockedHint">"LockedHint"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
meta_dbus_login1_session_get_locked_hint (MetaDBusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_IS_LOGIN1_SESSION (object), FALSE);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_locked_hint (object);
}

/**
 * meta_dbus_login1_session_set_locked_hint: (skip)
 * @object: A #MetaDBusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.LockedHint">"LockedHint"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_locked_hint (MetaDBusLogin1Session *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "locked-hint", value, NULL);
}

/**
 * meta_dbus_login1_session_emit_pause_device:
 * @object: A #MetaDBusLogin1Session.
 * @arg_major: Argument to pass with the signal.
 * @arg_minor: Argument to pass with the signal.
 * @arg_type: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-login1-Session.PauseDevice">"PauseDevice"</link> D-Bus signal.
 */
void
meta_dbus_login1_session_emit_pause_device (
    MetaDBusLogin1Session *object,
    guint arg_major,
    guint arg_minor,
    const gchar *arg_type)
{
  g_signal_emit (object, META_DBUS__LOGIN1_SESSION_SIGNALS[META_DBUS__LOGIN1_SESSION_PAUSE_DEVICE], 0, arg_major, arg_minor, arg_type);
}

/**
 * meta_dbus_login1_session_emit_resume_device:
 * @object: A #MetaDBusLogin1Session.
 * @arg_major: Argument to pass with the signal.
 * @arg_minor: Argument to pass with the signal.
 * @arg_fd: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-login1-Session.ResumeDevice">"ResumeDevice"</link> D-Bus signal.
 */
void
meta_dbus_login1_session_emit_resume_device (
    MetaDBusLogin1Session *object,
    guint arg_major,
    guint arg_minor,
    GVariant *arg_fd)
{
  g_signal_emit (object, META_DBUS__LOGIN1_SESSION_SIGNALS[META_DBUS__LOGIN1_SESSION_RESUME_DEVICE], 0, arg_major, arg_minor, arg_fd);
}

/**
 * meta_dbus_login1_session_emit_lock:
 * @object: A #MetaDBusLogin1Session.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-login1-Session.Lock">"Lock"</link> D-Bus signal.
 */
void
meta_dbus_login1_session_emit_lock (
    MetaDBusLogin1Session *object)
{
  g_signal_emit (object, META_DBUS__LOGIN1_SESSION_SIGNALS[META_DBUS__LOGIN1_SESSION_LOCK], 0);
}

/**
 * meta_dbus_login1_session_emit_unlock:
 * @object: A #MetaDBusLogin1Session.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-login1-Session.Unlock">"Unlock"</link> D-Bus signal.
 */
void
meta_dbus_login1_session_emit_unlock (
    MetaDBusLogin1Session *object)
{
  g_signal_emit (object, META_DBUS__LOGIN1_SESSION_SIGNALS[META_DBUS__LOGIN1_SESSION_UNLOCK], 0);
}

/**
 * meta_dbus_login1_session_call_terminate:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.Terminate">Terminate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_terminate_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_terminate_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_terminate (
    MetaDBusLogin1Session *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Terminate",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_terminate_finish:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_terminate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_terminate().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_terminate_finish (
    MetaDBusLogin1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_terminate_sync:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.Terminate">Terminate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_terminate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_terminate_sync (
    MetaDBusLogin1Session *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Terminate",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_activate:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.Activate">Activate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_activate_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_activate_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_activate (
    MetaDBusLogin1Session *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Activate",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_activate_finish:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_activate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_activate().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_activate_finish (
    MetaDBusLogin1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_activate_sync:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.Activate">Activate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_activate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_activate_sync (
    MetaDBusLogin1Session *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Activate",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_lock:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.Lock">Lock()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_lock_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_lock_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_lock (
    MetaDBusLogin1Session *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Lock",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_lock_finish:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_lock().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_lock().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_lock_finish (
    MetaDBusLogin1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_lock_sync:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.Lock">Lock()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_lock() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_lock_sync (
    MetaDBusLogin1Session *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Lock",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_unlock:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.Unlock">Unlock()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_unlock_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_unlock_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_unlock (
    MetaDBusLogin1Session *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Unlock",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_unlock_finish:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_unlock().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_unlock().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_unlock_finish (
    MetaDBusLogin1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_unlock_sync:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.Unlock">Unlock()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_unlock() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_unlock_sync (
    MetaDBusLogin1Session *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Unlock",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_set_idle_hint:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_idle: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetIdleHint">SetIdleHint()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_set_idle_hint_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_set_idle_hint_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_set_idle_hint (
    MetaDBusLogin1Session *proxy,
    gboolean arg_idle,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetIdleHint",
    g_variant_new ("(b)",
                   arg_idle),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_set_idle_hint_finish:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_set_idle_hint().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_set_idle_hint().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_set_idle_hint_finish (
    MetaDBusLogin1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_set_idle_hint_sync:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_idle: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetIdleHint">SetIdleHint()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_set_idle_hint() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_set_idle_hint_sync (
    MetaDBusLogin1Session *proxy,
    gboolean arg_idle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetIdleHint",
    g_variant_new ("(b)",
                   arg_idle),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_set_locked_hint:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_locked: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetLockedHint">SetLockedHint()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_set_locked_hint_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_set_locked_hint_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_set_locked_hint (
    MetaDBusLogin1Session *proxy,
    gboolean arg_locked,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetLockedHint",
    g_variant_new ("(b)",
                   arg_locked),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_set_locked_hint_finish:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_set_locked_hint().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_set_locked_hint().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_set_locked_hint_finish (
    MetaDBusLogin1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_set_locked_hint_sync:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_locked: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetLockedHint">SetLockedHint()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_set_locked_hint() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_set_locked_hint_sync (
    MetaDBusLogin1Session *proxy,
    gboolean arg_locked,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetLockedHint",
    g_variant_new ("(b)",
                   arg_locked),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_kill:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_who: Argument to pass with the method invocation.
 * @arg_signal_number: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.Kill">Kill()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_kill_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_kill_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_kill (
    MetaDBusLogin1Session *proxy,
    const gchar *arg_who,
    gint arg_signal_number,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Kill",
    g_variant_new ("(si)",
                   arg_who,
                   arg_signal_number),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_kill_finish:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_kill().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_kill().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_kill_finish (
    MetaDBusLogin1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_kill_sync:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_who: Argument to pass with the method invocation.
 * @arg_signal_number: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.Kill">Kill()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_kill() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_kill_sync (
    MetaDBusLogin1Session *proxy,
    const gchar *arg_who,
    gint arg_signal_number,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Kill",
    g_variant_new ("(si)",
                   arg_who,
                   arg_signal_number),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_take_control:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_force: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeControl">TakeControl()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_take_control_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_take_control_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_take_control (
    MetaDBusLogin1Session *proxy,
    gboolean arg_force,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "TakeControl",
    g_variant_new ("(b)",
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_take_control_finish:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_take_control().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_take_control().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_take_control_finish (
    MetaDBusLogin1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_take_control_sync:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_force: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeControl">TakeControl()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_take_control() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_take_control_sync (
    MetaDBusLogin1Session *proxy,
    gboolean arg_force,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "TakeControl",
    g_variant_new ("(b)",
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_release_control:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseControl">ReleaseControl()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_release_control_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_release_control_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_release_control (
    MetaDBusLogin1Session *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReleaseControl",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_release_control_finish:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_release_control().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_release_control().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_release_control_finish (
    MetaDBusLogin1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_release_control_sync:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseControl">ReleaseControl()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_release_control() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_release_control_sync (
    MetaDBusLogin1Session *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReleaseControl",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_set_type:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetType">SetType()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_set_type_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_set_type_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_set_type (
    MetaDBusLogin1Session *proxy,
    const gchar *arg_type,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetType",
    g_variant_new ("(s)",
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_set_type_finish:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_set_type().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_set_type().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_set_type_finish (
    MetaDBusLogin1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_set_type_sync:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetType">SetType()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_set_type() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_set_type_sync (
    MetaDBusLogin1Session *proxy,
    const gchar *arg_type,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetType",
    g_variant_new ("(s)",
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_set_display:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_display: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetDisplay">SetDisplay()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_set_display_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_set_display_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_set_display (
    MetaDBusLogin1Session *proxy,
    const gchar *arg_display,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetDisplay",
    g_variant_new ("(s)",
                   arg_display),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_set_display_finish:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_set_display().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_set_display().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_set_display_finish (
    MetaDBusLogin1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_set_display_sync:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_display: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetDisplay">SetDisplay()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_set_display() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_set_display_sync (
    MetaDBusLogin1Session *proxy,
    const gchar *arg_display,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetDisplay",
    g_variant_new ("(s)",
                   arg_display),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_set_tty:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_tty_fd: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetTTY">SetTTY()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_set_tty_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_set_tty_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_set_tty (
    MetaDBusLogin1Session *proxy,
    GVariant *arg_tty_fd,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetTTY",
    g_variant_new ("(@h)",
                   arg_tty_fd),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_set_tty_finish:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_set_tty().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_set_tty().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_set_tty_finish (
    MetaDBusLogin1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_set_tty_sync:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_tty_fd: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetTTY">SetTTY()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_set_tty() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_set_tty_sync (
    MetaDBusLogin1Session *proxy,
    GVariant *arg_tty_fd,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetTTY",
    g_variant_new ("(@h)",
                   arg_tty_fd),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_take_device:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_major: Argument to pass with the method invocation.
 * @arg_minor: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeDevice">TakeDevice()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_take_device_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_take_device_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_take_device (
    MetaDBusLogin1Session *proxy,
    guint arg_major,
    guint arg_minor,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "TakeDevice",
    g_variant_new ("(uu)",
                   arg_major,
                   arg_minor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_take_device_finish:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_inactive: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_take_device().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_take_device().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_take_device_finish (
    MetaDBusLogin1Session *proxy,
    GVariant **out_fd,
    gboolean *out_inactive,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@hb)",
                 out_fd,
                 out_inactive);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_take_device_sync:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_major: Argument to pass with the method invocation.
 * @arg_minor: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_inactive: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeDevice">TakeDevice()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_take_device() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_take_device_sync (
    MetaDBusLogin1Session *proxy,
    guint arg_major,
    guint arg_minor,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    gboolean *out_inactive,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "TakeDevice",
    g_variant_new ("(uu)",
                   arg_major,
                   arg_minor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@hb)",
                 out_fd,
                 out_inactive);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_release_device:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_major: Argument to pass with the method invocation.
 * @arg_minor: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseDevice">ReleaseDevice()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_release_device_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_release_device_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_release_device (
    MetaDBusLogin1Session *proxy,
    guint arg_major,
    guint arg_minor,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReleaseDevice",
    g_variant_new ("(uu)",
                   arg_major,
                   arg_minor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_release_device_finish:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_release_device().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_release_device().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_release_device_finish (
    MetaDBusLogin1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_release_device_sync:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_major: Argument to pass with the method invocation.
 * @arg_minor: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseDevice">ReleaseDevice()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_release_device() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_release_device_sync (
    MetaDBusLogin1Session *proxy,
    guint arg_major,
    guint arg_minor,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReleaseDevice",
    g_variant_new ("(uu)",
                   arg_major,
                   arg_minor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_pause_device_complete:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_major: Argument to pass with the method invocation.
 * @arg_minor: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.PauseDeviceComplete">PauseDeviceComplete()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_pause_device_complete_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_pause_device_complete_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_pause_device_complete (
    MetaDBusLogin1Session *proxy,
    guint arg_major,
    guint arg_minor,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PauseDeviceComplete",
    g_variant_new ("(uu)",
                   arg_major,
                   arg_minor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_pause_device_complete_finish:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_pause_device_complete().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_pause_device_complete().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_pause_device_complete_finish (
    MetaDBusLogin1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_pause_device_complete_sync:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_major: Argument to pass with the method invocation.
 * @arg_minor: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.PauseDeviceComplete">PauseDeviceComplete()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_pause_device_complete() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_pause_device_complete_sync (
    MetaDBusLogin1Session *proxy,
    guint arg_major,
    guint arg_minor,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PauseDeviceComplete",
    g_variant_new ("(uu)",
                   arg_major,
                   arg_minor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_set_brightness:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_subsystem: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_brightness: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetBrightness">SetBrightness()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_set_brightness_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_set_brightness_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_set_brightness (
    MetaDBusLogin1Session *proxy,
    const gchar *arg_subsystem,
    const gchar *arg_name,
    guint arg_brightness,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetBrightness",
    g_variant_new ("(ssu)",
                   arg_subsystem,
                   arg_name,
                   arg_brightness),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_set_brightness_finish:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_set_brightness().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_set_brightness().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_set_brightness_finish (
    MetaDBusLogin1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_set_brightness_sync:
 * @proxy: A #MetaDBusLogin1SessionProxy.
 * @arg_subsystem: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_brightness: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetBrightness">SetBrightness()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_set_brightness() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_set_brightness_sync (
    MetaDBusLogin1Session *proxy,
    const gchar *arg_subsystem,
    const gchar *arg_name,
    guint arg_brightness,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetBrightness",
    g_variant_new ("(ssu)",
                   arg_subsystem,
                   arg_name,
                   arg_brightness),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_complete_terminate:
 * @object: A #MetaDBusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.Terminate">Terminate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_terminate (
    MetaDBusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_session_complete_activate:
 * @object: A #MetaDBusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.Activate">Activate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_activate (
    MetaDBusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_session_complete_lock:
 * @object: A #MetaDBusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.Lock">Lock()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_lock (
    MetaDBusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_session_complete_unlock:
 * @object: A #MetaDBusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.Unlock">Unlock()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_unlock (
    MetaDBusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_session_complete_set_idle_hint:
 * @object: A #MetaDBusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetIdleHint">SetIdleHint()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_set_idle_hint (
    MetaDBusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_session_complete_set_locked_hint:
 * @object: A #MetaDBusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetLockedHint">SetLockedHint()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_set_locked_hint (
    MetaDBusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_session_complete_kill:
 * @object: A #MetaDBusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.Kill">Kill()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_kill (
    MetaDBusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_session_complete_take_control:
 * @object: A #MetaDBusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeControl">TakeControl()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_take_control (
    MetaDBusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_session_complete_release_control:
 * @object: A #MetaDBusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseControl">ReleaseControl()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_release_control (
    MetaDBusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_session_complete_set_type:
 * @object: A #MetaDBusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetType">SetType()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_set_type (
    MetaDBusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_session_complete_set_display:
 * @object: A #MetaDBusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetDisplay">SetDisplay()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_set_display (
    MetaDBusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_session_complete_set_tty:
 * @object: A #MetaDBusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetTTY">SetTTY()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_set_tty (
    MetaDBusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_session_complete_take_device:
 * @object: A #MetaDBusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 * @inactive: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeDevice">TakeDevice()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_take_device (
    MetaDBusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd,
    gboolean inactive)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@hb)",
                   fd,
                   inactive),
    fd_list);
}

/**
 * meta_dbus_login1_session_complete_release_device:
 * @object: A #MetaDBusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseDevice">ReleaseDevice()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_release_device (
    MetaDBusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_session_complete_pause_device_complete:
 * @object: A #MetaDBusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.PauseDeviceComplete">PauseDeviceComplete()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_pause_device_complete (
    MetaDBusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_session_complete_set_brightness:
 * @object: A #MetaDBusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.SetBrightness">SetBrightness()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_set_brightness (
    MetaDBusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MetaDBusLogin1SessionProxy:
 *
 * The #MetaDBusLogin1SessionProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDBusLogin1SessionProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDBusLogin1SessionProxy.
 */

struct _MetaDBusLogin1SessionProxyPrivate
{
  GData *qdata;
};

static void meta_dbus_login1_session_proxy_iface_init (MetaDBusLogin1SessionIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDBusLogin1SessionProxy, meta_dbus_login1_session_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MetaDBusLogin1SessionProxy)
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_LOGIN1_SESSION, meta_dbus_login1_session_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDBusLogin1SessionProxy, meta_dbus_login1_session_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_LOGIN1_SESSION, meta_dbus_login1_session_proxy_iface_init))

#endif
static void
meta_dbus_login1_session_proxy_finalize (GObject *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (meta_dbus_login1_session_proxy_parent_class)->finalize (object);
}

static void
meta_dbus_login1_session_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 25);
  info = (const _ExtendedGDBusPropertyInfo *) _meta_dbus_login1_session_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
meta_dbus_login1_session_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.login1.Session: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
meta_dbus_login1_session_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 25);
  info = (const _ExtendedGDBusPropertyInfo *) _meta_dbus_login1_session_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.login1.Session", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) meta_dbus_login1_session_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
meta_dbus_login1_session_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_meta_dbus_login1_session_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], META_DBUS_TYPE_LOGIN1_SESSION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_TYPE_LOGIN1_SESSION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
meta_dbus_login1_session_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_login1_session_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_login1_session_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
meta_dbus_login1_session_proxy_get_id (MetaDBusLogin1Session *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Id");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
meta_dbus_login1_session_proxy_get_user (MetaDBusLogin1Session *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "User");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static const gchar *
meta_dbus_login1_session_proxy_get_name (MetaDBusLogin1Session *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Name");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
meta_dbus_login1_session_proxy_get_timestamp (MetaDBusLogin1Session *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Timestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
meta_dbus_login1_session_proxy_get_timestamp_monotonic (MetaDBusLogin1Session *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "TimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
meta_dbus_login1_session_proxy_get_vtnr (MetaDBusLogin1Session *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "VTNr");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
meta_dbus_login1_session_proxy_get_seat (MetaDBusLogin1Session *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Seat");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static const gchar *
meta_dbus_login1_session_proxy_get_tty (MetaDBusLogin1Session *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "TTY");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_session_proxy_get_display (MetaDBusLogin1Session *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Display");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
meta_dbus_login1_session_proxy_get_remote (MetaDBusLogin1Session *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Remote");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_session_proxy_get_remote_host (MetaDBusLogin1Session *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RemoteHost");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_session_proxy_get_remote_user (MetaDBusLogin1Session *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RemoteUser");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_session_proxy_get_service (MetaDBusLogin1Session *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Service");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_session_proxy_get_desktop (MetaDBusLogin1Session *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Desktop");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_session_proxy_get_scope (MetaDBusLogin1Session *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Scope");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
meta_dbus_login1_session_proxy_get_leader (MetaDBusLogin1Session *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Leader");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
meta_dbus_login1_session_proxy_get_audit (MetaDBusLogin1Session *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Audit");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_session_proxy_get_type_ (MetaDBusLogin1Session *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Type");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_session_proxy_get_class (MetaDBusLogin1Session *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Class");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
meta_dbus_login1_session_proxy_get_active (MetaDBusLogin1Session *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Active");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
meta_dbus_login1_session_proxy_get_state (MetaDBusLogin1Session *object)
{
  MetaDBusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant