/* parsed class NVB06F */

#include "nvtypes.h"
#include "clb06f.h"

#include <assert.h>
#include <stdio.h>
#include "util/u_math.h"

struct nv_nvb06f_SET_OBJECT {
    uint32_t nvclass;
    uint32_t engine;
};

static inline void
__NVB06F_SET_OBJECT(uint32_t *val_out, struct nv_nvb06f_SET_OBJECT st)
{
    uint32_t val = 0;
    
    assert(st.nvclass < (1ULL << 16));
    val |= st.nvclass << 0;
    
    assert(st.engine < (1ULL << 5));
    val |= st.engine << 16;
    *val_out = val;
}

#define V_NVB06F_SET_OBJECT(val, args...) { \
    UNUSED uint32_t ENGINE_SW = NVB06F_SET_OBJECT_ENGINE_SW; \
    struct nv_nvb06f_SET_OBJECT __data = args; \
    __NVB06F_SET_OBJECT(&val, __data); \
}

#define VA_NVB06F_SET_OBJECT V_NVB06F_SET_OBJECT

#define P_NVB06F_SET_OBJECT(push, args...) do { \
    UNUSED uint32_t ENGINE_SW = NVB06F_SET_OBJECT_ENGINE_SW; \
    uint32_t nvk_p_ret; \
    V_NVB06F_SET_OBJECT(nvk_p_ret, args); \
    nv_push_val(push, NVB06F_SET_OBJECT, nvk_p_ret); \
} while(0)

struct nv_nvb06f_ILLEGAL {
    uint32_t handle;
};

static inline void
__NVB06F_ILLEGAL(uint32_t *val_out, struct nv_nvb06f_ILLEGAL st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVB06F_ILLEGAL(val, args...) { \
    struct nv_nvb06f_ILLEGAL __data = { .handle = (args) }; \
    __NVB06F_ILLEGAL(&val, __data); \
}

#define VA_NVB06F_ILLEGAL V_NVB06F_ILLEGAL

#define P_NVB06F_ILLEGAL(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVB06F_ILLEGAL(nvk_p_ret, args); \
    nv_push_val(push, NVB06F_ILLEGAL, nvk_p_ret); \
} while(0)

struct nv_nvb06f_NOP {
    uint32_t handle;
};

static inline void
__NVB06F_NOP(uint32_t *val_out, struct nv_nvb06f_NOP st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVB06F_NOP(val, args...) { \
    struct nv_nvb06f_NOP __data = { .handle = (args) }; \
    __NVB06F_NOP(&val, __data); \
}

#define VA_NVB06F_NOP V_NVB06F_NOP

#define P_NVB06F_NOP(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVB06F_NOP(nvk_p_ret, args); \
    nv_push_val(push, NVB06F_NOP, nvk_p_ret); \
} while(0)

struct nv_nvb06f_SEMAPHOREA {
    uint32_t offset_upper;
};

static inline void
__NVB06F_SEMAPHOREA(uint32_t *val_out, struct nv_nvb06f_SEMAPHOREA st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVB06F_SEMAPHOREA(val, args...) { \
    struct nv_nvb06f_SEMAPHOREA __data = { .offset_upper = (args) }; \
    __NVB06F_SEMAPHOREA(&val, __data); \
}

#define VA_NVB06F_SEMAPHOREA V_NVB06F_SEMAPHOREA

#define P_NVB06F_SEMAPHOREA(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVB06F_SEMAPHOREA(nvk_p_ret, args); \
    nv_push_val(push, NVB06F_SEMAPHOREA, nvk_p_ret); \
} while(0)

struct nv_nvb06f_SEMAPHOREB {
    uint32_t offset_lower;
};

static inline void
__NVB06F_SEMAPHOREB(uint32_t *val_out, struct nv_nvb06f_SEMAPHOREB st)
{
    uint32_t val = 0;
    
    assert(st.offset_lower < (1ULL << 30));
    val |= st.offset_lower << 2;
    *val_out = val;
}

#define V_NVB06F_SEMAPHOREB(val, args...) { \
    struct nv_nvb06f_SEMAPHOREB __data = { .offset_lower = (args) }; \
    __NVB06F_SEMAPHOREB(&val, __data); \
}

#define VA_NVB06F_SEMAPHOREB V_NVB06F_SEMAPHOREB

#define P_NVB06F_SEMAPHOREB(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVB06F_SEMAPHOREB(nvk_p_ret, args); \
    nv_push_val(push, NVB06F_SEMAPHOREB, nvk_p_ret); \
} while(0)

struct nv_nvb06f_SEMAPHOREC {
    uint32_t payload;
};

static inline void
__NVB06F_SEMAPHOREC(uint32_t *val_out, struct nv_nvb06f_SEMAPHOREC st)
{
    uint32_t val = 0;
    
    val |= st.payload;
    *val_out = val;
}

#define V_NVB06F_SEMAPHOREC(val, args...) { \
    struct nv_nvb06f_SEMAPHOREC __data = { .payload = (args) }; \
    __NVB06F_SEMAPHOREC(&val, __data); \
}

#define VA_NVB06F_SEMAPHOREC V_NVB06F_SEMAPHOREC

#define P_NVB06F_SEMAPHOREC(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVB06F_SEMAPHOREC(nvk_p_ret, args); \
    nv_push_val(push, NVB06F_SEMAPHOREC, nvk_p_ret); \
} while(0)

struct nv_nvb06f_SEMAPHORED {
    uint32_t operation;
    uint32_t acquire_switch;
    uint32_t release_wfi;
    uint32_t release_size;
    uint32_t reduction;
    uint32_t format;
};

static inline void
__NVB06F_SEMAPHORED(uint32_t *val_out, struct nv_nvb06f_SEMAPHORED st)
{
    uint32_t val = 0;
    
    assert(st.operation < (1ULL << 5));
    val |= st.operation << 0;
    
    assert(st.acquire_switch < (1ULL << 1));
    val |= st.acquire_switch << 12;
    
    assert(st.release_wfi < (1ULL << 1));
    val |= st.release_wfi << 20;
    
    assert(st.release_size < (1ULL << 1));
    val |= st.release_size << 24;
    
    assert(st.reduction < (1ULL << 4));
    val |= st.reduction << 27;
    
    assert(st.format < (1ULL << 1));
    val |= st.format << 31;
    *val_out = val;
}

#define V_NVB06F_SEMAPHORED(val, args...) { \
    UNUSED uint32_t OPERATION_ACQUIRE = NVB06F_SEMAPHORED_OPERATION_ACQUIRE; \
    UNUSED uint32_t OPERATION_RELEASE = NVB06F_SEMAPHORED_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_ACQ_GEQ = NVB06F_SEMAPHORED_OPERATION_ACQ_GEQ; \
    UNUSED uint32_t OPERATION_ACQ_AND = NVB06F_SEMAPHORED_OPERATION_ACQ_AND; \
    UNUSED uint32_t OPERATION_REDUCTION = NVB06F_SEMAPHORED_OPERATION_REDUCTION; \
    UNUSED uint32_t ACQUIRE_SWITCH_DISABLED = NVB06F_SEMAPHORED_ACQUIRE_SWITCH_DISABLED; \
    UNUSED uint32_t ACQUIRE_SWITCH_ENABLED = NVB06F_SEMAPHORED_ACQUIRE_SWITCH_ENABLED; \
    UNUSED uint32_t RELEASE_WFI_EN = NVB06F_SEMAPHORED_RELEASE_WFI_EN; \
    UNUSED uint32_t RELEASE_WFI_DIS = NVB06F_SEMAPHORED_RELEASE_WFI_DIS; \
    UNUSED uint32_t RELEASE_SIZE_16BYTE = NVB06F_SEMAPHORED_RELEASE_SIZE_16BYTE; \
    UNUSED uint32_t RELEASE_SIZE_4BYTE = NVB06F_SEMAPHORED_RELEASE_SIZE_4BYTE; \
    UNUSED uint32_t REDUCTION_MIN = NVB06F_SEMAPHORED_REDUCTION_MIN; \
    UNUSED uint32_t REDUCTION_MAX = NVB06F_SEMAPHORED_REDUCTION_MAX; \
    UNUSED uint32_t REDUCTION_XOR = NVB06F_SEMAPHORED_REDUCTION_XOR; \
    UNUSED uint32_t REDUCTION_AND = NVB06F_SEMAPHORED_REDUCTION_AND; \
    UNUSED uint32_t REDUCTION_OR = NVB06F_SEMAPHORED_REDUCTION_OR; \
    UNUSED uint32_t REDUCTION_ADD = NVB06F_SEMAPHORED_REDUCTION_ADD; \
    UNUSED uint32_t REDUCTION_INC = NVB06F_SEMAPHORED_REDUCTION_INC; \
    UNUSED uint32_t REDUCTION_DEC = NVB06F_SEMAPHORED_REDUCTION_DEC; \
    UNUSED uint32_t FORMAT_SIGNED = NVB06F_SEMAPHORED_FORMAT_SIGNED; \
    UNUSED uint32_t FORMAT_UNSIGNED = NVB06F_SEMAPHORED_FORMAT_UNSIGNED; \
    struct nv_nvb06f_SEMAPHORED __data = args; \
    __NVB06F_SEMAPHORED(&val, __data); \
}

#define VA_NVB06F_SEMAPHORED V_NVB06F_SEMAPHORED

#define P_NVB06F_SEMAPHORED(push, args...) do { \
    UNUSED uint32_t OPERATION_ACQUIRE = NVB06F_SEMAPHORED_OPERATION_ACQUIRE; \
    UNUSED uint32_t OPERATION_RELEASE = NVB06F_SEMAPHORED_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_ACQ_GEQ = NVB06F_SEMAPHORED_OPERATION_ACQ_GEQ; \
    UNUSED uint32_t OPERATION_ACQ_AND = NVB06F_SEMAPHORED_OPERATION_ACQ_AND; \
    UNUSED uint32_t OPERATION_REDUCTION = NVB06F_SEMAPHORED_OPERATION_REDUCTION; \
    UNUSED uint32_t ACQUIRE_SWITCH_DISABLED = NVB06F_SEMAPHORED_ACQUIRE_SWITCH_DISABLED; \
    UNUSED uint32_t ACQUIRE_SWITCH_ENABLED = NVB06F_SEMAPHORED_ACQUIRE_SWITCH_ENABLED; \
    UNUSED uint32_t RELEASE_WFI_EN = NVB06F_SEMAPHORED_RELEASE_WFI_EN; \
    UNUSED uint32_t RELEASE_WFI_DIS = NVB06F_SEMAPHORED_RELEASE_WFI_DIS; \
    UNUSED uint32_t RELEASE_SIZE_16BYTE = NVB06F_SEMAPHORED_RELEASE_SIZE_16BYTE; \
    UNUSED uint32_t RELEASE_SIZE_4BYTE = NVB06F_SEMAPHORED_RELEASE_SIZE_4BYTE; \
    UNUSED uint32_t REDUCTION_MIN = NVB06F_SEMAPHORED_REDUCTION_MIN; \
    UNUSED uint32_t REDUCTION_MAX = NVB06F_SEMAPHORED_REDUCTION_MAX; \
    UNUSED uint32_t REDUCTION_XOR = NVB06F_SEMAPHORED_REDUCTION_XOR; \
    UNUSED uint32_t REDUCTION_AND = NVB06F_SEMAPHORED_REDUCTION_AND; \
    UNUSED uint32_t REDUCTION_OR = NVB06F_SEMAPHORED_REDUCTION_OR; \
    UNUSED uint32_t REDUCTION_ADD = NVB06F_SEMAPHORED_REDUCTION_ADD; \
    UNUSED uint32_t REDUCTION_INC = NVB06F_SEMAPHORED_REDUCTION_INC; \
    UNUSED uint32_t REDUCTION_DEC = NVB06F_SEMAPHORED_REDUCTION_DEC; \
    UNUSED uint32_t FORMAT_SIGNED = NVB06F_SEMAPHORED_FORMAT_SIGNED; \
    UNUSED uint32_t FORMAT_UNSIGNED = NVB06F_SEMAPHORED_FORMAT_UNSIGNED; \
    uint32_t nvk_p_ret; \
    V_NVB06F_SEMAPHORED(nvk_p_ret, args); \
    nv_push_val(push, NVB06F_SEMAPHORED, nvk_p_ret); \
} while(0)

struct nv_nvb06f_NON_STALL_INTERRUPT {
    uint32_t handle;
};

static inline void
__NVB06F_NON_STALL_INTERRUPT(uint32_t *val_out, struct nv_nvb06f_NON_STALL_INTERRUPT st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVB06F_NON_STALL_INTERRUPT(val, args...) { \
    struct nv_nvb06f_NON_STALL_INTERRUPT __data = { .handle = (args) }; \
    __NVB06F_NON_STALL_INTERRUPT(&val, __data); \
}

#define VA_NVB06F_NON_STALL_INTERRUPT V_NVB06F_NON_STALL_INTERRUPT

#define P_NVB06F_NON_STALL_INTERRUPT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVB06F_NON_STALL_INTERRUPT(nvk_p_ret, args); \
    nv_push_val(push, NVB06F_NON_STALL_INTERRUPT, nvk_p_ret); \
} while(0)

struct nv_nvb06f_FB_FLUSH {
    uint32_t handle;
};

static inline void
__NVB06F_FB_FLUSH(uint32_t *val_out, struct nv_nvb06f_FB_FLUSH st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVB06F_FB_FLUSH(val, args...) { \
    struct nv_nvb06f_FB_FLUSH __data = { .handle = (args) }; \
    __NVB06F_FB_FLUSH(&val, __data); \
}

#define VA_NVB06F_FB_FLUSH V_NVB06F_FB_FLUSH

#define P_NVB06F_FB_FLUSH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVB06F_FB_FLUSH(nvk_p_ret, args); \
    nv_push_val(push, NVB06F_FB_FLUSH, nvk_p_ret); \
} while(0)

struct nv_nvb06f_MEM_OP_C {
    uint32_t operand_low;
    uint32_t tlb_invalidate_pdb;
    uint32_t tlb_invalidate_gpc;
    uint32_t tlb_invalidate_target;
    uint32_t tlb_invalidate_addr_lo;
};

static inline void
__NVB06F_MEM_OP_C(uint32_t *val_out, struct nv_nvb06f_MEM_OP_C st)
{
    uint32_t val = 0;
    
    assert(st.operand_low < (1ULL << 30));
    val |= st.operand_low << 2;
    
    assert(st.tlb_invalidate_pdb < (1ULL << 1));
    val |= st.tlb_invalidate_pdb << 0;
    
    assert(st.tlb_invalidate_gpc < (1ULL << 1));
    val |= st.tlb_invalidate_gpc << 1;
    
    assert(st.tlb_invalidate_target < (1ULL << 2));
    val |= st.tlb_invalidate_target << 10;
    
    assert(st.tlb_invalidate_addr_lo < (1ULL << 20));
    val |= st.tlb_invalidate_addr_lo << 12;
    *val_out = val;
}

#define V_NVB06F_MEM_OP_C(val, args...) { \
    UNUSED uint32_t TLB_INVALIDATE_PDB_ONE = NVB06F_MEM_OP_C_TLB_INVALIDATE_PDB_ONE; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_ALL = NVB06F_MEM_OP_C_TLB_INVALIDATE_PDB_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_GPC_ENABLE = NVB06F_MEM_OP_C_TLB_INVALIDATE_GPC_ENABLE; \
    UNUSED uint32_t TLB_INVALIDATE_GPC_DISABLE = NVB06F_MEM_OP_C_TLB_INVALIDATE_GPC_DISABLE; \
    UNUSED uint32_t TLB_INVALIDATE_TARGET_VID_MEM = NVB06F_MEM_OP_C_TLB_INVALIDATE_TARGET_VID_MEM; \
    UNUSED uint32_t TLB_INVALIDATE_TARGET_SYS_MEM_COHERENT = NVB06F_MEM_OP_C_TLB_INVALIDATE_TARGET_SYS_MEM_COHERENT; \
    UNUSED uint32_t TLB_INVALIDATE_TARGET_SYS_MEM_NONCOHERENT = NVB06F_MEM_OP_C_TLB_INVALIDATE_TARGET_SYS_MEM_NONCOHERENT; \
    struct nv_nvb06f_MEM_OP_C __data = args; \
    __NVB06F_MEM_OP_C(&val, __data); \
}

#define VA_NVB06F_MEM_OP_C V_NVB06F_MEM_OP_C

#define P_NVB06F_MEM_OP_C(push, args...) do { \
    UNUSED uint32_t TLB_INVALIDATE_PDB_ONE = NVB06F_MEM_OP_C_TLB_INVALIDATE_PDB_ONE; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_ALL = NVB06F_MEM_OP_C_TLB_INVALIDATE_PDB_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_GPC_ENABLE = NVB06F_MEM_OP_C_TLB_INVALIDATE_GPC_ENABLE; \
    UNUSED uint32_t TLB_INVALIDATE_GPC_DISABLE = NVB06F_MEM_OP_C_TLB_INVALIDATE_GPC_DISABLE; \
    UNUSED uint32_t TLB_INVALIDATE_TARGET_VID_MEM = NVB06F_MEM_OP_C_TLB_INVALIDATE_TARGET_VID_MEM; \
    UNUSED uint32_t TLB_INVALIDATE_TARGET_SYS_MEM_COHERENT = NVB06F_MEM_OP_C_TLB_INVALIDATE_TARGET_SYS_MEM_COHERENT; \
    UNUSED uint32_t TLB_INVALIDATE_TARGET_SYS_MEM_NONCOHERENT = NVB06F_MEM_OP_C_TLB_INVALIDATE_TARGET_SYS_MEM_NONCOHERENT; \
    uint32_t nvk_p_ret; \
    V_NVB06F_MEM_OP_C(nvk_p_ret, args); \
    nv_push_val(push, NVB06F_MEM_OP_C, nvk_p_ret); \
} while(0)

struct nv_nvb06f_MEM_OP_D {
    uint32_t operand_high;
    uint32_t operation;
    uint32_t tlb_invalidate_addr_hi;
};

static inline void
__NVB06F_MEM_OP_D(uint32_t *val_out, struct nv_nvb06f_MEM_OP_D st)
{
    uint32_t val = 0;
    
    assert(st.operand_high < (1ULL << 8));
    val |= st.operand_high << 0;
    
    assert(st.operation < (1ULL << 5));
    val |= st.operation << 27;
    
    assert(st.tlb_invalidate_addr_hi < (1ULL << 8));
    val |= st.tlb_invalidate_addr_hi << 0;
    *val_out = val;
}

#define V_NVB06F_MEM_OP_D(val, args...) { \
    UNUSED uint32_t OPERATION_MEMBAR = NVB06F_MEM_OP_D_OPERATION_MEMBAR; \
    UNUSED uint32_t OPERATION_MMU_TLB_INVALIDATE = NVB06F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE; \
    UNUSED uint32_t OPERATION_L2_PEERMEM_INVALIDATE = NVB06F_MEM_OP_D_OPERATION_L2_PEERMEM_INVALIDATE; \
    UNUSED uint32_t OPERATION_L2_SYSMEM_INVALIDATE = NVB06F_MEM_OP_D_OPERATION_L2_SYSMEM_INVALIDATE; \
    UNUSED uint32_t OPERATION_L2_CLEAN_COMPTAGS = NVB06F_MEM_OP_D_OPERATION_L2_CLEAN_COMPTAGS; \
    UNUSED uint32_t OPERATION_L2_FLUSH_DIRTY = NVB06F_MEM_OP_D_OPERATION_L2_FLUSH_DIRTY; \
    struct nv_nvb06f_MEM_OP_D __data = args; \
    __NVB06F_MEM_OP_D(&val, __data); \
}

#define VA_NVB06F_MEM_OP_D V_NVB06F_MEM_OP_D

#define P_NVB06F_MEM_OP_D(push, args...) do { \
    UNUSED uint32_t OPERATION_MEMBAR = NVB06F_MEM_OP_D_OPERATION_MEMBAR; \
    UNUSED uint32_t OPERATION_MMU_TLB_INVALIDATE = NVB06F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE; \
    UNUSED uint32_t OPERATION_L2_PEERMEM_INVALIDATE = NVB06F_MEM_OP_D_OPERATION_L2_PEERMEM_INVALIDATE; \
    UNUSED uint32_t OPERATION_L2_SYSMEM_INVALIDATE = NVB06F_MEM_OP_D_OPERATION_L2_SYSMEM_INVALIDATE; \
    UNUSED uint32_t OPERATION_L2_CLEAN_COMPTAGS = NVB06F_MEM_OP_D_OPERATION_L2_CLEAN_COMPTAGS; \
    UNUSED uint32_t OPERATION_L2_FLUSH_DIRTY = NVB06F_MEM_OP_D_OPERATION_L2_FLUSH_DIRTY; \
    uint32_t nvk_p_ret; \
    V_NVB06F_MEM_OP_D(nvk_p_ret, args); \
    nv_push_val(push, NVB06F_MEM_OP_D, nvk_p_ret); \
} while(0)

struct nv_nvb06f_SET_REFERENCE {
    uint32_t count;
};

static inline void
__NVB06F_SET_REFERENCE(uint32_t *val_out, struct nv_nvb06f_SET_REFERENCE st)
{
    uint32_t val = 0;
    
    val |= st.count;
    *val_out = val;
}

#define V_NVB06F_SET_REFERENCE(val, args...) { \
    struct nv_nvb06f_SET_REFERENCE __data = { .count = (args) }; \
    __NVB06F_SET_REFERENCE(&val, __data); \
}

#define VA_NVB06F_SET_REFERENCE V_NVB06F_SET_REFERENCE

#define P_NVB06F_SET_REFERENCE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVB06F_SET_REFERENCE(nvk_p_ret, args); \
    nv_push_val(push, NVB06F_SET_REFERENCE, nvk_p_ret); \
} while(0)

struct nv_nvb06f_WFI {
    uint32_t scope;
};

static inline void
__NVB06F_WFI(uint32_t *val_out, struct nv_nvb06f_WFI st)
{
    uint32_t val = 0;
    
    assert(st.scope < (1ULL << 1));
    val |= st.scope << 0;
    *val_out = val;
}

#define V_NVB06F_WFI(val, args...) { \
    UNUSED uint32_t SCOPE_ALL = NVB06F_WFI_SCOPE_ALL; \
    struct nv_nvb06f_WFI __data = { .scope = (args) }; \
    __NVB06F_WFI(&val, __data); \
}

#define VA_NVB06F_WFI V_NVB06F_WFI

#define P_NVB06F_WFI(push, args...) do { \
    UNUSED uint32_t SCOPE_ALL = NVB06F_WFI_SCOPE_ALL; \
    uint32_t nvk_p_ret; \
    V_NVB06F_WFI(nvk_p_ret, args); \
    nv_push_val(push, NVB06F_WFI, nvk_p_ret); \
} while(0)

struct nv_nvb06f_CRC_CHECK {
    uint32_t value;
};

static inline void
__NVB06F_CRC_CHECK(uint32_t *val_out, struct nv_nvb06f_CRC_CHECK st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVB06F_CRC_CHECK(val, args...) { \
    struct nv_nvb06f_CRC_CHECK __data = { .value = (args) }; \
    __NVB06F_CRC_CHECK(&val, __data); \
}

#define VA_NVB06F_CRC_CHECK V_NVB06F_CRC_CHECK

#define P_NVB06F_CRC_CHECK(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVB06F_CRC_CHECK(nvk_p_ret, args); \
    nv_push_val(push, NVB06F_CRC_CHECK, nvk_p_ret); \
} while(0)

struct nv_nvb06f_YIELD {
    uint32_t op;
};

static inline void
__NVB06F_YIELD(uint32_t *val_out, struct nv_nvb06f_YIELD st)
{
    uint32_t val = 0;
    
    assert(st.op < (1ULL << 2));
    val |= st.op << 0;
    *val_out = val;
}

#define V_NVB06F_YIELD(val, args...) { \
    UNUSED uint32_t OP_NOP = NVB06F_YIELD_OP_NOP; \
    UNUSED uint32_t OP_PBDMA_TIMESLICE = NVB06F_YIELD_OP_PBDMA_TIMESLICE; \
    UNUSED uint32_t OP_RUNLIST_TIMESLICE = NVB06F_YIELD_OP_RUNLIST_TIMESLICE; \
    UNUSED uint32_t OP_TSG = NVB06F_YIELD_OP_TSG; \
    struct nv_nvb06f_YIELD __data = { .op = (args) }; \
    __NVB06F_YIELD(&val, __data); \
}

#define VA_NVB06F_YIELD V_NVB06F_YIELD

#define P_NVB06F_YIELD(push, args...) do { \
    UNUSED uint32_t OP_NOP = NVB06F_YIELD_OP_NOP; \
    UNUSED uint32_t OP_PBDMA_TIMESLICE = NVB06F_YIELD_OP_PBDMA_TIMESLICE; \
    UNUSED uint32_t OP_RUNLIST_TIMESLICE = NVB06F_YIELD_OP_RUNLIST_TIMESLICE; \
    UNUSED uint32_t OP_TSG = NVB06F_YIELD_OP_TSG; \
    uint32_t nvk_p_ret; \
    V_NVB06F_YIELD(nvk_p_ret, args); \
    nv_push_val(push, NVB06F_YIELD, nvk_p_ret); \
} while(0)


const char *P_PARSE_NVB06F_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVB06F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                              const char *prefix) ATTRIBUTE_COLD;
