#ifndef INCLUDED_OFFICECFG_OFFICE_CANVAS_HXX
#define INCLUDED_OFFICECFG_OFFICE_CANVAS_HXX

#include "sal/config.h"

#include "com/sun/star/uno/Sequence.hxx"
#include "rtl/ustring.h"
#include "rtl/ustring.hxx"
#include "sal/types.h"
#include "comphelper/configuration.hxx"

namespace officecfg { namespace Office { namespace Canvas {

struct DXCanvas: public comphelper::ConfigurationGroup< DXCanvas> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Canvas/DXCanvas"_ustr); return PATH; }

struct DeviceDenylist: public comphelper::ConfigurationProperty<DeviceDenylist, com::sun::star::uno::Sequence<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Canvas/DXCanvas/DeviceDenylist"_ustr); return PATH; }
private:
    DeviceDenylist(); // not defined
    ~DeviceDenylist(); // not defined
};

struct DenylistCurrentDevice: public comphelper::ConfigurationProperty<DenylistCurrentDevice, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Canvas/DXCanvas/DenylistCurrentDevice"_ustr); return PATH; }
private:
    DenylistCurrentDevice(); // not defined
    ~DenylistCurrentDevice(); // not defined
};

struct MaxTextureSize: public comphelper::ConfigurationProperty<MaxTextureSize, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Canvas/DXCanvas/MaxTextureSize"_ustr); return PATH; }
private:
    MaxTextureSize(); // not defined
    ~MaxTextureSize(); // not defined
};

private:
    DXCanvas(); // not defined
    ~DXCanvas(); // not defined
};

struct CanvasServiceList: public comphelper::ConfigurationSet< CanvasServiceList> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Canvas/CanvasServiceList"_ustr); return PATH; }
private:
    CanvasServiceList(); // not defined
    ~CanvasServiceList(); // not defined
};

struct ForceSafeServiceImpl: public comphelper::ConfigurationProperty<ForceSafeServiceImpl, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Canvas/ForceSafeServiceImpl"_ustr); return PATH; }
private:
    ForceSafeServiceImpl(); // not defined
    ~ForceSafeServiceImpl(); // not defined
};

struct UseAcceleratedCanvas: public comphelper::ConfigurationProperty<UseAcceleratedCanvas, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Canvas/UseAcceleratedCanvas"_ustr); return PATH; }
private:
    UseAcceleratedCanvas(); // not defined
    ~UseAcceleratedCanvas(); // not defined
};

struct UseAntialiasingCanvas: public comphelper::ConfigurationProperty<UseAntialiasingCanvas, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Canvas/UseAntialiasingCanvas"_ustr); return PATH; }
private:
    UseAntialiasingCanvas(); // not defined
    ~UseAntialiasingCanvas(); // not defined
};

} } }

#endif
