#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x006e\x0062";
static constexpr OUStringLiteral langDefaultName = u"\x004e\x006f\x0072\x0077\x0065\x0067\x0069\x0061\x006e\x0020\x0042\x006f\x006b\x006d\x00e5\x006c";
static constexpr OUStringLiteral countryID = u"\x004e\x004f";
static constexpr OUStringLiteral countryDefaultName = u"\x004e\x006f\x0072\x0077\x0061\x0079";
static constexpr OUStringLiteral Variant = u"";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_nb_NO(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}
extern const OUString *  getLocaleItem_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getLocaleItem_nb_NO(sal_Int16& count)
{
	return getLocaleItem_no_NO(count);
}
static const sal_Unicode replaceTo0[] = {0x5b, 0x24, 0x6b, 0x72, 0x2d, 0x34, 0x31, 0x34, 0x5d, 0x0};
extern OUString const * getAllFormats0_no_NO(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to);
SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_nb_NO(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	to = replaceTo0;
	const sal_Unicode* tmp;
	return getAllFormats0_no_NO(count, from, tmp);
}
extern const OUString *  getDateAcceptancePatterns_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getDateAcceptancePatterns_nb_NO(sal_Int16& count)
{
	return getDateAcceptancePatterns_no_NO(count);
}
extern const OUString *  getCollatorImplementation_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollatorImplementation_nb_NO(sal_Int16& count)
{
	return getCollatorImplementation_no_NO(count);
}
extern const OUString *  getCollationOptions_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollationOptions_nb_NO(sal_Int16& count)
{
	return getCollationOptions_no_NO(count);
}
extern const OUString *  getSearchOptions_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getSearchOptions_nb_NO(sal_Int16& count)
{
	return getSearchOptions_no_NO(count);
}
extern const OUString *  getIndexAlgorithm_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getIndexAlgorithm_nb_NO(sal_Int16& count)
{
	return getIndexAlgorithm_no_NO(count);
}
extern const OUString *  getUnicodeScripts_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getUnicodeScripts_nb_NO(sal_Int16& count)
{
	return getUnicodeScripts_no_NO(count);
}
extern const OUString *  getFollowPageWords_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getFollowPageWords_nb_NO(sal_Int16& count)
{
	return getFollowPageWords_no_NO(count);
}
extern const OUString *  getAllCalendars_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getAllCalendars_nb_NO(sal_Int16& count)
{
	return getAllCalendars_no_NO(count);
}
extern const OUString *  getAllCurrencies_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getAllCurrencies_nb_NO(sal_Int16& count)
{
	return getAllCurrencies_no_NO(count);
}
extern const OUString *  getTransliterations_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getTransliterations_nb_NO(sal_Int16& count)
{
	return getTransliterations_no_NO(count);
}
extern const OUString *  getForbiddenCharacters_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getForbiddenCharacters_nb_NO(sal_Int16& count)
{
	return getForbiddenCharacters_no_NO(count);
}
extern const OUString *  getBreakIteratorRules_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getBreakIteratorRules_nb_NO(sal_Int16& count)
{
	return getBreakIteratorRules_no_NO(count);
}
extern const OUString *  getReservedWords_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getReservedWords_nb_NO(sal_Int16& count)
{
	return getReservedWords_no_NO(count);
}
// ---> ContinuousNumbering
extern const OUString **  getContinuousNumberingLevels_no_NO(sal_Int16& nStyles, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_nb_NO(sal_Int16& nStyles, sal_Int16& nAttributes)
{
	return getContinuousNumberingLevels_no_NO(nStyles, nAttributes);
}
// ---> OutlineNumbering
extern const OUString ***  getOutlineNumberingLevels_no_NO(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_nb_NO(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes)
{
	return getOutlineNumberingLevels_no_NO(nStyles, nLevels, nAttributes);
}
} // extern "C"

