{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkX11.Objects.X11Visual
    ( 

-- * Exported types
    X11Visual(..)                           ,
    IsX11Visual                             ,
    toX11Visual                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getBitsPerRgb]("GI.Gdk.Objects.Visual#g:method:getBitsPerRgb"), [getBluePixelDetails]("GI.Gdk.Objects.Visual#g:method:getBluePixelDetails"), [getByteOrder]("GI.Gdk.Objects.Visual#g:method:getByteOrder"), [getColormapSize]("GI.Gdk.Objects.Visual#g:method:getColormapSize"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDepth]("GI.Gdk.Objects.Visual#g:method:getDepth"), [getGreenPixelDetails]("GI.Gdk.Objects.Visual#g:method:getGreenPixelDetails"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRedPixelDetails]("GI.Gdk.Objects.Visual#g:method:getRedPixelDetails"), [getScreen]("GI.Gdk.Objects.Visual#g:method:getScreen"), [getVisualType]("GI.Gdk.Objects.Visual#g:method:getVisualType"), [getXvisual]("GI.GdkX11.Objects.X11Visual#g:method:getXvisual").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveX11VisualMethod                  ,
#endif

-- ** getXvisual #method:getXvisual#

#if defined(ENABLE_OVERLOADING)
    X11VisualGetXvisualMethodInfo           ,
#endif
    x11VisualGetXvisual                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Visual as Gdk.Visual
import qualified GI.Xlib.Structs.Visual as Xlib.Visual

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Visual as Gdk.Visual
import qualified GI.Xlib.Structs.Visual as Xlib.Visual

#endif

-- | Memory-managed wrapper type.
newtype X11Visual = X11Visual (SP.ManagedPtr X11Visual)
    deriving (Eq)

instance SP.ManagedPtrNewtype X11Visual where
    toManagedPtr (X11Visual p) = p

foreign import ccall "gdk_x11_visual_get_type"
    c_gdk_x11_visual_get_type :: IO B.Types.GType

instance B.Types.TypedObject X11Visual where
    glibType = c_gdk_x11_visual_get_type

instance B.Types.GObject X11Visual

-- | Type class for types which can be safely cast to t'X11Visual', for instance with `toX11Visual`.
class (SP.GObject o, O.IsDescendantOf X11Visual o) => IsX11Visual o
instance (SP.GObject o, O.IsDescendantOf X11Visual o) => IsX11Visual o

instance O.HasParentTypes X11Visual
type instance O.ParentTypes X11Visual = '[Gdk.Visual.Visual, GObject.Object.Object]

-- | Cast to t'X11Visual', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toX11Visual :: (MIO.MonadIO m, IsX11Visual o) => o -> m X11Visual
toX11Visual = MIO.liftIO . B.ManagedPtr.unsafeCastTo X11Visual

-- | Convert t'X11Visual' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe X11Visual) where
    gvalueGType_ = c_gdk_x11_visual_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr X11Visual)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr X11Visual)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject X11Visual ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveX11VisualMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveX11VisualMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveX11VisualMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveX11VisualMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveX11VisualMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveX11VisualMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveX11VisualMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveX11VisualMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveX11VisualMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveX11VisualMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveX11VisualMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveX11VisualMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveX11VisualMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveX11VisualMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveX11VisualMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveX11VisualMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveX11VisualMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveX11VisualMethod "getBitsPerRgb" o = Gdk.Visual.VisualGetBitsPerRgbMethodInfo
    ResolveX11VisualMethod "getBluePixelDetails" o = Gdk.Visual.VisualGetBluePixelDetailsMethodInfo
    ResolveX11VisualMethod "getByteOrder" o = Gdk.Visual.VisualGetByteOrderMethodInfo
    ResolveX11VisualMethod "getColormapSize" o = Gdk.Visual.VisualGetColormapSizeMethodInfo
    ResolveX11VisualMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveX11VisualMethod "getDepth" o = Gdk.Visual.VisualGetDepthMethodInfo
    ResolveX11VisualMethod "getGreenPixelDetails" o = Gdk.Visual.VisualGetGreenPixelDetailsMethodInfo
    ResolveX11VisualMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveX11VisualMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveX11VisualMethod "getRedPixelDetails" o = Gdk.Visual.VisualGetRedPixelDetailsMethodInfo
    ResolveX11VisualMethod "getScreen" o = Gdk.Visual.VisualGetScreenMethodInfo
    ResolveX11VisualMethod "getVisualType" o = Gdk.Visual.VisualGetVisualTypeMethodInfo
    ResolveX11VisualMethod "getXvisual" o = X11VisualGetXvisualMethodInfo
    ResolveX11VisualMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveX11VisualMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveX11VisualMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveX11VisualMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveX11VisualMethod t X11Visual, O.OverloadedMethod info X11Visual p) => OL.IsLabel t (X11Visual -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveX11VisualMethod t X11Visual, O.OverloadedMethod info X11Visual p, R.HasField t X11Visual p) => R.HasField t X11Visual p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveX11VisualMethod t X11Visual, O.OverloadedMethodInfo info X11Visual) => OL.IsLabel t (O.MethodProxy info X11Visual) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList X11Visual
type instance O.AttributeList X11Visual = X11VisualAttributeList
type X11VisualAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList X11Visual = X11VisualSignalList
type X11VisualSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method X11Visual::get_xvisual
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "visual"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Visual" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkVisual." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "xlib" , name = "Visual" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_visual_get_xvisual" gdk_x11_visual_get_xvisual :: 
    Ptr X11Visual ->                        -- visual : TInterface (Name {namespace = "GdkX11", name = "X11Visual"})
    IO (Ptr Xlib.Visual.Visual)

-- | Returns the X visual belonging to a t'GI.Gdk.Objects.Visual.Visual'.
x11VisualGetXvisual ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Visual a) =>
    a
    -- ^ /@visual@/: a t'GI.Gdk.Objects.Visual.Visual'.
    -> m Xlib.Visual.Visual
    -- ^ __Returns:__ an Xlib Visual*.
x11VisualGetXvisual visual = liftIO $ do
    visual' <- unsafeManagedPtrCastPtr visual
    result <- gdk_x11_visual_get_xvisual visual'
    checkUnexpectedReturnNULL "x11VisualGetXvisual" result
    result' <- (newPtr Xlib.Visual.Visual) result
    touchManagedPtr visual
    return result'

#if defined(ENABLE_OVERLOADING)
data X11VisualGetXvisualMethodInfo
instance (signature ~ (m Xlib.Visual.Visual), MonadIO m, IsX11Visual a) => O.OverloadedMethod X11VisualGetXvisualMethodInfo a signature where
    overloadedMethod = x11VisualGetXvisual

instance O.OverloadedMethodInfo X11VisualGetXvisualMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Visual.x11VisualGetXvisual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Visual.html#v:x11VisualGetXvisual"
        })


#endif


