{-# LANGUAGE CPP #-}
{-# LANGUAGE NoRebindableSyntax #-}
#if __GLASGOW_HASKELL__ >= 810
{-# OPTIONS_GHC -Wno-prepositive-qualified-module #-}
#endif
{-# OPTIONS_GHC -fno-warn-missing-import-lists #-}
{-# OPTIONS_GHC -w #-}
module Paths_clash_prelude (
    version,
    getBinDir, getLibDir, getDynLibDir, getDataDir, getLibexecDir,
    getDataFileName, getSysconfDir
  ) where


import qualified Control.Exception as Exception
import qualified Data.List as List
import Data.Version (Version(..))
import System.Environment (getEnv)
import Prelude


#if defined(VERSION_base)

#if MIN_VERSION_base(4,0,0)
catchIO :: IO a -> (Exception.IOException -> IO a) -> IO a
#else
catchIO :: IO a -> (Exception.Exception -> IO a) -> IO a
#endif

#else
catchIO :: IO a -> (Exception.IOException -> IO a) -> IO a
#endif
catchIO = Exception.catch

version :: Version
version = Version [1,8,2] []

getDataFileName :: FilePath -> IO FilePath
getDataFileName name = do
  dir <- getDataDir
  return (dir `joinFileName` name)

getBinDir, getLibDir, getDynLibDir, getDataDir, getLibexecDir, getSysconfDir :: IO FilePath




bindir, libdir, dynlibdir, datadir, libexecdir, sysconfdir :: FilePath
bindir     = "/usr/bin"
libdir     = "/usr/lib/ghc-9.6.6/site-local/clash-prelude-1.8.2"
dynlibdir  = "/usr/lib"
datadir    = "/usr/share/haskell-clash-prelude"
libexecdir = "/usr/libexec/x86_64-linux-ghc-9.6.6/clash-prelude-1.8.2"
sysconfdir = "/usr/etc"

getBinDir     = catchIO (getEnv "clash_prelude_bindir")     (\_ -> return bindir)
getLibDir     = catchIO (getEnv "clash_prelude_libdir")     (\_ -> return libdir)
getDynLibDir  = catchIO (getEnv "clash_prelude_dynlibdir")  (\_ -> return dynlibdir)
getDataDir    = catchIO (getEnv "clash_prelude_datadir")    (\_ -> return datadir)
getLibexecDir = catchIO (getEnv "clash_prelude_libexecdir") (\_ -> return libexecdir)
getSysconfDir = catchIO (getEnv "clash_prelude_sysconfdir") (\_ -> return sysconfdir)



joinFileName :: String -> String -> FilePath
joinFileName ""  fname = fname
joinFileName "." fname = fname
joinFileName dir ""    = dir
joinFileName dir fname
  | isPathSeparator (List.last dir) = dir ++ fname
  | otherwise                       = dir ++ pathSeparator : fname

pathSeparator :: Char
pathSeparator = '/'

isPathSeparator :: Char -> Bool
isPathSeparator c = c == '/'
