/* plugin-email-store.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from plugin-email-store.vala, do not modify */

/*
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLUGIN_EMAIL_STORE_EMAIL_DISPLAYED_SIGNAL,
	PLUGIN_EMAIL_STORE_EMAIL_SENT_SIGNAL,
	PLUGIN_EMAIL_STORE_NUM_SIGNALS
};
static guint plugin_email_store_signals[PLUGIN_EMAIL_STORE_NUM_SIGNALS] = {0};

static GType plugin_email_store_get_type_once (void);

const GVariantType*
plugin_email_store_get_email_identifier_variant_type (PluginEmailStore* self)
{
	PluginEmailStoreIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_EMAIL_STORE (self), NULL);
	_iface_ = PLUGIN_EMAIL_STORE_GET_INTERFACE (self);
	if (_iface_->get_email_identifier_variant_type) {
		return _iface_->get_email_identifier_variant_type (self);
	}
	return NULL;
}

void
plugin_email_store_get_email (PluginEmailStore* self,
                              GeeCollection* ids,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	PluginEmailStoreIface* _iface_;
	_iface_ = PLUGIN_EMAIL_STORE_GET_INTERFACE (self);
	if (_iface_->get_email) {
		_iface_->get_email (self, ids, cancellable, _callback_, _user_data_);
	}
}

GeeCollection*
plugin_email_store_get_email_finish (PluginEmailStore* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	PluginEmailStoreIface* _iface_;
	_iface_ = PLUGIN_EMAIL_STORE_GET_INTERFACE (self);
	if (_iface_->get_email_finish) {
		return _iface_->get_email_finish (self, _res_, error);
	}
	return NULL;
}

/**
     * Returns the email identifier specified by the given variant, if any.
     *
     * @see EmailIdentifier.to_variant
     * @see email_identifier_variant_type
     */
PluginEmailIdentifier*
plugin_email_store_get_email_identifier_for_variant (PluginEmailStore* self,
                                                     GVariant* id)
{
	PluginEmailStoreIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_EMAIL_STORE (self), NULL);
	_iface_ = PLUGIN_EMAIL_STORE_GET_INTERFACE (self);
	if (_iface_->get_email_identifier_for_variant) {
		return _iface_->get_email_identifier_for_variant (self, id);
	}
	return NULL;
}

static void
plugin_email_store_default_init (PluginEmailStoreIface * iface,
                                 gpointer iface_data)
{
	/**
	     * The type of variant email identifiers.
	     *
	     * @see EmailIdentifier.to_variant
	     * @see get_email_identifier_for_variant
	     */
	g_object_interface_install_property (iface, g_param_spec_boxed ("email-identifier-variant-type", "email-identifier-variant-type", "email-identifier-variant-type", G_TYPE_VARIANT_TYPE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Emitted when an email has been displayed in the UI. */
	plugin_email_store_signals[PLUGIN_EMAIL_STORE_EMAIL_DISPLAYED_SIGNAL] = g_signal_new ("email-displayed", PLUGIN_TYPE_EMAIL_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, PLUGIN_TYPE_EMAIL);
	/** Emitted when an email has been sent. */
	plugin_email_store_signals[PLUGIN_EMAIL_STORE_EMAIL_SENT_SIGNAL] = g_signal_new ("email-sent", PLUGIN_TYPE_EMAIL_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, PLUGIN_TYPE_EMAIL);
}

/**
 * Provides plugins with access to email.
 *
 * Plugins that implement the {@link EmailExtension} interface may
 * obtain instances of this object by calling {@link
 * EmailContext.get_email_store} on their {@link EmailExtension.email}
 * property.
 */
static GType
plugin_email_store_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginEmailStoreIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_email_store_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType plugin_email_store_type_id;
	plugin_email_store_type_id = g_type_register_static (G_TYPE_INTERFACE, "PluginEmailStore", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (plugin_email_store_type_id, GEARY_TYPE_BASE_OBJECT);
	return plugin_email_store_type_id;
}

GType
plugin_email_store_get_type (void)
{
	static volatile gsize plugin_email_store_type_id__once = 0;
	if (g_once_init_enter (&plugin_email_store_type_id__once)) {
		GType plugin_email_store_type_id;
		plugin_email_store_type_id = plugin_email_store_get_type_once ();
		g_once_init_leave (&plugin_email_store_type_id__once, plugin_email_store_type_id);
	}
	return plugin_email_store_type_id__once;
}

