/* Generated by wayland-scanner 1.24.0 */

#ifndef GAMESCOPE_ACTION_BINDING_SERVER_PROTOCOL_H
#define GAMESCOPE_ACTION_BINDING_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_gamescope_action_binding The gamescope_action_binding protocol
 * gamescope-specific protocol
 *
 * @section page_desc_gamescope_action_binding Description
 *
 * This is a private Gamescope protocol. Regular Wayland clients must not use
 * it.
 *
 * @section page_ifaces_gamescope_action_binding Interfaces
 * - @subpage page_iface_gamescope_action_binding_manager - 
 * - @subpage page_iface_gamescope_action_binding - 
 * @section page_copyright_gamescope_action_binding Copyright
 * <pre>
 *
 * Copyright © 2024 Valve Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct gamescope_action_binding;
struct gamescope_action_binding_manager;

#ifndef GAMESCOPE_ACTION_BINDING_MANAGER_INTERFACE
#define GAMESCOPE_ACTION_BINDING_MANAGER_INTERFACE
/**
 * @page page_iface_gamescope_action_binding_manager gamescope_action_binding_manager
 * @section page_iface_gamescope_action_binding_manager_api API
 * See @ref iface_gamescope_action_binding_manager.
 */
/**
 * @defgroup iface_gamescope_action_binding_manager The gamescope_action_binding_manager interface
 */
extern const struct wl_interface gamescope_action_binding_manager_interface;
#endif
#ifndef GAMESCOPE_ACTION_BINDING_INTERFACE
#define GAMESCOPE_ACTION_BINDING_INTERFACE
/**
 * @page page_iface_gamescope_action_binding gamescope_action_binding
 * @section page_iface_gamescope_action_binding_api API
 * See @ref iface_gamescope_action_binding.
 */
/**
 * @defgroup iface_gamescope_action_binding The gamescope_action_binding interface
 */
extern const struct wl_interface gamescope_action_binding_interface;
#endif

/**
 * @ingroup iface_gamescope_action_binding_manager
 * @struct gamescope_action_binding_manager_interface
 */
struct gamescope_action_binding_manager_interface {
	/**
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * @param callback new action binding object
	 */
	void (*create_action_binding)(struct wl_client *client,
				      struct wl_resource *resource,
				      uint32_t callback);
};


/**
 * @ingroup iface_gamescope_action_binding_manager
 */
#define GAMESCOPE_ACTION_BINDING_MANAGER_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_action_binding_manager
 */
#define GAMESCOPE_ACTION_BINDING_MANAGER_CREATE_ACTION_BINDING_SINCE_VERSION 1

#ifndef GAMESCOPE_ACTION_BINDING_ARM_FLAG_ENUM
#define GAMESCOPE_ACTION_BINDING_ARM_FLAG_ENUM
/**
 * @ingroup iface_gamescope_action_binding
 * arm flags
 *
 * Flags that control how the action is armed.
 */
enum gamescope_action_binding_arm_flag {
	/**
	 * disarm this action immediately after trigger. unrelated to niko
	 */
	GAMESCOPE_ACTION_BINDING_ARM_FLAG_ONE_SHOT = 0x1,
	/**
	 * don't block the result of this shortcut being seen by the app and keep processing hotkeys
	 */
	GAMESCOPE_ACTION_BINDING_ARM_FLAG_NO_BLOCK = 0x2,
};
#endif /* GAMESCOPE_ACTION_BINDING_ARM_FLAG_ENUM */

#ifndef GAMESCOPE_ACTION_BINDING_ARM_FLAG_ENUM_IS_VALID
#define GAMESCOPE_ACTION_BINDING_ARM_FLAG_ENUM_IS_VALID
/**
 * @ingroup iface_gamescope_action_binding
 * Validate a gamescope_action_binding arm_flag value.
 *
 * @return true on success, false on error.
 * @ref gamescope_action_binding_arm_flag
 */
static inline bool
gamescope_action_binding_arm_flag_is_valid(uint32_t value, uint32_t version) {
	uint32_t valid = 0;
	if (version >= 1)
		valid |= GAMESCOPE_ACTION_BINDING_ARM_FLAG_ONE_SHOT;
	if (version >= 1)
		valid |= GAMESCOPE_ACTION_BINDING_ARM_FLAG_NO_BLOCK;
	return (value & ~valid) == 0;
}
#endif /* GAMESCOPE_ACTION_BINDING_ARM_FLAG_ENUM_IS_VALID */

#ifndef GAMESCOPE_ACTION_BINDING_TRIGGER_FLAG_ENUM
#define GAMESCOPE_ACTION_BINDING_TRIGGER_FLAG_ENUM
/**
 * @ingroup iface_gamescope_action_binding
 * arm flags
 *
 * Flags that say how the action was triggered.
 */
enum gamescope_action_binding_trigger_flag {
	/**
	 * action was triggered by keyboard trigger
	 */
	GAMESCOPE_ACTION_BINDING_TRIGGER_FLAG_KEYBOARD = 0x1,
};
#endif /* GAMESCOPE_ACTION_BINDING_TRIGGER_FLAG_ENUM */

#ifndef GAMESCOPE_ACTION_BINDING_TRIGGER_FLAG_ENUM_IS_VALID
#define GAMESCOPE_ACTION_BINDING_TRIGGER_FLAG_ENUM_IS_VALID
/**
 * @ingroup iface_gamescope_action_binding
 * Validate a gamescope_action_binding trigger_flag value.
 *
 * @return true on success, false on error.
 * @ref gamescope_action_binding_trigger_flag
 */
static inline bool
gamescope_action_binding_trigger_flag_is_valid(uint32_t value, uint32_t version) {
	uint32_t valid = 0;
	if (version >= 1)
		valid |= GAMESCOPE_ACTION_BINDING_TRIGGER_FLAG_KEYBOARD;
	return (value & ~valid) == 0;
}
#endif /* GAMESCOPE_ACTION_BINDING_TRIGGER_FLAG_ENUM_IS_VALID */

/**
 * @ingroup iface_gamescope_action_binding
 * @struct gamescope_action_binding_interface
 */
struct gamescope_action_binding_interface {
	/**
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * @param description human-readable description as to what the action is for, used for debugging purposes.
	 */
	void (*set_description)(struct wl_client *client,
				struct wl_resource *resource,
				const char *description);
	/**
	 * @param keysyms array of xkb_keysym_t's
	 */
	void (*add_keyboard_trigger)(struct wl_client *client,
				     struct wl_resource *resource,
				     struct wl_array *keysyms);
	/**
	 */
	void (*clear_triggers)(struct wl_client *client,
			       struct wl_resource *resource);
	/**
	 * @param arm_flags combination of 'arm_flag' values
	 */
	void (*arm)(struct wl_client *client,
		    struct wl_resource *resource,
		    uint32_t arm_flags);
	/**
	 */
	void (*disarm)(struct wl_client *client,
		       struct wl_resource *resource);
};

#define GAMESCOPE_ACTION_BINDING_TRIGGERED 0

/**
 * @ingroup iface_gamescope_action_binding
 */
#define GAMESCOPE_ACTION_BINDING_TRIGGERED_SINCE_VERSION 1

/**
 * @ingroup iface_gamescope_action_binding
 */
#define GAMESCOPE_ACTION_BINDING_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_action_binding
 */
#define GAMESCOPE_ACTION_BINDING_SET_DESCRIPTION_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_action_binding
 */
#define GAMESCOPE_ACTION_BINDING_ADD_KEYBOARD_TRIGGER_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_action_binding
 */
#define GAMESCOPE_ACTION_BINDING_CLEAR_TRIGGERS_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_action_binding
 */
#define GAMESCOPE_ACTION_BINDING_ARM_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_action_binding
 */
#define GAMESCOPE_ACTION_BINDING_DISARM_SINCE_VERSION 1

/**
 * @ingroup iface_gamescope_action_binding
 * Sends an triggered event to the client owning the resource.
 * @param resource_ The client's resource
 * @param sequence global sequence no of actions that have been trigged
 * @param time_lo lower bits of 64-bit timestamp in nanos (CLOCK_MONOTONIC)
 * @param time_hi upper bits of 64-bit timestamp in nanos (CLOCK_MONOTONIC)
 * @param trigger_flags flags for this trigger
 */
static inline void
gamescope_action_binding_send_triggered(struct wl_resource *resource_, uint32_t sequence, uint32_t time_lo, uint32_t time_hi, uint32_t trigger_flags)
{
	wl_resource_post_event(resource_, GAMESCOPE_ACTION_BINDING_TRIGGERED, sequence, time_lo, time_hi, trigger_flags);
}

#ifdef  __cplusplus
}
#endif

#endif
