/* stanza_node.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from stanza_node.vala, do not modify */

#include "xmpp-vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>
#include <gee.h>
#include <errno.h>
#include <stdarg.h>
#include <gio/gio.h>

#define XMPP_STANZA_NODE_TAG_START_BEGIN_FORMAT "%s<{%s}:%s"
#define XMPP_STANZA_NODE_TAG_START_EMPTY_END " />\n"
#define XMPP_STANZA_NODE_TAG_START_CONTENT_END ">\n"
#define XMPP_STANZA_NODE_TAG_END_FORMAT "%s</{%s}:%s>\n"
#define XMPP_STANZA_NODE_TAG_ANSI_START_BEGIN_FORMAT "%s" XMPP_STANZA_ENTRY_ANSI_COLOR_YELLOW "<" XMPP_STANZA_ENTRY_ANSI_COLOR_GRAY "{%s}:" XMPP_STANZA_ENTRY_ANSI_COLOR_YELLOW "%s" XMPP_STANZA_ENTRY_ANSI_COLOR_END
#define XMPP_STANZA_NODE_TAG_ANSI_START_BEGIN_NO_NS_FORMAT "%s" XMPP_STANZA_ENTRY_ANSI_COLOR_YELLOW "<%s" XMPP_STANZA_ENTRY_ANSI_COLOR_END
#define XMPP_STANZA_NODE_TAG_ANSI_START_EMPTY_END XMPP_STANZA_ENTRY_ANSI_COLOR_YELLOW " />" XMPP_STANZA_ENTRY_ANSI_COLOR_END "\n"
#define XMPP_STANZA_NODE_TAG_ANSI_START_CONTENT_END XMPP_STANZA_ENTRY_ANSI_COLOR_YELLOW ">" XMPP_STANZA_ENTRY_ANSI_COLOR_END "\n"
#define XMPP_STANZA_NODE_TAG_ANSI_END_FORMAT "%s" XMPP_STANZA_ENTRY_ANSI_COLOR_YELLOW "</" XMPP_STANZA_ENTRY_ANSI_COLOR_GRAY "{%s}:" XMPP_STANZA_ENTRY_ANSI_COLOR_YELLOW "%s>" XMPP_STANZA_ENTRY_ANSI_COLOR_END "\n"
#define XMPP_STANZA_NODE_TAG_ANSI_END_NO_NS_FORMAT "%s" XMPP_STANZA_ENTRY_ANSI_COLOR_YELLOW "</%s>" XMPP_STANZA_ENTRY_ANSI_COLOR_END "\n"
#define XMPP_STANZA_ATTRIBUTE_ATTRIBUTE_STRING_FORMAT "{%s}:%s='%s'"
#define XMPP_STANZA_ATTRIBUTE_ATTRIBUTE_STRING_ANSI_NO_NS_FORMAT "%s=" XMPP_STANZA_ENTRY_ANSI_COLOR_GREEN "'%s'" XMPP_STANZA_ENTRY_ANSI_COLOR_END
#define XMPP_STANZA_ATTRIBUTE_ATTRIBUTE_STRING_ANSI_FORMAT XMPP_STANZA_ENTRY_ANSI_COLOR_GRAY "{%s}:" XMPP_STANZA_ENTRY_ANSI_COLOR_END "%s=" XMPP_STANZA_ENTRY_ANSI_COLOR_GREEN "'%s'" XMPP_STANZA_ENTRY_ANSI_COLOR_END
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _XmppParamSpecStanzaEntry XmppParamSpecStanzaEntry;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _xmpp_stanza_entry_unref0(var) ((var == NULL) ? NULL : (var = (xmpp_stanza_entry_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _xmpp_namespace_state_unref0(var) ((var == NULL) ? NULL : (var = (xmpp_namespace_state_unref (var), NULL)))

struct _XmppParamSpecStanzaEntry {
	GParamSpec parent_instance;
};

static gpointer xmpp_stanza_entry_parent_class = NULL;
static gpointer xmpp_stanza_node_parent_class = NULL;

static const gchar* xmpp_stanza_entry_real_get_string_content (XmppStanzaEntry* self);
static gchar* xmpp_stanza_entry_real_to_string (XmppStanzaEntry* self,
                                         gint i);
static void xmpp_stanza_entry_finalize (XmppStanzaEntry * obj);
static GType xmpp_stanza_entry_get_type_once (void);
VALA_EXTERN XmppStanzaNode* xmpp_stanza_node_new (void);
VALA_EXTERN XmppStanzaNode* xmpp_stanza_node_construct (GType object_type);
static const gchar* xmpp_stanza_node_real_get_string_content (XmppStanzaEntry* base);
VALA_EXTERN gchar* xmpp_stanza_node_printf (XmppStanzaNode* self,
                                gint i,
                                const gchar* fmt_start_begin,
                                const gchar* start_empty_end,
                                const gchar* start_content_end,
                                const gchar* fmt_end,
                                const gchar* fmt_attr,
                                gboolean no_ns);
VALA_EXTERN gchar* xmpp_stanza_attribute_printf (XmppStanzaAttribute* self,
                                     const gchar* fmt,
                                     gboolean no_ns,
                                     const gchar* ns_name);
static gchar* xmpp_stanza_node_real_to_string (XmppStanzaEntry* base,
                                        gint i);
static void xmpp_stanza_node_finalize (XmppStanzaEntry * obj);
static GType xmpp_stanza_node_get_type_once (void);

static const gchar*
xmpp_stanza_entry_real_get_string_content (XmppStanzaEntry* self)
{
	const gchar* _tmp0_;
	const gchar* result;
	_tmp0_ = self->val;
	result = _tmp0_;
	return result;
}

const gchar*
xmpp_stanza_entry_get_string_content (XmppStanzaEntry* self)
{
	XmppStanzaEntryClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = XMPP_STANZA_ENTRY_GET_CLASS (self);
	if (_klass_->get_string_content) {
		return _klass_->get_string_content (self);
	}
	return NULL;
}

static gchar*
xmpp_stanza_entry_real_to_string (XmppStanzaEntry* self,
                                  gint i)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp1_ = xmpp_stanza_entry_get_string_content (self);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "(null)";
	}
	_tmp2_ = g_strdup (_tmp0_);
	result = _tmp2_;
	return result;
}

gchar*
xmpp_stanza_entry_to_string (XmppStanzaEntry* self,
                             gint i)
{
	XmppStanzaEntryClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = XMPP_STANZA_ENTRY_GET_CLASS (self);
	if (_klass_->to_string) {
		return _klass_->to_string (self, i);
	}
	return NULL;
}

XmppStanzaEntry*
xmpp_stanza_entry_construct (GType object_type)
{
	XmppStanzaEntry* self = NULL;
	self = (XmppStanzaEntry*) g_type_create_instance (object_type);
	return self;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
xmpp_stanza_entry_get_encoded_val (XmppStanzaEntry* self)
{
	gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->val;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->val;
	_tmp2_ = string_replace ((const gchar*) _tmp1_, "&", "&amp;");
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "\"", "&quot;");
	_tmp5_ = _tmp4_;
	_tmp6_ = string_replace (_tmp5_, "'", "&apos;");
	_tmp7_ = _tmp6_;
	_tmp8_ = string_replace (_tmp7_, "<", "&lt;");
	_tmp9_ = _tmp8_;
	_tmp10_ = string_replace (_tmp9_, ">", "&gt;");
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	result = _tmp11_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_splice (const gchar* self,
               glong start,
               glong end,
               const gchar* str)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gsize str_size = 0UL;
	const gchar* _result_ = NULL;
	void* _tmp6_;
	gchar* dest = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	if (str == NULL) {
		str_size = (gsize) 0;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = strlen ((const gchar*) str);
		_tmp5_ = _tmp4_;
		str_size = (gsize) _tmp5_;
	}
	_tmp6_ = g_malloc0 (((string_length - (end - start)) + str_size) + 1);
	_result_ = _tmp6_;
	_tmp7_ = _result_;
	dest = (gchar*) _tmp7_;
	_tmp8_ = dest;
	memcpy (_tmp8_, self, (gsize) start);
	_tmp9_ = dest;
	dest = _tmp9_ + start;
	if (str != NULL) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = dest;
		memcpy (_tmp10_, str, str_size);
		_tmp11_ = dest;
		dest = _tmp11_ + str_size;
	}
	_tmp12_ = dest;
	memcpy (_tmp12_, ((gchar*) self) + end, (gsize) (string_length - end));
	_tmp13_ = _result_;
	_result_ = NULL;
	result = (gchar*) _tmp13_;
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

void
xmpp_stanza_entry_set_encoded_val (XmppStanzaEntry* self,
                                   const gchar* value)
{
	gchar* tmp = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	g_return_if_fail (self != NULL);
	if (value == NULL) {
		_g_free0 (self->val);
		self->val = NULL;
		return;
	}
	_tmp0_ = string_replace ((const gchar*) value, "&gt;", ">");
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, "&lt;", "<");
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "&apos;", "'");
	_tmp5_ = _tmp4_;
	_tmp6_ = string_replace (_tmp5_, "&quot;", "\"");
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	tmp = _tmp7_;
	while (TRUE) {
		const gchar* _tmp8_;
		gint start = 0;
		const gchar* _tmp9_;
		gint end = 0;
		const gchar* _tmp10_;
		gunichar num = 0U;
		const gchar* _tmp11_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp8_ = tmp;
		if (!string_contains (_tmp8_, "&#")) {
			break;
		}
		_tmp9_ = tmp;
		start = string_index_of (_tmp9_, "&#", 0);
		_tmp10_ = tmp;
		end = string_index_of (_tmp10_, ";", start);
		if (end < start) {
			break;
		}
		num = (gunichar) -1;
		_tmp11_ = tmp;
		if (string_get (_tmp11_, (glong) (start + 2)) == 'x') {
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp12_ = tmp;
			_tmp13_ = string_substring (_tmp12_, (glong) (start + 3), (glong) ((start - end) - 3));
			_tmp14_ = _tmp13_;
			sscanf (_tmp14_, "%x", &num);
			_g_free0 (_tmp14_);
		} else {
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp15_ = tmp;
			_tmp16_ = string_substring (_tmp15_, (glong) (start + 2), (glong) ((start - end) - 2));
			_tmp17_ = _tmp16_;
			num = (gunichar) atoi (_tmp17_);
			_g_free0 (_tmp17_);
		}
		_tmp18_ = tmp;
		_tmp19_ = g_unichar_to_string (num);
		_tmp20_ = _tmp19_;
		_tmp21_ = string_splice (_tmp18_, (glong) start, (glong) end, _tmp20_);
		_g_free0 (tmp);
		tmp = _tmp21_;
		_g_free0 (_tmp20_);
	}
	_tmp22_ = tmp;
	_tmp23_ = string_replace (_tmp22_, "&amp;", "&");
	_g_free0 (self->val);
	self->val = _tmp23_;
	_g_free0 (tmp);
}

static void
xmpp_value_stanza_entry_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
xmpp_value_stanza_entry_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		xmpp_stanza_entry_unref (value->data[0].v_pointer);
	}
}

static void
xmpp_value_stanza_entry_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = xmpp_stanza_entry_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
xmpp_value_stanza_entry_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
xmpp_value_stanza_entry_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		XmppStanzaEntry * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = xmpp_stanza_entry_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
xmpp_value_stanza_entry_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	XmppStanzaEntry ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = xmpp_stanza_entry_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
xmpp_param_spec_stanza_entry (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	XmppParamSpecStanzaEntry* spec;
	g_return_val_if_fail (g_type_is_a (object_type, XMPP_TYPE_STANZA_ENTRY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
xmpp_value_get_stanza_entry (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, XMPP_TYPE_STANZA_ENTRY), NULL);
	return value->data[0].v_pointer;
}

void
xmpp_value_set_stanza_entry (GValue* value,
                             gpointer v_object)
{
	XmppStanzaEntry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, XMPP_TYPE_STANZA_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, XMPP_TYPE_STANZA_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		xmpp_stanza_entry_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		xmpp_stanza_entry_unref (old);
	}
}

void
xmpp_value_take_stanza_entry (GValue* value,
                              gpointer v_object)
{
	XmppStanzaEntry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, XMPP_TYPE_STANZA_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, XMPP_TYPE_STANZA_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		xmpp_stanza_entry_unref (old);
	}
}

static void
xmpp_stanza_entry_class_init (XmppStanzaEntryClass * klass,
                              gpointer klass_data)
{
	xmpp_stanza_entry_parent_class = g_type_class_peek_parent (klass);
	((XmppStanzaEntryClass *) klass)->finalize = xmpp_stanza_entry_finalize;
	((XmppStanzaEntryClass *) klass)->get_string_content = (const gchar* (*) (XmppStanzaEntry*)) xmpp_stanza_entry_real_get_string_content;
	((XmppStanzaEntryClass *) klass)->to_string = (gchar* (*) (XmppStanzaEntry*, gint)) xmpp_stanza_entry_real_to_string;
}

static void
xmpp_stanza_entry_instance_init (XmppStanzaEntry * self,
                                 gpointer klass)
{
	self->ref_count = 1;
}

static void
xmpp_stanza_entry_finalize (XmppStanzaEntry * obj)
{
	XmppStanzaEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XMPP_TYPE_STANZA_ENTRY, XmppStanzaEntry);
	g_signal_handlers_destroy (self);
	_g_free0 (self->ns_uri);
	_g_free0 (self->name);
	_g_free0 (self->val);
}

static GType
xmpp_stanza_entry_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { xmpp_value_stanza_entry_init, xmpp_value_stanza_entry_free_value, xmpp_value_stanza_entry_copy_value, xmpp_value_stanza_entry_peek_pointer, "p", xmpp_value_stanza_entry_collect_value, "p", xmpp_value_stanza_entry_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (XmppStanzaEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xmpp_stanza_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XmppStanzaEntry), 0, (GInstanceInitFunc) xmpp_stanza_entry_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType xmpp_stanza_entry_type_id;
	xmpp_stanza_entry_type_id = g_type_register_fundamental (g_type_fundamental_next (), "XmppStanzaEntry", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return xmpp_stanza_entry_type_id;
}

GType
xmpp_stanza_entry_get_type (void)
{
	static volatile gsize xmpp_stanza_entry_type_id__once = 0;
	if (g_once_init_enter (&xmpp_stanza_entry_type_id__once)) {
		GType xmpp_stanza_entry_type_id;
		xmpp_stanza_entry_type_id = xmpp_stanza_entry_get_type_once ();
		g_once_init_leave (&xmpp_stanza_entry_type_id__once, xmpp_stanza_entry_type_id);
	}
	return xmpp_stanza_entry_type_id__once;
}

gpointer
xmpp_stanza_entry_ref (gpointer instance)
{
	XmppStanzaEntry * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
xmpp_stanza_entry_unref (gpointer instance)
{
	XmppStanzaEntry * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		XMPP_STANZA_ENTRY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

XmppStanzaNode*
xmpp_stanza_node_construct (GType object_type)
{
	XmppStanzaNode* self = NULL;
	self = (XmppStanzaNode*) xmpp_stanza_entry_construct (object_type);
	return self;
}

XmppStanzaNode*
xmpp_stanza_node_new (void)
{
	return xmpp_stanza_node_construct (XMPP_TYPE_STANZA_NODE);
}

XmppStanzaNode*
xmpp_stanza_node_construct_build (GType object_type,
                                  const gchar* name,
                                  const gchar* ns_uri,
                                  GeeArrayList* nodes,
                                  GeeArrayList* attrs)
{
	XmppStanzaNode* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (ns_uri != NULL, NULL);
	self = (XmppStanzaNode*) xmpp_stanza_entry_construct (object_type);
	_tmp0_ = g_strdup (ns_uri);
	_g_free0 (((XmppStanzaEntry*) self)->ns_uri);
	((XmppStanzaEntry*) self)->ns_uri = _tmp0_;
	_tmp1_ = g_strdup (name);
	_g_free0 (((XmppStanzaEntry*) self)->name);
	((XmppStanzaEntry*) self)->name = _tmp1_;
	if (nodes != NULL) {
		GeeList* _tmp2_;
		_tmp2_ = self->sub_nodes;
		gee_collection_add_all ((GeeCollection*) _tmp2_, (GeeCollection*) G_TYPE_CHECK_INSTANCE_CAST (nodes, GEE_TYPE_ARRAY_LIST, GeeArrayList));
	}
	if (attrs != NULL) {
		GeeList* _tmp3_;
		_tmp3_ = self->attributes;
		gee_collection_add_all ((GeeCollection*) _tmp3_, (GeeCollection*) G_TYPE_CHECK_INSTANCE_CAST (attrs, GEE_TYPE_ARRAY_LIST, GeeArrayList));
	}
	return self;
}

XmppStanzaNode*
xmpp_stanza_node_new_build (const gchar* name,
                            const gchar* ns_uri,
                            GeeArrayList* nodes,
                            GeeArrayList* attrs)
{
	return xmpp_stanza_node_construct_build (XMPP_TYPE_STANZA_NODE, name, ns_uri, nodes, attrs);
}

XmppStanzaNode*
xmpp_stanza_node_construct_text (GType object_type,
                                 const gchar* text)
{
	XmppStanzaNode* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (text != NULL, NULL);
	self = (XmppStanzaNode*) xmpp_stanza_entry_construct (object_type);
	_tmp0_ = g_strdup ("#text");
	_g_free0 (((XmppStanzaEntry*) self)->name);
	((XmppStanzaEntry*) self)->name = _tmp0_;
	_tmp1_ = g_strdup (text);
	_g_free0 (((XmppStanzaEntry*) self)->val);
	((XmppStanzaEntry*) self)->val = _tmp1_;
	return self;
}

XmppStanzaNode*
xmpp_stanza_node_new_text (const gchar* text)
{
	return xmpp_stanza_node_construct_text (XMPP_TYPE_STANZA_NODE, text);
}

XmppStanzaNode*
xmpp_stanza_node_construct_encoded_text (GType object_type,
                                         const gchar* text)
{
	XmppStanzaNode* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (text != NULL, NULL);
	self = (XmppStanzaNode*) xmpp_stanza_entry_construct (object_type);
	_tmp0_ = g_strdup ("#text");
	_g_free0 (((XmppStanzaEntry*) self)->name);
	((XmppStanzaEntry*) self)->name = _tmp0_;
	xmpp_stanza_entry_set_encoded_val ((XmppStanzaEntry*) self, text);
	return self;
}

XmppStanzaNode*
xmpp_stanza_node_new_encoded_text (const gchar* text)
{
	return xmpp_stanza_node_construct_encoded_text (XMPP_TYPE_STANZA_NODE, text);
}

static gpointer
_xmpp_stanza_entry_ref0 (gpointer self)
{
	return self ? xmpp_stanza_entry_ref (self) : NULL;
}

XmppStanzaNode*
xmpp_stanza_node_add_self_xmlns (XmppStanzaNode* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp2_;
	XmppStanzaNode* _tmp3_;
	XmppStanzaNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ((XmppStanzaEntry*) self)->ns_uri;
	if (_tmp0_ == NULL) {
		XmppStanzaNode* _tmp1_;
		_tmp1_ = _xmpp_stanza_entry_ref0 (self);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = ((XmppStanzaEntry*) self)->ns_uri;
	_tmp3_ = xmpp_stanza_node_put_attribute (self, "xmlns", (const gchar*) _tmp2_, NULL);
	result = _tmp3_;
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

const gchar*
xmpp_stanza_node_get_attribute (XmppStanzaNode* self,
                                const gchar* name,
                                const gchar* ns_uri)
{
	gchar* _name = NULL;
	gchar* _tmp0_;
	gchar* _ns_uri = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup (name);
	_name = _tmp0_;
	_tmp1_ = g_strdup (ns_uri);
	_ns_uri = _tmp1_;
	_tmp2_ = _ns_uri;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		_tmp3_ = _name;
		if (string_contains (_tmp3_, ":")) {
			gint lastIndex = 0;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp4_ = _name;
			lastIndex = string_last_index_of_char (_tmp4_, (gunichar) ':', 0);
			_tmp5_ = _name;
			_tmp6_ = string_substring (_tmp5_, (glong) 0, (glong) lastIndex);
			_g_free0 (_ns_uri);
			_ns_uri = _tmp6_;
			_tmp7_ = _name;
			_tmp8_ = string_substring (_tmp7_, (glong) (lastIndex + 1), (glong) -1);
			_g_free0 (_name);
			_name = _tmp8_;
		} else {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = ((XmppStanzaEntry*) self)->ns_uri;
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (_ns_uri);
			_ns_uri = _tmp10_;
		}
	}
	{
		GeeList* _attr_list = NULL;
		GeeList* _tmp11_;
		gint _attr_size = 0;
		GeeList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _attr_index = 0;
		_tmp11_ = self->attributes;
		_attr_list = _tmp11_;
		_tmp12_ = _attr_list;
		_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_attr_size = _tmp14_;
		_attr_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			XmppStanzaAttribute* attr = NULL;
			GeeList* _tmp17_;
			gpointer _tmp18_;
			gboolean _tmp19_ = FALSE;
			XmppStanzaAttribute* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			_attr_index = _attr_index + 1;
			_tmp15_ = _attr_index;
			_tmp16_ = _attr_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _attr_list;
			_tmp18_ = gee_list_get (_tmp17_, _attr_index);
			attr = (XmppStanzaAttribute*) _tmp18_;
			_tmp20_ = attr;
			_tmp21_ = ((XmppStanzaEntry*) _tmp20_)->ns_uri;
			_tmp22_ = _ns_uri;
			if (g_strcmp0 (_tmp21_, (const gchar*) _tmp22_) == 0) {
				XmppStanzaAttribute* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				_tmp23_ = attr;
				_tmp24_ = ((XmppStanzaEntry*) _tmp23_)->name;
				_tmp25_ = _name;
				_tmp19_ = g_strcmp0 (_tmp24_, _tmp25_) == 0;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				XmppStanzaAttribute* _tmp26_;
				const gchar* _tmp27_;
				_tmp26_ = attr;
				_tmp27_ = ((XmppStanzaEntry*) _tmp26_)->val;
				result = _tmp27_;
				_xmpp_stanza_entry_unref0 (attr);
				_g_free0 (_ns_uri);
				_g_free0 (_name);
				return result;
			}
			_xmpp_stanza_entry_unref0 (attr);
		}
	}
	result = NULL;
	_g_free0 (_ns_uri);
	_g_free0 (_name);
	return result;
}

static gboolean
int_try_parse (const gchar* str,
               gint* _result_,
               const gchar** unparsed,
               guint _base)
{
	gint _vala__result_ = 0;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	glong long_result = 0L;
	gchar* _tmp0_ = NULL;
	glong _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	glong _tmp6_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = strtol (str, &_tmp0_, (gint) _base);
	endptr = _tmp0_;
	long_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
	}
	_tmp6_ = long_result;
	if ((((glong) G_MININT) <= _tmp6_) && (_tmp6_ <= ((glong) G_MAXINT))) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_vala__result_ = (gint) long_result;
		if (errno != ERANGE) {
			_tmp8_ = errno != EINVAL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = _vala_unparsed;
			_tmp10_ = endptr;
			_tmp7_ = _tmp9_ != _tmp10_;
		} else {
			_tmp7_ = FALSE;
		}
		result = _tmp7_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		_vala__result_ = G_MAXINT;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

gint
xmpp_stanza_node_get_attribute_int (XmppStanzaNode* self,
                                    const gchar* name,
                                    gint def,
                                    const gchar* ns_uri)
{
	gchar* attribute_str = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gint res = 0;
	gboolean parse_success = FALSE;
	const gchar* _tmp3_;
	gint _tmp4_ = 0;
	gboolean _tmp5_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = xmpp_stanza_node_get_attribute (self, name, ns_uri);
	_tmp1_ = g_strdup (_tmp0_);
	attribute_str = _tmp1_;
	_tmp2_ = attribute_str;
	if (_tmp2_ == NULL) {
		result = def;
		_g_free0 (attribute_str);
		return result;
	}
	res = def;
	_tmp3_ = attribute_str;
	_tmp5_ = int_try_parse (_tmp3_, &_tmp4_, NULL, (guint) 10);
	res = _tmp4_;
	parse_success = _tmp5_;
	if (!parse_success) {
		const gchar* _tmp6_;
		_tmp6_ = attribute_str;
		g_info ("stanza_node.vala:107: Could not parse int attribute %s: %s", name, _tmp6_);
		result = def;
		_g_free0 (attribute_str);
		return result;
	}
	result = res;
	_g_free0 (attribute_str);
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
uint_try_parse (const gchar* str,
                guint* _result_,
                const gchar** unparsed,
                guint _base)
{
	guint _vala__result_ = 0U;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gulong ulong_result = 0UL;
	gchar* _tmp0_ = NULL;
	gulong _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gulong _tmp6_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = strtoul (str, &_tmp0_, (gint) _base);
	endptr = _tmp0_;
	ulong_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
	}
	_tmp6_ = ulong_result;
	if ((((gulong) 0) <= _tmp6_) && (_tmp6_ <= ((gulong) G_MAXUINT))) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_vala__result_ = (guint) ulong_result;
		if (errno != ERANGE) {
			_tmp8_ = errno != EINVAL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = _vala_unparsed;
			_tmp10_ = endptr;
			_tmp7_ = _tmp9_ != _tmp10_;
		} else {
			_tmp7_ = FALSE;
		}
		result = _tmp7_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		_vala__result_ = G_MAXUINT;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

guint
xmpp_stanza_node_get_attribute_uint (XmppStanzaNode* self,
                                     const gchar* name,
                                     guint def,
                                     const gchar* ns_uri)
{
	gchar* attribute_str = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	guint res = 0U;
	gboolean parse_success = FALSE;
	const gchar* _tmp7_;
	guint _tmp8_ = 0U;
	gboolean _tmp9_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (name != NULL, 0U);
	_tmp0_ = xmpp_stanza_node_get_attribute (self, name, ns_uri);
	_tmp1_ = g_strdup (_tmp0_);
	attribute_str = _tmp1_;
	_tmp3_ = attribute_str;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = attribute_str;
		_tmp5_ = string_strip (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = g_str_has_prefix (_tmp6_, "-");
		_g_free0 (_tmp6_);
	}
	if (_tmp2_) {
		result = def;
		_g_free0 (attribute_str);
		return result;
	}
	res = def;
	_tmp7_ = attribute_str;
	_tmp9_ = uint_try_parse (_tmp7_, &_tmp8_, NULL, (guint) 10);
	res = _tmp8_;
	parse_success = _tmp9_;
	if (!parse_success) {
		const gchar* _tmp10_;
		_tmp10_ = attribute_str;
		g_info ("stanza_node.vala:120: Could not parse uint attribute %s: %s", name, _tmp10_);
		result = def;
		_g_free0 (attribute_str);
		return result;
	}
	result = res;
	_g_free0 (attribute_str);
	return result;
}

gboolean
xmpp_stanza_node_get_attribute_bool (XmppStanzaNode* self,
                                     const gchar* name,
                                     gboolean def,
                                     const gchar* ns_uri)
{
	gchar* res = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = xmpp_stanza_node_get_attribute (self, name, ns_uri);
	_tmp1_ = g_strdup (_tmp0_);
	res = _tmp1_;
	_tmp2_ = res;
	if (_tmp2_ == NULL) {
		result = def;
		_g_free0 (res);
		return result;
	}
	_tmp4_ = res;
	_tmp5_ = g_utf8_strdown ((const gchar*) _tmp4_, (gssize) -1);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strcmp0 (_tmp6_, "true") == 0;
	_g_free0 (_tmp6_);
	if (_tmp7_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = res;
		_tmp3_ = g_strcmp0 (_tmp8_, "1") == 0;
	}
	result = _tmp3_;
	_g_free0 (res);
	return result;
}

XmppStanzaAttribute*
xmpp_stanza_node_get_attribute_raw (XmppStanzaNode* self,
                                    const gchar* name,
                                    const gchar* ns_uri)
{
	gchar* _name = NULL;
	gchar* _tmp0_;
	gchar* _ns_uri = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	XmppStanzaAttribute* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup (name);
	_name = _tmp0_;
	_tmp1_ = g_strdup (ns_uri);
	_ns_uri = _tmp1_;
	_tmp2_ = _ns_uri;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		_tmp3_ = _name;
		if (string_contains (_tmp3_, ":")) {
			gint lastIndex = 0;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp4_ = _name;
			lastIndex = string_last_index_of_char (_tmp4_, (gunichar) ':', 0);
			_tmp5_ = _name;
			_tmp6_ = string_substring (_tmp5_, (glong) 0, (glong) lastIndex);
			_g_free0 (_ns_uri);
			_ns_uri = _tmp6_;
			_tmp7_ = _name;
			_tmp8_ = string_substring (_tmp7_, (glong) (lastIndex + 1), (glong) -1);
			_g_free0 (_name);
			_name = _tmp8_;
		} else {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = ((XmppStanzaEntry*) self)->ns_uri;
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (_ns_uri);
			_ns_uri = _tmp10_;
		}
	}
	{
		GeeList* _attr_list = NULL;
		GeeList* _tmp11_;
		gint _attr_size = 0;
		GeeList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _attr_index = 0;
		_tmp11_ = self->attributes;
		_attr_list = _tmp11_;
		_tmp12_ = _attr_list;
		_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_attr_size = _tmp14_;
		_attr_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			XmppStanzaAttribute* attr = NULL;
			GeeList* _tmp17_;
			gpointer _tmp18_;
			gboolean _tmp19_ = FALSE;
			XmppStanzaAttribute* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			_attr_index = _attr_index + 1;
			_tmp15_ = _attr_index;
			_tmp16_ = _attr_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _attr_list;
			_tmp18_ = gee_list_get (_tmp17_, _attr_index);
			attr = (XmppStanzaAttribute*) _tmp18_;
			_tmp20_ = attr;
			_tmp21_ = ((XmppStanzaEntry*) _tmp20_)->ns_uri;
			_tmp22_ = _ns_uri;
			if (g_strcmp0 (_tmp21_, _tmp22_) == 0) {
				XmppStanzaAttribute* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				_tmp23_ = attr;
				_tmp24_ = ((XmppStanzaEntry*) _tmp23_)->name;
				_tmp25_ = _name;
				_tmp19_ = g_strcmp0 (_tmp24_, _tmp25_) == 0;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				result = attr;
				_g_free0 (_ns_uri);
				_g_free0 (_name);
				return result;
			}
			_xmpp_stanza_entry_unref0 (attr);
		}
	}
	result = NULL;
	_g_free0 (_ns_uri);
	_g_free0 (_name);
	return result;
}

GeeList*
xmpp_stanza_node_get_attributes_by_ns_uri (XmppStanzaNode* self,
                                           const gchar* ns_uri)
{
	GeeArrayList* ret = NULL;
	GeeArrayList* _tmp0_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ns_uri != NULL, NULL);
	_tmp0_ = gee_array_list_new (XMPP_TYPE_STANZA_ATTRIBUTE, (GBoxedCopyFunc) xmpp_stanza_entry_ref, (GDestroyNotify) xmpp_stanza_entry_unref, NULL, NULL, NULL);
	ret = _tmp0_;
	{
		GeeList* _attr_list = NULL;
		GeeList* _tmp1_;
		gint _attr_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _attr_index = 0;
		_tmp1_ = self->attributes;
		_attr_list = _tmp1_;
		_tmp2_ = _attr_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_attr_size = _tmp4_;
		_attr_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			XmppStanzaAttribute* attr = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			XmppStanzaAttribute* _tmp9_;
			const gchar* _tmp10_;
			_attr_index = _attr_index + 1;
			_tmp5_ = _attr_index;
			_tmp6_ = _attr_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _attr_list;
			_tmp8_ = gee_list_get (_tmp7_, _attr_index);
			attr = (XmppStanzaAttribute*) _tmp8_;
			_tmp9_ = attr;
			_tmp10_ = ((XmppStanzaEntry*) _tmp9_)->ns_uri;
			if (g_strcmp0 (_tmp10_, ns_uri) == 0) {
				GeeArrayList* _tmp11_;
				XmppStanzaAttribute* _tmp12_;
				_tmp11_ = ret;
				_tmp12_ = attr;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
			}
			_xmpp_stanza_entry_unref0 (attr);
		}
	}
	result = (GeeList*) ret;
	return result;
}

const gchar*
xmpp_stanza_node_get_deep_attribute (XmppStanzaNode* self,
                                     ...)
{
	va_list l = {0};
	XmppStanzaAttribute* res = NULL;
	va_list _tmp0_ = {0};
	XmppStanzaAttribute* _tmp1_;
	XmppStanzaAttribute* _tmp2_;
	XmppStanzaAttribute* _tmp3_;
	XmppStanzaAttribute* _tmp4_;
	const gchar* _tmp5_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	va_start (l, self);
	va_copy (_tmp0_, l);
	_tmp1_ = xmpp_stanza_node_get_deep_attribute_ (self, _tmp0_);
	_tmp2_ = _tmp1_;
	va_end (_tmp0_);
	res = _tmp2_;
	_tmp3_ = res;
	if (_tmp3_ == NULL) {
		result = NULL;
		_xmpp_stanza_entry_unref0 (res);
		va_end (l);
		return result;
	}
	_tmp4_ = res;
	_tmp5_ = ((XmppStanzaEntry*) G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, XMPP_TYPE_STANZA_ATTRIBUTE, XmppStanzaAttribute))->val;
	result = _tmp5_;
	_xmpp_stanza_entry_unref0 (res);
	va_end (l);
	return result;
}

XmppStanzaAttribute*
xmpp_stanza_node_get_deep_attribute_ (XmppStanzaNode* self,
                                      va_list l)
{
	XmppStanzaNode* node = NULL;
	XmppStanzaNode* _tmp0_;
	gchar* attribute_name = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	XmppStanzaNode* _tmp15_;
	const gchar* _tmp16_;
	XmppStanzaAttribute* _tmp17_;
	XmppStanzaAttribute* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _xmpp_stanza_entry_ref0 (self);
	node = _tmp0_;
	_tmp1_ = va_arg (l, gchar*);
	_tmp2_ = g_strdup (_tmp1_);
	attribute_name = _tmp2_;
	_tmp3_ = attribute_name;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_free0 (attribute_name);
		_xmpp_stanza_entry_unref0 (node);
		return result;
	}
	while (TRUE) {
		gchar* s = NULL;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		XmppStanzaNode* node_tmp = NULL;
		XmppStanzaNode* _tmp7_;
		const gchar* _tmp8_;
		XmppStanzaNode* _tmp9_;
		XmppStanzaNode* _tmp10_;
		XmppStanzaNode* _tmp11_;
		XmppStanzaNode* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp4_ = va_arg (l, gchar*);
		_tmp5_ = g_strdup (_tmp4_);
		s = _tmp5_;
		_tmp6_ = s;
		if (_tmp6_ == NULL) {
			_g_free0 (s);
			break;
		}
		_tmp7_ = node;
		_tmp8_ = attribute_name;
		_tmp9_ = xmpp_stanza_node_get_subnode (_tmp7_, (const gchar*) _tmp8_, NULL, FALSE);
		node_tmp = _tmp9_;
		_tmp10_ = node_tmp;
		if (_tmp10_ == NULL) {
			result = NULL;
			_xmpp_stanza_entry_unref0 (node_tmp);
			_g_free0 (s);
			_g_free0 (attribute_name);
			_xmpp_stanza_entry_unref0 (node);
			return result;
		}
		_tmp11_ = node_tmp;
		_tmp12_ = _xmpp_stanza_entry_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, XMPP_TYPE_STANZA_NODE, XmppStanzaNode));
		_xmpp_stanza_entry_unref0 (node);
		node = _tmp12_;
		_tmp13_ = s;
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (attribute_name);
		attribute_name = _tmp14_;
		_xmpp_stanza_entry_unref0 (node_tmp);
		_g_free0 (s);
	}
	_tmp15_ = node;
	_tmp16_ = attribute_name;
	_tmp17_ = xmpp_stanza_node_get_attribute_raw (_tmp15_, (const gchar*) _tmp16_, NULL);
	result = _tmp17_;
	_g_free0 (attribute_name);
	_xmpp_stanza_entry_unref0 (node);
	return result;
}

XmppStanzaNode*
xmpp_stanza_node_get_subnode (XmppStanzaNode* self,
                              const gchar* name,
                              const gchar* ns_uri,
                              gboolean recurse)
{
	gchar* _name = NULL;
	gchar* _tmp0_;
	gchar* _ns_uri = NULL;
	gchar* _tmp1_;
	XmppStanzaNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup (name);
	_name = _tmp0_;
	_tmp1_ = g_strdup (ns_uri);
	_ns_uri = _tmp1_;
	if (ns_uri == NULL) {
		const gchar* _tmp2_;
		_tmp2_ = _name;
		if (string_contains (_tmp2_, ":")) {
			gint lastIndex = 0;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp3_ = _name;
			lastIndex = string_last_index_of_char (_tmp3_, (gunichar) ':', 0);
			_tmp4_ = _name;
			_tmp5_ = string_substring (_tmp4_, (glong) 0, (glong) lastIndex);
			_g_free0 (_ns_uri);
			_ns_uri = _tmp5_;
			_tmp6_ = _name;
			_tmp7_ = string_substring (_tmp6_, (glong) (lastIndex + 1), (glong) -1);
			_g_free0 (_name);
			_name = _tmp7_;
		} else {
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = ((XmppStanzaEntry*) self)->ns_uri;
			_tmp9_ = g_strdup (_tmp8_);
			_g_free0 (_ns_uri);
			_ns_uri = _tmp9_;
		}
	}
	{
		GeeList* _node_list = NULL;
		GeeList* _tmp10_;
		gint _node_size = 0;
		GeeList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _node_index = 0;
		_tmp10_ = self->sub_nodes;
		_node_list = _tmp10_;
		_tmp11_ = _node_list;
		_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_node_size = _tmp13_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			XmppStanzaNode* node = NULL;
			GeeList* _tmp16_;
			gpointer _tmp17_;
			gboolean _tmp18_ = FALSE;
			XmppStanzaNode* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			_node_index = _node_index + 1;
			_tmp14_ = _node_index;
			_tmp15_ = _node_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _node_list;
			_tmp17_ = gee_list_get (_tmp16_, _node_index);
			node = (XmppStanzaNode*) _tmp17_;
			_tmp19_ = node;
			_tmp20_ = ((XmppStanzaEntry*) _tmp19_)->ns_uri;
			_tmp21_ = _ns_uri;
			if (g_strcmp0 (_tmp20_, _tmp21_) == 0) {
				XmppStanzaNode* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				_tmp22_ = node;
				_tmp23_ = ((XmppStanzaEntry*) _tmp22_)->name;
				_tmp24_ = _name;
				_tmp18_ = g_strcmp0 (_tmp23_, _tmp24_) == 0;
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				result = node;
				_g_free0 (_ns_uri);
				_g_free0 (_name);
				return result;
			}
			if (recurse) {
				XmppStanzaNode* x = NULL;
				XmppStanzaNode* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				XmppStanzaNode* _tmp28_;
				XmppStanzaNode* _tmp29_;
				_tmp25_ = node;
				_tmp26_ = _name;
				_tmp27_ = _ns_uri;
				_tmp28_ = xmpp_stanza_node_get_subnode (_tmp25_, _tmp26_, _tmp27_, recurse);
				x = _tmp28_;
				_tmp29_ = x;
				if (_tmp29_ != NULL) {
					result = x;
					_xmpp_stanza_entry_unref0 (node);
					_g_free0 (_ns_uri);
					_g_free0 (_name);
					return result;
				}
				_xmpp_stanza_entry_unref0 (x);
			}
			_xmpp_stanza_entry_unref0 (node);
		}
	}
	result = NULL;
	_g_free0 (_ns_uri);
	_g_free0 (_name);
	return result;
}

GeeList*
xmpp_stanza_node_get_subnodes (XmppStanzaNode* self,
                               const gchar* name,
                               const gchar* ns_uri,
                               gboolean recurse)
{
	GeeArrayList* ret = NULL;
	GeeArrayList* _tmp0_;
	gchar* _name = NULL;
	gchar* _tmp1_;
	gchar* _ns_uri = NULL;
	gchar* _tmp2_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gee_array_list_new (XMPP_TYPE_STANZA_NODE, (GBoxedCopyFunc) xmpp_stanza_entry_ref, (GDestroyNotify) xmpp_stanza_entry_unref, NULL, NULL, NULL);
	ret = _tmp0_;
	_tmp1_ = g_strdup (name);
	_name = _tmp1_;
	_tmp2_ = g_strdup (ns_uri);
	_ns_uri = _tmp2_;
	if (ns_uri == NULL) {
		const gchar* _tmp3_;
		_tmp3_ = _name;
		if (string_contains (_tmp3_, ":")) {
			gint lastIndex = 0;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp4_ = _name;
			lastIndex = string_last_index_of_char (_tmp4_, (gunichar) ':', 0);
			_tmp5_ = _name;
			_tmp6_ = string_substring (_tmp5_, (glong) 0, (glong) lastIndex);
			_g_free0 (_ns_uri);
			_ns_uri = _tmp6_;
			_tmp7_ = _name;
			_tmp8_ = string_substring (_tmp7_, (glong) (lastIndex + 1), (glong) -1);
			_g_free0 (_name);
			_name = _tmp8_;
		} else {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = ((XmppStanzaEntry*) self)->ns_uri;
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (_ns_uri);
			_ns_uri = _tmp10_;
		}
	}
	{
		GeeList* _node_list = NULL;
		GeeList* _tmp11_;
		gint _node_size = 0;
		GeeList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _node_index = 0;
		_tmp11_ = self->sub_nodes;
		_node_list = _tmp11_;
		_tmp12_ = _node_list;
		_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_node_size = _tmp14_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			XmppStanzaNode* node = NULL;
			GeeList* _tmp17_;
			gpointer _tmp18_;
			gboolean _tmp19_ = FALSE;
			XmppStanzaNode* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			_node_index = _node_index + 1;
			_tmp15_ = _node_index;
			_tmp16_ = _node_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _node_list;
			_tmp18_ = gee_list_get (_tmp17_, _node_index);
			node = (XmppStanzaNode*) _tmp18_;
			_tmp20_ = node;
			_tmp21_ = ((XmppStanzaEntry*) _tmp20_)->ns_uri;
			_tmp22_ = _ns_uri;
			if (g_strcmp0 (_tmp21_, _tmp22_) == 0) {
				XmppStanzaNode* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				_tmp23_ = node;
				_tmp24_ = ((XmppStanzaEntry*) _tmp23_)->name;
				_tmp25_ = _name;
				_tmp19_ = g_strcmp0 (_tmp24_, _tmp25_) == 0;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				GeeArrayList* _tmp26_;
				XmppStanzaNode* _tmp27_;
				_tmp26_ = ret;
				_tmp27_ = node;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, _tmp27_);
			}
			if (recurse) {
				GeeArrayList* _tmp28_;
				XmppStanzaNode* _tmp29_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				GeeList* _tmp32_;
				GeeList* _tmp33_;
				_tmp28_ = ret;
				_tmp29_ = node;
				_tmp30_ = _name;
				_tmp31_ = _ns_uri;
				_tmp32_ = xmpp_stanza_node_get_subnodes (_tmp29_, _tmp30_, _tmp31_, recurse);
				_tmp33_ = _tmp32_;
				gee_array_list_add_all (_tmp28_, (GeeCollection*) _tmp33_);
				_g_object_unref0 (_tmp33_);
			}
			_xmpp_stanza_entry_unref0 (node);
		}
	}
	result = (GeeList*) ret;
	_g_free0 (_ns_uri);
	_g_free0 (_name);
	return result;
}

XmppStanzaNode*
xmpp_stanza_node_get_deep_subnode (XmppStanzaNode* self,
                                   ...)
{
	va_list l = {0};
	va_list _tmp0_ = {0};
	XmppStanzaNode* _tmp1_;
	XmppStanzaNode* _tmp2_;
	XmppStanzaNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	va_start (l, self);
	va_copy (_tmp0_, l);
	_tmp1_ = xmpp_stanza_node_get_deep_subnode_ (self, _tmp0_);
	_tmp2_ = _tmp1_;
	va_end (_tmp0_);
	result = _tmp2_;
	va_end (l);
	return result;
}

XmppStanzaNode*
xmpp_stanza_node_get_deep_subnode_ (XmppStanzaNode* self,
                                    va_list l)
{
	XmppStanzaNode* node = NULL;
	XmppStanzaNode* _tmp0_;
	XmppStanzaNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _xmpp_stanza_entry_ref0 (self);
	node = _tmp0_;
	while (TRUE) {
		gchar* s = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		XmppStanzaNode* node_tmp = NULL;
		XmppStanzaNode* _tmp4_;
		const gchar* _tmp5_;
		XmppStanzaNode* _tmp6_;
		XmppStanzaNode* _tmp7_;
		XmppStanzaNode* _tmp8_;
		XmppStanzaNode* _tmp9_;
		_tmp1_ = va_arg (l, gchar*);
		_tmp2_ = g_strdup (_tmp1_);
		s = _tmp2_;
		_tmp3_ = s;
		if (_tmp3_ == NULL) {
			_g_free0 (s);
			break;
		}
		_tmp4_ = node;
		_tmp5_ = s;
		_tmp6_ = xmpp_stanza_node_get_subnode (_tmp4_, (const gchar*) _tmp5_, NULL, FALSE);
		node_tmp = _tmp6_;
		_tmp7_ = node_tmp;
		if (_tmp7_ == NULL) {
			result = NULL;
			_xmpp_stanza_entry_unref0 (node_tmp);
			_g_free0 (s);
			_xmpp_stanza_entry_unref0 (node);
			return result;
		}
		_tmp8_ = node_tmp;
		_tmp9_ = _xmpp_stanza_entry_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, XMPP_TYPE_STANZA_NODE, XmppStanzaNode));
		_xmpp_stanza_entry_unref0 (node);
		node = _tmp9_;
		_xmpp_stanza_entry_unref0 (node_tmp);
		_g_free0 (s);
	}
	result = node;
	return result;
}

GeeList*
xmpp_stanza_node_get_deep_subnodes (XmppStanzaNode* self,
                                    ...)
{
	va_list l = {0};
	va_list _tmp0_ = {0};
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	va_start (l, self);
	va_copy (_tmp0_, l);
	_tmp1_ = xmpp_stanza_node_get_deep_subnodes_ (self, _tmp0_);
	_tmp2_ = _tmp1_;
	va_end (_tmp0_);
	result = _tmp2_;
	va_end (l);
	return result;
}

GeeList*
xmpp_stanza_node_get_deep_subnodes_ (XmppStanzaNode* self,
                                     va_list l)
{
	XmppStanzaNode* node = NULL;
	XmppStanzaNode* _tmp0_;
	gchar* subnode_name = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	XmppStanzaNode* _tmp17_;
	const gchar* _tmp18_;
	GeeList* _tmp19_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _xmpp_stanza_entry_ref0 (self);
	node = _tmp0_;
	_tmp1_ = va_arg (l, gchar*);
	_tmp2_ = g_strdup (_tmp1_);
	subnode_name = _tmp2_;
	_tmp3_ = subnode_name;
	if (_tmp3_ == NULL) {
		GeeArrayList* _tmp4_;
		_tmp4_ = gee_array_list_new (XMPP_TYPE_STANZA_NODE, (GBoxedCopyFunc) xmpp_stanza_entry_ref, (GDestroyNotify) xmpp_stanza_entry_unref, NULL, NULL, NULL);
		result = (GeeList*) _tmp4_;
		_g_free0 (subnode_name);
		_xmpp_stanza_entry_unref0 (node);
		return result;
	}
	while (TRUE) {
		gchar* s = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		XmppStanzaNode* node_tmp = NULL;
		XmppStanzaNode* _tmp8_;
		const gchar* _tmp9_;
		XmppStanzaNode* _tmp10_;
		XmppStanzaNode* _tmp11_;
		XmppStanzaNode* _tmp13_;
		XmppStanzaNode* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp5_ = va_arg (l, gchar*);
		_tmp6_ = g_strdup (_tmp5_);
		s = _tmp6_;
		_tmp7_ = s;
		if (_tmp7_ == NULL) {
			_g_free0 (s);
			break;
		}
		_tmp8_ = node;
		_tmp9_ = subnode_name;
		_tmp10_ = xmpp_stanza_node_get_subnode (_tmp8_, (const gchar*) _tmp9_, NULL, FALSE);
		node_tmp = _tmp10_;
		_tmp11_ = node_tmp;
		if (_tmp11_ == NULL) {
			GeeArrayList* _tmp12_;
			_tmp12_ = gee_array_list_new (XMPP_TYPE_STANZA_NODE, (GBoxedCopyFunc) xmpp_stanza_entry_ref, (GDestroyNotify) xmpp_stanza_entry_unref, NULL, NULL, NULL);
			result = (GeeList*) _tmp12_;
			_xmpp_stanza_entry_unref0 (node_tmp);
			_g_free0 (s);
			_g_free0 (subnode_name);
			_xmpp_stanza_entry_unref0 (node);
			return result;
		}
		_tmp13_ = node_tmp;
		_tmp14_ = _xmpp_stanza_entry_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, XMPP_TYPE_STANZA_NODE, XmppStanzaNode));
		_xmpp_stanza_entry_unref0 (node);
		node = _tmp14_;
		_tmp15_ = s;
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (subnode_name);
		subnode_name = _tmp16_;
		_xmpp_stanza_entry_unref0 (node_tmp);
		_g_free0 (s);
	}
	_tmp17_ = node;
	_tmp18_ = subnode_name;
	_tmp19_ = xmpp_stanza_node_get_subnodes (_tmp17_, (const gchar*) _tmp18_, NULL, FALSE);
	result = _tmp19_;
	_g_free0 (subnode_name);
	_xmpp_stanza_entry_unref0 (node);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GeeList*
xmpp_stanza_node_get_all_subnodes (XmppStanzaNode* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->sub_nodes;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GeeList*
xmpp_stanza_node_get_deep_all_subnodes (XmppStanzaNode* self,
                                        ...)
{
	va_list l = {0};
	XmppStanzaNode* node = NULL;
	va_list _tmp0_ = {0};
	XmppStanzaNode* _tmp1_;
	XmppStanzaNode* _tmp2_;
	XmppStanzaNode* _tmp3_;
	GeeArrayList* _tmp6_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	va_start (l, self);
	va_copy (_tmp0_, l);
	_tmp1_ = xmpp_stanza_node_get_deep_subnode_ (self, _tmp0_);
	_tmp2_ = _tmp1_;
	va_end (_tmp0_);
	node = _tmp2_;
	_tmp3_ = node;
	if (_tmp3_ != NULL) {
		XmppStanzaNode* _tmp4_;
		GeeList* _tmp5_;
		_tmp4_ = node;
		_tmp5_ = xmpp_stanza_node_get_all_subnodes (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, XMPP_TYPE_STANZA_NODE, XmppStanzaNode));
		result = _tmp5_;
		_xmpp_stanza_entry_unref0 (node);
		va_end (l);
		return result;
	}
	_tmp6_ = gee_array_list_new (XMPP_TYPE_STANZA_NODE, (GBoxedCopyFunc) xmpp_stanza_entry_ref, (GDestroyNotify) xmpp_stanza_entry_unref, NULL, NULL, NULL);
	result = (GeeList*) _tmp6_;
	_xmpp_stanza_entry_unref0 (node);
	va_end (l);
	return result;
}

void
xmpp_stanza_node_add_attribute (XmppStanzaNode* self,
                                XmppStanzaAttribute* attr)
{
	GeeList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = self->attributes;
	gee_collection_add ((GeeCollection*) _tmp0_, attr);
}

static const gchar*
xmpp_stanza_node_real_get_string_content (XmppStanzaEntry* base)
{
	XmppStanzaNode * self;
	const gchar* _tmp0_;
	GeeList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* result;
	self = (XmppStanzaNode*) base;
	_tmp0_ = ((XmppStanzaEntry*) self)->val;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = ((XmppStanzaEntry*) self)->val;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->sub_nodes;
	_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 1) {
		GeeList* _tmp5_;
		gpointer _tmp6_;
		XmppStanzaNode* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp5_ = self->sub_nodes;
		_tmp6_ = gee_list_get (_tmp5_, 0);
		_tmp7_ = (XmppStanzaNode*) _tmp6_;
		_tmp8_ = xmpp_stanza_entry_get_string_content ((XmppStanzaEntry*) _tmp7_);
		_tmp9_ = _tmp8_;
		_xmpp_stanza_entry_unref0 (_tmp7_);
		result = _tmp9_;
		return result;
	}
	result = NULL;
	return result;
}

const gchar*
xmpp_stanza_node_get_deep_string_content (XmppStanzaNode* self,
                                          ...)
{
	va_list l = {0};
	XmppStanzaNode* node = NULL;
	va_list _tmp0_ = {0};
	XmppStanzaNode* _tmp1_;
	XmppStanzaNode* _tmp2_;
	XmppStanzaNode* _tmp3_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	va_start (l, self);
	va_copy (_tmp0_, l);
	_tmp1_ = xmpp_stanza_node_get_deep_subnode_ (self, _tmp0_);
	_tmp2_ = _tmp1_;
	va_end (_tmp0_);
	node = _tmp2_;
	_tmp3_ = node;
	if (_tmp3_ != NULL) {
		XmppStanzaNode* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = node;
		_tmp5_ = xmpp_stanza_entry_get_string_content ((XmppStanzaEntry*) G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, XMPP_TYPE_STANZA_NODE, XmppStanzaNode));
		result = _tmp5_;
		_xmpp_stanza_entry_unref0 (node);
		va_end (l);
		return result;
	}
	result = NULL;
	_xmpp_stanza_entry_unref0 (node);
	va_end (l);
	return result;
}

XmppStanzaNode*
xmpp_stanza_node_put_attribute (XmppStanzaNode* self,
                                const gchar* name,
                                const gchar* val,
                                const gchar* ns_uri)
{
	gchar* _ns_uri = NULL;
	gchar* _tmp0_;
	const gchar* _tmp2_;
	const gchar* _tmp5_;
	GeeList* _tmp7_;
	const gchar* _tmp8_;
	XmppStanzaAttribute* _tmp9_;
	XmppStanzaAttribute* _tmp10_;
	XmppStanzaNode* _tmp11_;
	XmppStanzaNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (val != NULL, NULL);
	_tmp0_ = g_strdup (ns_uri);
	_ns_uri = _tmp0_;
	if (g_strcmp0 (name, "xmlns") == 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (XMPP_XMLNS_URI);
		_g_free0 (_ns_uri);
		_ns_uri = _tmp1_;
	}
	_tmp2_ = _ns_uri;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = ((XmppStanzaEntry*) self)->ns_uri;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (_ns_uri);
		_ns_uri = _tmp4_;
	}
	_tmp5_ = _ns_uri;
	if (_tmp5_ == NULL) {
		XmppStanzaNode* _tmp6_;
		_tmp6_ = _xmpp_stanza_entry_ref0 (self);
		result = _tmp6_;
		_g_free0 (_ns_uri);
		return result;
	}
	_tmp7_ = self->attributes;
	_tmp8_ = _ns_uri;
	_tmp9_ = xmpp_stanza_attribute_new_build ((const gchar*) _tmp8_, name, val);
	_tmp10_ = _tmp9_;
	gee_collection_add ((GeeCollection*) _tmp7_, _tmp10_);
	_xmpp_stanza_entry_unref0 (_tmp10_);
	_tmp11_ = _xmpp_stanza_entry_ref0 (self);
	result = _tmp11_;
	_g_free0 (_ns_uri);
	return result;
}

/**
    *    Set only occurrence
    **/
void
xmpp_stanza_node_set_attribute (XmppStanzaNode* self,
                                const gchar* name,
                                const gchar* val,
                                const gchar* ns_uri)
{
	XmppStanzaNode* _tmp16_;
	XmppStanzaNode* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (val != NULL);
	if (ns_uri == NULL) {
		const gchar* _tmp0_;
		_tmp0_ = ((XmppStanzaEntry*) self)->ns_uri;
		ns_uri = _tmp0_;
	}
	{
		GeeList* _attr_list = NULL;
		GeeList* _tmp1_;
		gint _attr_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _attr_index = 0;
		_tmp1_ = self->attributes;
		_attr_list = _tmp1_;
		_tmp2_ = _attr_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_attr_size = _tmp4_;
		_attr_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			XmppStanzaAttribute* attr = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			gboolean _tmp9_ = FALSE;
			XmppStanzaAttribute* _tmp10_;
			const gchar* _tmp11_;
			_attr_index = _attr_index + 1;
			_tmp5_ = _attr_index;
			_tmp6_ = _attr_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _attr_list;
			_tmp8_ = gee_list_get (_tmp7_, _attr_index);
			attr = (XmppStanzaAttribute*) _tmp8_;
			_tmp10_ = attr;
			_tmp11_ = ((XmppStanzaEntry*) _tmp10_)->ns_uri;
			if (g_strcmp0 (_tmp11_, ns_uri) == 0) {
				XmppStanzaAttribute* _tmp12_;
				const gchar* _tmp13_;
				_tmp12_ = attr;
				_tmp13_ = ((XmppStanzaEntry*) _tmp12_)->name;
				_tmp9_ = g_strcmp0 (_tmp13_, name) == 0;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				XmppStanzaAttribute* _tmp14_;
				gchar* _tmp15_;
				_tmp14_ = attr;
				_tmp15_ = g_strdup (val);
				_g_free0 (((XmppStanzaEntry*) _tmp14_)->val);
				((XmppStanzaEntry*) _tmp14_)->val = _tmp15_;
				_xmpp_stanza_entry_unref0 (attr);
				return;
			}
			_xmpp_stanza_entry_unref0 (attr);
		}
	}
	_tmp16_ = xmpp_stanza_node_put_attribute (self, name, val, ns_uri);
	_tmp17_ = _tmp16_;
	_xmpp_stanza_entry_unref0 (_tmp17_);
}

XmppStanzaNode*
xmpp_stanza_node_put_node (XmppStanzaNode* self,
                           XmppStanzaNode* node)
{
	GeeList* _tmp0_;
	XmppStanzaNode* _tmp1_;
	XmppStanzaNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = self->sub_nodes;
	gee_collection_add ((GeeCollection*) _tmp0_, node);
	_tmp1_ = _xmpp_stanza_entry_ref0 (self);
	result = _tmp1_;
	return result;
}

gboolean
xmpp_stanza_node_equals (XmppStanzaNode* self,
                         XmppStanzaNode* other)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GeeList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GeeList* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	GeeList* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (other != NULL, FALSE);
	_tmp0_ = ((XmppStanzaEntry*) other)->name;
	_tmp1_ = ((XmppStanzaEntry*) self)->name;
	if (g_strcmp0 (_tmp0_, _tmp1_) != 0) {
		result = FALSE;
		return result;
	}
	_tmp2_ = ((XmppStanzaEntry*) other)->val;
	_tmp3_ = ((XmppStanzaEntry*) self)->val;
	if (g_strcmp0 (_tmp2_, _tmp3_) != 0) {
		result = FALSE;
		return result;
	}
	_tmp4_ = ((XmppStanzaEntry*) self)->name;
	if (g_strcmp0 (_tmp4_, "#text") == 0) {
		result = TRUE;
		return result;
	}
	_tmp5_ = ((XmppStanzaEntry*) other)->ns_uri;
	_tmp6_ = ((XmppStanzaEntry*) self)->ns_uri;
	if (g_strcmp0 (_tmp5_, _tmp6_) != 0) {
		result = FALSE;
		return result;
	}
	_tmp7_ = other->sub_nodes;
	_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->sub_nodes;
	_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp9_ != _tmp12_) {
		result = FALSE;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				GeeList* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				GeeList* _tmp18_;
				gpointer _tmp19_;
				XmppStanzaNode* _tmp20_;
				GeeList* _tmp21_;
				gpointer _tmp22_;
				XmppStanzaNode* _tmp23_;
				gboolean _tmp24_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = i;
					i = _tmp14_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp15_ = self->sub_nodes;
				_tmp16_ = gee_collection_get_size ((GeeCollection*) _tmp15_);
				_tmp17_ = _tmp16_;
				if (!(i < _tmp17_)) {
					break;
				}
				_tmp18_ = other->sub_nodes;
				_tmp19_ = gee_list_get (_tmp18_, i);
				_tmp20_ = (XmppStanzaNode*) _tmp19_;
				_tmp21_ = self->sub_nodes;
				_tmp22_ = gee_list_get (_tmp21_, i);
				_tmp23_ = (XmppStanzaNode*) _tmp22_;
				_tmp24_ = !xmpp_stanza_node_equals (_tmp20_, _tmp23_);
				_xmpp_stanza_entry_unref0 (_tmp23_);
				_xmpp_stanza_entry_unref0 (_tmp20_);
				if (_tmp24_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	_tmp25_ = other->attributes;
	_tmp26_ = gee_collection_get_size ((GeeCollection*) _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = self->attributes;
	_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp27_ != _tmp30_) {
		result = FALSE;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp31_ = FALSE;
			_tmp31_ = TRUE;
			while (TRUE) {
				GeeList* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				GeeList* _tmp36_;
				gpointer _tmp37_;
				XmppStanzaAttribute* _tmp38_;
				GeeList* _tmp39_;
				gpointer _tmp40_;
				XmppStanzaAttribute* _tmp41_;
				gboolean _tmp42_;
				if (!_tmp31_) {
					gint _tmp32_;
					_tmp32_ = i;
					i = _tmp32_ + 1;
				}
				_tmp31_ = FALSE;
				_tmp33_ = self->attributes;
				_tmp34_ = gee_collection_get_size ((GeeCollection*) _tmp33_);
				_tmp35_ = _tmp34_;
				if (!(i < _tmp35_)) {
					break;
				}
				_tmp36_ = other->attributes;
				_tmp37_ = gee_list_get (_tmp36_, i);
				_tmp38_ = (XmppStanzaAttribute*) _tmp37_;
				_tmp39_ = self->attributes;
				_tmp40_ = gee_list_get (_tmp39_, i);
				_tmp41_ = (XmppStanzaAttribute*) _tmp40_;
				_tmp42_ = !xmpp_stanza_attribute_equals (_tmp38_, _tmp41_);
				_xmpp_stanza_entry_unref0 (_tmp41_);
				_xmpp_stanza_entry_unref0 (_tmp38_);
				if (_tmp42_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

gchar*
xmpp_stanza_node_printf (XmppStanzaNode* self,
                         gint i,
                         const gchar* fmt_start_begin,
                         const gchar* start_empty_end,
                         const gchar* start_content_end,
                         const gchar* fmt_end,
                         const gchar* fmt_attr,
                         gboolean no_ns)
{
	gchar* indent = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GString* sb = NULL;
	GString* _tmp18_;
	gboolean _tmp38_ = FALSE;
	GString* _tmp66_;
	const gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (fmt_start_begin != NULL, NULL);
	g_return_val_if_fail (start_empty_end != NULL, NULL);
	g_return_val_if_fail (start_content_end != NULL, NULL);
	g_return_val_if_fail (fmt_end != NULL, NULL);
	g_return_val_if_fail (fmt_attr != NULL, NULL);
	_tmp0_ = g_strnfill ((gsize) (i * 2), ' ');
	indent = _tmp0_;
	_tmp1_ = ((XmppStanzaEntry*) self)->name;
	if (g_strcmp0 (_tmp1_, "#text") == 0) {
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp2_ = ((XmppStanzaEntry*) self)->val;
		_tmp3_ = strlen ((const gchar*) _tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_ > 1000) {
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = indent;
			_tmp6_ = g_strconcat (_tmp5_, "[... retracted for brevity ...]\n", NULL);
			result = _tmp6_;
			_g_free0 (indent);
			return result;
		}
		_tmp7_ = indent;
		_tmp8_ = ((XmppStanzaEntry*) self)->val;
		_tmp9_ = indent;
		_tmp10_ = g_strconcat ("\n", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_replace ((const gchar*) _tmp8_, "\n", _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp7_, _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat (_tmp15_, "\n", NULL);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		result = _tmp17_;
		_g_free0 (indent);
		return result;
	}
	_tmp18_ = g_string_new ("");
	sb = _tmp18_;
	if (no_ns) {
		GString* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		_tmp19_ = sb;
		_tmp20_ = indent;
		_tmp21_ = ((XmppStanzaEntry*) self)->name;
		g_string_append_printf (_tmp19_, fmt_start_begin, _tmp20_, _tmp21_);
	} else {
		GString* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		_tmp22_ = sb;
		_tmp23_ = indent;
		_tmp24_ = ((XmppStanzaEntry*) self)->ns_uri;
		_tmp25_ = ((XmppStanzaEntry*) self)->name;
		g_string_append_printf (_tmp22_, fmt_start_begin, _tmp23_, (const gchar*) _tmp24_, _tmp25_);
	}
	{
		GeeList* _attr_list = NULL;
		GeeList* _tmp26_;
		gint _attr_size = 0;
		GeeList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _attr_index = 0;
		_tmp26_ = self->attributes;
		_attr_list = _tmp26_;
		_tmp27_ = _attr_list;
		_tmp28_ = gee_collection_get_size ((GeeCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_attr_size = _tmp29_;
		_attr_index = -1;
		while (TRUE) {
			gint _tmp30_;
			gint _tmp31_;
			XmppStanzaAttribute* attr = NULL;
			GeeList* _tmp32_;
			gpointer _tmp33_;
			GString* _tmp34_;
			XmppStanzaAttribute* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			_attr_index = _attr_index + 1;
			_tmp30_ = _attr_index;
			_tmp31_ = _attr_size;
			if (!(_tmp30_ < _tmp31_)) {
				break;
			}
			_tmp32_ = _attr_list;
			_tmp33_ = gee_list_get (_tmp32_, _attr_index);
			attr = (XmppStanzaAttribute*) _tmp33_;
			_tmp34_ = sb;
			_tmp35_ = attr;
			_tmp36_ = xmpp_stanza_attribute_printf (_tmp35_, fmt_attr, no_ns, NULL);
			_tmp37_ = _tmp36_;
			g_string_append_printf (_tmp34_, " %s", _tmp37_);
			_g_free0 (_tmp37_);
			_xmpp_stanza_entry_unref0 (attr);
		}
	}
	if (!self->has_nodes) {
		GeeList* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		_tmp39_ = self->sub_nodes;
		_tmp40_ = gee_collection_get_size ((GeeCollection*) _tmp39_);
		_tmp41_ = _tmp40_;
		_tmp38_ = _tmp41_ == 0;
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		GString* _tmp42_;
		_tmp42_ = sb;
		g_string_append (_tmp42_, start_empty_end);
	} else {
		GString* _tmp43_;
		GeeList* _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		_tmp43_ = sb;
		g_string_append (_tmp43_, start_content_end);
		_tmp44_ = self->sub_nodes;
		_tmp45_ = gee_collection_get_size ((GeeCollection*) _tmp44_);
		_tmp46_ = _tmp45_;
		if (_tmp46_ != 0) {
			{
				GeeList* _subnode_list = NULL;
				GeeList* _tmp47_;
				gint _subnode_size = 0;
				GeeList* _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				gint _subnode_index = 0;
				_tmp47_ = self->sub_nodes;
				_subnode_list = _tmp47_;
				_tmp48_ = _subnode_list;
				_tmp49_ = gee_collection_get_size ((GeeCollection*) _tmp48_);
				_tmp50_ = _tmp49_;
				_subnode_size = _tmp50_;
				_subnode_index = -1;
				while (TRUE) {
					gint _tmp51_;
					gint _tmp52_;
					XmppStanzaNode* subnode = NULL;
					GeeList* _tmp53_;
					gpointer _tmp54_;
					GString* _tmp55_;
					XmppStanzaNode* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					_subnode_index = _subnode_index + 1;
					_tmp51_ = _subnode_index;
					_tmp52_ = _subnode_size;
					if (!(_tmp51_ < _tmp52_)) {
						break;
					}
					_tmp53_ = _subnode_list;
					_tmp54_ = gee_list_get (_tmp53_, _subnode_index);
					subnode = (XmppStanzaNode*) _tmp54_;
					_tmp55_ = sb;
					_tmp56_ = subnode;
					_tmp57_ = xmpp_stanza_node_printf (_tmp56_, i + 1, fmt_start_begin, start_empty_end, start_content_end, fmt_end, fmt_attr, no_ns);
					_tmp58_ = _tmp57_;
					g_string_append (_tmp55_, _tmp58_);
					_g_free0 (_tmp58_);
					_xmpp_stanza_entry_unref0 (subnode);
				}
			}
			if (no_ns) {
				GString* _tmp59_;
				const gchar* _tmp60_;
				const gchar* _tmp61_;
				_tmp59_ = sb;
				_tmp60_ = indent;
				_tmp61_ = ((XmppStanzaEntry*) self)->name;
				g_string_append_printf (_tmp59_, fmt_end, _tmp60_, _tmp61_);
			} else {
				GString* _tmp62_;
				const gchar* _tmp63_;
				const gchar* _tmp64_;
				const gchar* _tmp65_;
				_tmp62_ = sb;
				_tmp63_ = indent;
				_tmp64_ = ((XmppStanzaEntry*) self)->ns_uri;
				_tmp65_ = ((XmppStanzaEntry*) self)->name;
				g_string_append_printf (_tmp62_, fmt_end, _tmp63_, (const gchar*) _tmp64_, _tmp65_);
			}
		}
	}
	_tmp66_ = sb;
	_tmp67_ = _tmp66_->str;
	_tmp68_ = g_strdup (_tmp67_);
	result = _tmp68_;
	_g_string_free0 (sb);
	_g_free0 (indent);
	return result;
}

static gchar*
xmpp_stanza_node_real_to_string (XmppStanzaEntry* base,
                                 gint i)
{
	XmppStanzaNode * self;
	gchar* _tmp0_;
	gchar* result;
	self = (XmppStanzaNode*) base;
	_tmp0_ = xmpp_stanza_node_printf (self, i, XMPP_STANZA_NODE_TAG_START_BEGIN_FORMAT, XMPP_STANZA_NODE_TAG_START_EMPTY_END, XMPP_STANZA_NODE_TAG_START_CONTENT_END, XMPP_STANZA_NODE_TAG_END_FORMAT, XMPP_STANZA_ATTRIBUTE_ATTRIBUTE_STRING_FORMAT, FALSE);
	result = _tmp0_;
	return result;
}

gchar*
xmpp_stanza_node_to_ansi_string (XmppStanzaNode* self,
                                 gboolean hide_ns,
                                 gint i)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (hide_ns) {
		gchar* _tmp0_;
		_tmp0_ = xmpp_stanza_node_printf (self, i, XMPP_STANZA_NODE_TAG_ANSI_START_BEGIN_NO_NS_FORMAT, XMPP_STANZA_NODE_TAG_ANSI_START_EMPTY_END, XMPP_STANZA_NODE_TAG_ANSI_START_CONTENT_END, XMPP_STANZA_NODE_TAG_ANSI_END_NO_NS_FORMAT, XMPP_STANZA_ATTRIBUTE_ATTRIBUTE_STRING_ANSI_NO_NS_FORMAT, TRUE);
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = xmpp_stanza_node_printf (self, i, XMPP_STANZA_NODE_TAG_ANSI_START_BEGIN_FORMAT, XMPP_STANZA_NODE_TAG_ANSI_START_EMPTY_END, XMPP_STANZA_NODE_TAG_ANSI_START_CONTENT_END, XMPP_STANZA_NODE_TAG_ANSI_END_FORMAT, XMPP_STANZA_ATTRIBUTE_ATTRIBUTE_STRING_ANSI_FORMAT, FALSE);
		result = _tmp1_;
		return result;
	}
}

static gpointer
_xmpp_namespace_state_ref0 (gpointer self)
{
	return self ? xmpp_namespace_state_ref (self) : NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
xmpp_stanza_node_to_xml (XmppStanzaNode* self,
                         XmppNamespaceState* state,
                         GError** error)
{
	XmppNamespaceState* _tmp0_ = NULL;
	XmppNamespaceState* _tmp1_;
	XmppNamespaceState* my_state = NULL;
	XmppNamespaceState* _tmp3_;
	const gchar* _tmp4_;
	XmppNamespaceState* _tmp10_;
	XmppNamespaceState* _tmp11_;
	GString* sb = NULL;
	GString* _tmp32_;
	const gchar* _tmp33_;
	XmppNamespaceState* _tmp34_;
	const gchar* _tmp35_;
	XmppNamespaceState* attr_ns_state = NULL;
	XmppNamespaceState* _tmp44_;
	const gchar* _tmp45_;
	XmppNamespaceState* _tmp46_;
	gboolean _tmp60_ = FALSE;
	XmppNamespaceState* _tmp96_;
	XmppNamespaceState* _tmp97_;
	GString* _tmp98_;
	const gchar* _tmp99_;
	gchar* _tmp100_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = _xmpp_namespace_state_ref0 (state);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		XmppNamespaceState* _tmp2_;
		_tmp2_ = xmpp_namespace_state_new_for_stanza ();
		_xmpp_namespace_state_unref0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	my_state = _tmp3_;
	_tmp4_ = ((XmppStanzaEntry*) self)->name;
	if (g_strcmp0 (_tmp4_, "#text") == 0) {
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_;
		_tmp6_ = ((XmppStanzaEntry*) self)->val;
		if (_tmp6_ == NULL) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("");
			_g_free0 (_tmp5_);
			_tmp5_ = _tmp7_;
		} else {
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = xmpp_stanza_entry_get_encoded_val ((XmppStanzaEntry*) self);
			_tmp9_ = _tmp8_;
			_g_free0 (_tmp5_);
			_tmp5_ = (gchar*) _tmp9_;
		}
		result = _tmp5_;
		_xmpp_namespace_state_unref0 (my_state);
		_xmpp_namespace_state_unref0 (_tmp0_);
		return result;
	}
	_tmp10_ = my_state;
	_tmp11_ = xmpp_namespace_state_push (_tmp10_);
	_xmpp_namespace_state_unref0 (my_state);
	my_state = _tmp11_;
	{
		GeeList* _xmlns_list = NULL;
		GeeList* _tmp12_;
		gint _xmlns_size = 0;
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _xmlns_index = 0;
		_tmp12_ = xmpp_stanza_node_get_attributes_by_ns_uri (self, XMPP_XMLNS_URI);
		_xmlns_list = _tmp12_;
		_tmp13_ = _xmlns_list;
		_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_xmlns_size = _tmp15_;
		_xmlns_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			XmppStanzaAttribute* xmlns = NULL;
			GeeList* _tmp18_;
			gpointer _tmp19_;
			XmppStanzaAttribute* _tmp20_;
			const gchar* _tmp21_;
			XmppStanzaAttribute* _tmp22_;
			const gchar* _tmp23_;
			_xmlns_index = _xmlns_index + 1;
			_tmp16_ = _xmlns_index;
			_tmp17_ = _xmlns_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _xmlns_list;
			_tmp19_ = gee_list_get (_tmp18_, _xmlns_index);
			xmlns = (XmppStanzaAttribute*) _tmp19_;
			_tmp20_ = xmlns;
			_tmp21_ = ((XmppStanzaEntry*) _tmp20_)->val;
			if (_tmp21_ == NULL) {
				_xmpp_stanza_entry_unref0 (xmlns);
				continue;
			}
			_tmp22_ = xmlns;
			_tmp23_ = ((XmppStanzaEntry*) _tmp22_)->name;
			if (g_strcmp0 (_tmp23_, "xmlns") == 0) {
				XmppNamespaceState* _tmp24_;
				XmppStanzaAttribute* _tmp25_;
				const gchar* _tmp26_;
				_tmp24_ = my_state;
				_tmp25_ = xmlns;
				_tmp26_ = ((XmppStanzaEntry*) _tmp25_)->val;
				xmpp_namespace_state_set_current (_tmp24_, (const gchar*) _tmp26_);
			} else {
				XmppNamespaceState* _tmp27_;
				XmppStanzaAttribute* _tmp28_;
				const gchar* _tmp29_;
				XmppStanzaAttribute* _tmp30_;
				const gchar* _tmp31_;
				_tmp27_ = my_state;
				_tmp28_ = xmlns;
				_tmp29_ = ((XmppStanzaEntry*) _tmp28_)->val;
				_tmp30_ = xmlns;
				_tmp31_ = ((XmppStanzaEntry*) _tmp30_)->name;
				xmpp_namespace_state_add_assoc (_tmp27_, (const gchar*) _tmp29_, _tmp31_);
			}
			_xmpp_stanza_entry_unref0 (xmlns);
		}
		_g_object_unref0 (_xmlns_list);
	}
	_tmp32_ = g_string_new ("");
	sb = _tmp32_;
	_tmp33_ = ((XmppStanzaEntry*) self)->ns_uri;
	_tmp34_ = my_state;
	_tmp35_ = _tmp34_->current_ns_uri;
	if (g_strcmp0 (_tmp33_, _tmp35_) == 0) {
		GString* _tmp36_;
		const gchar* _tmp37_;
		_tmp36_ = sb;
		_tmp37_ = ((XmppStanzaEntry*) self)->name;
		g_string_append_printf (_tmp36_, "<%s", _tmp37_);
	} else {
		gchar* _tmp38_ = NULL;
		XmppNamespaceState* _tmp39_;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		GString* _tmp42_;
		const gchar* _tmp43_;
		_tmp39_ = my_state;
		_tmp40_ = ((XmppStanzaEntry*) self)->ns_uri;
		_tmp41_ = xmpp_namespace_state_find_name (_tmp39_, (const gchar*) _tmp40_, &_inner_error0_);
		_tmp38_ = _tmp41_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_string_free0 (sb);
				_xmpp_namespace_state_unref0 (my_state);
				_xmpp_namespace_state_unref0 (_tmp0_);
				return NULL;
			} else {
				_g_string_free0 (sb);
				_xmpp_namespace_state_unref0 (my_state);
				_xmpp_namespace_state_unref0 (_tmp0_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp42_ = sb;
		_tmp43_ = ((XmppStanzaEntry*) self)->name;
		g_string_append_printf (_tmp42_, "<%s:%s", _tmp38_, _tmp43_);
		_g_free0 (_tmp38_);
	}
	_tmp44_ = my_state;
	_tmp45_ = ((XmppStanzaEntry*) self)->ns_uri;
	_tmp46_ = xmpp_namespace_state_new_with_current (_tmp44_, (const gchar*) _tmp45_);
	attr_ns_state = _tmp46_;
	{
		GeeList* _attr_list = NULL;
		GeeList* _tmp47_;
		gint _attr_size = 0;
		GeeList* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gint _attr_index = 0;
		_tmp47_ = self->attributes;
		_attr_list = _tmp47_;
		_tmp48_ = _attr_list;
		_tmp49_ = gee_collection_get_size ((GeeCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		_attr_size = _tmp50_;
		_attr_index = -1;
		while (TRUE) {
			gint _tmp51_;
			gint _tmp52_;
			XmppStanzaAttribute* attr = NULL;
			GeeList* _tmp53_;
			gpointer _tmp54_;
			GString* _tmp55_;
			XmppStanzaAttribute* _tmp56_;
			XmppNamespaceState* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			_attr_index = _attr_index + 1;
			_tmp51_ = _attr_index;
			_tmp52_ = _attr_size;
			if (!(_tmp51_ < _tmp52_)) {
				break;
			}
			_tmp53_ = _attr_list;
			_tmp54_ = gee_list_get (_tmp53_, _attr_index);
			attr = (XmppStanzaAttribute*) _tmp54_;
			_tmp55_ = sb;
			_tmp56_ = attr;
			_tmp57_ = attr_ns_state;
			_tmp58_ = xmpp_stanza_attribute_to_xml (_tmp56_, _tmp57_);
			_tmp59_ = _tmp58_;
			g_string_append_printf (_tmp55_, " %s", _tmp59_);
			_g_free0 (_tmp59_);
			_xmpp_stanza_entry_unref0 (attr);
		}
	}
	if (!self->has_nodes) {
		GeeList* _tmp61_;
		gint _tmp62_;
		gint _tmp63_;
		_tmp61_ = self->sub_nodes;
		_tmp62_ = gee_collection_get_size ((GeeCollection*) _tmp61_);
		_tmp63_ = _tmp62_;
		_tmp60_ = _tmp63_ == 0;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		GString* _tmp64_;
		_tmp64_ = sb;
		g_string_append (_tmp64_, "/>");
	} else {
		GString* _tmp65_;
		GeeList* _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		_tmp65_ = sb;
		g_string_append (_tmp65_, ">");
		_tmp66_ = self->sub_nodes;
		_tmp67_ = gee_collection_get_size ((GeeCollection*) _tmp66_);
		_tmp68_ = _tmp67_;
		if (_tmp68_ != 0) {
			const gchar* _tmp82_;
			XmppNamespaceState* _tmp83_;
			const gchar* _tmp84_;
			{
				GeeList* _subnode_list = NULL;
				GeeList* _tmp69_;
				gint _subnode_size = 0;
				GeeList* _tmp70_;
				gint _tmp71_;
				gint _tmp72_;
				gint _subnode_index = 0;
				_tmp69_ = self->sub_nodes;
				_subnode_list = _tmp69_;
				_tmp70_ = _subnode_list;
				_tmp71_ = gee_collection_get_size ((GeeCollection*) _tmp70_);
				_tmp72_ = _tmp71_;
				_subnode_size = _tmp72_;
				_subnode_index = -1;
				while (TRUE) {
					gint _tmp73_;
					gint _tmp74_;
					XmppStanzaNode* subnode = NULL;
					GeeList* _tmp75_;
					gpointer _tmp76_;
					gchar* _tmp77_ = NULL;
					XmppStanzaNode* _tmp78_;
					XmppNamespaceState* _tmp79_;
					gchar* _tmp80_;
					GString* _tmp81_;
					_subnode_index = _subnode_index + 1;
					_tmp73_ = _subnode_index;
					_tmp74_ = _subnode_size;
					if (!(_tmp73_ < _tmp74_)) {
						break;
					}
					_tmp75_ = _subnode_list;
					_tmp76_ = gee_list_get (_tmp75_, _subnode_index);
					subnode = (XmppStanzaNode*) _tmp76_;
					_tmp78_ = subnode;
					_tmp79_ = my_state;
					_tmp80_ = xmpp_stanza_node_to_xml (_tmp78_, _tmp79_, &_inner_error0_);
					_tmp77_ = _tmp80_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_IO_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_xmpp_stanza_entry_unref0 (subnode);
							_xmpp_namespace_state_unref0 (attr_ns_state);
							_g_string_free0 (sb);
							_xmpp_namespace_state_unref0 (my_state);
							_xmpp_namespace_state_unref0 (_tmp0_);
							return NULL;
						} else {
							_xmpp_stanza_entry_unref0 (subnode);
							_xmpp_namespace_state_unref0 (attr_ns_state);
							_g_string_free0 (sb);
							_xmpp_namespace_state_unref0 (my_state);
							_xmpp_namespace_state_unref0 (_tmp0_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp81_ = sb;
					g_string_append (_tmp81_, _tmp77_);
					_g_free0 (_tmp77_);
					_xmpp_stanza_entry_unref0 (subnode);
				}
			}
			_tmp82_ = ((XmppStanzaEntry*) self)->ns_uri;
			_tmp83_ = my_state;
			_tmp84_ = _tmp83_->current_ns_uri;
			if (g_strcmp0 (_tmp82_, _tmp84_) == 0) {
				GString* _tmp85_;
				const gchar* _tmp86_;
				const gchar* _tmp87_;
				gchar* _tmp88_;
				gchar* _tmp89_;
				_tmp85_ = sb;
				_tmp86_ = ((XmppStanzaEntry*) self)->name;
				_tmp87_ = string_to_string (_tmp86_);
				_tmp88_ = g_strconcat ("</", _tmp87_, ">", NULL);
				_tmp89_ = _tmp88_;
				g_string_append (_tmp85_, _tmp89_);
				_g_free0 (_tmp89_);
			} else {
				gchar* _tmp90_ = NULL;
				XmppNamespaceState* _tmp91_;
				const gchar* _tmp92_;
				gchar* _tmp93_;
				GString* _tmp94_;
				const gchar* _tmp95_;
				_tmp91_ = my_state;
				_tmp92_ = ((XmppStanzaEntry*) self)->ns_uri;
				_tmp93_ = xmpp_namespace_state_find_name (_tmp91_, (const gchar*) _tmp92_, &_inner_error0_);
				_tmp90_ = _tmp93_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_IO_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_xmpp_namespace_state_unref0 (attr_ns_state);
						_g_string_free0 (sb);
						_xmpp_namespace_state_unref0 (my_state);
						_xmpp_namespace_state_unref0 (_tmp0_);
						return NULL;
					} else {
						_xmpp_namespace_state_unref0 (attr_ns_state);
						_g_string_free0 (sb);
						_xmpp_namespace_state_unref0 (my_state);
						_xmpp_namespace_state_unref0 (_tmp0_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp94_ = sb;
				_tmp95_ = ((XmppStanzaEntry*) self)->name;
				g_string_append_printf (_tmp94_, "</%s:%s>", _tmp90_, _tmp95_);
				_g_free0 (_tmp90_);
			}
		}
	}
	_tmp96_ = my_state;
	_tmp97_ = xmpp_namespace_state_pop (_tmp96_);
	_xmpp_namespace_state_unref0 (my_state);
	my_state = _tmp97_;
	_tmp98_ = sb;
	_tmp99_ = _tmp98_->str;
	_tmp100_ = g_strdup (_tmp99_);
	result = _tmp100_;
	_xmpp_namespace_state_unref0 (attr_ns_state);
	_g_string_free0 (sb);
	_xmpp_namespace_state_unref0 (my_state);
	_xmpp_namespace_state_unref0 (_tmp0_);
	return result;
}

static void
xmpp_stanza_node_class_init (XmppStanzaNodeClass * klass,
                             gpointer klass_data)
{
	xmpp_stanza_node_parent_class = g_type_class_peek_parent (klass);
	((XmppStanzaEntryClass *) klass)->finalize = xmpp_stanza_node_finalize;
	((XmppStanzaEntryClass *) klass)->get_string_content = (const gchar* (*) (XmppStanzaEntry*)) xmpp_stanza_node_real_get_string_content;
	((XmppStanzaEntryClass *) klass)->to_string = (gchar* (*) (XmppStanzaEntry*, gint)) xmpp_stanza_node_real_to_string;
}

static void
xmpp_stanza_node_instance_init (XmppStanzaNode * self,
                                gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	_tmp0_ = gee_array_list_new (XMPP_TYPE_STANZA_NODE, (GBoxedCopyFunc) xmpp_stanza_entry_ref, (GDestroyNotify) xmpp_stanza_entry_unref, NULL, NULL, NULL);
	self->sub_nodes = (GeeList*) _tmp0_;
	_tmp1_ = gee_array_list_new (XMPP_TYPE_STANZA_ATTRIBUTE, (GBoxedCopyFunc) xmpp_stanza_entry_ref, (GDestroyNotify) xmpp_stanza_entry_unref, NULL, NULL, NULL);
	self->attributes = (GeeList*) _tmp1_;
	self->has_nodes = FALSE;
	self->pseudo = FALSE;
}

static void
xmpp_stanza_node_finalize (XmppStanzaEntry * obj)
{
	XmppStanzaNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XMPP_TYPE_STANZA_NODE, XmppStanzaNode);
	_g_object_unref0 (self->sub_nodes);
	_g_object_unref0 (self->attributes);
	XMPP_STANZA_ENTRY_CLASS (xmpp_stanza_node_parent_class)->finalize (obj);
}

static GType
xmpp_stanza_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XmppStanzaNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xmpp_stanza_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XmppStanzaNode), 0, (GInstanceInitFunc) xmpp_stanza_node_instance_init, NULL };
	GType xmpp_stanza_node_type_id;
	xmpp_stanza_node_type_id = g_type_register_static (XMPP_TYPE_STANZA_ENTRY, "XmppStanzaNode", &g_define_type_info, 0);
	return xmpp_stanza_node_type_id;
}

GType
xmpp_stanza_node_get_type (void)
{
	static volatile gsize xmpp_stanza_node_type_id__once = 0;
	if (g_once_init_enter (&xmpp_stanza_node_type_id__once)) {
		GType xmpp_stanza_node_type_id;
		xmpp_stanza_node_type_id = xmpp_stanza_node_get_type_once ();
		g_once_init_leave (&xmpp_stanza_node_type_id__once, xmpp_stanza_node_type_id);
	}
	return xmpp_stanza_node_type_id__once;
}

