/* DirHandling.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DirHandling.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include "deja.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static void _vala_array_add9 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
VALA_EXTERN void deja_dup_expand_links_in_file (GFile* file,
                                    GList** all,
                                    gboolean keep_internal,
                                    gboolean keep_missing,
                                    GList* seen);
static gint ______lambda13_ (GFile* a,
                      GFile* b);
static gint _______lambda13__gcompare_func (gconstpointer a,
                                     gconstpointer b);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN void deja_dup_expand_links_in_list (GList** all,
                                    gboolean keep_internal,
                                    gboolean keep_missing);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
deja_dup_parse_keywords (const gchar* dir)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar** dirs = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gint dirs_length1;
	gint _dirs_size_;
	GUserDirectory* enums = NULL;
	GUserDirectory* _tmp10_;
	gint enums_length1;
	gint _enums_size_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	GUserDirectory* _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp13_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gboolean _tmp43_ = FALSE;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gboolean _tmp47_;
	gchar* result;
	g_return_val_if_fail (dir != NULL, NULL);
	_tmp0_ = g_strdup (dir);
	_result_ = _tmp0_;
	_tmp1_ = g_strdup ("$DESKTOP");
	_tmp2_ = g_strdup ("$DOCUMENTS");
	_tmp3_ = g_strdup ("$DOWNLOAD");
	_tmp4_ = g_strdup ("$MUSIC");
	_tmp5_ = g_strdup ("$PICTURES");
	_tmp6_ = g_strdup ("$PUBLIC_SHARE");
	_tmp7_ = g_strdup ("$TEMPLATES");
	_tmp8_ = g_strdup ("$VIDEOS");
	_tmp9_ = g_new0 (gchar*, 8 + 1);
	_tmp9_[0] = _tmp1_;
	_tmp9_[1] = _tmp2_;
	_tmp9_[2] = _tmp3_;
	_tmp9_[3] = _tmp4_;
	_tmp9_[4] = _tmp5_;
	_tmp9_[5] = _tmp6_;
	_tmp9_[6] = _tmp7_;
	_tmp9_[7] = _tmp8_;
	dirs = _tmp9_;
	dirs_length1 = 8;
	_dirs_size_ = dirs_length1;
	_tmp10_ = g_new0 (GUserDirectory, 8);
	_tmp10_[0] = G_USER_DIRECTORY_DESKTOP;
	_tmp10_[1] = G_USER_DIRECTORY_DOCUMENTS;
	_tmp10_[2] = G_USER_DIRECTORY_DOWNLOAD;
	_tmp10_[3] = G_USER_DIRECTORY_MUSIC;
	_tmp10_[4] = G_USER_DIRECTORY_PICTURES;
	_tmp10_[5] = G_USER_DIRECTORY_PUBLIC_SHARE;
	_tmp10_[6] = G_USER_DIRECTORY_TEMPLATES;
	_tmp10_[7] = G_USER_DIRECTORY_VIDEOS;
	enums = _tmp10_;
	enums_length1 = 8;
	_enums_size_ = enums_length1;
	_tmp11_ = dirs;
	_tmp11__length1 = dirs_length1;
	_tmp12_ = enums;
	_tmp12__length1 = enums_length1;
	_vala_assert (_tmp11__length1 == _tmp12__length1, "dirs.length == enums.length");
	_tmp13_ = _result_;
	if (g_str_has_prefix (_tmp13_, "$HOME")) {
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp14_ = _result_;
		_tmp15_ = g_get_home_dir ();
		_tmp16_ = string_replace (_tmp14_, "$HOME", _tmp15_);
		_g_free0 (_result_);
		_result_ = _tmp16_;
	} else {
		const gchar* _tmp17_;
		_tmp17_ = _result_;
		if (g_str_has_prefix (_tmp17_, "$TRASH")) {
			const gchar* _tmp18_;
			DejaDupInstallEnv* _tmp19_;
			DejaDupInstallEnv* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp18_ = _result_;
			_tmp19_ = deja_dup_install_env_instance ();
			_tmp20_ = _tmp19_;
			_tmp21_ = deja_dup_install_env_get_trash_dir (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = string_replace (_tmp18_, "$TRASH", _tmp22_);
			_g_free0 (_result_);
			_result_ = _tmp23_;
			_g_free0 (_tmp22_);
			_g_object_unref0 (_tmp20_);
		} else {
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp24_ = FALSE;
					_tmp24_ = TRUE;
					while (TRUE) {
						gchar** _tmp26_;
						gint _tmp26__length1;
						const gchar* _tmp27_;
						gchar** _tmp28_;
						gint _tmp28__length1;
						const gchar* _tmp29_;
						if (!_tmp24_) {
							gint _tmp25_;
							_tmp25_ = i;
							i = _tmp25_ + 1;
						}
						_tmp24_ = FALSE;
						_tmp26_ = dirs;
						_tmp26__length1 = dirs_length1;
						if (!(i < _tmp26__length1)) {
							break;
						}
						_tmp27_ = _result_;
						_tmp28_ = dirs;
						_tmp28__length1 = dirs_length1;
						_tmp29_ = _tmp28_[i];
						if (g_str_has_prefix (_tmp27_, _tmp29_)) {
							gchar* replacement = NULL;
							GUserDirectory* _tmp30_;
							gint _tmp30__length1;
							GUserDirectory _tmp31_;
							const gchar* _tmp32_;
							gchar* _tmp33_;
							const gchar* _tmp34_;
							const gchar* _tmp35_;
							gchar** _tmp36_;
							gint _tmp36__length1;
							const gchar* _tmp37_;
							const gchar* _tmp38_;
							gchar* _tmp39_;
							_tmp30_ = enums;
							_tmp30__length1 = enums_length1;
							_tmp31_ = _tmp30_[i];
							_tmp32_ = g_get_user_special_dir (_tmp31_);
							_tmp33_ = g_strdup (_tmp32_);
							replacement = _tmp33_;
							_tmp34_ = replacement;
							if (_tmp34_ == NULL) {
								result = NULL;
								_g_free0 (replacement);
								enums = (g_free (enums), NULL);
								dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (_result_);
								return result;
							}
							_tmp35_ = _result_;
							_tmp36_ = dirs;
							_tmp36__length1 = dirs_length1;
							_tmp37_ = _tmp36_[i];
							_tmp38_ = replacement;
							_tmp39_ = string_replace (_tmp35_, _tmp37_, _tmp38_);
							_g_free0 (_result_);
							_result_ = _tmp39_;
							_g_free0 (replacement);
							break;
						}
					}
				}
			}
		}
	}
	_tmp40_ = _result_;
	_tmp41_ = g_get_user_name ();
	_tmp42_ = string_replace (_tmp40_, "$USER", _tmp41_);
	_g_free0 (_result_);
	_result_ = _tmp42_;
	_tmp44_ = _result_;
	_tmp45_ = g_uri_parse_scheme (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = _tmp46_ == NULL;
	_g_free0 (_tmp46_);
	if (_tmp47_) {
		const gchar* _tmp48_;
		_tmp48_ = _result_;
		_tmp43_ = !g_path_is_absolute (_tmp48_);
	} else {
		_tmp43_ = FALSE;
	}
	if (_tmp43_) {
		const gchar* _tmp49_;
		const gchar* _tmp50_;
		gchar* _tmp51_;
		_tmp49_ = g_get_home_dir ();
		_tmp50_ = _result_;
		_tmp51_ = g_build_filename (_tmp49_, _tmp50_, NULL);
		_g_free0 (_result_);
		_result_ = _tmp51_;
	}
	result = _result_;
	enums = (g_free (enums), NULL);
	dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GFile*
deja_dup_remove_read_root (GFile* folder)
{
	gchar* root = NULL;
	DejaDupInstallEnv* _tmp0_;
	DejaDupInstallEnv* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* relpath = NULL;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	const gchar* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	GFile* result;
	g_return_val_if_fail (folder != NULL, NULL);
	_tmp0_ = deja_dup_install_env_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_install_env_get_read_root (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	root = _tmp3_;
	_tmp4_ = root;
	if (_tmp4_ == NULL) {
		GFile* _tmp5_;
		_tmp5_ = _g_object_ref0 (folder);
		result = _tmp5_;
		_g_free0 (root);
		return result;
	}
	_tmp6_ = root;
	_tmp7_ = g_file_new_for_path (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_file_get_relative_path (_tmp8_, folder);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	relpath = _tmp10_;
	_tmp11_ = relpath;
	if (_tmp11_ == NULL) {
		GFile* _tmp12_;
		_tmp12_ = _g_object_ref0 (folder);
		result = _tmp12_;
		_g_free0 (relpath);
		_g_free0 (root);
		return result;
	}
	_tmp13_ = g_file_new_for_path ("/");
	_tmp14_ = _tmp13_;
	_tmp15_ = relpath;
	_tmp16_ = g_file_resolve_relative_path (_tmp14_, _tmp15_);
	_tmp17_ = _tmp16_;
	_g_object_unref0 (_tmp14_);
	result = _tmp17_;
	_g_free0 (relpath);
	_g_free0 (root);
	return result;
}

GFile*
deja_dup_parse_dir (const gchar* dir)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* result;
	g_return_val_if_fail (dir != NULL, NULL);
	_tmp0_ = deja_dup_parse_keywords (dir);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		GFile* _tmp3_;
		_tmp2_ = _result_;
		_tmp3_ = g_file_parse_name (_tmp2_);
		result = _tmp3_;
		_g_free0 (_result_);
		return result;
	} else {
		result = NULL;
		_g_free0 (_result_);
		return result;
	}
}

static void
_vala_array_add9 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

GFile**
deja_dup_parse_dir_list (const gchar** dirs,
                         gint dirs_length1,
                         gint* result_length1)
{
	GFile** rv = NULL;
	GFile** _tmp0_;
	gint rv_length1;
	gint _rv_size_;
	GFile** _tmp7_;
	gint _tmp7__length1;
	GFile** result;
	_tmp0_ = g_new0 (GFile*, 0 + 1);
	rv = _tmp0_;
	rv_length1 = 0;
	_rv_size_ = rv_length1;
	{
		const gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = dirs;
		s_collection_length1 = dirs_length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			gchar* _tmp1_;
			gchar* s = NULL;
			_tmp1_ = g_strdup ((gchar*) s_collection[s_it]);
			s = _tmp1_;
			{
				GFile* f = NULL;
				const gchar* _tmp2_;
				GFile* _tmp3_;
				GFile* _tmp4_;
				_tmp2_ = s;
				_tmp3_ = deja_dup_parse_dir (_tmp2_);
				f = _tmp3_;
				_tmp4_ = f;
				if (_tmp4_ != NULL) {
					GFile* _tmp5_;
					GFile* _tmp6_;
					_tmp5_ = f;
					_tmp6_ = _g_object_ref0 (_tmp5_);
					_vala_array_add9 (&rv, &rv_length1, &_rv_size_, _tmp6_);
				}
				_g_object_unref0 (f);
				_g_free0 (s);
			}
		}
	}
	_tmp7_ = rv;
	_tmp7__length1 = rv_length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}

static gint
______lambda13_ (GFile* a,
                 GFile* b)
{
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	if (a != NULL) {
		_tmp2_ = b != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = g_file_equal (a, b);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = 0;
	} else {
		_tmp0_ = 1;
	}
	result = _tmp0_;
	return result;
}

static gint
_______lambda13__gcompare_func (gconstpointer a,
                                gconstpointer b)
{
	gint result;
	result = ______lambda13_ ((GFile*) a, (GFile*) b);
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

void
deja_dup_expand_links_in_file (GFile* file,
                               GList** all,
                               gboolean keep_internal,
                               gboolean keep_missing,
                               GList* seen)
{
	GList* pieces = NULL;
	GFile* iter = NULL;
	GFile* _tmp0_;
	GFile* parent = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (file != NULL);
	pieces = NULL;
	_tmp0_ = _g_object_ref0 (file);
	iter = _tmp0_;
	while (TRUE) {
		GFile* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		gchar* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		_tmp1_ = iter;
		_tmp2_ = g_file_get_parent (_tmp1_);
		_g_object_unref0 (parent);
		parent = _tmp2_;
		_tmp3_ = parent;
		if (!(_tmp3_ != NULL)) {
			break;
		}
		_tmp4_ = parent;
		_tmp5_ = iter;
		_tmp6_ = g_file_get_relative_path (_tmp4_, _tmp5_);
		pieces = g_list_prepend (pieces, _tmp6_);
		_tmp7_ = parent;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (iter);
		iter = _tmp8_;
	}
	{
		GFile* so_far = NULL;
		GFile* _tmp9_;
		GList* _tmp10_;
		_tmp9_ = g_file_new_for_path ("/");
		so_far = _tmp9_;
		_tmp10_ = pieces;
		{
			GList* piece_collection = NULL;
			GList* piece_it = NULL;
			piece_collection = _tmp10_;
			for (piece_it = piece_collection; piece_it != NULL; piece_it = piece_it->next) {
				const gchar* piece = NULL;
				piece = (const gchar*) piece_it->data;
				{
					GFile* _tmp11_;
					GFile* _tmp12_;
					GFile* _tmp13_;
					const gchar* _tmp14_;
					GFile* _tmp15_;
					GFileInfo* info = NULL;
					GFile* _tmp16_;
					GFileInfo* _tmp17_;
					GFileInfo* _tmp18_;
					_tmp11_ = so_far;
					_tmp12_ = _g_object_ref0 (_tmp11_);
					_g_object_unref0 (parent);
					parent = _tmp12_;
					_tmp13_ = parent;
					_tmp14_ = piece;
					_tmp15_ = g_file_resolve_relative_path (_tmp13_, _tmp14_);
					_g_object_unref0 (so_far);
					so_far = _tmp15_;
					_tmp16_ = so_far;
					_tmp17_ = g_file_query_info (_tmp16_, G_FILE_ATTRIBUTE_STANDARD_IS_SYMLINK "," G_FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
					info = _tmp17_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (so_far);
						if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
							goto __catch0_g_io_error_not_found;
						}
						goto __catch0_g_error;
					}
					_tmp18_ = info;
					if (g_file_info_get_is_symlink (_tmp18_)) {
						GFile* _tmp19_;
						GList* _tmp20_;
						gchar* symlink_target = NULL;
						GFileInfo* _tmp23_;
						const gchar* _tmp24_;
						gchar* _tmp25_;
						GFile* full_target = NULL;
						const gchar* _tmp26_;
						gchar* remaining = NULL;
						GFile* _tmp32_;
						gchar* _tmp33_;
						const gchar* _tmp34_;
						GFile* _tmp38_;
						GFile* _tmp39_;
						GFile* _tmp40_;
						_tmp19_ = so_far;
						_tmp20_ = g_list_find_custom (seen, _tmp19_, _______lambda13__gcompare_func);
						if (_tmp20_ != NULL) {
							_g_object_unref0 (info);
							_g_object_unref0 (so_far);
							_g_object_unref0 (parent);
							_g_object_unref0 (iter);
							(pieces == NULL) ? NULL : (pieces = (_g_list_free__g_free0_ (pieces), NULL));
							return;
						}
						if (keep_internal) {
							GFile* _tmp21_;
							GFile* _tmp22_;
							_tmp21_ = so_far;
							_tmp22_ = _g_object_ref0 (_tmp21_);
							*all = g_list_append (*all, _tmp22_);
						}
						_tmp23_ = info;
						_tmp24_ = g_file_info_get_symlink_target (_tmp23_);
						_tmp25_ = g_strdup (_tmp24_);
						symlink_target = _tmp25_;
						_tmp26_ = symlink_target;
						if (g_path_is_absolute (_tmp26_)) {
							const gchar* _tmp27_;
							GFile* _tmp28_;
							_tmp27_ = symlink_target;
							_tmp28_ = g_file_new_for_path (_tmp27_);
							_g_object_unref0 (full_target);
							full_target = _tmp28_;
						} else {
							GFile* _tmp29_;
							const gchar* _tmp30_;
							GFile* _tmp31_;
							_tmp29_ = parent;
							_tmp30_ = symlink_target;
							_tmp31_ = g_file_resolve_relative_path (_tmp29_, _tmp30_);
							_g_object_unref0 (full_target);
							full_target = _tmp31_;
						}
						_tmp32_ = so_far;
						_tmp33_ = g_file_get_relative_path (_tmp32_, file);
						remaining = _tmp33_;
						_tmp34_ = remaining;
						if (_tmp34_ != NULL) {
							GFile* _tmp35_;
							const gchar* _tmp36_;
							GFile* _tmp37_;
							_tmp35_ = full_target;
							_tmp36_ = remaining;
							_tmp37_ = g_file_resolve_relative_path (_tmp35_, _tmp36_);
							_g_object_unref0 (full_target);
							full_target = _tmp37_;
						}
						if (keep_internal) {
							*all = vala_g_list_remove_full (*all, file, _g_object_unref0_);
						}
						_tmp38_ = so_far;
						_tmp39_ = _g_object_ref0 (_tmp38_);
						seen = g_list_prepend (seen, _tmp39_);
						_tmp40_ = full_target;
						deja_dup_expand_links_in_file (_tmp40_, all, keep_internal, keep_missing, seen);
						_g_free0 (remaining);
						_g_object_unref0 (full_target);
						_g_free0 (symlink_target);
						_g_object_unref0 (info);
						_g_object_unref0 (so_far);
						_g_object_unref0 (parent);
						_g_object_unref0 (iter);
						(pieces == NULL) ? NULL : (pieces = (_g_list_free__g_free0_ (pieces), NULL));
						return;
					}
					_g_object_unref0 (info);
				}
			}
		}
		if (seen != NULL) {
			GFile* _tmp41_;
			_tmp41_ = _g_object_ref0 (file);
			*all = g_list_append (*all, _tmp41_);
		}
		_g_object_unref0 (so_far);
	}
	goto __finally0;
	__catch0_g_io_error_not_found:
	{
		g_clear_error (&_inner_error0_);
		if (!keep_missing) {
			*all = vala_g_list_remove_full (*all, file, _g_object_unref0_);
		} else {
			if (seen != NULL) {
				GFile* _tmp42_;
				_tmp42_ = _g_object_ref0 (file);
				*all = g_list_append (*all, _tmp42_);
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp43_;
		const gchar* _tmp44_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp43_ = e;
		_tmp44_ = _tmp43_->message;
		g_warning ("DirHandling.vala:160: %s\n", _tmp44_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parent);
		_g_object_unref0 (iter);
		(pieces == NULL) ? NULL : (pieces = (_g_list_free__g_free0_ (pieces), NULL));
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (parent);
	_g_object_unref0 (iter);
	(pieces == NULL) ? NULL : (pieces = (_g_list_free__g_free0_ (pieces), NULL));
}

void
deja_dup_expand_links_in_list (GList** all,
                               gboolean keep_internal,
                               gboolean keep_missing)
{
	GList* all2 = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	_tmp0_ = g_list_copy (*all);
	all2 = _tmp0_;
	_tmp1_ = all2;
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
		file_collection = _tmp1_;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			GFile* _tmp2_;
			GFile* file = NULL;
			_tmp2_ = _g_object_ref0 ((GFile*) file_it->data);
			file = _tmp2_;
			{
				GFile* _tmp3_;
				_tmp3_ = file;
				deja_dup_expand_links_in_file (_tmp3_, all, keep_internal, keep_missing, NULL);
				_g_object_unref0 (file);
			}
		}
	}
	(all2 == NULL) ? NULL : (all2 = (g_list_free (all2), NULL));
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
deja_dup_resolve_user_dir (const gchar* user_path)
{
	gchar* homedir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (user_path != NULL, NULL);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	homedir = _tmp1_;
	if (g_strcmp0 (user_path, "") == 0) {
		result = NULL;
		_g_free0 (homedir);
		return result;
	} else {
		if (g_strcmp0 (user_path, "~") == 0) {
			result = homedir;
			return result;
		} else {
			if (g_str_has_prefix (user_path, "~/")) {
				const gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp2_ = homedir;
				_tmp3_ = string_substring (user_path, (glong) 2, (glong) -1);
				_tmp4_ = _tmp3_;
				_tmp5_ = g_build_filename (_tmp2_, _tmp4_, NULL);
				_tmp6_ = _tmp5_;
				_g_free0 (_tmp4_);
				result = _tmp6_;
				_g_free0 (homedir);
				return result;
			} else {
				if (!g_path_is_absolute (user_path)) {
					const gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp7_ = homedir;
					_tmp8_ = g_build_filename (_tmp7_, user_path, NULL);
					result = _tmp8_;
					_g_free0 (homedir);
					return result;
				} else {
					gchar* _tmp9_;
					_tmp9_ = g_strdup (user_path);
					result = _tmp9_;
					_g_free0 (homedir);
					return result;
				}
			}
		}
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

