/* Generated by wayland-scanner 1.24.0 */

#ifndef DDE_RESTRICT_SERVER_PROTOCOL_H
#define DDE_RESTRICT_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_dde_restrict The dde_restrict protocol
 * @section page_ifaces_dde_restrict Interfaces
 * - @subpage page_iface_dde_restrict - dde restrict 
 * @section page_copyright_dde_restrict Copyright
 * <pre>
 *
 * Copyright © 2020  pengwenhao <pengwenhao@uniontech.com>
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct dde_restrict;

#ifndef DDE_RESTRICT_INTERFACE
#define DDE_RESTRICT_INTERFACE
/**
 * @page page_iface_dde_restrict dde_restrict
 * @section page_iface_dde_restrict_desc Description
 * @section page_iface_dde_restrict_api API
 * See @ref iface_dde_restrict.
 */
/**
 * @defgroup iface_dde_restrict The dde_restrict interface
 */
extern const struct wl_interface dde_restrict_interface;
#endif

#ifndef DDE_RESTRICT_SWITCH_FLAG_ENUM
#define DDE_RESTRICT_SWITCH_FLAG_ENUM
/**
 * @ingroup iface_dde_restrict
 * the switch status of whether the feature can be used or not
 */
enum dde_restrict_switch_flag {
	/**
	 * feature toggle on
	 */
	DDE_RESTRICT_SWITCH_FLAG_ON = 1,
	/**
	 * feature toggle off
	 */
	DDE_RESTRICT_SWITCH_FLAG_OFF = 2,
};
#endif /* DDE_RESTRICT_SWITCH_FLAG_ENUM */

#ifndef DDE_RESTRICT_SWITCH_FLAG_ENUM_IS_VALID
#define DDE_RESTRICT_SWITCH_FLAG_ENUM_IS_VALID
/**
 * @ingroup iface_dde_restrict
 * Validate a dde_restrict switch_flag value.
 *
 * @return true on success, false on error.
 * @ref dde_restrict_switch_flag
 */
static inline bool
dde_restrict_switch_flag_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case DDE_RESTRICT_SWITCH_FLAG_ON:
		return version >= 1;
	case DDE_RESTRICT_SWITCH_FLAG_OFF:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* DDE_RESTRICT_SWITCH_FLAG_ENUM_IS_VALID */

/**
 * @ingroup iface_dde_restrict
 * @struct dde_restrict_interface
 */
struct dde_restrict_interface {
	/**
	 * switch screencast feature flag
	 *
	 * 
	 * @param switch_flag Requested screencast flag
	 */
	void (*switch_screencast)(struct wl_client *client,
				  struct wl_resource *resource,
				  uint32_t switch_flag);
	/**
	 * this feature is enabled only when the feature is turned on and the whitelisted client displays
	 *
	 * 
	 * @param whitelists comma-separated window resource classes
	 */
	void (*client_whitelist)(struct wl_client *client,
				 struct wl_resource *resource,
				 const char *whitelists);
	/**
	 * set protected window id which prohibit screenshot
	 *
	 * 
	 * @param window set protected window id
	 */
	void (*set_protected_window)(struct wl_client *client,
				     struct wl_resource *resource,
				     int32_t window);
	/**
	 * remove protected window id which prohibit screenshot
	 *
	 * 
	 * @param window remove protected window id
	 */
	void (*remove_protected_window)(struct wl_client *client,
					struct wl_resource *resource,
					int32_t window);
};

#define DDE_RESTRICT_LOGED 0

/**
 * @ingroup iface_dde_restrict
 */
#define DDE_RESTRICT_LOGED_SINCE_VERSION 1

/**
 * @ingroup iface_dde_restrict
 */
#define DDE_RESTRICT_SWITCH_SCREENCAST_SINCE_VERSION 1
/**
 * @ingroup iface_dde_restrict
 */
#define DDE_RESTRICT_CLIENT_WHITELIST_SINCE_VERSION 1
/**
 * @ingroup iface_dde_restrict
 */
#define DDE_RESTRICT_SET_PROTECTED_WINDOW_SINCE_VERSION 1
/**
 * @ingroup iface_dde_restrict
 */
#define DDE_RESTRICT_REMOVE_PROTECTED_WINDOW_SINCE_VERSION 1

/**
 * @ingroup iface_dde_restrict
 * Sends an loged event to the client owning the resource.
 * @param resource_ The client's resource
 * @param log A human readable translated error message.
 */
static inline void
dde_restrict_send_loged(struct wl_resource *resource_, const char *log)
{
	wl_resource_post_event(resource_, DDE_RESTRICT_LOGED, log);
}

#ifdef  __cplusplus
}
#endif

#endif
