/* BudgieMenu.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BudgieMenu.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "budgiemenuapplet.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "plugin.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "budgie-appindexer.h"
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libpeas/peas.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BUDGIE_MENU_0_PROPERTY,
	BUDGIE_MENU_NUM_PROPERTIES
};
static GParamSpec* budgie_menu_properties[BUDGIE_MENU_NUM_PROPERTIES];
enum  {
	BUDGIE_MENU_SETTINGS_0_PROPERTY,
	BUDGIE_MENU_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* budgie_menu_settings_properties[BUDGIE_MENU_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	BUDGIE_MENU_APPLET_0_PROPERTY,
	BUDGIE_MENU_APPLET_UUID_PROPERTY,
	BUDGIE_MENU_APPLET_NUM_PROPERTIES
};
static GParamSpec* budgie_menu_applet_properties[BUDGIE_MENU_APPLET_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BudgieMenuSettingsPrivate {
	GtkSwitch* switch_menu_label;
	GtkSwitch* switch_menu_compact;
	GtkSwitch* switch_menu_headers;
	GtkSwitch* switch_menu_categories_hover;
	GtkSwitch* switch_menu_show_settings_items;
	GtkEntry* entry_label;
	GtkSwitch* switch_use_default_icon;
	GtkEntry* entry_icon_pick;
	GtkButton* button_icon_pick;
	GSettings* settings;
};

struct _BudgieMenuAppletPrivate {
	GSettings* ui_settings;
	GtkImage* img;
	GtkLabel* label;
	BudgiePanelPosition panel_position;
	gint pixel_size;
	BudgiePopoverManager* manager;
	gchar* _uuid;
	BudgieAppIndex* app_index;
};

static gpointer budgie_menu_parent_class = NULL;
static BudgiePluginIface * budgie_menu_budgie_plugin_parent_iface = NULL;
static GType budgie_menu_type_id = 0;
static gint BudgieMenuSettings_private_offset;
static gpointer budgie_menu_settings_parent_class = NULL;
static GType budgie_menu_settings_type_id = 0;
static gint BudgieMenuApplet_private_offset;
static gpointer budgie_menu_applet_parent_class = NULL;
static GType budgie_menu_applet_type_id = 0;

static BudgieApplet* budgie_menu_real_get_panel_widget (BudgiePlugin* base,
                                                 const gchar* uuid);
static void budgie_menu_settings_on_pick_click (BudgieMenuSettings* self);
static void _budgie_menu_settings_on_pick_click_gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static void budgie_menu_settings_finalize (GObject * obj);
static GtkWidget* budgie_menu_applet_real_get_settings_ui (BudgieApplet* base);
static gboolean budgie_menu_applet_real_supports_settings (BudgieApplet* base);
static void _budgie_menu_applet_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                 const gchar* key,
                                                                 gpointer self);
static void __lambda21_ (BudgieMenuApplet* self,
                  const gchar* key);
static void ___lambda21__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda22_ (BudgieMenuApplet* self);
static gboolean ___lambda23_ (BudgieMenuApplet* self);
static gboolean ____lambda23__gsource_func (gpointer self);
static void ___lambda22__budgie_app_index_changed (BudgieAppIndex* _sender,
                                            gpointer self);
static gboolean __lambda24_ (BudgieMenuApplet* self,
                      GdkEventButton* e);
static gboolean ___lambda24__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static void __lambda25_ (BudgieMenuApplet* self,
                  gint p,
                  gint i,
                  gint s);
static void ___lambda25__budgie_applet_panel_size_changed (BudgieApplet* _sender,
                                                    gint panel_size,
                                                    gint icon_size,
                                                    gint small_icon_size,
                                                    gpointer self);
static gboolean __lambda26_ (BudgieMenuApplet* self,
                      GdkEventKey* e);
static gboolean ___lambda26__gtk_widget_key_release_event (GtkWidget* _sender,
                                                    GdkEventKey* event,
                                                    gpointer self);
static void budgie_menu_applet_real_panel_position_changed (BudgieApplet* base,
                                                     BudgiePanelPosition position);
static void budgie_menu_applet_real_invoke_action (BudgieApplet* base,
                                            BudgiePanelAction action);
static gboolean budgie_menu_applet_start_here_icon_is_gnome_foot (BudgieMenuApplet* self);
static void budgie_menu_applet_real_update_popovers (BudgieApplet* base,
                                              BudgiePopoverManager* manager);
static void budgie_menu_applet_finalize (GObject * obj);
static void _vala_budgie_menu_applet_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_budgie_menu_applet_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
GType category_button_register_type (GTypeModule * module);
GType menu_button_register_type (GTypeModule * module);
GType budgie_menu_window_register_type (GTypeModule * module);
GType icon_chooser_register_type (GTypeModule * module);
GType overlay_menus_register_type (GTypeModule * module);
GType user_button_register_type (GTypeModule * module);
GType menu_item_register_type (GTypeModule * module);
GType application_view_register_type (GTypeModule * module);
GType application_list_view_register_type (GTypeModule * module);
GType accounts_remote_register_type (GTypeModule * module);
VALA_EXTERN void accounts_remote_proxy_register_dynamic_type (GTypeModule* module);
GType account_user_remote_register_type (GTypeModule * module);
VALA_EXTERN void account_user_remote_proxy_register_dynamic_type (GTypeModule* module);
GType properties_remote_register_type (GTypeModule * module);
VALA_EXTERN void properties_remote_proxy_register_dynamic_type (GTypeModule* module);
GType power_dialog_remote_register_type (GTypeModule * module);
VALA_EXTERN void power_dialog_remote_proxy_register_dynamic_type (GTypeModule* module);
GType xdg_dir_tracker_remote_register_type (GTypeModule * module);
VALA_EXTERN void xdg_dir_tracker_remote_proxy_register_dynamic_type (GTypeModule* module);

static BudgieApplet*
budgie_menu_real_get_panel_widget (BudgiePlugin* base,
                                   const gchar* uuid)
{
	BudgieMenu * self;
	BudgieMenuApplet* _tmp0_;
	BudgieApplet* result;
	self = (BudgieMenu*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = budgie_menu_applet_new (uuid);
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

BudgieMenu*
budgie_menu_construct (GType object_type)
{
	BudgieMenu * self = NULL;
	self = (BudgieMenu*) g_object_new (object_type, NULL);
	return self;
}

BudgieMenu*
budgie_menu_new (void)
{
	return budgie_menu_construct (TYPE_BUDGIE_MENU);
}

static void
budgie_menu_class_init (BudgieMenuClass * klass,
                        gpointer klass_data)
{
	budgie_menu_parent_class = g_type_class_peek_parent (klass);
}

static void
budgie_menu_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                          gpointer iface_data)
{
	budgie_menu_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) budgie_menu_real_get_panel_widget;
}

static void
budgie_menu_instance_init (BudgieMenu * self,
                           gpointer klass)
{
}

GType
budgie_menu_get_type (void)
{
	return budgie_menu_type_id;
}

GType
budgie_menu_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieMenu), 0, (GInstanceInitFunc) budgie_menu_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) budgie_menu_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	budgie_menu_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "BudgieMenu", &g_define_type_info, 0);
	g_type_module_add_interface (module, budgie_menu_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return budgie_menu_type_id;
}

static inline gpointer
budgie_menu_settings_get_instance_private (BudgieMenuSettings* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieMenuSettings_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_budgie_menu_settings_on_pick_click_gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
	budgie_menu_settings_on_pick_click ((BudgieMenuSettings*) self);
}

BudgieMenuSettings*
budgie_menu_settings_construct (GType object_type,
                                GSettings* settings)
{
	BudgieMenuSettings * self = NULL;
	GSettings* _tmp0_;
	GtkSwitch* _tmp1_;
	GtkSwitch* _tmp2_;
	GtkSwitch* _tmp3_;
	GtkSwitch* _tmp4_;
	GtkEntry* _tmp5_;
	GtkSwitch* _tmp6_;
	GtkEntry* _tmp7_;
	GtkSwitch* _tmp8_;
	GtkButton* _tmp9_;
	self = (BudgieMenuSettings*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->switch_menu_label;
	g_settings_bind (settings, "enable-menu-label", (GObject*) _tmp1_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp2_ = self->priv->switch_menu_compact;
	g_settings_bind (settings, "menu-compact", (GObject*) _tmp2_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp3_ = self->priv->switch_menu_headers;
	g_settings_bind (settings, "menu-headers", (GObject*) _tmp3_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp4_ = self->priv->switch_menu_categories_hover;
	g_settings_bind (settings, "menu-categories-hover", (GObject*) _tmp4_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp5_ = self->priv->entry_label;
	g_settings_bind (settings, "menu-label", (GObject*) _tmp5_, "text", G_SETTINGS_BIND_DEFAULT);
	_tmp6_ = self->priv->switch_use_default_icon;
	g_settings_bind (settings, "use-default-menu-icon", (GObject*) _tmp6_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp7_ = self->priv->entry_icon_pick;
	g_settings_bind (settings, "menu-icon", (GObject*) _tmp7_, "text", G_SETTINGS_BIND_DEFAULT);
	_tmp8_ = self->priv->switch_menu_show_settings_items;
	g_settings_bind (settings, "menu-show-control-center-items", (GObject*) _tmp8_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp9_ = self->priv->button_icon_pick;
	g_signal_connect_object (_tmp9_, "clicked", (GCallback) _budgie_menu_settings_on_pick_click_gtk_button_clicked, self, 0);
	return self;
}

BudgieMenuSettings*
budgie_menu_settings_new (GSettings* settings)
{
	return budgie_menu_settings_construct (TYPE_BUDGIE_MENU_SETTINGS, settings);
}

/**
 * Handle the icon picker
 */
static void
budgie_menu_settings_on_pick_click (BudgieMenuSettings* self)
{
	IconChooser* chooser = NULL;
	GtkWidget* _tmp0_;
	IconChooser* _tmp1_;
	gchar* response = NULL;
	IconChooser* _tmp2_;
	gchar* _tmp3_;
	IconChooser* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = icon_chooser_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp0_) : NULL);
	g_object_ref_sink (_tmp1_);
	chooser = _tmp1_;
	_tmp2_ = chooser;
	_tmp3_ = icon_chooser_run (_tmp2_);
	response = _tmp3_;
	_tmp4_ = chooser;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
	_tmp5_ = response;
	if (_tmp5_ != NULL) {
		GtkEntry* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = self->priv->entry_icon_pick;
		_tmp7_ = response;
		gtk_entry_set_text (_tmp6_, _tmp7_);
	}
	_g_free0 (response);
	_g_object_unref0 (chooser);
}

static void
budgie_menu_settings_class_init (BudgieMenuSettingsClass * klass,
                                 gpointer klass_data)
{
	budgie_menu_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieMenuSettings_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_menu_settings_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/budgie-menu/settings.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_menu_label", FALSE, BudgieMenuSettings_private_offset + G_STRUCT_OFFSET (BudgieMenuSettingsPrivate, switch_menu_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_menu_compact", FALSE, BudgieMenuSettings_private_offset + G_STRUCT_OFFSET (BudgieMenuSettingsPrivate, switch_menu_compact));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_menu_headers", FALSE, BudgieMenuSettings_private_offset + G_STRUCT_OFFSET (BudgieMenuSettingsPrivate, switch_menu_headers));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_menu_categories_hover", FALSE, BudgieMenuSettings_private_offset + G_STRUCT_OFFSET (BudgieMenuSettingsPrivate, switch_menu_categories_hover));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_menu_show_settings_items", FALSE, BudgieMenuSettings_private_offset + G_STRUCT_OFFSET (BudgieMenuSettingsPrivate, switch_menu_show_settings_items));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "entry_label", FALSE, BudgieMenuSettings_private_offset + G_STRUCT_OFFSET (BudgieMenuSettingsPrivate, entry_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_use_default_icon", FALSE, BudgieMenuSettings_private_offset + G_STRUCT_OFFSET (BudgieMenuSettingsPrivate, switch_use_default_icon));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "entry_icon_pick", FALSE, BudgieMenuSettings_private_offset + G_STRUCT_OFFSET (BudgieMenuSettingsPrivate, entry_icon_pick));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "button_icon_pick", FALSE, BudgieMenuSettings_private_offset + G_STRUCT_OFFSET (BudgieMenuSettingsPrivate, button_icon_pick));
}

static void
budgie_menu_settings_instance_init (BudgieMenuSettings * self,
                                    gpointer klass)
{
	self->priv = budgie_menu_settings_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
budgie_menu_settings_finalize (GObject * obj)
{
	BudgieMenuSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BUDGIE_MENU_SETTINGS, BudgieMenuSettings);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (budgie_menu_settings_parent_class)->finalize (obj);
}

GType
budgie_menu_settings_get_type (void)
{
	return budgie_menu_settings_type_id;
}

GType
budgie_menu_settings_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieMenuSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_menu_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieMenuSettings), 0, (GInstanceInitFunc) budgie_menu_settings_instance_init, NULL };
	budgie_menu_settings_type_id = g_type_module_register_type (module, gtk_grid_get_type (), "BudgieMenuSettings", &g_define_type_info, 0);
	BudgieMenuSettings_private_offset = sizeof (BudgieMenuSettingsPrivate);
	return budgie_menu_settings_type_id;
}

static inline gpointer
budgie_menu_applet_get_instance_private (BudgieMenuApplet* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieMenuApplet_private_offset);
}

static GtkWidget*
budgie_menu_applet_real_get_settings_ui (BudgieApplet* base)
{
	BudgieMenuApplet * self;
	const gchar* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	BudgieMenuSettings* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* result;
	self = (BudgieMenuApplet*) base;
	_tmp0_ = self->priv->_uuid;
	_tmp1_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = budgie_menu_settings_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = (GtkWidget*) _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static gboolean
budgie_menu_applet_real_supports_settings (BudgieApplet* base)
{
	BudgieMenuApplet * self;
	gboolean result;
	self = (BudgieMenuApplet*) base;
	result = TRUE;
	return result;
}

static void
_budgie_menu_applet_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                            const gchar* key,
                                                            gpointer self)
{
	budgie_menu_applet_on_settings_changed ((BudgieMenuApplet*) self, key);
}

static void
__lambda21_ (BudgieMenuApplet* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "icon-theme") == 0) {
		budgie_menu_applet_on_settings_changed (self, "menu-icon");
	}
}

static void
___lambda21__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda21_ ((BudgieMenuApplet*) self, key);
}

static gboolean
___lambda23_ (BudgieMenuApplet* self)
{
	BudgieMenuWindow* _tmp0_;
	BudgieMenuWindow* _tmp1_;
	BudgieAppIndex* _tmp2_;
	gboolean result;
	_tmp0_ = self->popover;
	if (gtk_widget_is_visible ((GtkWidget*) _tmp0_)) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->popover;
	_tmp2_ = self->priv->app_index;
	budgie_menu_window_refresh (_tmp1_, _tmp2_, FALSE);
	result = FALSE;
	return result;
}

static gboolean
____lambda23__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda23_ ((BudgieMenuApplet*) self);
	return result;
}

static void
__lambda22_ (BudgieMenuApplet* self)
{
	BudgieMenuWindow* _tmp0_;
	_tmp0_ = self->popover;
	if (gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT_IDLE, (guint) 1, ____lambda23__gsource_func, g_object_ref (self), g_object_unref);
	} else {
		BudgieMenuWindow* _tmp1_;
		BudgieAppIndex* _tmp2_;
		_tmp1_ = self->popover;
		_tmp2_ = self->priv->app_index;
		budgie_menu_window_refresh (_tmp1_, _tmp2_, FALSE);
	}
}

static void
___lambda22__budgie_app_index_changed (BudgieAppIndex* _sender,
                                       gpointer self)
{
	__lambda22_ ((BudgieMenuApplet*) self);
}

static gboolean
__lambda24_ (BudgieMenuApplet* self,
             GdkEventButton* e)
{
	BudgieMenuWindow* _tmp0_;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = self->popover;
	if (gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
		BudgieMenuWindow* _tmp1_;
		_tmp1_ = self->popover;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	} else {
		BudgieMenuWindow* _tmp2_;
		GtkWidget* _tmp3_;
		BudgiePopoverManager* _tmp4_;
		GtkToggleButton* _tmp5_;
		_tmp2_ = self->popover;
		_tmp3_ = gtk_bin_get_child ((GtkBin*) _tmp2_);
		gtk_widget_show_all (_tmp3_);
		_tmp4_ = self->priv->manager;
		_tmp5_ = self->widget;
		budgie_popover_manager_show_popover (_tmp4_, (GtkWidget*) _tmp5_);
	}
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
___lambda24__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda24_ ((BudgieMenuApplet*) self, event);
	return result;
}

static void
__lambda25_ (BudgieMenuApplet* self,
             gint p,
             gint i,
             gint s)
{
	if (self->priv->pixel_size != i) {
		self->priv->pixel_size = (gint) i;
		budgie_menu_applet_on_settings_changed (self, "menu-icon");
	}
}

static void
___lambda25__budgie_applet_panel_size_changed (BudgieApplet* _sender,
                                               gint panel_size,
                                               gint icon_size,
                                               gint small_icon_size,
                                               gpointer self)
{
	__lambda25_ ((BudgieMenuApplet*) self, panel_size, icon_size, small_icon_size);
}

static gboolean
__lambda26_ (BudgieMenuApplet* self,
             GdkEventKey* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->keyval == GDK_KEY_Escape) {
		BudgieMenuWindow* _tmp0_;
		_tmp0_ = self->popover;
		gtk_widget_hide ((GtkWidget*) _tmp0_);
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
___lambda26__gtk_widget_key_release_event (GtkWidget* _sender,
                                           GdkEventKey* event,
                                           gpointer self)
{
	gboolean result;
	result = __lambda26_ ((BudgieMenuApplet*) self, event);
	return result;
}

BudgieMenuApplet*
budgie_menu_applet_construct (GType object_type,
                              const gchar* uuid)
{
	BudgieMenuApplet * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	BudgieAppIndex* _tmp4_;
	GtkToggleButton* _tmp5_;
	GtkToggleButton* _tmp6_;
	GtkImage* _tmp7_;
	GtkImage* _tmp8_;
	GtkImage* _tmp9_;
	GtkBox* layout = NULL;
	GtkBox* _tmp10_;
	GtkImage* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkToggleButton* _tmp15_;
	GtkStyleContext* st = NULL;
	GtkToggleButton* _tmp16_;
	GtkStyleContext* _tmp17_;
	GtkStyleContext* _tmp18_;
	GSettings* _tmp19_;
	GtkToggleButton* _tmp20_;
	BudgieMenuWindow* _tmp21_;
	BudgieMenuWindow* _tmp22_;
	GtkToggleButton* _tmp23_;
	BudgieMenuWindow* _tmp24_;
	BudgieAppIndex* _tmp25_;
	BudgieAppIndex* _tmp26_;
	GtkToggleButton* _tmp27_;
	BudgieMenuWindow* _tmp28_;
	GtkWidget* _tmp29_;
	GtkToggleButton* _tmp30_;
	BudgieMenuWindow* _tmp31_;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (BudgieMenuApplet*) g_object_new (object_type, "uuid", uuid, NULL);
	budgie_applet_set_settings_schema ((BudgieApplet*) self, "com.solus-project.budgie-menu");
	budgie_applet_set_settings_prefix ((BudgieApplet*) self, "/com/solus-project/budgie-panel/instance/budgie-menu");
	_tmp0_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, uuid);
	_g_object_unref0 (self->settings);
	self->settings = _tmp0_;
	_tmp1_ = self->settings;
	g_signal_connect_object (_tmp1_, "changed", (GCallback) _budgie_menu_applet_on_settings_changed_g_settings_changed, self, 0);
	_tmp2_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (self->priv->ui_settings);
	self->priv->ui_settings = _tmp2_;
	_tmp3_ = self->priv->ui_settings;
	g_signal_connect_object (_tmp3_, "changed", (GCallback) ___lambda21__g_settings_changed, self, 0);
	_tmp4_ = budgie_app_index_get ();
	_g_object_unref0 (self->priv->app_index);
	self->priv->app_index = _tmp4_;
	_tmp5_ = (GtkToggleButton*) gtk_toggle_button_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->widget);
	self->widget = _tmp5_;
	_tmp6_ = self->widget;
	gtk_button_set_relief ((GtkButton*) _tmp6_, GTK_RELIEF_NONE);
	_tmp7_ = (GtkImage*) gtk_image_new_from_icon_name ("view-grid-symbolic", (GtkIconSize) GTK_ICON_SIZE_INVALID);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->img);
	self->priv->img = _tmp7_;
	_tmp8_ = self->priv->img;
	gtk_image_set_pixel_size (_tmp8_, self->priv->pixel_size);
	_tmp9_ = self->priv->img;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp9_, TRUE);
	_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp10_);
	layout = _tmp10_;
	_tmp11_ = self->priv->img;
	gtk_box_pack_start (layout, (GtkWidget*) _tmp11_, TRUE, TRUE, (guint) 0);
	_tmp12_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp12_;
	_tmp13_ = self->priv->label;
	gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_START);
	_tmp14_ = self->priv->label;
	gtk_box_pack_start (layout, (GtkWidget*) _tmp14_, TRUE, TRUE, (guint) 3);
	_tmp15_ = self->widget;
	gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) layout);
	_tmp16_ = self->widget;
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) _tmp16_);
	_tmp18_ = _g_object_ref0 (_tmp17_);
	st = _tmp18_;
	gtk_style_context_add_class (st, "budgie-menu-launcher");
	gtk_style_context_add_class (st, "panel-button");
	_tmp19_ = self->settings;
	_tmp20_ = self->widget;
	_tmp21_ = budgie_menu_window_new (_tmp19_, (GtkWidget*) _tmp20_);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->popover);
	self->popover = _tmp21_;
	_tmp22_ = self->popover;
	_tmp23_ = self->widget;
	g_object_bind_property_with_closures ((GObject*) _tmp22_, "visible", (GObject*) _tmp23_, "active", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp24_ = self->popover;
	_tmp25_ = self->priv->app_index;
	budgie_menu_window_refresh (_tmp24_, _tmp25_, TRUE);
	_tmp26_ = self->priv->app_index;
	g_signal_connect_object (_tmp26_, "changed", (GCallback) ___lambda22__budgie_app_index_changed, self, 0);
	_tmp27_ = self->widget;
	g_signal_connect_object ((GtkWidget*) _tmp27_, "button-press-event", (GCallback) ___lambda24__gtk_widget_button_press_event, self, 0);
	_tmp28_ = self->popover;
	_tmp29_ = gtk_bin_get_child ((GtkBin*) _tmp28_);
	gtk_widget_show_all (_tmp29_);
	g_object_set ((BudgieApplet*) self, "supported-actions", BUDGIE_PANEL_ACTION_MENU, NULL);
	_tmp30_ = self->widget;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp30_);
	gtk_widget_show_all ((GtkWidget*) self);
	gtk_widget_set_valign ((GtkWidget*) layout, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_FILL);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_FILL);
	budgie_menu_applet_on_settings_changed (self, "enable-menu-label");
	budgie_menu_applet_on_settings_changed (self, "use-default-menu-icon");
	budgie_menu_applet_on_settings_changed (self, "menu-icon");
	budgie_menu_applet_on_settings_changed (self, "menu-label");
	g_signal_connect_object ((BudgieApplet*) self, "panel-size-changed", (GCallback) ___lambda25__budgie_applet_panel_size_changed, self, 0);
	_tmp31_ = self->popover;
	g_signal_connect_object ((GtkWidget*) _tmp31_, "key-release-event", (GCallback) ___lambda26__gtk_widget_key_release_event, self, 0);
	_g_object_unref0 (st);
	_g_object_unref0 (layout);
	return self;
}

BudgieMenuApplet*
budgie_menu_applet_new (const gchar* uuid)
{
	return budgie_menu_applet_construct (TYPE_BUDGIE_MENU_APPLET, uuid);
}

static void
budgie_menu_applet_real_panel_position_changed (BudgieApplet* base,
                                                BudgiePanelPosition position)
{
	BudgieMenuApplet * self;
	gboolean _tmp0_ = FALSE;
	gboolean vertical = FALSE;
	gint _tmp1_ = 0;
	gint margin = 0;
	GtkLabel* _tmp2_;
	self = (BudgieMenuApplet*) base;
	self->priv->panel_position = position;
	if (position == BUDGIE_PANEL_POSITION_LEFT) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = position == BUDGIE_PANEL_POSITION_RIGHT;
	}
	vertical = _tmp0_;
	if (vertical) {
		_tmp1_ = 0;
	} else {
		_tmp1_ = 3;
	}
	margin = _tmp1_;
	_tmp2_ = self->priv->label;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp2_, margin);
	budgie_menu_applet_on_settings_changed (self, "enable-menu-label");
}

static void
budgie_menu_applet_real_invoke_action (BudgieApplet* base,
                                       BudgiePanelAction action)
{
	BudgieMenuApplet * self;
	self = (BudgieMenuApplet*) base;
	if ((action & BUDGIE_PANEL_ACTION_MENU) != 0) {
		BudgieMenuWindow* _tmp0_;
		_tmp0_ = self->popover;
		if (gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
			BudgieMenuWindow* _tmp1_;
			_tmp1_ = self->popover;
			gtk_widget_hide ((GtkWidget*) _tmp1_);
		} else {
			BudgieMenuWindow* _tmp2_;
			GtkWidget* _tmp3_;
			BudgiePopoverManager* _tmp4_;
			GtkToggleButton* _tmp5_;
			_tmp2_ = self->popover;
			_tmp3_ = gtk_bin_get_child ((GtkBin*) _tmp2_);
			gtk_widget_show_all (_tmp3_);
			_tmp4_ = self->priv->manager;
			_tmp5_ = self->widget;
			budgie_popover_manager_show_popover (_tmp4_, (GtkWidget*) _tmp5_);
		}
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

void
budgie_menu_applet_on_settings_changed (BudgieMenuApplet* self,
                                        const gchar* key)
{
	gboolean should_show = FALSE;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	should_show = TRUE;
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if ((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("use-default-menu-icon")))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("menu-icon"))))) {
		switch (0) {
			default:
			{
				gchar* icon = NULL;
				gboolean _tmp3_ = FALSE;
				GSettings* _tmp4_;
				const gchar* _tmp8_;
				GtkImage* _tmp21_;
				GtkImage* _tmp22_;
				_tmp4_ = self->settings;
				if (g_settings_get_boolean (_tmp4_, "use-default-menu-icon")) {
					_tmp3_ = TRUE;
				} else {
					_tmp3_ = budgie_menu_applet_start_here_icon_is_gnome_foot (self);
				}
				if (_tmp3_) {
					gchar* _tmp5_;
					_tmp5_ = g_strdup ("budgie-menu-symbolic");
					_g_free0 (icon);
					icon = _tmp5_;
				} else {
					GSettings* _tmp6_;
					gchar* _tmp7_;
					_tmp6_ = self->settings;
					_tmp7_ = g_settings_get_string (_tmp6_, "menu-icon");
					_g_free0 (icon);
					icon = _tmp7_;
				}
				_tmp8_ = icon;
				if (string_contains (_tmp8_, "/")) {
					{
						GdkPixbuf* pixbuf = NULL;
						const gchar* _tmp9_;
						GdkPixbuf* _tmp10_;
						GtkImage* _tmp11_;
						GdkPixbuf* _tmp12_;
						GdkPixbuf* _tmp13_;
						GdkPixbuf* _tmp14_;
						_tmp9_ = icon;
						_tmp10_ = gdk_pixbuf_new_from_file (_tmp9_, &_inner_error0_);
						pixbuf = _tmp10_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
						_tmp11_ = self->priv->img;
						_tmp12_ = pixbuf;
						_tmp13_ = gdk_pixbuf_scale_simple (_tmp12_, self->priv->pixel_size, self->priv->pixel_size, GDK_INTERP_BILINEAR);
						_tmp14_ = _tmp13_;
						gtk_image_set_from_pixbuf (_tmp11_, _tmp14_);
						_g_object_unref0 (_tmp14_);
						_g_object_unref0 (pixbuf);
					}
					goto __finally0;
					__catch0_g_error:
					{
						GError* e = NULL;
						GError* _tmp15_;
						const gchar* _tmp16_;
						GtkImage* _tmp17_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp15_ = e;
						_tmp16_ = _tmp15_->message;
						g_warning ("BudgieMenu.vala:242: Failed to update Budgie Menu applet icon: %s", _tmp16_);
						_tmp17_ = self->priv->img;
						gtk_image_set_from_icon_name (_tmp17_, "start-here-symbolic", (GtkIconSize) GTK_ICON_SIZE_INVALID);
						_g_error_free0 (e);
					}
					__finally0:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (icon);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				} else {
					const gchar* _tmp18_;
					_tmp18_ = icon;
					if (g_strcmp0 (_tmp18_, "") == 0) {
						should_show = FALSE;
					} else {
						GtkImage* _tmp19_;
						const gchar* _tmp20_;
						_tmp19_ = self->priv->img;
						_tmp20_ = icon;
						gtk_image_set_from_icon_name (_tmp19_, _tmp20_, (GtkIconSize) GTK_ICON_SIZE_INVALID);
					}
				}
				_tmp21_ = self->priv->img;
				gtk_image_set_pixel_size (_tmp21_, self->priv->pixel_size);
				_tmp22_ = self->priv->img;
				gtk_widget_set_visible ((GtkWidget*) _tmp22_, should_show);
				_g_free0 (icon);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("menu-label")))) {
		switch (0) {
			default:
			{
				GtkLabel* _tmp23_;
				GSettings* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp23_ = self->priv->label;
				_tmp24_ = self->settings;
				_tmp25_ = g_settings_get_string (_tmp24_, key);
				_tmp26_ = _tmp25_;
				gtk_label_set_label (_tmp23_, _tmp26_);
				_g_free0 (_tmp26_);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("enable-menu-label")))) {
		switch (0) {
			default:
			{
				gboolean _tmp27_ = FALSE;
				gboolean _tmp28_ = FALSE;
				gboolean visible = FALSE;
				GtkLabel* _tmp30_;
				if (self->priv->panel_position == BUDGIE_PANEL_POSITION_TOP) {
					_tmp28_ = TRUE;
				} else {
					_tmp28_ = self->priv->panel_position == BUDGIE_PANEL_POSITION_BOTTOM;
				}
				if (_tmp28_) {
					GSettings* _tmp29_;
					_tmp29_ = self->settings;
					_tmp27_ = g_settings_get_boolean (_tmp29_, key);
				} else {
					_tmp27_ = FALSE;
				}
				visible = _tmp27_;
				_tmp30_ = self->priv->label;
				gtk_widget_set_visible ((GtkWidget*) _tmp30_, visible);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("menu-show-control-center-items")))) {
		switch (0) {
			default:
			{
				BudgieAppIndex* _tmp31_;
				_tmp31_ = self->priv->app_index;
				budgie_app_index_queue_refresh (_tmp31_, 3);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

static gboolean
budgie_menu_applet_start_here_icon_is_gnome_foot (BudgieMenuApplet* self)
{
	gchar* theme_name = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->ui_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "icon-theme");
	theme_name = _tmp1_;
	_tmp6_ = theme_name;
	if (g_strcmp0 (_tmp6_, "") == 0) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp7_;
		_tmp7_ = theme_name;
		_tmp5_ = g_strcmp0 (_tmp7_, "default") == 0;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = theme_name;
		_tmp4_ = g_strcmp0 (_tmp8_, "Adwaita") == 0;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = theme_name;
		_tmp3_ = g_strcmp0 (_tmp9_, "hicolor") == 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp10_;
		_tmp10_ = theme_name;
		_tmp2_ = g_strcmp0 (_tmp10_, "HighContrast") == 0;
	}
	result = _tmp2_;
	_g_free0 (theme_name);
	return result;
}

static void
budgie_menu_applet_real_update_popovers (BudgieApplet* base,
                                         BudgiePopoverManager* manager)
{
	BudgieMenuApplet * self;
	GtkToggleButton* _tmp0_;
	BudgieMenuWindow* _tmp1_;
	self = (BudgieMenuApplet*) base;
	self->priv->manager = manager;
	_tmp0_ = self->widget;
	_tmp1_ = self->popover;
	budgie_popover_manager_register_popover (manager, (GtkWidget*) _tmp0_, (BudgiePopover*) _tmp1_);
}

const gchar*
budgie_menu_applet_get_uuid (BudgieMenuApplet* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}

void
budgie_menu_applet_set_uuid (BudgieMenuApplet* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_menu_applet_get_uuid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uuid);
		self->priv->_uuid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_menu_applet_properties[BUDGIE_MENU_APPLET_UUID_PROPERTY]);
	}
}

static void
budgie_menu_applet_class_init (BudgieMenuAppletClass * klass,
                               gpointer klass_data)
{
	budgie_menu_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieMenuApplet_private_offset);
	((BudgieAppletClass *) klass)->get_settings_ui = (GtkWidget* (*) (BudgieApplet*)) budgie_menu_applet_real_get_settings_ui;
	((BudgieAppletClass *) klass)->supports_settings = (gboolean (*) (BudgieApplet*)) budgie_menu_applet_real_supports_settings;
	((BudgieAppletClass *) klass)->panel_position_changed = (void (*) (BudgieApplet*, BudgiePanelPosition)) budgie_menu_applet_real_panel_position_changed;
	((BudgieAppletClass *) klass)->invoke_action = (void (*) (BudgieApplet*, BudgiePanelAction)) budgie_menu_applet_real_invoke_action;
	((BudgieAppletClass *) klass)->update_popovers = (void (*) (BudgieApplet*, BudgiePopoverManager*)) budgie_menu_applet_real_update_popovers;
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_menu_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_menu_applet_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_menu_applet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_MENU_APPLET_UUID_PROPERTY, budgie_menu_applet_properties[BUDGIE_MENU_APPLET_UUID_PROPERTY] = g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
budgie_menu_applet_instance_init (BudgieMenuApplet * self,
                                  gpointer klass)
{
	self->priv = budgie_menu_applet_get_instance_private (self);
	self->priv->panel_position = BUDGIE_PANEL_POSITION_BOTTOM;
	self->priv->pixel_size = 32;
	self->priv->manager = NULL;
}

static void
budgie_menu_applet_finalize (GObject * obj)
{
	BudgieMenuApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BUDGIE_MENU_APPLET, BudgieMenuApplet);
	_g_object_unref0 (self->widget);
	_g_object_unref0 (self->popover);
	_g_object_unref0 (self->settings);
	_g_object_unref0 (self->priv->ui_settings);
	_g_object_unref0 (self->priv->img);
	_g_object_unref0 (self->priv->label);
	_g_free0 (self->priv->_uuid);
	_g_object_unref0 (self->priv->app_index);
	G_OBJECT_CLASS (budgie_menu_applet_parent_class)->finalize (obj);
}

GType
budgie_menu_applet_get_type (void)
{
	return budgie_menu_applet_type_id;
}

GType
budgie_menu_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieMenuAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_menu_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieMenuApplet), 0, (GInstanceInitFunc) budgie_menu_applet_instance_init, NULL };
	budgie_menu_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "BudgieMenuApplet", &g_define_type_info, 0);
	BudgieMenuApplet_private_offset = sizeof (BudgieMenuAppletPrivate);
	return budgie_menu_applet_type_id;
}

static void
_vala_budgie_menu_applet_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	BudgieMenuApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BUDGIE_MENU_APPLET, BudgieMenuApplet);
	switch (property_id) {
		case BUDGIE_MENU_APPLET_UUID_PROPERTY:
		g_value_set_string (value, budgie_menu_applet_get_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_menu_applet_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	BudgieMenuApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BUDGIE_MENU_APPLET, BudgieMenuApplet);
	switch (property_id) {
		case BUDGIE_MENU_APPLET_UUID_PROPERTY:
		budgie_menu_applet_set_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	budgie_menu_register_type (module);
	budgie_menu_settings_register_type (module);
	budgie_menu_applet_register_type (module);
	category_button_register_type (module);
	menu_button_register_type (module);
	budgie_menu_window_register_type (module);
	icon_chooser_register_type (module);
	overlay_menus_register_type (module);
	user_button_register_type (module);
	menu_item_register_type (module);
	application_view_register_type (module);
	application_list_view_register_type (module);
	accounts_remote_register_type (module);
	accounts_remote_proxy_register_dynamic_type (module);
	account_user_remote_register_type (module);
	account_user_remote_proxy_register_dynamic_type (module);
	properties_remote_register_type (module);
	properties_remote_proxy_register_dynamic_type (module);
	power_dialog_remote_register_type (module);
	power_dialog_remote_proxy_register_dynamic_type (module);
	xdg_dir_tracker_remote_register_type (module);
	xdg_dir_tracker_remote_proxy_register_dynamic_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_BUDGIE_MENU);
	_g_object_unref0 (objmodule);
}

